/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.inference.gbp;

import cc.mallet.grmm.inference.gbp.Region;
import cc.mallet.grmm.inference.gbp.RegionGraph;
import cc.mallet.grmm.types.DiscreteFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.LogTableFactor;
import cc.mallet.grmm.types.TableFactor;
import java.util.Iterator;

class MessageArray {
    private DiscreteFactor[][] messages;

    private MessageArray() {
    }

    public MessageArray(RegionGraph rg) {
        int size = rg.size();
        this.messages = new TableFactor[size][size];
        Iterator it = rg.iterator();
        while (it.hasNext()) {
            Region from = (Region)it.next();
            for (Region to : from.children) {
                LogTableFactor ptl = new LogTableFactor(to.vars);
                this.messages[from.index][to.index] = ptl;
            }
        }
    }

    public MessageArray(TableFactor[][] messages) {
        this.messages = messages;
    }

    DiscreteFactor getMessage(Region from, Region to) {
        return this.messages[from.index][to.index];
    }

    public void setMessage(Region from, Region to, TableFactor result) {
        this.messages[from.index][to.index] = result;
    }

    public MessageArray duplicate() {
        MessageArray arr = new MessageArray();
        arr.messages = new TableFactor[this.messages.length][this.messages.length];
        for (int i = 0; i < this.messages.length; ++i) {
            for (int j = 0; j < this.messages[i].length; ++j) {
                if (this.messages[i][j] == null) continue;
                arr.messages[i][j] = (TableFactor)this.messages[i][j].duplicate();
            }
        }
        return arr;
    }

    public int size() {
        return this.messages.length;
    }

    public Factor getMessage(int i, int j) {
        return this.messages[i][j];
    }
}

