/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

public final class Strings {
    public static int commonPrefixIndex(String[] strings) {
        int prefixLen = strings[0].length();
        block0: for (int i = 1; i < strings.length; ++i) {
            if (strings[i].length() < prefixLen) {
                prefixLen = strings[i].length();
            }
            if (prefixLen == 0) {
                return 0;
            }
            for (int j = 0; j < prefixLen; ++j) {
                if (strings[i - 1].charAt(j) == strings[i].charAt(j)) continue;
                prefixLen = j;
                continue block0;
            }
        }
        return prefixLen;
    }

    public static String commonPrefix(String[] strings) {
        return strings[0].substring(0, Strings.commonPrefixIndex(strings));
    }

    public static int count(String string, char ch) {
        int idx = -1;
        int count = 0;
        while ((idx = string.indexOf(ch, idx + 1)) >= 0) {
            ++count;
        }
        return count;
    }

    public static double levenshteinDistance(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return 1.0;
        }
        if (m == 0) {
            return 1.0;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = Strings.minimum(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        int longer = n > m ? n : m;
        return (double)d[n][m] / (double)longer;
    }

    private static int minimum(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }
}

