/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.topology.SteinerTree;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.ui.RoutingDebug;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpCoord;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.MutableBoolean;
import com.sun.electric.util.math.MutableDouble;
import com.sun.electric.util.math.MutableInteger;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SeaOfGatesEngine {
    public static final boolean DEBUGGRIDDING = false;
    public static final boolean NEWBLOCKAGE = true;
    private static final boolean ANYPOINTONDESTINATION = true;
    private static final boolean STICKTOJUMPEDGES = false;
    private static final double SPINERATIO = 50.0;
    private static final double GRAINSIZE = 1.0;
    private static final int COSTALTERNATINGMETAL = 20;
    private static final int COSTLAYERCHANGE = 8;
    private static final int COSTWRONGDIRECTION = 15;
    private static final int COSTUNFAVORED = 10;
    private static final int COSTTURNING = 1;
    private static final int COSTOFFGRID = 15;
    private static final int OFFSETVIRTUAL = 1;
    private static final int OFFSETENDA = 2;
    private static final int OFFSETENDB = 4;
    public static SearchVertex svAborted = new SearchVertex(0.0, 0.0, 0, 0, null, null, 0, null);
    public static SearchVertex svExhausted = new SearchVertex(0.0, 0.0, 0, 0, null, null, 0, null);
    public static SearchVertex svLimited = new SearchVertex(0.0, 0.0, 0, 0, null, null, 0, null);
    public static SearchVertex svAbandoned = new SearchVertex(0.0, 0.0, 0, 0, null, null, 0, null);
    private static int numMetalLayers;
    protected Environment env;
    private Cell cell;
    private boolean parallelDij;
    private ErrorLogger errorLogger;
    private Rectangle2D cellBounds;
    private Technology tech;
    private Layer[] metalLayers;
    private Layer[] viaLayers;
    private ArcProto[] metalArcs;
    private boolean[] favorArcs;
    private boolean[] preventArcs;
    private MetalVias[] metalVias;
    private double[][] metalGrid;
    private double[] metalGridRange;
    private double[] metalSurround;
    private double[] worstMetalSurround;
    private double[] viaSurround;
    private BlockageTrees rTrees;
    private Map<Network, Integer> netIDs;
    private SeaOfGates.SeaOfGatesOptions prefs;
    public Handler handler;
    private EditingPreferences ep;
    private SeaOfGates.SeaOfGatesCellParameters sogp;
    private List<NeededRoute> tapRoutes;
    private boolean messagesQuiet;
    private int totalBlockages;
    private int blockagesFound;
    private Map<Double, Map<Double, double[]>>[] layerSurround;
    private double totalWireLength;
    Map<Integer, List<MutableInteger>> netIDsByValue = new HashMap<Integer, List<MutableInteger>>();

    public void routeIt(Handler handler, Cell cell, boolean quiet) {
        this.routeIt(handler, cell, quiet, null);
    }

    public void routeIt(Handler handler, Cell cell, boolean quiet, List<ArcInst> arcsToRoute) {
        this.routeIt(handler, cell, quiet, arcsToRoute, new SeaOfGates.SeaOfGatesCellParameters(cell));
    }

    public void routeIt(Handler handler, Cell cell, boolean quiet, List<ArcInst> arcsToRoute, SeaOfGates.SeaOfGatesCellParameters sogp) {
        this.messagesQuiet = quiet;
        this.totalWireLength = 0.0;
        this.handler = handler;
        this.ep = handler.getEditingPreferences();
        this.env = cell.getDatabase().getEnvironment();
        this.sogp = sogp;
        this.tapRoutes = new ArrayList<NeededRoute>();
        this.cell = cell;
        this.cellBounds = cell.getBounds();
        this.tech = cell.getTechnology();
        if (this.initializeDesignRules()) {
            return;
        }
        this.initializeGrids();
        this.netIDs = new HashMap<Network, Integer>();
        this.errorLogger = ErrorLogger.newInstance("Routing (Sea of gates) " + cell.describe(false));
        this.prefs.theTimer = ElapseTimer.createInstance().start();
        Netlist netList = cell.getNetlist();
        Set<String> netsToRoute = sogp.getNetsToRoute();
        if (netsToRoute != null && netsToRoute.size() > 0) {
            boolean allSelected = true;
            if (arcsToRoute != null) {
                Iterator<ArcInst> it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = it.next();
                    if (ai.getProto() != Generic.tech().unrouted_arc || arcsToRoute.contains(ai)) continue;
                    allSelected = false;
                    break;
                }
            }
            if (allSelected) {
                arcsToRoute = new ArrayList<ArcInst>();
                for (String netName : netsToRoute) {
                    ArcInst ai = cell.findArc(netName);
                    if (ai == null) {
                        System.out.println("WARNING: Could not find network '" + netName + "' which was requested by the Sea-of-Gates Cell Properties");
                        continue;
                    }
                    Network net = netList.getNetwork(ai, 0);
                    if (net == null) continue;
                    Iterator<ArcInst> it = net.getArcs();
                    while (it.hasNext()) {
                        ai = it.next();
                        arcsToRoute.add(ai);
                    }
                }
                System.out.println("Routing " + arcsToRoute.size() + " arcs from the list given in the Sea-of-Gates Cell Properties");
            }
        }
        if (arcsToRoute == null) {
            arcsToRoute = new ArrayList<ArcInst>();
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                arcsToRoute.add(ai);
            }
        }
        if (arcsToRoute.isEmpty()) {
            return;
        }
        this.setProgressNote("Make list of routes...");
        if (!RoutingDebug.isActive()) {
            handler.startProgressDialog("Routing " + arcsToRoute.size() + " nets in cell " + cell.describe(false));
        }
        ArrayList<EPoint> linesInNonMahnattan = new ArrayList<EPoint>();
        RouteBatch[] routeBatches = this.makeListOfRoutes(netList, arcsToRoute, linesInNonMahnattan);
        MutableBoolean hadNonmanhattan = new MutableBoolean(linesInNonMahnattan.size() > 0);
        if (routeBatches.length == 0) {
            return;
        }
        if (RoutingDebug.isRewireNetworks()) {
            this.rewireNetworks(routeBatches);
            return;
        }
        ArrayList<NeededRoute> allRoutes = new ArrayList<NeededRoute>();
        for (int b = 0; b < routeBatches.length; ++b) {
            for (NeededRoute nr : routeBatches[b].routesInBatch) {
                allRoutes.add(nr);
            }
        }
        this.info("");
        this.info("Sea-of-gates router finding " + allRoutes.size() + " paths on " + routeBatches.length + " networks in cell " + cell.describe(false));
        if (hadNonmanhattan.booleanValue()) {
            String info = "Found nonmanhattan geometry. This will cause large rectangular blockages, which may block too much.";
            this.warn(info);
            this.errorLogger.logMessageWithLines(info, linesInNonMahnattan, linesInNonMahnattan, cell, 0, false);
        }
        if (this.prefs.useGlobalRouter || RoutingDebug.isTestGlobalRouting()) {
            this.setProgressNote("Do Global Routing...");
            this.info("Doing Global Routing...");
            RouteBatch[] fakeRBs = null;
            if (RoutingDebug.isActive()) {
                HashMap<Network, RouteBatch> additionalRBs = new HashMap<Network, RouteBatch>();
                HashSet<ArcInst> arcsInCell = new HashSet<ArcInst>();
                for (ArcInst ai : arcsToRoute) {
                    arcsInCell.add(ai);
                }
                Iterator<ArcInst> it = cell.getArcs();
                while (it.hasNext()) {
                    ArcProto bArc;
                    ArcInst ai;
                    ai = it.next();
                    if (ai.getProto() != Generic.tech().unrouted_arc || arcsInCell.contains(ai)) continue;
                    Network net = netList.getNetwork(ai, 0);
                    RouteBatch rb = (RouteBatch)additionalRBs.get(net);
                    if (rb == null) {
                        rb = new RouteBatch();
                        additionalRBs.put(net, rb);
                    }
                    PortInst aPi = ai.getHeadPortInst();
                    PortInst bPi = ai.getTailPortInst();
                    ArcProto aArc = this.getMetalArcOnPort(aPi);
                    if (aArc == null || (bArc = this.getMetalArcOnPort(bPi)) == null) continue;
                    NeededRoute nr = new NeededRoute(net.getName(), aPi, bPi, aArc, bArc, null, 0.0);
                    rb.addRoute(nr);
                }
                fakeRBs = new RouteBatch[additionalRBs.size()];
                int i = 0;
                for (Network net : additionalRBs.keySet()) {
                    fakeRBs[i++] = (RouteBatch)additionalRBs.get(net);
                }
            }
            double wirePitch = this.metalSurround[0] + this.metalArcs[0].getDefaultLambdaBaseWidth(this.ep);
            GlobalRouter gr = this.doGlobalRouting(cell, routeBatches, fakeRBs, wirePitch);
            ArrayList<NeededRoute> withGR = new ArrayList<NeededRoute>();
            ArrayList<NeededRoute> withoutGR = new ArrayList<NeededRoute>();
            for (NeededRoute nr : allRoutes) {
                if (nr.buckets != null) {
                    withGR.add(nr);
                    continue;
                }
                withoutGR.add(nr);
            }
            this.info("Global Routing planned " + withGR.size() + " paths in " + gr.getXBuckets() + "x" + gr.getYBuckets() + " buckets (" + withoutGR.size() + " paths are too short to route globally)");
            if (RoutingDebug.isActive()) {
                RoutingDebug.setGlobalRouting(gr);
            }
            if (RoutingDebug.isTestGlobalRouting()) {
                RoutingDebug.showGlobalRouting();
                return;
            }
            this.setProgressNote("Detail Route " + allRoutes.size() + " paths...");
            this.info("Detail Routing " + allRoutes.size() + " paths...");
        } else {
            this.setProgressNote("Route " + allRoutes.size() + " paths...");
            this.info("Routing " + allRoutes.size() + " paths...");
        }
        for (NeededRoute nr : allRoutes) {
            if (nr.spineTaps != null) {
                nr.routeName = nr.routeName + " (spine)";
                continue;
            }
            if (((NeededRoute)nr).batch.routesInBatch.size() <= 1) continue;
            nr.routeName = nr.routeName + (" (" + (nr.routeInBatch + 1) + " of " + ((NeededRoute)nr).batch.routesInBatch.size() + ")");
        }
        if (RoutingDebug.isActive() && allRoutes.size() > 0) {
            int whichRoute = RoutingDebug.getDesiredRouteToDebug();
            if (whichRoute < 0) {
                whichRoute = 0;
            }
            if (whichRoute >= allRoutes.size()) {
                whichRoute = allRoutes.size() - 1;
            }
            NeededRoute nr = (NeededRoute)allRoutes.get(whichRoute);
            if (RoutingDebug.isDisplayAreaBlockages()) {
                RoutingDebug.showGeometryInArea(nr);
                return;
            }
            if (RoutingDebug.isDisplayEndBlockages()) {
                RoutingDebug.showGeometryAtRouteEnds(nr);
                return;
            }
            if (RoutingDebug.isTestRoutingGrid()) {
                RoutingDebug.showRoutingGrid(nr);
                return;
            }
            if (RoutingDebug.isDisplayRouting()) {
                RoutingDebug.debugRoute(nr, allRoutes);
                return;
            }
        }
        boolean parallel = this.prefs.useParallelRoutes;
        this.parallelDij = this.prefs.useParallelFromToRoutes;
        int numberOfProcessors = Runtime.getRuntime().availableProcessors();
        if (numberOfProcessors <= 1) {
            this.parallelDij = false;
        }
        int numberOfThreads = numberOfProcessors;
        if (this.prefs.forcedNumberOfThreads > 0) {
            this.info("Forcing use of " + this.prefs.forcedNumberOfThreads + " threads");
            numberOfThreads = this.prefs.forcedNumberOfThreads;
        }
        if (!parallel) {
            numberOfThreads = 1;
        }
        if (numberOfThreads == 1) {
            parallel = false;
            this.parallelDij = false;
        }
        if (parallel) {
            String message = "NOTE: System has " + numberOfProcessors + " processors so";
            if (this.parallelDij) {
                message = message + " routing " + numberOfThreads / 2 + " paths in parallel";
                message = message + " and routing both directions of each path in parallel";
            } else {
                message = message + " routing " + numberOfThreads + " paths in parallel";
            }
            this.info(message);
        }
        if (numberOfThreads > 1) {
            this.doRoutingParallel(numberOfThreads, allRoutes);
        } else {
            this.doRouting(allRoutes);
        }
        handler.flush(true);
        if (this.tapRoutes.size() > 0) {
            this.setProgressNote("Adding taps to spine routes...");
            this.info("------------------ Adding taps to spine routes...");
            if (numberOfThreads > 1) {
                this.doRoutingParallel(numberOfThreads, this.tapRoutes);
            } else {
                this.doRouting(this.tapRoutes);
            }
            handler.flush(true);
        }
        ArrayList<NeededRoute> redoRoutes = new ArrayList<NeededRoute>();
        for (int b = 0; b < routeBatches.length; ++b) {
            for (NeededRoute nr : routeBatches[b].routesInBatch) {
                if (nr.routedSuccess) continue;
                redoRoutes.add(nr);
                NeededRoute.access$002(nr, null);
                nr.errorMessage = null;
                nr.complexityLimit = this.prefs.rerunComplexityLimit;
                nr.makeWavefronts();
            }
        }
        if (this.prefs.reRunFailedRoutes && redoRoutes.size() > 0) {
            this.setProgressNote("Re-Route " + redoRoutes.size() + " paths...");
            this.info("------------------ Re-Route " + redoRoutes.size() + " paths...");
            for (NeededRoute nr : redoRoutes) {
                nr.reroute = true;
            }
            if (numberOfThreads > 1) {
                this.doRoutingParallel(numberOfThreads, redoRoutes);
            } else {
                this.doRouting(redoRoutes);
            }
            handler.flush(true);
        }
        RouteResolution resolution = new RouteResolution(cell.getId());
        for (int b = 0; b < routeBatches.length; ++b) {
            for (NeededRoute nr : routeBatches[b].routesInBatch) {
                if (nr.routedSuccess) continue;
                resolution.addUnrouted(nr.aPi, nr.bPi);
            }
        }
        handler.instantiate(resolution);
        handler.flush(true);
        this.summarize(routeBatches, allRoutes);
        handler.termLogging(this.errorLogger);
        handler.stopProgressDialog();
    }

    public RTNode<SOGBound> getMetalTree(Layer lay) {
        return this.rTrees.getMetalTree(lay).getRoot();
    }

    public Iterator<SOGBound> searchMetalTree(Layer lay, Rectangle2D bound) {
        return this.rTrees.getMetalTree(lay).search(bound);
    }

    private void rewireNetworks(RouteBatch[] routeBatches) {
        for (int b = 0; b < routeBatches.length; ++b) {
            RouteBatch rb = routeBatches[b];
            RouteResolution res = rb.resolution;
            for (ArcInst aiKill : rb.unroutedArcs) {
                res.killArc(aiKill);
            }
            for (NodeInst niKill : rb.unroutedNodes) {
                res.killNode(niKill);
            }
            for (NeededRoute nr : rb.routesInBatch) {
                res.addUnrouted(nr.aPi, nr.bPi);
            }
            this.handler.instantiate(res);
        }
        this.handler.flush(true);
        this.sogp.setSteinerDone(true);
        this.sogp.saveParameters(this.ep);
    }

    private void summarize(RouteBatch[] routeBatches, List<NeededRoute> allRoutes) {
        int numRoutedSegments = 0;
        int numFailedNets = 0;
        int numFailedBatches = 0;
        for (int b = 0; b < routeBatches.length; ++b) {
            boolean failed = false;
            for (NeededRoute nr : routeBatches[b].routesInBatch) {
                if (nr.routedSuccess) {
                    ++numRoutedSegments;
                    continue;
                }
                if (nr.errorMessage == null) continue;
                failed = true;
                ++numFailedNets;
            }
            if (!failed) continue;
            ++numFailedBatches;
        }
        this.prefs.theTimer.end();
        this.info("Cell " + this.cell.describe(false) + " routed " + numRoutedSegments + " out of " + allRoutes.size() + " segments; total length of routed wires is " + this.formatDistance(this.totalWireLength) + " (took " + this.prefs.theTimer + ")");
        if (numFailedNets > 0) {
            this.info("NOTE: " + numFailedNets + " segments on " + numFailedBatches + " nets were not routed");
        }
    }

    public void setPrefs(SeaOfGates.SeaOfGatesOptions p) {
        this.prefs = p;
    }

    public SeaOfGates.SeaOfGatesOptions getPrefs() {
        return this.prefs;
    }

    public Technology getTech() {
        return this.tech;
    }

    public int getNumMetals() {
        return numMetalLayers;
    }

    public Layer getMetalLayer(int layNum) {
        return this.metalLayers[layNum];
    }

    public Layer getViaLayer(int layNum) {
        return this.viaLayers[layNum];
    }

    protected String formatDistance(double v) {
        return TextUtils.formatDistance(v, this.tech);
    }

    protected String describe(NodeInst ni) {
        NodeProto np = ni.getProto();
        boolean libDescribe = np instanceof Cell ? ((Cell)np).getLibrary() != this.cell.getLibrary() : ((PrimitiveNode)np).getTechnology() != this.tech;
        return libDescribe ? ni.libDescribe() : ni.noLibDescribe();
    }

    protected String describe(ArcInst ai) {
        ArcProto ap = ai.getProto();
        boolean libDescribe = ap.getTechnology() != this.tech;
        return libDescribe ? ai.libDescribe() : ai.noLibDescribe();
    }

    protected String describe(NodeProto np) {
        boolean libDescribe = np instanceof Cell ? ((Cell)np).getLibrary() != this.cell.getLibrary() : ((PrimitiveNode)np).getTechnology() != this.tech;
        return libDescribe ? np.libDescribe() : np.noLibDescribe();
    }

    protected String describe(ArcProto ap) {
        boolean libDescribe = ap.getTechnology() != this.tech;
        return libDescribe ? ap.getFullName() : ap.getName();
    }

    protected boolean checkAbort() {
        return this.handler.checkAbort();
    }

    protected void trace(String msg) {
        this.handler.trace(msg);
    }

    protected void debug(String msg) {
        this.handler.debug(msg);
    }

    protected void info(String msg) {
        this.handler.info(msg);
    }

    protected void warn(String msg) {
        this.handler.warn(msg);
    }

    protected void error(String msg) {
        this.handler.error(msg);
    }

    protected void setProgressNote(String message) {
        if (!RoutingDebug.isActive()) {
            this.handler.setProgressNote(message);
        }
    }

    protected void setProgressValue(int done, int total) {
        if (!RoutingDebug.isActive()) {
            this.handler.setProgressValue(done, total);
        }
    }

    void flush() {
        this.handler.flush(false);
    }

    protected abstract void doRoutingParallel(int var1, List<NeededRoute> var2);

    private void doRouting(List<NeededRoute> allRoutes) {
        int totalRoutes = allRoutes.size();
        for (int r = 0; r < totalRoutes; ++r) {
            Runnable[] runnables;
            if (this.checkAbort()) {
                this.info("Sea-of-gates routing aborted");
                break;
            }
            NeededRoute nr = allRoutes.get(r);
            this.setProgressValue(r, totalRoutes);
            this.setProgressNote("Network " + nr.routeName);
            if (!this.messagesQuiet) {
                this.trace("Routing network " + nr.routeName + "...");
            }
            if ((runnables = this.findPath(nr)) == null) continue;
            for (Runnable runnable : runnables) {
                runnable.run();
            }
        }
    }

    private boolean initializeDesignRules() {
        int i;
        int i2;
        numMetalLayers = this.tech.getNumMetals();
        this.metalLayers = new Layer[numMetalLayers];
        this.metalArcs = new ArcProto[numMetalLayers];
        this.favorArcs = new boolean[numMetalLayers];
        this.preventArcs = new boolean[numMetalLayers];
        this.viaLayers = new Layer[numMetalLayers - 1];
        this.metalVias = new MetalVias[numMetalLayers - 1];
        for (int i3 = 0; i3 < numMetalLayers - 1; ++i3) {
            this.metalVias[i3] = new MetalVias();
        }
        Iterator<Layer> it = this.tech.getLayers();
        while (it.hasNext()) {
            int layerIndex;
            Layer lay = it.next();
            if (!lay.getFunction().isMetal() || (layerIndex = lay.getFunction().getLevel() - 1) >= numMetalLayers) continue;
            this.metalLayers[layerIndex] = lay;
        }
        boolean hasFavorites = false;
        Iterator<ArcProto> it2 = this.tech.getArcs();
        block2: while (it2.hasNext()) {
            ArcProto ap = it2.next();
            for (int i4 = 0; i4 < numMetalLayers; ++i4) {
                if (ap.getLayer(0) != this.metalLayers[i4]) continue;
                this.metalArcs[i4] = ap;
                this.favorArcs[i4] = this.sogp.isFavored(ap);
                if (this.favorArcs[i4]) {
                    hasFavorites = true;
                }
                this.preventArcs[i4] = this.sogp.isPrevented(ap);
                continue block2;
            }
        }
        if (!hasFavorites) {
            for (int i5 = 0; i5 < numMetalLayers; ++i5) {
                this.favorArcs[i5] = true;
            }
        }
        String ignorePattern = this.sogp.getIgnorePrimitives();
        String acceptPattern = this.sogp.getAcceptOnlyPrimitives();
        boolean contactsCanRotate = this.sogp.isContactsRotate();
        Pattern ignorePat = ignorePattern != null ? Pattern.compile(ignorePattern) : null;
        Pattern acceptPat = acceptPattern != null ? Pattern.compile(acceptPattern) : null;
        Iterator<PrimitiveNode> it3 = this.tech.getNodes();
        block5: while (it3.hasNext()) {
            Matcher matcher;
            PrimitiveNode np = it3.next();
            if (np.isNotUsed() || !np.getFunction().isContact() || ignorePat != null && (matcher = ignorePat.matcher(np.getName())).find() || acceptPat != null && !(matcher = acceptPat.matcher(np.getName())).find()) continue;
            ArcProto[] conns = np.getPort(0).getConnections();
            for (int i6 = 0; i6 < numMetalLayers - 1; ++i6) {
                if ((conns[0] != this.metalArcs[i6] || conns[1] != this.metalArcs[i6 + 1]) && (conns[1] != this.metalArcs[i6] || conns[0] != this.metalArcs[i6 + 1])) continue;
                boolean square = true;
                boolean offCenter = false;
                NodeInst dummyNi = NodeInst.makeDummyInstance((NodeProto)np, this.ep);
                Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                int horMet = -1;
                int verMet = -1;
                double horMetInset = 0.0;
                double verMetInset = 0.0;
                for (int p = 0; p < conPolys.length; ++p) {
                    Poly conPoly = conPolys[p];
                    Layer conLayer = conPoly.getLayer();
                    Layer.Function lFun = conLayer.getFunction();
                    if (lFun.isMetal()) {
                        FixpRectangle conRect = conPoly.getBounds2D();
                        if (((RectangularShape)conRect).getWidth() != ((RectangularShape)conRect).getHeight()) {
                            square = false;
                            if (((RectangularShape)conRect).getWidth() > ((RectangularShape)conRect).getHeight()) {
                                horMet = lFun.getLevel() - 1;
                                horMetInset = dummyNi.getYSize() - ((RectangularShape)conRect).getHeight();
                            } else {
                                verMet = lFun.getLevel() - 1;
                                verMetInset = dummyNi.getXSize() - ((RectangularShape)conRect).getWidth();
                            }
                        }
                        if (((RectangularShape)conRect).getCenterX() == 0.0 && ((RectangularShape)conRect).getCenterY() == 0.0) continue;
                        offCenter = true;
                        continue;
                    }
                    if (!lFun.isContact()) continue;
                    this.viaLayers[i6] = conLayer;
                }
                if (square || offCenter) {
                    verMet = -1;
                    horMet = -1;
                } else if (horMet < 0 || verMet < 0) {
                    verMet = -1;
                    horMet = -1;
                }
                this.metalVias[i6].addVia(np, 0, horMet, horMetInset, verMet, verMetInset);
                if (!contactsCanRotate) continue block5;
                if (offCenter) {
                    this.metalVias[i6].addVia(np, 90, horMet, horMetInset, verMet, verMetInset);
                    this.metalVias[i6].addVia(np, 180, horMet, horMetInset, verMet, verMetInset);
                    this.metalVias[i6].addVia(np, 270, horMet, horMetInset, verMet, verMetInset);
                    continue block5;
                }
                if (square) continue block5;
                this.metalVias[i6].addVia(np, 90, verMet, verMetInset, horMet, horMetInset);
                continue block5;
            }
        }
        for (i2 = 0; i2 < numMetalLayers; ++i2) {
            if (this.metalLayers[i2] == null) {
                this.error("Cannot find layer for Metal " + (i2 + 1));
                return true;
            }
            if (this.metalArcs[i2] == null) {
                this.error("Cannot find arc for Metal " + (i2 + 1));
                return true;
            }
            if (i2 >= numMetalLayers - 1) continue;
            boolean noContact = false;
            if (this.metalVias[i2].getVias().size() == 0) {
                this.warn("Cannot find contact node between Metal " + (i2 + 1) + " and Metal " + (i2 + 2) + " in technology " + this.tech.getTechName() + ". Ignoring Metal layers " + (i2 + 2) + " and higher.");
                noContact = true;
            } else if (this.viaLayers[i2] == null) {
                this.warn("Cannot find contact layer between Metal " + (i2 + 1) + " and Metal " + (i2 + 2) + " in technology " + this.tech.getTechName() + ". Ignoring Metal layers " + (i2 + 2) + " and higher.");
                noContact = true;
            }
            if (!noContact) continue;
            for (int j = i2 + 1; j < numMetalLayers; ++j) {
                this.preventArcs[j] = true;
            }
            break;
        }
        this.layerSurround = new Map[numMetalLayers];
        for (i2 = 0; i2 < numMetalLayers; ++i2) {
            this.layerSurround[i2] = new HashMap<Double, Map<Double, double[]>>();
        }
        this.metalSurround = new double[numMetalLayers];
        this.worstMetalSurround = new double[numMetalLayers];
        MutableDouble mutableDist = new MutableDouble(0.0);
        for (i = 0; i < numMetalLayers; ++i) {
            DRCTemplate rule = DRC.getSpacingRule(this.metalLayers[i], null, this.metalLayers[i], null, false, -1, this.metalArcs[i].getDefaultLambdaBaseWidth(this.ep), 50.0);
            this.metalSurround[i] = 0.0;
            if (rule != null) {
                this.metalSurround[i] = rule.getValue(0);
            }
            if (!DRC.getMaxSurround(this.metalLayers[i], Double.MAX_VALUE, mutableDist)) continue;
            this.worstMetalSurround[i] = mutableDist.doubleValue();
        }
        this.viaSurround = new double[numMetalLayers - 1];
        for (i = 0; i < numMetalLayers - 1; ++i) {
            Layer lay = this.viaLayers[i];
            if (lay == null) continue;
            double spacing = 2.0;
            double arcWidth = this.metalArcs[i].getDefaultLambdaBaseWidth(this.ep);
            DRCTemplate ruleSpacing = DRC.getSpacingRule(lay, null, lay, null, false, -1, arcWidth, 50.0);
            if (ruleSpacing != null) {
                spacing = ruleSpacing.getValue(0);
            }
            double width = 0.0;
            DRCTemplate ruleWidth = DRC.getMinValue(lay, DRCTemplate.DRCRuleType.NODSIZ);
            if (ruleWidth != null) {
                width = ruleWidth.getValue(0);
            }
            List<MetalVia> nps = this.metalVias[i].getVias();
            for (MetalVia mv : nps) {
                NodeInst dummyNi = NodeInst.makeDummyInstance((NodeProto)mv.via, this.ep);
                Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                for (int p = 0; p < conPolys.length; ++p) {
                    Poly conPoly = conPolys[p];
                    if (!conPoly.getLayer().getFunction().isContact()) continue;
                    FixpRectangle bounds = conPoly.getBounds2D();
                    width = Math.max(width, ((RectangularShape)bounds).getWidth());
                    width = Math.max(width, ((RectangularShape)bounds).getHeight());
                }
            }
            this.viaSurround[i] = spacing + width;
        }
        return false;
    }

    private void initializeGrids() {
        this.metalGrid = new double[numMetalLayers][];
        this.metalGridRange = new double[numMetalLayers];
        for (int i = 0; i < numMetalLayers; ++i) {
            int j;
            ArcProto ap = this.metalArcs[i];
            String arcGrid = this.sogp.getGrid(ap);
            if (arcGrid == null) {
                this.metalGrid[i] = null;
                this.metalGridRange[i] = 0.0;
                continue;
            }
            ArrayList<Double> found = new ArrayList<Double>();
            String[] parts = arcGrid.split(",");
            for (j = 0; j < parts.length; ++j) {
                String part = parts[j].trim();
                if (part.length() == 0) continue;
                double val = com.sun.electric.util.TextUtils.atof(part);
                found.add(new Double(val));
            }
            this.metalGrid[i] = new double[found.size()];
            for (j = 0; j < found.size(); ++j) {
                this.metalGrid[i][j] = (Double)found.get(j);
            }
            this.metalGridRange[i] = this.metalGrid[i][found.size() - 1] - this.metalGrid[i][0];
        }
    }

    private RouteBatch[] makeListOfRoutes(Netlist netList, List<ArcInst> arcsToRoute, List<EPoint> linesInNonMahnattan) {
        ArrayList<RoutesOnNetwork> allRoutes = new ArrayList<RoutesOnNetwork>();
        if (RoutingDebug.isActive() && !RoutingDebug.isRewireNetworks()) {
            ArcInst ai = arcsToRoute.get(0);
            Network net = netList.getNetwork(ai, 0);
            RoutesOnNetwork ron = new RoutesOnNetwork(net.getName());
            allRoutes.add(ron);
            ron.unroutedArcs.add(ai);
            ron.addUnorderedPort(ai.getHeadPortInst());
            ron.addUnorderedPort(ai.getTailPortInst());
            ron.pairs.add(new SteinerTree.SteinerTreePortPair(ai.getHeadPortInst(), ai.getTailPortInst()));
        } else {
            HashMap<Network, ArrayList<ArcInst>> seen = new HashMap<Network, ArrayList<ArcInst>>();
            for (int b = 0; b < arcsToRoute.size(); ++b) {
                ArcInst ai = arcsToRoute.get(b);
                Network net = netList.getNetwork(ai, 0);
                if (net == null) {
                    this.warn("Arc " + this.describe(ai) + " has no network!");
                    continue;
                }
                ArrayList<ArcInst> arcsOnNet = (ArrayList<ArcInst>)seen.get(net);
                if (arcsOnNet == null) {
                    arcsOnNet = new ArrayList<ArcInst>();
                    seen.put(net, arcsOnNet);
                }
                arcsOnNet.add(ai);
            }
            ArrayList<Network> allNets = new ArrayList<Network>();
            for (Network net : seen.keySet()) {
                allNets.add(net);
            }
            Collections.sort(allNets);
            for (Network net : allNets) {
                RoutesOnNetwork ron = new RoutesOnNetwork(net.getName());
                allRoutes.add(ron);
                List arcsOnNet = (List)seen.get(net);
                for (ArcInst ai : arcsOnNet) {
                    ron.unroutedArcs.add(ai);
                    ron.addUnorderedPort(ai.getHeadPortInst());
                    ron.addUnorderedPort(ai.getTailPortInst());
                }
                if (this.sogp.isSteinerDone()) {
                    for (ArcInst ai : arcsOnNet) {
                        ron.pairs.add(new SteinerTree.SteinerTreePortPair(ai.getHeadPortInst(), ai.getTailPortInst()));
                    }
                    continue;
                }
                if (this.prefs.enableSpineRouting && ron.setupSpineInfo()) continue;
                ArrayList<SteinerTree.SteinerTreePort> portList = new ArrayList<SteinerTree.SteinerTreePort>();
                for (PortInst pi : ron.unorderedPorts) {
                    portList.add(new PortInstShadow(pi));
                }
                SteinerTree st = new SteinerTree(portList);
                ron.pairs = st.getTreeBranches();
                if (ron.pairs != null) continue;
                String errMsg = "Arcs in " + net.getName() + " do not make valid connection: deleted";
                this.error(errMsg);
                ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                for (ArcInst delAi : ron.unroutedArcs) {
                    lineList.add(delAi.getHeadLocation());
                    lineList.add(delAi.getTailLocation());
                }
                this.errorLogger.logMessageWithLines(errMsg, null, lineList, this.cell, 0, true);
            }
        }
        if (this.buildRTrees(netList, arcsToRoute, linesInNonMahnattan)) {
            this.info("Non-Manhattan geometry found");
        }
        this.totalBlockages = this.getNumBlockages();
        this.blockagesFound = 0;
        this.setProgressNote("Extract connectivity (" + this.totalBlockages + " blockages)");
        this.setProgressValue(0, 100);
        for (RoutesOnNetwork ron : allRoutes) {
            double minWidth = this.getMinWidth(ron.unorderedPorts);
            for (int i = 0; i < ron.pairs.size(); ++i) {
                NeededRoute nr;
                ArcProto bArc;
                SteinerTree.SteinerTreePort obj2;
                SteinerTree.SteinerTreePort obj1 = ron.pairs.get(i).getPort1();
                if (obj1 instanceof PortInstShadow) {
                    obj1 = ((PortInstShadow)obj1).getPortInst();
                }
                if ((obj2 = ron.pairs.get(i).getPort2()) instanceof PortInstShadow) {
                    obj2 = ((PortInstShadow)obj2).getPortInst();
                }
                PortInst aPi = (PortInst)obj1;
                PortInst bPi = (PortInst)obj2;
                ArcProto aArc = this.getMetalArcOnPort(aPi);
                if (aArc == null || (bArc = this.getMetalArcOnPort(bPi)) == null || this.inValidPort(aPi, nr = new NeededRoute(ron.netName, aPi, bPi, aArc, bArc, ron.spineTapPorts, minWidth)) || this.inValidPort(bPi, nr)) continue;
                ron.neededRoutes.add(nr);
                Iterator<ArcInst> it = ron.unroutedArcs.iterator();
                ArcInst sampleArc = it.next();
                Network net = netList.getNetwork(sampleArc, 0);
                nr.setNetID(net);
                nr.growNetwork();
            }
        }
        this.setProgressNote("Final Prepare for Routing...");
        this.setProgressValue(0, 100);
        TreeMap<Integer, TreeSet<RoutesOnNetwork>> uniqueNets = new TreeMap<Integer, TreeSet<RoutesOnNetwork>>();
        for (RoutesOnNetwork ron : allRoutes) {
            int netNumber = -1;
            for (NeededRoute nr : ron.neededRoutes) {
                int thisNetNumber = nr.netID.intValue();
                if (netNumber < 0) {
                    netNumber = thisNetNumber;
                }
                if (netNumber == thisNetNumber) continue;
                this.error("Error: network " + ron.netName + " has network IDs " + netNumber + " and " + thisNetNumber);
            }
            Integer id = netNumber;
            TreeSet<RoutesOnNetwork> mergedRoutes = (TreeSet<RoutesOnNetwork>)uniqueNets.get(id);
            if (mergedRoutes == null) {
                mergedRoutes = new TreeSet<RoutesOnNetwork>();
                uniqueNets.put(id, mergedRoutes);
            }
            mergedRoutes.add(ron);
        }
        ArrayList<RouteBatch> allBatches = new ArrayList<RouteBatch>();
        for (Integer netID : uniqueNets.keySet()) {
            Set mergedRoutes = (Set)uniqueNets.get(netID);
            RouteBatch rb = null;
            for (RoutesOnNetwork ron : mergedRoutes) {
                if (rb == null) {
                    rb = new RouteBatch();
                    allBatches.add(rb);
                }
                for (ArcInst ai : ron.unroutedArcs) {
                    rb.unroutedArcs.add(ai);
                    if (rb.isPwrGnd) continue;
                    Network net = netList.getNetwork(ai, 0);
                    Iterator<Export> it = net.getExports();
                    while (it.hasNext()) {
                        Export e = it.next();
                        if (!e.isGround() && !e.isPower()) continue;
                        rb.isPwrGnd = true;
                        break;
                    }
                    PortProto headPort = ai.getHeadPortInst().getPortProto();
                    PortProto tailPort = ai.getTailPortInst().getPortProto();
                    if (!headPort.isGround() && !headPort.isPower() && !tailPort.isGround() && !tailPort.isPower()) continue;
                    rb.isPwrGnd = true;
                }
                for (NeededRoute nr : ron.neededRoutes) {
                    nr.setBatchInfo(rb, rb.routesInBatch.size());
                    double dX = nr.getAX() - nr.getBX();
                    double dY = nr.getAY() - nr.getBY();
                    rb.length += Math.sqrt(dX * dX + dY * dY);
                    rb.addRoute(nr);
                }
            }
        }
        for (RouteBatch rb : allBatches) {
            for (NeededRoute nr : rb.routesInBatch) {
                nr.addBlockagesAtPorts(nr.aPi);
                nr.addBlockagesAtPorts(nr.bPi);
                if (nr.spineTaps == null) continue;
                for (PortInst pi : nr.spineTaps) {
                    nr.addBlockagesAtPorts(pi);
                }
            }
        }
        Collections.sort(allBatches);
        RouteBatch[] routeBatches = new RouteBatch[allBatches.size()];
        for (int i = 0; i < allBatches.size(); ++i) {
            routeBatches[i] = (RouteBatch)allBatches.get(i);
        }
        return routeBatches;
    }

    private ArcProto getMetalArcOnPort(PortInst pi) {
        ArcProto[] arcs = this.getPossibleConnections(pi.getPortProto());
        for (int j = 0; j < arcs.length; ++j) {
            if (arcs[j].getTechnology() != this.tech || !arcs[j].getFunction().isMetal()) continue;
            return arcs[j];
        }
        String errorMsg = "Cannot connect port " + pi.getPortProto().getName() + " of node " + this.describe(pi.getNodeInst()) + " because it has no metal connection in " + this.tech.getTechName() + " technology";
        this.error(errorMsg);
        ArrayList<Poly> polyList = new ArrayList<Poly>();
        polyList.add(pi.getPoly());
        this.errorLogger.logMessage(errorMsg, polyList, this.cell, 0, true);
        return null;
    }

    Runnable[] findPath(NeededRoute nr) {
        Wavefront[] wavefronts = nr.makeWavefronts();
        if (nr.checkEndSurround()) {
            return null;
        }
        Wavefront d1 = wavefronts[0];
        Wavefront d2 = wavefronts[1];
        if (DBMath.rectsIntersect(d1.fromRect, d1.toRect) && d1.toZ == d1.fromZ) {
            double xVal = (Math.max(d1.fromRect.getMinX(), d1.toRect.getMinX()) + Math.min(d1.fromRect.getMaxX(), d1.toRect.getMaxX())) / 2.0;
            double yVal = (Math.max(d1.fromRect.getMinY(), d1.toRect.getMinY()) + Math.min(d1.fromRect.getMaxY(), d1.toRect.getMaxY())) / 2.0;
            SearchVertex sv = new SearchVertex(xVal, yVal, d1.toZ, 0, null, null, 0, d1);
            nr.completeRoute(sv);
            return null;
        }
        if (this.parallelDij) {
            DijkstraParallel aToB = new DijkstraParallel(d1, d2);
            DijkstraParallel bToA = new DijkstraParallel(d2, d1);
            return new Runnable[]{aToB, bToA};
        }
        return new Runnable[]{new DijkstraTwoWay(nr, d1, d2)};
    }

    private double getMinWidth(List<PortInst> orderedPorts) {
        double minWidth = 0.0;
        for (PortInst pi : orderedPorts) {
            double widestAtPort = this.getWidestMetalArcOnPort(pi);
            if (!(widestAtPort > minWidth)) continue;
            minWidth = widestAtPort;
        }
        if (minWidth > this.prefs.maxArcWidth) {
            minWidth = this.prefs.maxArcWidth;
        }
        return minWidth;
    }

    private ArcProto[] getPossibleConnections(PortProto pp) {
        Export e;
        Variable var;
        ArcProto[] poss = pp.getBasePort().getConnections();
        if (pp instanceof Export && (var = (e = (Export)pp).getVar(Export.EXPORT_PREFERRED_ARCS)) != null) {
            String[] arcNames = (String[])var.getObject();
            ArcProto[] arcs = new ArcProto[arcNames.length];
            boolean allFound = true;
            for (int j = 0; j < arcNames.length; ++j) {
                arcs[j] = ArcProto.findArcProto(arcNames[j]);
                if (arcs[j] != null) continue;
                allFound = false;
            }
            if (allFound) {
                return arcs;
            }
        }
        return poss;
    }

    private static boolean inDestGrid(FixpRectangle toRectGridded, double x2, double y) {
        if (x2 < toRectGridded.getMinX()) {
            return false;
        }
        if (x2 > toRectGridded.getMaxX()) {
            return false;
        }
        if (y < toRectGridded.getMinY()) {
            return false;
        }
        return !(y > toRectGridded.getMaxY());
    }

    private double getWidestMetalArcOnPort(PortInst pi) {
        Export export;
        PortInst exportedInst;
        double width2;
        double width = 0.0;
        Iterator<Connection> it = pi.getConnections();
        while (it.hasNext()) {
            double newWidth;
            Connection c = it.next();
            ArcInst ai = c.getArc();
            if (!ai.getProto().getFunction().isMetal() || !((newWidth = ai.getLambdaBaseWidth()) > width)) continue;
            width = newWidth;
        }
        NodeInst ni = pi.getNodeInst();
        if (ni.isCellInstance() && (width2 = this.getWidestMetalArcOnPort(exportedInst = (export = (Export)pi.getPortProto()).getOriginalPort())) > width) {
            width = width2;
        }
        return width;
    }

    private boolean inValidPort(PortInst pi, NeededRoute nr) {
        ArcProto[] conns = this.getPossibleConnections(pi.getPortProto());
        boolean valid = false;
        for (int j = 0; j < conns.length; ++j) {
            ArcProto ap = conns[j];
            if (ap.getTechnology() != this.tech || !ap.getFunction().isMetal() || nr.preventArc(conns[j].getFunction().getLevel() - 1)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            this.warn("Cannot connect to port " + pi.getPortProto().getName() + " on node " + this.describe(pi.getNodeInst()) + " because all connecting layers have been prevented by Routing Preferences");
            return true;
        }
        return false;
    }

    void getOptimizedList(SearchVertex initialThread, List<SearchVertex> realVertices) {
        realVertices.clear();
        SearchVertex thread = initialThread;
        if (thread != null) {
            SearchVertex lastVertex = thread;
            realVertices.add(lastVertex);
            thread = thread.last;
            while (thread != null) {
                if (lastVertex.getZ() != thread.getZ()) {
                    realVertices.add(thread);
                    lastVertex = thread;
                    thread = thread.last;
                    continue;
                }
                double dx = thread.getX() - lastVertex.getX();
                double dy = thread.getY() - lastVertex.getY();
                lastVertex = thread;
                thread = thread.last;
                while (!(thread == null || lastVertex.getZ() != thread.getZ() || dx == 0.0 && thread.getX() - lastVertex.getX() != 0.0 || dy == 0.0 && thread.getY() - lastVertex.getY() != 0.0)) {
                    lastVertex = thread;
                    thread = thread.last;
                }
                realVertices.add(lastVertex);
            }
        }
    }

    private int getNumBlockages() {
        int total = 0;
        for (int i = 0; i < numMetalLayers; ++i) {
            BlockageTree bTree = this.rTrees.getMetalTree(this.metalLayers[i]);
            if (bTree.root == null) continue;
            total += this.getNumLeafs(bTree.root);
        }
        return total;
    }

    private int getNumLeafs(RTNode<SOGBound> branch) {
        int total = 0;
        for (int i = 0; i < branch.getTotal(); ++i) {
            if (branch.getFlag()) {
                ++total;
                continue;
            }
            RTNode<SOGBound> subrt = branch.getChildTree(i);
            total += this.getNumLeafs(subrt);
        }
        return total;
    }

    private boolean buildRTrees(Netlist netList, List<ArcInst> arcsToRoute, List<EPoint> linesInNonMahnattan) {
        this.rTrees = new BlockageTrees(numMetalLayers);
        MutableInteger nextNetNumber = new MutableInteger(1);
        HashMap<Network, Integer> netNumbers = new HashMap<Network, Integer>();
        for (ArcInst ai : arcsToRoute) {
            Network net = netList.getNetwork(ai, 0);
            Integer netNumber = (Integer)netNumbers.get(net);
            if (netNumber != null) continue;
            netNumber = nextNetNumber.intValue() * 8;
            netNumbers.put(net, netNumber);
            nextNetNumber.increment();
            this.netIDs.put(net, netNumber);
        }
        this.setProgressNote("Find blockages...");
        this.setProgressValue(0, 100);
        boolean retval = this.addArea(this.cell, this.cellBounds, Orientation.IDENT.pureRotate(), true, nextNetNumber, linesInNonMahnattan);
        return retval;
    }

    private boolean addArea(Cell cell, Rectangle2D bounds, FixpTransform transToTop, boolean topLevel, MutableInteger nextNetNumber, List<EPoint> linesInNonMahnattan) {
        boolean hasNonmanhattan = false;
        int numCells = 0;
        Iterator<Geometric> it = cell.searchIterator(bounds);
        while (it.hasNext()) {
            Geometric geom = it.next();
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                if (ni.isCellInstance()) {
                    ++numCells;
                    continue;
                }
                FixpTransform nodeTrans = ni.rotateOut(transToTop);
                PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                Technology tech = pNp.getTechnology();
                Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, true, false, null);
                MutableInteger netNumber = null;
                List<Integer> exclusionLayers = null;
                if (pNp == Generic.tech().routeNode) {
                    Integer nn = nextNetNumber.intValue() * 8;
                    nextNetNumber.increment();
                    netNumber = new MutableInteger(nn);
                    exclusionLayers = this.parseExclusionLayers(ni);
                }
                for (int i = 0; i < nodeInstPolyList.length; ++i) {
                    Poly poly = nodeInstPolyList[i];
                    if (exclusionLayers != null) {
                        for (Integer lay : exclusionLayers) {
                            poly.setLayer(this.getMetalLayer(lay));
                            if (!this.addLayer(poly, nodeTrans, netNumber, false, linesInNonMahnattan, true)) continue;
                            hasNonmanhattan = true;
                        }
                        continue;
                    }
                    if (!this.addLayer(poly, nodeTrans, netNumber, false, linesInNonMahnattan, true)) continue;
                    hasNonmanhattan = true;
                }
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            if (ai.getProto() == Generic.tech().unrouted_arc) continue;
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                if (!this.addLayer(poly, transToTop, null, false, linesInNonMahnattan, true)) continue;
                hasNonmanhattan = true;
            }
        }
        int cellCount = 0;
        Iterator<Geometric> it2 = cell.searchIterator(bounds);
        while (it2.hasNext()) {
            NodeInst ni;
            Geometric geom = it2.next();
            if (!(geom instanceof NodeInst) || !(ni = (NodeInst)geom).isCellInstance()) continue;
            if (topLevel) {
                this.setProgressValue(++cellCount, numCells + 1);
                this.setProgressNote("Find blockages in " + ni.describe(false) + "...");
            }
            Rectangle2D.Double subBounds = new Rectangle2D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
            DBMath.transformRect(subBounds, ni.transformIn());
            FixpTransform transBack = ni.transformOut(transToTop);
            this.addArea((Cell)ni.getProto(), subBounds, transBack, false, nextNetNumber, linesInNonMahnattan);
        }
        return hasNonmanhattan;
    }

    private List<Integer> parseExclusionLayers(NodeInst ni) {
        ArrayList<Integer> exclusionLayers = new ArrayList<Integer>();
        String layers = "";
        Variable var = ni.getVar(Generic.ROUTING_EXCLUSION);
        if (var != null) {
            layers = var.getPureValue(-1);
        }
        layers.replaceAll(" ", "");
        if (layers.length() == 0) {
            return exclusionLayers;
        }
        if (layers.equalsIgnoreCase("all")) {
            for (int i = 0; i < this.getNumMetals(); ++i) {
                exclusionLayers.add(i);
            }
            return exclusionLayers;
        }
        int pt = 0;
        while (pt < layers.length()) {
            int layNum = com.sun.electric.util.TextUtils.atoi(layers.substring(pt));
            while (pt < layers.length() && Character.isDigit(layers.charAt(pt))) {
                ++pt;
            }
            if (pt >= layers.length() || layers.charAt(pt) == ',') {
                exclusionLayers.add(layNum - 1);
                if (pt >= layers.length()) continue;
                ++pt;
                continue;
            }
            if (layers.charAt(pt) != '-' || pt >= layers.length() - 1) {
                System.out.println("ERROR: Routing exclusion node " + ni.describe(false) + " has invalid exclusion description: " + layers);
                break;
            }
            int layEnd = com.sun.electric.util.TextUtils.atoi(layers.substring(++pt));
            while (pt < layers.length() && Character.isDigit(layers.charAt(pt))) {
                ++pt;
            }
            for (int i = layNum; i <= layEnd; ++i) {
                exclusionLayers.add(i - 1);
            }
            if (pt >= layers.length()) continue;
            if (layers.charAt(pt) != ',') {
                System.out.println("ERROR: Routing exclusion node " + ni.describe(false) + " has invalid exclusion description: " + layers);
                break;
            }
            ++pt;
        }
        return exclusionLayers;
    }

    private boolean addLayer(PolyBase poly, FixpTransform trans, MutableInteger netID, boolean lockTree, List<EPoint> linesInNonMahnattan, boolean merge) {
        boolean isNonmanhattan = false;
        Layer layer = poly.getLayer();
        Layer.Function fun = layer.getFunction();
        if (fun.isMetal()) {
            if (poly.getStyle() != Poly.Type.FILLED) {
                return false;
            }
            poly.transform(trans);
            FixpRectangle bounds = poly.getBox();
            if (bounds == null) {
                this.addPolygon(poly, layer, netID, lockTree);
                for (PolyBase.Point p : poly.getPoints()) {
                    linesInNonMahnattan.add(EPoint.fromLambda(p.getX(), p.getY()));
                }
                isNonmanhattan = true;
            } else {
                this.addRectangle(bounds, layer, netID, lockTree, merge);
            }
        } else if (fun.isContact()) {
            FixpRectangle bounds = poly.getBounds2D();
            DBMath.transformRect((Rectangle2D)bounds, trans);
            this.addVia(EPoint.fromLambda(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY()), layer, netID, lockTree);
        }
        return isNonmanhattan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SOGBound addRectangle(Rectangle2D bounds, Layer layer, MutableInteger netID, boolean lockTree, boolean merge) {
        SOGBound sogb = null;
        BlockageTree bTree = this.rTrees.getMetalTree(layer);
        if (merge) {
            ArrayList<SOGBound> removeThese = null;
            Iterator sea = bTree.search(bounds);
            while (sea.hasNext()) {
                SOGBound sBound = (SOGBound)sea.next();
                if (sBound.bound.getMinX() <= bounds.getMinX() && sBound.bound.getMaxX() >= bounds.getMaxX() && sBound.bound.getMinY() <= bounds.getMinY() && sBound.bound.getMaxY() >= bounds.getMaxY()) {
                    return null;
                }
                if (!(bounds.getMinX() <= sBound.bound.getMinX()) || !(bounds.getMaxX() >= sBound.bound.getMaxX()) || !(bounds.getMinY() <= sBound.bound.getMinY()) || !(bounds.getMaxY() >= sBound.bound.getMaxY())) continue;
                if (removeThese == null) {
                    removeThese = new ArrayList<SOGBound>();
                }
                removeThese.add(sBound);
            }
            if (removeThese != null) {
                if (lockTree) {
                    bTree.lock();
                }
                try {
                    RTNode<SOGBound> rootFixp = bTree.getRoot();
                    for (SOGBound s : removeThese) {
                        RTNode<SOGBound> newRootFixp = RTNode.unLinkGeom(null, rootFixp, s);
                        if (newRootFixp == rootFixp) continue;
                        rootFixp = newRootFixp;
                        bTree.setRoot(rootFixp);
                    }
                }
                finally {
                    if (lockTree) {
                        bTree.unlock();
                    }
                }
            }
        }
        if (lockTree) {
            bTree.lock();
        }
        try {
            RTNode<SOGBound> newRootFixp;
            sogb = new SOGBound(ERectangle.fromLambda(bounds), netID);
            RTNode rootFixp = bTree.getRoot();
            if (rootFixp == null) {
                rootFixp = RTNode.makeTopLevel();
                bTree.setRoot(rootFixp);
            }
            if ((newRootFixp = RTNode.linkGeom(null, rootFixp, sogb)) != rootFixp) {
                bTree.setRoot(newRootFixp);
            }
        }
        finally {
            if (lockTree) {
                bTree.unlock();
            }
        }
        return sogb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPolygon(PolyBase poly, Layer layer, MutableInteger netID, boolean lockTree) {
        BlockageTree bTree = this.rTrees.getMetalTree(layer);
        if (lockTree) {
            bTree.lock();
        }
        try {
            RTNode<SOGPoly> newRootFixp;
            SOGPoly sogb = new SOGPoly(ERectangle.fromLambda(poly.getBounds2D()), netID, poly);
            RTNode rootFixp = bTree.getRoot();
            if (rootFixp == null) {
                rootFixp = RTNode.makeTopLevel();
                bTree.setRoot(rootFixp);
            }
            if ((newRootFixp = RTNode.linkGeom(null, rootFixp, sogb)) != rootFixp) {
                bTree.setRoot(newRootFixp);
            }
        }
        finally {
            if (lockTree) {
                bTree.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVia(EPoint loc, Layer layer, MutableInteger netID, boolean lockTree) {
        BlockageTree bTree = this.rTrees.getViaTree(layer);
        if (lockTree) {
            bTree.lock();
        }
        try {
            RTNode<SOGVia> newRootFixp;
            SOGVia sogb = new SOGVia(loc, netID);
            RTNode rootFixp = bTree.getRoot();
            if (rootFixp == null) {
                rootFixp = RTNode.makeTopLevel();
                bTree.setRoot(rootFixp);
            }
            if ((newRootFixp = RTNode.linkGeom(null, rootFixp, sogb)) != rootFixp) {
                bTree.setRoot(newRootFixp);
            }
        }
        finally {
            if (lockTree) {
                bTree.unlock();
            }
        }
    }

    public GlobalRouter doGlobalRouting(Cell cell, RouteBatch[] routeBatches, RouteBatch[] fakeBatches, double wirePitch) {
        GlobalRouter gr = new GlobalRouter(cell, routeBatches, fakeBatches, wirePitch);
        gr.solve();
        return gr;
    }

    private static class GRWavefrontPoint
    implements Comparable<GRWavefrontPoint> {
        private GRBucket n;
        private double cost;

        public GRWavefrontPoint(GRBucket n, double c) {
            this.n = n;
            this.cost = c;
        }

        public GRBucket getBucket() {
            return this.n;
        }

        public double getCost() {
            return this.cost;
        }

        @Override
        public int compareTo(GRWavefrontPoint other) {
            if (this.cost < other.cost) {
                return -1000000000;
            }
            if (this.cost > other.cost) {
                return 1000000000;
            }
            return this.n.compareTo(other.n);
        }
    }

    private static class GRPathElement {
        private GRBucket n;
        private GREdge e;

        public GRPathElement(GRBucket n, GREdge e) {
            this.n = n;
            this.e = e;
        }

        public GRBucket getBucket() {
            return this.n;
        }

        public GREdge getEdge() {
            return this.e;
        }
    }

    private static class GREdge {
        private GRBucket n1;
        private GRBucket n2;
        private int current;
        private final int capacity;
        private final double minCost;
        private final double maxCost;

        public GREdge(GRBucket n1, GRBucket n2, int cap) {
            this.n1 = n1;
            this.n2 = n2;
            this.current = 0;
            this.minCost = 1.0;
            this.maxCost = 16.0;
            this.capacity = cap;
            n1.addEdge(this);
            n2.addEdge(this);
        }

        public void changeCurrentValue(int delta) {
            this.current += delta;
        }

        public GRBucket getOtherOne(GRBucket thisOne) {
            return thisOne == this.n1 ? this.n2 : this.n1;
        }

        double usageCost() {
            if (this.current <= 0) {
                return this.minCost;
            }
            if (this.current >= this.capacity) {
                return this.maxCost;
            }
            double ratio = (double)this.current / (double)this.capacity;
            return this.minCost + (this.maxCost - this.minCost) * ratio;
        }
    }

    public static class GRWire {
        private GRBucket n1;
        private GRBucket n2;
        private EPoint pt1;
        private EPoint pt2;
        private List<GRPathElement> path;
        private NeededRoute nr;

        public GRWire(NeededRoute nr, GRBucket n1, GRBucket n2, EPoint pt1, EPoint pt2) {
            this.nr = nr;
            this.n1 = n1;
            this.n2 = n2;
            this.pt1 = pt1;
            this.pt2 = pt2;
        }

        public void setPathOnRoute() {
            NeededRoute.access$002(this.nr, new Rectangle2D[this.path.size()]);
            for (int i = 0; i < this.path.size(); ++i) {
                ((NeededRoute)this.nr).buckets[i] = this.path.get(i).getBucket().bounds;
            }
        }

        public int getNumPathElements() {
            return this.path.size();
        }

        public GRBucket getPathBucket(int index) {
            return this.path.get(index).getBucket();
        }

        public GRBucket getBucket1() {
            return this.n1;
        }

        public GRBucket getBucket2() {
            return this.n2;
        }

        public EPoint getPoint1() {
            return this.pt1;
        }

        public EPoint getPoint2() {
            return this.pt2;
        }

        public NeededRoute getNeededRoute() {
            return this.nr;
        }

        private void addPath(int width) {
            for (GRPathElement pe : this.path) {
                if (pe.getEdge() == null) continue;
                pe.getEdge().changeCurrentValue(width);
            }
        }

        /*
         * Unable to fully structure code
         */
        private boolean setShortestPath() {
            start = this.n1;
            finish = this.n2;
            this.path = new ArrayList<GRPathElement>();
            if (start == finish) {
                return false;
            }
            h = new TreeSet<GRWavefrontPoint>();
            clean = new ArrayList<GRBucket>();
            current = start;
            h.add(new GRWavefrontPoint(current, 0.0));
            while (true) {
                if ((it = h.iterator()).hasNext()) {
                    he = (GRWavefrontPoint)it.next();
                    current = he.getBucket();
                    h.remove(he);
                    if (current.getCost() != he.getCost()) {
                        continue;
                    }
                } else {
                    current = null;
                }
                if (current == null || current == finish) break;
                i$ = current.getEdges().iterator();
                while (true) {
                    if (!i$.hasNext()) ** break;
                    e = i$.next();
                    next = e.getOtherOne(current);
                    if (next == start) continue;
                    cost = current.getCost() + e.usageCost();
                    if (next.getPrevEdge() != null && !(next.getCost() > cost)) continue;
                    next.setCost(cost);
                    h.add(new GRWavefrontPoint(next, cost));
                    if (next.getPrevEdge() == null) {
                        clean.add(next);
                    }
                    next.setPrevEdge(e);
                }
                break;
            }
            if (current == finish) {
                while (current != null) {
                    pe = new GRPathElement(current, current.getPrevEdge());
                    this.path.add(pe);
                    current = pe.getEdge() == null ? null : pe.getEdge().getOtherOne(current);
                }
            } else {
                return true;
            }
            Collections.reverse(this.path);
            for (GRBucket n : clean) {
                n.setPrevEdge(null);
                n.setCost(0.0);
            }
            return false;
        }
    }

    public static class GRNet {
        private List<GRWire> wires = new ArrayList<GRWire>();

        GRNet() {
        }

        public void addWire(GRWire w) {
            this.wires.add(w);
        }

        public List<GRWire> getWires() {
            return this.wires;
        }
    }

    public static class GRBucket
    implements Comparable<GRBucket> {
        private int id;
        private Rectangle2D bounds;
        private List<GREdge> edges;
        private double cost;
        private GREdge prev;

        public GRBucket(int id, Rectangle2D bounds) {
            this.id = id;
            this.bounds = bounds;
            this.edges = new ArrayList<GREdge>();
        }

        public Rectangle2D getBounds() {
            return this.bounds;
        }

        public double getCost() {
            return this.cost;
        }

        public void setCost(double c) {
            this.cost = c;
        }

        public GREdge getPrevEdge() {
            return this.prev;
        }

        public void setPrevEdge(GREdge e) {
            this.prev = e;
        }

        public void addEdge(GREdge e) {
            this.edges.add(e);
        }

        public List<GREdge> getEdges() {
            return this.edges;
        }

        public String toString() {
            return "BUCKET-" + this.id;
        }

        @Override
        public int compareTo(GRBucket other) {
            return this.id - other.id;
        }
    }

    public class GlobalRouter {
        private int numXBuckets;
        private int numYBuckets;
        private GRBucket[] buckets;
        private GREdge[] edges;
        private List<GRNet> nets;

        public List<GRNet> getNets() {
            return this.nets;
        }

        public int getXBuckets() {
            return this.numXBuckets;
        }

        public int getYBuckets() {
            return this.numYBuckets;
        }

        public GlobalRouter(Cell c, RouteBatch[] routeBatches, RouteBatch[] fakeBatches, double wirePitch) {
            int eid;
            int y;
            int x2;
            ERectangle bounds;
            int size2;
            int total = 0;
            for (RouteBatch rb : routeBatches) {
                total += rb.routesInBatch.size();
            }
            if (fakeBatches != null) {
                for (RouteBatch rb : fakeBatches) {
                    total += rb.routesInBatch.size();
                }
            }
            if ((size2 = (int)Math.sqrt(total)) < 2) {
                size2 = 2;
            }
            if ((bounds = c.getBounds()).getWidth() > bounds.getHeight()) {
                this.numXBuckets = size2;
                this.numYBuckets = (int)Math.round((double)size2 * bounds.getHeight() / bounds.getWidth());
                if (this.numYBuckets < 2) {
                    this.numYBuckets = 2;
                }
            } else {
                this.numXBuckets = (int)Math.round((double)size2 * bounds.getWidth() / bounds.getHeight());
                if (this.numXBuckets < 2) {
                    this.numXBuckets = 2;
                }
                this.numYBuckets = size2;
            }
            double bucketWidth = bounds.getWidth() / (double)this.numXBuckets;
            double bucketHeight = bounds.getHeight() / (double)this.numYBuckets;
            int capacity = (int)Math.round(bucketWidth / wirePitch);
            if (capacity < 1) {
                capacity = 1;
            }
            this.buckets = new GRBucket[this.numXBuckets * this.numYBuckets];
            int t = 0;
            for (int y2 = 0; y2 < this.numYBuckets; ++y2) {
                for (int x3 = 0; x3 < this.numXBuckets; ++x3) {
                    double lX = bounds.getMinX() + (double)x3 * bucketWidth;
                    double hX = lX + bucketWidth;
                    double lY = bounds.getMinY() + (double)y2 * bucketHeight;
                    double hY = lY + bucketHeight;
                    this.buckets[t++] = new GRBucket(t, new Rectangle2D.Double(lX, lY, hX - lX, hY - lY));
                }
            }
            int numEdges = this.numXBuckets * (this.numYBuckets - 1) + this.numYBuckets * (this.numXBuckets - 1);
            this.edges = new GREdge[numEdges];
            int e = 0;
            for (x2 = 0; x2 < this.numXBuckets; ++x2) {
                for (y = 1; y < this.numYBuckets; ++y) {
                    int sid = y * this.numXBuckets + x2;
                    eid = (y - 1) * this.numXBuckets + x2;
                    this.edges[e++] = new GREdge(this.buckets[sid], this.buckets[eid], capacity);
                }
            }
            for (x2 = 1; x2 < this.numXBuckets; ++x2) {
                for (y = 0; y < this.numYBuckets; ++y) {
                    int sid = y * this.numXBuckets + x2;
                    eid = y * this.numXBuckets + (x2 - 1);
                    this.edges[e++] = new GREdge(this.buckets[sid], this.buckets[eid], capacity);
                }
            }
            this.nets = new ArrayList<GRNet>();
            this.addBatches(routeBatches, bounds, bucketWidth, bucketHeight);
            if (fakeBatches != null) {
                this.addBatches(fakeBatches, bounds, bucketWidth, bucketHeight);
            }
        }

        private void addBatches(RouteBatch[] batches, ERectangle bounds, double bucketWidth, double bucketHeight) {
            for (RouteBatch rb : batches) {
                GRNet nn = null;
                for (NeededRoute nr : rb.routesInBatch) {
                    int x1 = (int)((nr.aX - bounds.getMinX()) / bucketWidth);
                    int y1 = (int)((nr.aY - bounds.getMinY()) / bucketHeight);
                    int x2 = (int)((nr.bX - bounds.getMinX()) / bucketWidth);
                    int bucket1 = y1 * this.numXBuckets + x1;
                    int y2 = (int)((nr.bY - bounds.getMinY()) / bucketHeight);
                    int bucket2 = y2 * this.numXBuckets + x2;
                    if (bucket1 == bucket2) continue;
                    if (nn == null) {
                        nn = new GRNet();
                        this.nets.add(nn);
                    }
                    GRWire w = new GRWire(nr, this.buckets[bucket1], this.buckets[bucket2], EPoint.fromLambda(nr.aX, nr.aY), EPoint.fromLambda(nr.bX, nr.bY));
                    nn.addWire(w);
                }
            }
        }

        public void solve() {
            ElapseTimer theTimer = ElapseTimer.createInstance().start();
            this.route();
            theTimer.end();
            SeaOfGatesEngine.this.info("Global routing: initialized (took " + theTimer + ")");
            int iterations = 4;
            for (int iteration = 0; iteration < iterations; ++iteration) {
                theTimer.start();
                this.ripupReroute();
                theTimer.end();
                SeaOfGatesEngine.this.info("Global routing: Rip-up and reroute pass " + iteration + " (took " + theTimer + ")");
            }
            for (GRNet net : this.nets) {
                for (GRWire wire : net.wires) {
                    wire.setPathOnRoute();
                }
            }
        }

        private void route() {
            for (GRNet net : this.nets) {
                for (GRWire w : net.getWires()) {
                    if (w.setShortestPath()) {
                        SeaOfGatesEngine.this.error("ERROR: No path from " + w.n1 + " to " + w.n2);
                    }
                    w.addPath(1);
                }
            }
        }

        private void ripupReroute() {
            for (GRNet net : this.nets) {
                for (GRWire w : net.getWires()) {
                    w.addPath(-1);
                    if (w.setShortestPath()) {
                        SeaOfGatesEngine.this.error("ERROR: No path from " + w.n1 + " to " + w.n2);
                    }
                    w.addPath(1);
                }
            }
        }
    }

    public static class SOGVia
    extends SOGBound {
        private EPoint loc;

        SOGVia(EPoint loc, MutableInteger netID) {
            super(ERectangle.fromFixp(loc.getFixpX(), loc.getFixpY(), 0L, 0L), netID);
            this.loc = loc;
        }

        @Override
        public String toString() {
            return "SOGVia on net " + this.getNetID();
        }
    }

    private static class SOGPoly
    extends SOGBound {
        private PolyBase poly;

        SOGPoly(ERectangle bound, MutableInteger netID, PolyBase poly) {
            super(bound, netID);
            this.poly = poly;
        }

        public PolyBase getPoly() {
            return this.poly;
        }
    }

    public static class SOGBound
    extends SOGNetID
    implements RTBounds {
        private ERectangle bound;

        SOGBound(ERectangle bound, MutableInteger netID) {
            super(netID);
            this.bound = bound;
        }

        @Override
        public ERectangle getBounds() {
            return this.bound;
        }

        public String toString() {
            return "SOGBound on net " + this.getNetID();
        }
    }

    public static class SOGNetID {
        private MutableInteger netID;

        SOGNetID(MutableInteger netID) {
            this.netID = netID;
        }

        public MutableInteger getNetID() {
            return this.netID;
        }

        public void setNetID(MutableInteger n) {
            this.netID = n;
        }

        public void updateNetID(MutableInteger n, Map<Integer, List<MutableInteger>> netIDsByValue) {
            if (this.isSameBasicNet(n)) {
                return;
            }
            List<MutableInteger> oldNetIDs = netIDsByValue.get(this.netID.intValue());
            if (oldNetIDs == null) {
                return;
            }
            List<MutableInteger> newNetIDs = netIDsByValue.get(n.intValue());
            for (MutableInteger mi : oldNetIDs) {
                mi.setValue(n.intValue());
                newNetIDs.add(mi);
            }
            oldNetIDs.clear();
        }

        public boolean isSameBasicNet(MutableInteger otherNetID) {
            int netValue = 0;
            if (this.netID != null) {
                netValue = this.netID.intValue();
            }
            return (netValue & 0xFFFFFFF8) == (otherNetID.intValue() & 0xFFFFFFF8);
        }

        public boolean isPseudoBlockage() {
            if (this.netID == null) {
                return false;
            }
            return (this.netID.intValue() & 1) != 0;
        }

        public boolean hasEndBit(int bit) {
            if (this.netID == null) {
                return false;
            }
            return (this.netID.intValue() & bit) != 0;
        }
    }

    private static class BlockageTrees {
        private final BlockageTree[] metalTrees;
        private final BlockageTree[] viaTrees;

        BlockageTrees(int numMetals) {
            this.metalTrees = new BlockageTree[numMetals];
            this.viaTrees = new BlockageTree[numMetals];
            for (int i = 0; i < this.metalTrees.length; ++i) {
                this.metalTrees[i] = new BlockageTree(null);
                this.viaTrees[i] = new BlockageTree(null);
            }
        }

        private BlockageTree getMetalTree(Layer lay) {
            if (lay == null) {
                return BlockageTree.emptyTree;
            }
            return this.metalTrees[lay.getFunction().getLevel() - 1];
        }

        private BlockageTree getViaTree(Layer lay) {
            if (lay == null) {
                return BlockageTree.emptyTree;
            }
            return this.viaTrees[lay.getFunction().getLevel() - 1];
        }
    }

    private static class BlockageTree {
        private final ReentrantLock lock = new ReentrantLock();
        private RTNode<SOGBound> root;
        public static BlockageTree emptyTree = new BlockageTree(null);

        private BlockageTree(RTNode<SOGBound> root2) {
            this.root = root2;
        }

        private void lock() {
            this.lock.lock();
        }

        private void unlock() {
            this.lock.unlock();
        }

        private RTNode<SOGBound> getRoot() {
            return this.root;
        }

        private void setRoot(RTNode<SOGBound> root2) {
            this.root = root2;
        }

        private boolean isEmpty() {
            return this.root == null;
        }

        private Iterator<SOGBound> search(Rectangle2D searchArea) {
            if (this.root == null) {
                return Collections.emptyList().iterator();
            }
            RTNode.Search<SOGBound> it = new RTNode.Search<SOGBound>(searchArea, this.root, true);
            return it;
        }
    }

    private class PrimsBySize
    implements Comparator<MetalVia> {
        private PrimsBySize() {
        }

        @Override
        public int compare(MetalVia mv1, MetalVia mv2) {
            double sz2;
            PrimitiveNode pn1 = mv1.via;
            PrimitiveNode pn2 = mv2.via;
            double sz1 = pn1.getDefWidth(SeaOfGatesEngine.this.ep) * pn1.getDefHeight(SeaOfGatesEngine.this.ep);
            if (sz1 < (sz2 = pn2.getDefWidth(SeaOfGatesEngine.this.ep) * pn2.getDefHeight(SeaOfGatesEngine.this.ep))) {
                return -1;
            }
            if (sz1 > sz2) {
                return 1;
            }
            return 0;
        }
    }

    private class MetalVias {
        List<MetalVia> vias = new ArrayList<MetalVia>();

        private MetalVias() {
        }

        void addVia(PrimitiveNode pn, int o, int hm, double hmi, int vm, double vmi) {
            this.vias.add(new MetalVia(pn, o, hm, hmi, vm, vmi));
            Collections.sort(this.vias, new PrimsBySize());
        }

        List<MetalVia> getVias() {
            return this.vias;
        }
    }

    private static class MetalVia {
        PrimitiveNode via;
        int orientation;
        int horMetal;
        int verMetal;
        double horMetalInset;
        double verMetalInset;

        MetalVia(PrimitiveNode v, int o, int hm, double hmi, int vm, double vmi) {
            this.via = v;
            this.orientation = o;
            this.horMetal = hm;
            this.horMetalInset = hmi;
            this.verMetal = vm;
            this.verMetalInset = vmi;
        }
    }

    private static class PortInstShadow
    implements SteinerTree.SteinerTreePort {
        private PortInst pi;
        private EPoint ctr;

        PortInstShadow(PortInst pi) {
            this.pi = pi;
            this.ctr = pi.getNodeInst().getShapeOfPort(pi.getPortProto()).getCenter();
        }

        @Override
        public EPoint getCenter() {
            return this.ctr;
        }

        public PortInst getPortInst() {
            return this.pi;
        }
    }

    private class DijkstraTwoWay
    implements Runnable {
        private final NeededRoute nr;
        private final Wavefront dirAtoB;
        private final Wavefront dirBtoA;

        private DijkstraTwoWay(NeededRoute nr, Wavefront dirAtoB, Wavefront dirBtoA) {
            this.nr = nr;
            this.dirAtoB = dirAtoB;
            this.dirBtoA = dirBtoA;
        }

        @Override
        public void run() {
            Environment.setThreadEnvironment(SeaOfGatesEngine.this.env);
            SearchVertex result2 = null;
            while (result2 == null) {
                SearchVertex resultA = this.dirAtoB.advanceWavefront();
                SearchVertex resultB = this.dirBtoA.advanceWavefront();
                if (resultA == null && resultB == null) continue;
                if (resultA == svAborted || resultB == svAborted) {
                    this.nr.completeRoute(svAborted);
                    return;
                }
                if (resultA == svLimited || resultB == svLimited) {
                    this.nr.completeRoute(svLimited);
                    return;
                }
                if (resultA == svExhausted || resultB == svExhausted) {
                    this.nr.completeRoute(svExhausted);
                    return;
                }
                result2 = resultA;
                if (result2 != null && result2 != svAbandoned) continue;
                result2 = resultB;
            }
            this.nr.completeRoute(result2);
        }
    }

    private class DijkstraParallel
    implements Runnable {
        private final Wavefront wf;
        private final Wavefront otherWf;

        private DijkstraParallel(Wavefront wf, Wavefront otherWf) {
            this.wf = wf;
            this.otherWf = otherWf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean success2;
            Environment.setThreadEnvironment(SeaOfGatesEngine.this.env);
            SearchVertex result2 = null;
            while (result2 == null) {
                if (this.wf.abort) {
                    result2 = svAbandoned;
                    continue;
                }
                result2 = this.wf.advanceWavefront();
            }
            boolean bl = success2 = result2.wf != null;
            if (success2) assert (result2.wf == this.wf);
            NeededRoute neededRoute = this.wf.nr;
            synchronized (neededRoute) {
                assert (!this.wf.finished);
                if (!this.otherWf.finished) {
                    this.otherWf.abort = true;
                    if (success2) {
                        this.wf.nr.routedSuccess = true;
                    }
                }
                this.wf.finished = true;
            }
            this.wf.nr.completeRoute(result2);
        }
    }

    private static class RoutesOnNetwork
    implements Comparable<RoutesOnNetwork> {
        String netName;
        List<SteinerTree.SteinerTreePortPair> pairs;
        List<PortInst> spineTapPorts;
        List<ArcInst> unroutedArcs;
        List<PortInst> unorderedPorts;
        List<NeededRoute> neededRoutes;

        RoutesOnNetwork(String netName) {
            this.netName = netName;
            this.pairs = new ArrayList<SteinerTree.SteinerTreePortPair>();
            this.spineTapPorts = null;
            this.unroutedArcs = new ArrayList<ArcInst>();
            this.unorderedPorts = new ArrayList<PortInst>();
            this.neededRoutes = new ArrayList<NeededRoute>();
        }

        public void addUnorderedPort(PortInst pi) {
            if ((pi.getNodeInst().isCellInstance() || ((PrimitiveNode)pi.getNodeInst().getProto()).getTechnology() != Generic.tech()) && !this.unorderedPorts.contains(pi)) {
                this.unorderedPorts.add(pi);
            }
        }

        public boolean setupSpineInfo() {
            EPoint pt;
            HashSet<PortInst> uniquePorts = new HashSet<PortInst>();
            for (PortInst pi : this.unorderedPorts) {
                uniquePorts.add(pi);
            }
            if (uniquePorts.size() < 4) {
                return false;
            }
            double lowX = 0.0;
            double highX = 0.0;
            double lowY = 0.0;
            double highY = 0.0;
            boolean first = true;
            for (PortInst pi : uniquePorts) {
                EPoint pt2 = pi.getCenter();
                if (first) {
                    lowX = highX = pt2.getX();
                    lowY = highY = pt2.getY();
                    first = false;
                    continue;
                }
                if (pt2.getX() < lowX) {
                    lowX = pt2.getX();
                }
                if (pt2.getX() > highX) {
                    highX = pt2.getX();
                }
                if (pt2.getY() < lowY) {
                    lowY = pt2.getY();
                }
                if (!(pt2.getY() > highY)) continue;
                highY = pt2.getY();
            }
            double width = highX - lowX;
            double height = highY - lowY;
            if (width * 50.0 > height && height * 50.0 > width) {
                return false;
            }
            PortInst endA = null;
            PortInst endB = null;
            if (width * 50.0 <= height) {
                double lowestY = 0.0;
                double highestY = 0.0;
                first = true;
                for (PortInst pi : uniquePorts) {
                    pt = pi.getCenter();
                    if (first) {
                        lowestY = highestY = pt.getY();
                        endA = endB = pi;
                        first = false;
                        continue;
                    }
                    if (pt.getY() < lowestY) {
                        lowestY = pt.getX();
                        endA = pi;
                    }
                    if (!(pt.getY() > highestY)) continue;
                    highestY = pt.getX();
                    endB = pi;
                }
            } else {
                double lowestX = 0.0;
                double highestX = 0.0;
                first = true;
                for (PortInst pi : uniquePorts) {
                    pt = pi.getCenter();
                    if (first) {
                        lowestX = highestX = pt.getX();
                        endA = endB = pi;
                        first = false;
                        continue;
                    }
                    if (pt.getX() < lowestX) {
                        lowestX = pt.getX();
                        endA = pi;
                    }
                    if (!(pt.getX() > highestX)) continue;
                    highestX = pt.getX();
                    endB = pi;
                }
            }
            if (endA == null || endB == null || endA == endB) {
                return false;
            }
            this.spineTapPorts = new ArrayList<PortInst>();
            for (PortInst pi : uniquePorts) {
                if (pi == endA || pi == endB) continue;
                this.spineTapPorts.add(pi);
            }
            this.pairs.add(new SteinerTree.SteinerTreePortPair(endA, endB));
            return true;
        }

        @Override
        public int compareTo(RoutesOnNetwork other) {
            return this.netName.compareTo(other.netName);
        }
    }

    public static class SearchVertex
    implements Comparable<SearchVertex> {
        private final double xv;
        private final double yv;
        private final int zv;
        private int cost;
        private int cutLayer;
        private int autoGen;
        private int globalRoutingBucket;
        private Point2D[] cuts;
        private Point2D size;
        private SearchVertex last;
        private final Wavefront wf;

        SearchVertex(double x2, double y, int z, int whichContact, Point2D[] cuts, Point2D size2, int cl, Wavefront w) {
            this.xv = x2;
            this.yv = y;
            this.zv = (z << 8) + (whichContact & 0xFF);
            this.cuts = cuts;
            this.size = size2;
            this.cutLayer = cl;
            this.autoGen = -1;
            this.globalRoutingBucket = -1;
            this.wf = w;
        }

        public double getX() {
            return this.xv;
        }

        public double getY() {
            return this.yv;
        }

        public int getZ() {
            return this.zv >> 8;
        }

        public SearchVertex getLast() {
            return this.last;
        }

        public int getCost() {
            return this.cost;
        }

        public int getGRBucket() {
            return this.globalRoutingBucket;
        }

        public Wavefront getWavefront() {
            return this.wf;
        }

        int getContactNo() {
            return this.zv & 0xFF;
        }

        Point2D[] getCuts() {
            return this.cuts;
        }

        Point2D getSize() {
            return this.size;
        }

        void clearCuts() {
            this.cuts = null;
        }

        int getCutLayer() {
            return this.cutLayer;
        }

        int getAutoGen() {
            return this.autoGen;
        }

        void setAutoGen(int a) {
            this.autoGen = a;
        }

        @Override
        public int compareTo(SearchVertex svo) {
            int diff2 = this.cost - svo.cost;
            if (diff2 != 0) {
                return diff2;
            }
            if (this.wf != null) {
                double otherDist;
                double thisDist = Math.abs(this.xv - this.wf.toX) + Math.abs(this.yv - this.wf.toY) + (double)Math.abs(this.zv - this.wf.toZ);
                if (thisDist < (otherDist = Math.abs(svo.xv - this.wf.toX) + Math.abs(svo.yv - this.wf.toY) + (double)Math.abs(svo.zv - this.wf.toZ))) {
                    return -1;
                }
                if (thisDist > otherDist) {
                    return 1;
                }
            }
            return 0;
        }

        private void generateIntermediateVertex(NeededRoute nr, int lastDirection, FixpRectangle toRectGridded) {
            SearchVertex prevSV = this.last;
            double dX = 0.0;
            double dY = 0.0;
            if (this.getX() > prevSV.getX()) {
                dX = -1.0;
            } else if (this.getX() < prevSV.getX()) {
                dX = 1.0;
            } else if (this.getY() > prevSV.getY()) {
                dY = -1.0;
            } else if (this.getY() < prevSV.getY()) {
                dY = 1.0;
            }
            if (dX == 0.0 && dY == 0.0) {
                return;
            }
            int z = this.getZ();
            double newX = this.getX();
            double newY = this.getY();
            if (dX < 0.0 && !SeaOfGatesEngine.inDestGrid(toRectGridded, newX -= 1.0, newY)) {
                newX = nr.getLowerXGrid(z, newX);
            }
            if (dX > 0.0 && !SeaOfGatesEngine.inDestGrid(toRectGridded, newX += 1.0, newY)) {
                newX = nr.getUpperXGrid(z, newX);
            }
            if (dY < 0.0 && !SeaOfGatesEngine.inDestGrid(toRectGridded, newX, newY -= 1.0)) {
                newY = nr.getLowerYGrid(z, newY);
            }
            if (dY > 0.0 && !SeaOfGatesEngine.inDestGrid(toRectGridded, newX, newY += 1.0)) {
                newY = nr.getUpperYGrid(z, newY);
            }
            while (!(dX < 0.0 && newX <= prevSV.getX() || dX > 0.0 && newX >= prevSV.getX() || dY < 0.0 && newY <= prevSV.getY() || dY > 0.0 && newY >= prevSV.getY())) {
                if (this.wf.getVertex(newX, newY, z) == null) {
                    SearchVertex svIntermediate = new SearchVertex(newX, newY, z, this.getContactNo(), this.getCuts(), this.getSize(), z, this.wf);
                    if (this.wf.globalRoutingDelta != 0) {
                        svIntermediate.globalRoutingBucket = this.wf.getNextBucket(this, newX, newY);
                    }
                    svIntermediate.setAutoGen(lastDirection);
                    svIntermediate.last = prevSV;
                    svIntermediate.cost = this.cost + 1;
                    this.wf.setVertex(newX, newY, z, svIntermediate);
                    this.wf.active.add(svIntermediate);
                    break;
                }
                if (dX < 0.0 && !SeaOfGatesEngine.inDestGrid(toRectGridded, newX -= 1.0, newY)) {
                    newX = nr.getLowerXGrid(z, newX);
                }
                if (dX > 0.0 && !SeaOfGatesEngine.inDestGrid(toRectGridded, newX += 1.0, newY)) {
                    newX = nr.getUpperXGrid(z, newX);
                }
                if (dY < 0.0 && !SeaOfGatesEngine.inDestGrid(toRectGridded, newX, newY -= 1.0)) {
                    newY = nr.getLowerYGrid(z, newY);
                }
                if (!(dY > 0.0) || SeaOfGatesEngine.inDestGrid(toRectGridded, newX, newY += 1.0)) continue;
                newY = nr.getUpperYGrid(z, newY);
            }
        }
    }

    public static class OrderedSearchVertex {
        TreeMap<Integer, List<SearchVertex>> listBetter = new TreeMap();

        OrderedSearchVertex() {
        }

        public Set<SearchVertex> getSet() {
            TreeSet<SearchVertex> totalList = new TreeSet<SearchVertex>();
            for (Integer key : this.listBetter.keySet()) {
                List<SearchVertex> curList = this.listBetter.get(key);
                for (SearchVertex sv : curList) {
                    totalList.add(sv);
                }
            }
            return totalList;
        }

        public void add(SearchVertex sv) {
            Integer key = sv.cost;
            List<SearchVertex> curList = this.listBetter.get(key);
            if (curList == null) {
                curList = new ArrayList<SearchVertex>();
                this.listBetter.put(key, curList);
            }
            curList.add(sv);
        }

        public void remove(SearchVertex sv) {
            Integer key = sv.cost;
            List<SearchVertex> curList = this.listBetter.get(key);
            if (curList != null) {
                curList.remove(sv);
                if (curList.size() == 0) {
                    this.listBetter.remove(key);
                }
            } else {
                System.out.println("++++++++++ COULD NOT REMOVE SEARCH VERTEX");
            }
        }

        public boolean inList(SearchVertex sv) {
            Integer key = sv.cost;
            List<SearchVertex> curList = this.listBetter.get(key);
            if (curList == null) {
                return false;
            }
            return curList.contains(sv);
        }

        public SearchVertex getFirst() {
            if (this.listBetter.size() == 0) {
                return null;
            }
            Integer key = this.listBetter.firstKey();
            List<SearchVertex> curList = this.listBetter.get(key);
            if (curList.size() == 0) {
                System.out.println("+++++++++++++ HMMM, FIRST KEY HAS NOTHING (" + key + ")");
            }
            return curList.get(0);
        }
    }

    public class Wavefront {
        final NeededRoute nr;
        final String name;
        private final OrderedSearchVertex active;
        private final List<SearchVertex> inactive;
        List<SearchVertex> vertices;
        volatile boolean abort;
        final PortInst from;
        final PortInst to;
        final double fromX;
        final double fromY;
        final FixpRectangle fromRect;
        final int fromZ;
        final double toX;
        final double toY;
        final FixpRectangle toRect;
        final FixpRectangle toRectGridded;
        final int toZ;
        int numStepsMade;
        Rectangle2D[] orderedBuckets;
        int[] orderedBase;
        final int fromBit;
        final int toBit;
        final int globalRoutingDelta;
        final Map<Integer, Map<Integer, SearchVertex>>[] searchVertexPlanes = new Map[SeaOfGatesEngine.access$2500()];
        private boolean finished;
        private List<SearchVertex> optimizedList = new ArrayList<SearchVertex>();
        private String[] debugString;

        Wavefront(NeededRoute nr, PortInst from2, FixpRectangle fromRect, double fromX, double fromY, int fromZ, int fromBit, PortInst to2, FixpRectangle toRect, FixpRectangle toRectGridded, double toX, double toY, int toZ, int toBit, int globalRoutingDelta, String name) {
            this.nr = nr;
            this.from = from2;
            this.fromX = fromX;
            this.fromY = fromY;
            this.fromZ = fromZ;
            this.fromRect = fromRect;
            this.fromBit = fromBit;
            this.to = to2;
            this.toX = toX;
            this.toY = toY;
            this.toZ = toZ;
            this.toRect = toRect;
            this.toRectGridded = toRectGridded;
            this.toBit = toBit;
            if (nr.buckets == null) {
                globalRoutingDelta = 0;
            }
            this.globalRoutingDelta = globalRoutingDelta;
            this.name = name;
            this.numStepsMade = 0;
            this.active = new OrderedSearchVertex();
            this.inactive = new ArrayList<SearchVertex>();
            this.vertices = null;
            this.abort = false;
            SearchVertex svStart = new SearchVertex(fromX, fromY, fromZ, 0, null, null, 0, this);
            if (globalRoutingDelta != 0) {
                this.orderedBuckets = new Rectangle2D[nr.buckets.length];
                this.orderedBase = new int[nr.buckets.length];
                if (globalRoutingDelta > 0) {
                    svStart.globalRoutingBucket = 0;
                    for (int i = 0; i < nr.buckets.length; ++i) {
                        int lastInRun = i;
                        for (int j = i + 1; j < nr.buckets.length; ++j) {
                            if (nr.buckets[i].getMinX() == nr.buckets[j].getMinX() && nr.buckets[i].getMaxX() == nr.buckets[j].getMaxX()) {
                                lastInRun = j;
                            }
                            if (nr.buckets[i].getMinY() == nr.buckets[j].getMinY() && nr.buckets[i].getMaxY() == nr.buckets[j].getMaxY()) {
                                lastInRun = j;
                            }
                            if (lastInRun != j) break;
                        }
                        double lX = Math.min(nr.buckets[i].getMinX(), nr.buckets[lastInRun].getMinX());
                        double hX = Math.max(nr.buckets[i].getMaxX(), nr.buckets[lastInRun].getMaxX());
                        double lY = Math.min(nr.buckets[i].getMinY(), nr.buckets[lastInRun].getMinY());
                        double hY = Math.max(nr.buckets[i].getMaxY(), nr.buckets[lastInRun].getMaxY());
                        Rectangle2D.Double combinedRun = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                        int initially = i;
                        if (i > 0) {
                            --initially;
                        }
                        for (int pos = i; pos <= lastInRun; ++pos) {
                            this.orderedBuckets[pos] = combinedRun;
                            this.orderedBase[pos] = initially;
                            initially = i;
                        }
                        if (lastInRun != nr.buckets.length - 1) {
                            i = lastInRun - 1;
                            continue;
                        }
                        break;
                    }
                } else {
                    svStart.globalRoutingBucket = nr.buckets.length - 1;
                    for (int i = nr.buckets.length - 1; i >= 0; --i) {
                        int lastInRun = i;
                        for (int j = i - 1; j >= 0; --j) {
                            if (nr.buckets[i].getMinX() == nr.buckets[j].getMinX() && nr.buckets[i].getMaxX() == nr.buckets[j].getMaxX()) {
                                lastInRun = j;
                            }
                            if (nr.buckets[i].getMinY() == nr.buckets[j].getMinY() && nr.buckets[i].getMaxY() == nr.buckets[j].getMaxY()) {
                                lastInRun = j;
                            }
                            if (lastInRun != j) break;
                        }
                        double lX = Math.min(nr.buckets[i].getMinX(), nr.buckets[lastInRun].getMinX());
                        double hX = Math.max(nr.buckets[i].getMaxX(), nr.buckets[lastInRun].getMaxX());
                        double lY = Math.min(nr.buckets[i].getMinY(), nr.buckets[lastInRun].getMinY());
                        double hY = Math.max(nr.buckets[i].getMaxY(), nr.buckets[lastInRun].getMaxY());
                        Rectangle2D.Double combinedRun = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                        int initially = i;
                        if (i < nr.buckets.length - 1) {
                            ++initially;
                        }
                        for (int pos = i; pos >= lastInRun; --pos) {
                            this.orderedBuckets[pos] = combinedRun;
                            this.orderedBase[pos] = initially;
                            initially = i;
                        }
                        if (lastInRun != 0) {
                            i = lastInRun + 1;
                            continue;
                        }
                        break;
                    }
                }
            }
            svStart.cost = 0;
            this.setVertex(fromX, fromY, fromZ, svStart);
            this.active.add(svStart);
        }

        public PortInst getFromPortInst() {
            return this.from;
        }

        public PortInst getToPortInst() {
            return this.to;
        }

        public double getFromX() {
            return this.fromX;
        }

        public double getFromY() {
            return this.fromY;
        }

        public int getFromZ() {
            return this.fromZ;
        }

        public double getToX() {
            return this.toX;
        }

        public double getToY() {
            return this.toY;
        }

        public int getToZ() {
            return this.toZ;
        }

        public Set<SearchVertex> getActive() {
            return this.active.getSet();
        }

        public List<SearchVertex> getInactive() {
            return this.inactive;
        }

        public NeededRoute getNeededRoute() {
            return this.nr;
        }

        public int getGRDirection() {
            return this.globalRoutingDelta;
        }

        public Rectangle2D[] getOrderedBuckets() {
            return this.orderedBuckets;
        }

        public SearchVertex getNextSearchVertex() {
            SearchVertex sv = this.active.getFirst();
            if (sv == null) {
                return svExhausted;
            }
            return sv;
        }

        public SearchVertex getVertex(double x2, double y, int z) {
            Map<Integer, Map<Integer, SearchVertex>> plane = this.searchVertexPlanes[z];
            if (plane == null) {
                return null;
            }
            Map<Integer, SearchVertex> row = plane.get(new Integer((int)Math.round(y * 400.0)));
            if (row == null) {
                return null;
            }
            SearchVertex found = row.get(new Integer((int)Math.round(x2 * 400.0)));
            return found;
        }

        public void setVertex(double x2, double y, int z, SearchVertex sv) {
            Integer iY;
            Map<Integer, SearchVertex> row;
            Map<Integer, Map<Integer, SearchVertex>> plane = this.searchVertexPlanes[z];
            if (plane == null) {
                this.searchVertexPlanes[z] = plane = new HashMap<Integer, Map<Integer, SearchVertex>>();
            }
            if ((row = plane.get(iY = new Integer((int)Math.round(y * 400.0)))) == null) {
                row = new HashMap<Integer, SearchVertex>();
                plane.put(iY, row);
            }
            row.put(new Integer((int)Math.round(x2 * 400.0)), sv);
        }

        public Map<Integer, Map<Integer, SearchVertex>>[] getSearchVertexPlanes() {
            return this.searchVertexPlanes;
        }

        private void initDebugStrings() {
            this.debugString = new String[7];
        }

        private void setDebugStringHeader(String str) {
            this.debugString[0] = str;
        }

        private void setDebugString(int direction, String str) {
            this.debugString[direction + 1] = str;
        }

        private void addDebugString(int direction, String str) {
            int n = direction + 1;
            this.debugString[n] = this.debugString[n] + str;
        }

        private void completeDebugString(int direction, String str) {
            int n = direction + 1;
            this.debugString[n] = this.debugString[n] + str;
        }

        /*
         * Enabled aggressive block sorting
         */
        public SearchVertex advanceWavefront() {
            int lastDirection;
            ++this.numStepsMade;
            if (this.numStepsMade > this.nr.complexityLimit) {
                return svLimited;
            }
            SearchVertex svCurrent = this.getNextSearchVertex();
            if (svCurrent == svExhausted) {
                return svCurrent;
            }
            this.active.remove(svCurrent);
            this.inactive.add(svCurrent);
            double curX = svCurrent.getX();
            double curY = svCurrent.getY();
            int curZ = svCurrent.getZ();
            if (RoutingDebug.isActive()) {
                this.initDebugStrings();
                String str = "At: (" + com.sun.electric.util.TextUtils.formatDouble(curX) + "," + com.sun.electric.util.TextUtils.formatDouble(curY) + ",M" + (curZ + 1) + "), Cost: " + svCurrent.cost;
                str = this.globalRoutingDelta == 0 ? str + ", NO Global Routing" : str + ", Global Routing Bucket: " + svCurrent.globalRoutingBucket;
                this.setDebugStringHeader(str);
            }
            if ((lastDirection = svCurrent.getAutoGen()) >= 0) {
                svCurrent.generateIntermediateVertex(this.nr, lastDirection, this.toRectGridded);
            }
            SearchVertex destinationSV = null;
            block22: for (int i = 0; i < 6; ++i) {
                int c;
                boolean penaltyOffGridY;
                boolean penaltyOffGridX;
                String costExplanation;
                int newCost;
                SearchVertex svNext;
                SearchVertex alreadyThere;
                int nZ;
                double nY;
                double nX;
                int dz;
                double dy;
                double dx;
                block154: {
                    block152: {
                        block153: {
                            boolean foundDest;
                            Point2D.Double size2;
                            Point2D[] cuts;
                            int whichContact;
                            MutableBoolean foundDestination;
                            block151: {
                                String[] failureReasons;
                                List<MetalVia> nps;
                                int highMetal;
                                int lowMetal;
                                block150: {
                                    block149: {
                                        dx = 0.0;
                                        dy = 0.0;
                                        dz = 0;
                                        foundDestination = null;
                                        boolean stuck = false;
                                        switch (i) {
                                            case 0: {
                                                if (SeaOfGatesEngine.this.sogp.isForceHorVer() && curZ % 2 == 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                                    if (!RoutingDebug.isActive()) continue block22;
                                                    this.setDebugString(i, "Cannot move in this axis");
                                                    continue block22;
                                                }
                                                dx = SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX - 1.0, curY) ? -1.0 : this.nr.getLowerXGrid(curZ, curX - 1.0) - curX;
                                                double intermediate = this.nr.upToGrainAlways(curX + dx);
                                                if (intermediate != curX + dx) {
                                                    dx = intermediate - curX;
                                                }
                                                if (!(this.toX - curX < 0.0) || !((dx = this.getJumpSize(svCurrent, curX, curY, curZ, dx, dy, foundDestination = new MutableBoolean(false))) >= 0.0)) break;
                                                dx = -1.0;
                                                stuck = true;
                                                break;
                                            }
                                            case 1: {
                                                if (SeaOfGatesEngine.this.sogp.isForceHorVer() && curZ % 2 == 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                                    if (!RoutingDebug.isActive()) continue block22;
                                                    this.setDebugString(i, "Cannot move in this axis");
                                                    continue block22;
                                                }
                                                dx = SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX + 1.0, curY) ? 1.0 : this.nr.getUpperXGrid(curZ, curX + 1.0) - curX;
                                                double intermediate = this.nr.downToGrainAlways(curX + dx);
                                                if (intermediate != curX + dx) {
                                                    dx = intermediate - curX;
                                                }
                                                if (!(this.toX - curX > 0.0) || !((dx = this.getJumpSize(svCurrent, curX, curY, curZ, dx, dy, foundDestination = new MutableBoolean(false))) <= 0.0)) break;
                                                dx = 1.0;
                                                stuck = true;
                                                break;
                                            }
                                            case 2: {
                                                if (SeaOfGatesEngine.this.sogp.isForceHorVer() && curZ % 2 != 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                                    if (!RoutingDebug.isActive()) continue block22;
                                                    this.setDebugString(i, "Cannot move in this axis");
                                                    continue block22;
                                                }
                                                dy = SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, curY - 1.0) ? -1.0 : this.nr.getLowerYGrid(curZ, curY - 1.0) - curY;
                                                double intermediate = this.nr.upToGrainAlways(curY + dy);
                                                if (intermediate != curY + dy) {
                                                    dy = intermediate - curY;
                                                }
                                                if (!(this.toY - curY < 0.0) || !((dy = this.getJumpSize(svCurrent, curX, curY, curZ, dx, dy, foundDestination = new MutableBoolean(false))) >= 0.0)) break;
                                                dy = -1.0;
                                                stuck = true;
                                                break;
                                            }
                                            case 3: {
                                                if (SeaOfGatesEngine.this.sogp.isForceHorVer() && curZ % 2 != 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                                    if (!RoutingDebug.isActive()) continue block22;
                                                    this.setDebugString(i, "Cannot move in this axis");
                                                    continue block22;
                                                }
                                                dy = SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, curY + 1.0) ? 1.0 : this.nr.getUpperYGrid(curZ, curY + 1.0) - curY;
                                                double intermediate = this.nr.downToGrainAlways(curY + dy);
                                                if (intermediate != curY + dy) {
                                                    dy = intermediate - curY;
                                                }
                                                if (!(this.toY - curY > 0.0) || !((dy = this.getJumpSize(svCurrent, curX, curY, curZ, dx, dy, foundDestination = new MutableBoolean(false))) <= 0.0)) break;
                                                dy = 1.0;
                                                stuck = true;
                                                break;
                                            }
                                            case 4: {
                                                dz = -1;
                                                break;
                                            }
                                            case 5: {
                                                dz = 1;
                                            }
                                        }
                                        if (RoutingDebug.isActive()) {
                                            switch (i) {
                                                case 0: {
                                                    this.setDebugString(i, "Move -" + com.sun.electric.util.TextUtils.formatDouble(Math.abs(dx)));
                                                    break;
                                                }
                                                case 1: {
                                                    this.setDebugString(i, "Move +" + com.sun.electric.util.TextUtils.formatDouble(dx));
                                                    break;
                                                }
                                                case 2: {
                                                    this.setDebugString(i, "Move -" + com.sun.electric.util.TextUtils.formatDouble(Math.abs(dy)));
                                                    break;
                                                }
                                                case 3: {
                                                    this.setDebugString(i, "Move +" + com.sun.electric.util.TextUtils.formatDouble(dy));
                                                    break;
                                                }
                                                case 4: {
                                                    this.setDebugString(i, "Move -1");
                                                    break;
                                                }
                                                case 5: {
                                                    this.setDebugString(i, "Move +1");
                                                    break;
                                                }
                                            }
                                        }
                                        if (stuck) {
                                            // empty if block
                                        }
                                        nX = curX + dx;
                                        nY = curY + dy;
                                        nZ = curZ + dz;
                                        if (foundDestination != null && !foundDestination.booleanValue()) {
                                            foundDestination = null;
                                        }
                                        if (this.globalRoutingDelta != 0 && foundDestination == null) {
                                            Rectangle2D limit = this.orderedBuckets[svCurrent.globalRoutingBucket];
                                            if (nX < limit.getMinX()) {
                                                nX = limit.getMinX();
                                                if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, nX, curY)) {
                                                    nX = this.nr.getUpperXGrid(curZ, nX);
                                                }
                                                if ((dx = nX - curX) == 0.0) {
                                                    if (!RoutingDebug.isActive()) continue;
                                                    this.completeDebugString(i, ": Out Of Global Routing X Bounds");
                                                    continue;
                                                }
                                            }
                                            if (nX > limit.getMaxX()) {
                                                nX = limit.getMaxX();
                                                if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, nX, curY)) {
                                                    nX = this.nr.getLowerXGrid(curZ, nX);
                                                }
                                                if ((dx = nX - curX) == 0.0) {
                                                    if (!RoutingDebug.isActive()) continue;
                                                    this.completeDebugString(i, ": Out Of Global Routing X Bounds");
                                                    continue;
                                                }
                                            }
                                            if (nY < limit.getMinY()) {
                                                nY = limit.getMinY();
                                                if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, nY)) {
                                                    nY = this.nr.getUpperYGrid(curZ, nY);
                                                }
                                                if ((dy = nY - curY) == 0.0) {
                                                    if (!RoutingDebug.isActive()) continue;
                                                    this.completeDebugString(i, ": Out Of Global Routing Y Bounds");
                                                    continue;
                                                }
                                            }
                                            if (nY > limit.getMaxY()) {
                                                nY = limit.getMaxY();
                                                if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, nY)) {
                                                    nY = this.nr.getLowerYGrid(curZ, nY);
                                                }
                                                if ((dy = nY - curY) == 0.0) {
                                                    if (!RoutingDebug.isActive()) continue;
                                                    this.completeDebugString(i, ": Out Of Global Routing Y Bounds");
                                                    continue;
                                                }
                                            }
                                        }
                                        if (nX < this.nr.routeBounds.getMinX()) {
                                            nX = this.nr.routeBounds.getMinX();
                                            if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, nX, curY)) {
                                                nX = this.nr.getUpperXGrid(curZ, nX);
                                            }
                                            if ((dx = nX - curX) == 0.0) {
                                                if (!RoutingDebug.isActive()) continue;
                                                this.completeDebugString(i, ": Out Of X Bounds");
                                                continue;
                                            }
                                        }
                                        if (nX > this.nr.routeBounds.getMaxX()) {
                                            nX = this.nr.routeBounds.getMaxX();
                                            if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, nX, curY)) {
                                                nX = this.nr.getLowerXGrid(curZ, nX);
                                            }
                                            if ((dx = nX - curX) == 0.0) {
                                                if (!RoutingDebug.isActive()) continue;
                                                this.completeDebugString(i, ": Out Of X Bounds");
                                                continue;
                                            }
                                        }
                                        if (nY < this.nr.routeBounds.getMinY()) {
                                            nY = this.nr.routeBounds.getMinY();
                                            if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, nY)) {
                                                nY = this.nr.getUpperYGrid(curZ, nY);
                                            }
                                            if ((dy = nY - curY) == 0.0) {
                                                if (!RoutingDebug.isActive()) continue;
                                                this.completeDebugString(i, ": Out Of Y Bounds");
                                                continue;
                                            }
                                        }
                                        if (nY > this.nr.routeBounds.getMaxY()) {
                                            nY = this.nr.routeBounds.getMaxY();
                                            if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, nY)) {
                                                nY = this.nr.getLowerYGrid(curZ, nY);
                                            }
                                            if ((dy = nY - curY) == 0.0) {
                                                if (!RoutingDebug.isActive()) continue;
                                                this.completeDebugString(i, ": Out Of Y Bounds");
                                                continue;
                                            }
                                        }
                                        if (nZ < 0 || nZ >= numMetalLayers) {
                                            if (!RoutingDebug.isActive()) continue;
                                            this.completeDebugString(i, ": Out Of Bounds");
                                            continue;
                                        }
                                        if (this.nr.preventArc(nZ)) {
                                            if (!RoutingDebug.isActive()) continue;
                                            this.completeDebugString(i, ": Disallowed Arc");
                                            continue;
                                        }
                                        alreadyThere = this.getVertex(nX, nY, nZ);
                                        if (alreadyThere != null && !this.active.inList(alreadyThere)) {
                                            if (!RoutingDebug.isActive()) continue;
                                            this.completeDebugString(i, ": Already Visited");
                                            continue;
                                        }
                                        whichContact = 0;
                                        cuts = null;
                                        size2 = null;
                                        if (dz == 0) break block149;
                                        lowMetal = Math.min(curZ, nZ);
                                        highMetal = Math.max(curZ, nZ);
                                        nps = SeaOfGatesEngine.this.metalVias[lowMetal].getVias();
                                        whichContact = -1;
                                        failureReasons = null;
                                        if (RoutingDebug.isActive()) {
                                            failureReasons = new String[nps.size()];
                                        }
                                        break block150;
                                    }
                                    double width = this.nr.getArcWidth(nZ);
                                    double metalSpacing = width / 2.0;
                                    boolean allClear = false;
                                    double initNX = nX;
                                    double initNY = nY;
                                    String explanation = null;
                                    if (RoutingDebug.isActive()) {
                                        explanation = "";
                                    }
                                    while (true) {
                                        double newNY;
                                        double newNX;
                                        SOGBound sb;
                                        SearchVertex prevPath = svCurrent;
                                        double checkX = (curX + nX) / 2.0;
                                        double checkY = (curY + nY) / 2.0;
                                        double halfWid = metalSpacing + Math.abs(dx) / 2.0;
                                        double halfHei = metalSpacing + Math.abs(dy) / 2.0;
                                        while (prevPath != null && prevPath.last != null && prevPath.zv == nZ && prevPath.last.zv == nZ) {
                                            if (prevPath.xv == prevPath.last.xv && dx == 0.0) {
                                                checkY = (prevPath.last.yv + nY) / 2.0;
                                                halfHei = metalSpacing + Math.abs(prevPath.last.yv - nY) / 2.0;
                                                prevPath = prevPath.last;
                                                continue;
                                            }
                                            if (prevPath.yv != prevPath.last.yv || dy != 0.0) break;
                                            checkX = (prevPath.last.xv + nX) / 2.0;
                                            halfWid = metalSpacing + Math.abs(prevPath.last.xv - nX) / 2.0;
                                            prevPath = prevPath.last;
                                        }
                                        if ((sb = this.getMetalBlockageAndNotch(nZ, halfWid, halfHei, checkX, checkY, prevPath)) == null) {
                                            allClear = true;
                                            break;
                                        }
                                        if (RoutingDebug.isActive()) {
                                            explanation = explanation + ": Blocked on M" + (nZ + 1) + " because proposed " + com.sun.electric.util.TextUtils.formatDouble(checkX - halfWid) + "<=X<=" + com.sun.electric.util.TextUtils.formatDouble(checkX + halfWid) + " and " + com.sun.electric.util.TextUtils.formatDouble(checkY - halfHei) + "<=Y<=" + com.sun.electric.util.TextUtils.formatDouble(checkY + halfHei) + " is less than " + com.sun.electric.util.TextUtils.formatDouble(metalSpacing) + " to " + com.sun.electric.util.TextUtils.formatDouble(sb.bound.getMinX()) + "<=X<=" + com.sun.electric.util.TextUtils.formatDouble(sb.bound.getMaxX()) + " and " + com.sun.electric.util.TextUtils.formatDouble(sb.bound.getMinY()) + "<=Y<=" + com.sun.electric.util.TextUtils.formatDouble(sb.bound.getMaxY());
                                        }
                                        if (i == 0 ? (newNX = SeaOfGatesEngine.inDestGrid(this.toRectGridded, newNX = nX + 1.0, curY) ? this.nr.downToGrainAlways(newNX) : this.nr.getUpperXGrid(curZ, newNX)) >= curX || DBMath.areEquals(newNX, nX) || (dx = newNX - curX) == 0.0 : (i == 1 ? (newNX = SeaOfGatesEngine.inDestGrid(this.toRectGridded, newNX = nX - 1.0, curY) ? this.nr.upToGrainAlways(newNX) : this.nr.getLowerXGrid(curZ, newNX)) <= curX || DBMath.areEquals(newNX, nX) || (dx = newNX - curX) == 0.0 : (i == 2 ? (newNY = SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, newNY = nY + 1.0) ? this.nr.downToGrainAlways(newNY) : this.nr.getUpperYGrid(curZ, newNY)) >= curY || DBMath.areEquals(newNY, nY) || (dy = newNY - curY) == 0.0 : i == 3 && ((newNY = SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, newNY = nY - 1.0) ? this.nr.upToGrainAlways(newNY) : this.nr.getLowerYGrid(curZ, newNY)) <= curY || DBMath.areEquals(newNY, nY) || (dy = newNY - curY) == 0.0)))) break;
                                        nX = curX + dx;
                                        nY = curY + dy;
                                    }
                                    if (!allClear) {
                                        if (!RoutingDebug.isActive()) continue;
                                        double checkX = (curX + nX) / 2.0;
                                        double checkY = (curY + nY) / 2.0;
                                        double halfWid = metalSpacing + Math.abs(dx) / 2.0;
                                        double halfHei = metalSpacing + Math.abs(dy) / 2.0;
                                        double surround = SeaOfGatesEngine.this.worstMetalSurround[nZ];
                                        SOGBound sb = this.nr.getMetalBlockage(this.nr.netID, nZ, halfWid, halfHei, new double[]{surround, surround}, checkX, checkY);
                                        explanation = sb != null ? explanation + ": Blocked" : explanation + ": Blocked, Notch";
                                        this.completeDebugString(i, explanation);
                                        continue;
                                    }
                                    if (!RoutingDebug.isActive()) break block151;
                                    if (initNX != nX || initNY != nY) {
                                        explanation = explanation + " so move only ";
                                        switch (i) {
                                            case 0: {
                                                explanation = explanation + com.sun.electric.util.TextUtils.formatDouble(Math.abs(dx));
                                                break;
                                            }
                                            case 1: {
                                                explanation = explanation + com.sun.electric.util.TextUtils.formatDouble(dx);
                                                break;
                                            }
                                            case 2: {
                                                explanation = explanation + com.sun.electric.util.TextUtils.formatDouble(Math.abs(dy));
                                                break;
                                            }
                                            case 3: {
                                                explanation = explanation + com.sun.electric.util.TextUtils.formatDouble(dy);
                                                break;
                                            }
                                        }
                                    }
                                    this.addDebugString(i, explanation);
                                    break block151;
                                }
                                for (int contactNo = 0; contactNo < nps.size(); ++contactNo) {
                                    MetalVia mv = nps.get(contactNo);
                                    PrimitiveNode np = mv.via;
                                    Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                                    SizeOffset so = np.getProtoSizeOffset();
                                    double minWid = this.nr.minWidth;
                                    double minHei = this.nr.minWidth;
                                    double xOffset = so.getLowXOffset() + so.getHighXOffset();
                                    double yOffset = so.getLowYOffset() + so.getHighYOffset();
                                    double conWid = Math.max(np.getDefWidth(SeaOfGatesEngine.this.ep) - xOffset, minWid) + xOffset;
                                    double conHei = Math.max(np.getDefHeight(SeaOfGatesEngine.this.ep) - yOffset, minHei) + yOffset;
                                    boolean allowOverrides = false;
                                    if (mv.horMetal >= 0 && mv.verMetal >= 0) {
                                        if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                            if ((mv.horMetal + 1) % 2 == 0) {
                                                allowOverrides = true;
                                            }
                                        } else if ((mv.verMetal + 1) % 2 != 0) {
                                            allowOverrides = true;
                                        }
                                    }
                                    if (allowOverrides) {
                                        xOffset = mv.verMetalInset;
                                        yOffset = mv.horMetalInset;
                                        if (this.nr.getArcWidth(mv.verMetal) + xOffset > conWid) {
                                            conWid = this.nr.getArcWidth(mv.verMetal) + xOffset;
                                        }
                                        if (this.nr.getArcWidth(mv.horMetal) + yOffset > conHei) {
                                            conHei = this.nr.getArcWidth(mv.horMetal) + yOffset;
                                        }
                                    }
                                    NodeInst dummyNi = NodeInst.makeDummyInstance(np, SeaOfGatesEngine.this.ep, EPoint.fromLambda(nX, nY), conWid, conHei, orient);
                                    Poly[] conPolys = SeaOfGatesEngine.this.tech.getShapeOfNode(dummyNi);
                                    FixpTransform trans = null;
                                    if (orient != Orientation.IDENT) {
                                        trans = dummyNi.rotateOut();
                                    }
                                    int cutCount = 0;
                                    for (int p = 0; p < conPolys.length; ++p) {
                                        if (!conPolys[p].getLayer().getFunction().isContact()) continue;
                                        ++cutCount;
                                    }
                                    Point2D[] curCuts = new Point2D[cutCount];
                                    cutCount = 0;
                                    String failedReason = null;
                                    for (int p = 0; p < conPolys.length; ++p) {
                                        SearchVertex lastSv;
                                        FixpRectangle conRect;
                                        Layer conLayer;
                                        Layer.Function lFun;
                                        Poly conPoly = conPolys[p];
                                        if (trans != null) {
                                            conPoly.transform(trans);
                                        }
                                        if ((lFun = (conLayer = conPoly.getLayer()).getFunction()).isMetal()) {
                                            double halfHei;
                                            double halfWid;
                                            conRect = conPoly.getBounds2D();
                                            int metalNo = lFun.getLevel() - 1;
                                            SOGBound sb = this.getMetalBlockageAndNotch(metalNo, halfWid = ((RectangularShape)conRect).getWidth() / 2.0, halfHei = ((RectangularShape)conRect).getHeight() / 2.0, ((RectangularShape)conRect).getCenterX(), ((RectangularShape)conRect).getCenterY(), svCurrent);
                                            if (sb == null) continue;
                                            if (failureReasons == null) {
                                                failedReason = "";
                                                break;
                                            }
                                            failedReason = "layer " + conLayer.getName();
                                            failedReason = failedReason + " at " + com.sun.electric.util.TextUtils.formatDouble(((RectangularShape)conRect).getMinX()) + "<=X<=" + com.sun.electric.util.TextUtils.formatDouble(((RectangularShape)conRect).getMaxX()) + " and " + com.sun.electric.util.TextUtils.formatDouble(((RectangularShape)conRect).getMinY()) + "<=Y<=" + com.sun.electric.util.TextUtils.formatDouble(((RectangularShape)conRect).getMaxY());
                                            failedReason = failedReason + " conflicts with " + com.sun.electric.util.TextUtils.formatDouble(sb.getBounds().getMinX()) + "<=X<=" + com.sun.electric.util.TextUtils.formatDouble(sb.getBounds().getMaxX()) + " and " + com.sun.electric.util.TextUtils.formatDouble(sb.getBounds().getMinY()) + "<=Y<=" + com.sun.electric.util.TextUtils.formatDouble(sb.getBounds().getMaxY());
                                            break;
                                        }
                                        if (!lFun.isContact()) continue;
                                        conRect = conPoly.getBounds2D();
                                        double conCX = ((RectangularShape)conRect).getCenterX();
                                        double conCY = ((RectangularShape)conRect).getCenterY();
                                        double surround = SeaOfGatesEngine.this.viaSurround[lowMetal];
                                        if (this.nr.getViaBlockage(this.nr.netID, conLayer, surround, surround, conCX, conCY) != null) {
                                            if (failureReasons == null) {
                                                failedReason = "";
                                                break;
                                            }
                                            failedReason = "cut " + conLayer.getName() + " at " + com.sun.electric.util.TextUtils.formatDouble(((RectangularShape)conRect).getMinX()) + "<=X<=" + com.sun.electric.util.TextUtils.formatDouble(((RectangularShape)conRect).getMaxX()) + " and " + com.sun.electric.util.TextUtils.formatDouble(((RectangularShape)conRect).getMinY()) + "<=Y<=" + com.sun.electric.util.TextUtils.formatDouble(((RectangularShape)conRect).getMaxY());
                                            break;
                                        }
                                        curCuts[cutCount++] = new Point2D.Double(conCX, conCY);
                                        SearchVertex sv = svCurrent;
                                        while (sv != null && (lastSv = sv.last) != null) {
                                            if (Math.min(sv.getZ(), lastSv.getZ()) == lowMetal && Math.max(sv.getZ(), lastSv.getZ()) == highMetal) {
                                                Point2D[] svCuts = sv.getCutLayer() == lowMetal ? sv.getCuts() : lastSv.getCuts();
                                                if (svCuts != null) {
                                                    for (Point2D cutPt : svCuts) {
                                                        if (Math.abs(cutPt.getX() - conCX) >= surround || Math.abs(cutPt.getY() - conCY) >= surround) continue;
                                                        if (failureReasons == null) {
                                                            failedReason = "";
                                                            break;
                                                        }
                                                        failedReason = conLayer.getName() + " cut at (" + com.sun.electric.util.TextUtils.formatDouble(conCX) + "," + com.sun.electric.util.TextUtils.formatDouble(conCY) + ") because it is too close (" + surround + ") to previous cut at (" + com.sun.electric.util.TextUtils.formatDouble(sv.getX()) + "," + com.sun.electric.util.TextUtils.formatDouble(sv.getY()) + ")";
                                                        break;
                                                    }
                                                }
                                                if (failedReason != null) break;
                                            }
                                            sv = sv.last;
                                        }
                                        if (failedReason != null) break;
                                    }
                                    if (failedReason != null) {
                                        if (!RoutingDebug.isActive()) continue;
                                        failureReasons[contactNo] = failedReason;
                                        continue;
                                    }
                                    whichContact = contactNo;
                                    cuts = curCuts;
                                    size2 = new Point2D.Double(conWid, conHei);
                                    break;
                                }
                                if (whichContact < 0) {
                                    if (!RoutingDebug.isActive()) continue;
                                    String further = ": Blocked because:";
                                    for (int contactNo = 0; contactNo < failureReasons.length; ++contactNo) {
                                        MetalVia mv = nps.get(contactNo);
                                        further = further + "|In " + SeaOfGatesEngine.this.describe(mv.via);
                                        if (mv.orientation != 0) {
                                            further = further + " (rotated " + mv.orientation + ")";
                                        }
                                        further = further + " cannot place " + failureReasons[contactNo];
                                    }
                                    this.completeDebugString(i, further);
                                    continue;
                                }
                            }
                            boolean bl = foundDest = DBMath.pointInRect(EPoint.fromLambda(nX, nY), this.toRect) && nZ == this.toZ;
                            if (foundDestination != null) {
                                foundDest = true;
                            }
                            if (foundDest && (Math.abs(dx) > 10.0 && nZ % 2 == 0 || Math.abs(dy) > 10.0 && nZ % 2 != 0)) continue;
                            svNext = new SearchVertex(nX, nY, nZ, whichContact, cuts, size2, Math.min(curZ, nZ), this);
                            if (dz == 0 && (Math.abs(dx) >= 2.0 || Math.abs(dy) >= 2.0)) {
                                svNext.setAutoGen(i);
                            }
                            svNext.last = svCurrent;
                            if (foundDest) {
                                if (RoutingDebug.isActive()) {
                                    RoutingDebug.saveSVLink(svNext, i);
                                    this.completeDebugString(i, ": Found Destination!");
                                }
                                destinationSV = svNext;
                                continue;
                            }
                            if (this.globalRoutingDelta != 0) {
                                svNext.globalRoutingBucket = this.getNextBucket(svCurrent, nX, nY);
                            }
                            newCost = svCurrent.cost;
                            costExplanation = "";
                            penaltyOffGridX = false;
                            if (nX < this.toRect.getMinX() || nX > this.toRect.getMaxX()) {
                                penaltyOffGridX = this.nr.gridLocationsX[nZ] == null ? this.nr.downToGrainAlways(nX) != nX : !this.nr.isOnXGrid(nZ, nX);
                            }
                            penaltyOffGridY = false;
                            if (nY < this.toRect.getMinY() || nY > this.toRect.getMaxY()) {
                                penaltyOffGridY = this.nr.gridLocationsY[nZ] == null ? this.nr.downToGrainAlways(nY) != nY : !this.nr.isOnYGrid(nZ, nY);
                            }
                            double distBefore = Math.sqrt((curX - this.toX) * (curX - this.toX) + (curY - this.toY) * (curY - this.toY));
                            double distAfter = Math.sqrt((nX - this.toX) * (nX - this.toX) + (nY - this.toY) * (nY - this.toY));
                            c = (int)((distAfter - distBefore) / 5.0);
                            newCost += c;
                            if (RoutingDebug.isActive()) {
                                costExplanation = " [COST: Dist-to-target=" + c;
                            }
                            if (dx != 0.0) {
                                if (curX >= this.toRect.getMinX() && curX <= this.toRect.getMaxX()) {
                                    c = 7;
                                    newCost += c;
                                    if (RoutingDebug.isActive()) {
                                        costExplanation = costExplanation + " Zero-X-progress=" + c;
                                    }
                                } else if ((this.toX - curX) * dx < 0.0) {
                                    if (curY >= this.toRect.getMinY() && curY <= this.toRect.getMaxY()) {
                                        c = 1;
                                        newCost += c;
                                        if (RoutingDebug.isActive()) {
                                            costExplanation = costExplanation + " Backward-X-progress-at-dest-Y=" + c;
                                        }
                                    } else {
                                        c = 15;
                                        newCost += c;
                                        if (RoutingDebug.isActive()) {
                                            costExplanation = costExplanation + " Backward-X-progress=" + c;
                                        }
                                    }
                                }
                                if (SeaOfGatesEngine.this.sogp.isFavorHorVer() && nZ % 2 == 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                    c = (int)Math.round(20.0 * Math.abs(dx));
                                    newCost += c;
                                    if (RoutingDebug.isActive()) {
                                        costExplanation = costExplanation + " Not-alternating-metal=" + c;
                                    }
                                }
                            }
                            if (dy != 0.0) {
                                if (curY >= this.toRect.getMinY() && curY <= this.toRect.getMaxY()) {
                                    c = 7;
                                    newCost += c;
                                    if (RoutingDebug.isActive()) {
                                        costExplanation = costExplanation + " Zero-Y-progress=" + c;
                                    }
                                } else if ((this.toY - curY) * dy < 0.0) {
                                    if (curX >= this.toRect.getMinX() && curX <= this.toRect.getMaxX()) {
                                        c = 1;
                                        newCost += c;
                                        if (RoutingDebug.isActive()) {
                                            costExplanation = costExplanation + " Backward-Y-progress-at-dest-X=" + c;
                                        }
                                    } else {
                                        c = 15;
                                        newCost += c;
                                        if (RoutingDebug.isActive()) {
                                            costExplanation = costExplanation + " Backward-Y-progress=" + c;
                                        }
                                    }
                                }
                                if (SeaOfGatesEngine.this.sogp.isFavorHorVer() && nZ % 2 != 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                    c = (int)Math.round(20.0 * Math.abs(dy));
                                    newCost += c;
                                    if (RoutingDebug.isActive()) {
                                        costExplanation = costExplanation + " Not-alternating-metal=" + c;
                                    }
                                }
                            }
                            if (dz == 0) break block152;
                            if (this.toZ != curZ) break block153;
                            c = 8;
                            newCost += c;
                            if (RoutingDebug.isActive()) {
                                costExplanation = costExplanation + " Layer-change=" + c;
                            }
                            break block154;
                        }
                        if ((this.toZ - curZ) * dz < 0) {
                            c = 9;
                            newCost += c;
                            if (RoutingDebug.isActive()) {
                                costExplanation = costExplanation + " Layer-change-wrong-direction=" + c;
                            }
                        }
                        break block154;
                    }
                    double jumpSize1 = Math.abs(this.getJumpSize(svCurrent, nX, nY, nZ, dx, dy, null));
                    double jumpSize2 = Math.abs(this.getJumpSize(svCurrent, curX, curY, curZ, -dx, -dy, null));
                    if (jumpSize1 > 1.0 && jumpSize2 > 1.0 && (c = (int)(jumpSize1 * jumpSize2 / 10.0)) > 0) {
                        newCost += c;
                        if (RoutingDebug.isActive()) {
                            costExplanation = costExplanation + " Fragments-track=" + c;
                        }
                    }
                    if (svCurrent.last != null) {
                        boolean xTurn = svCurrent.getX() != svCurrent.last.getX();
                        boolean yTurn = svCurrent.getY() != svCurrent.last.getY();
                        if (xTurn != (dx != 0.0) || yTurn != (dy != 0.0)) {
                            c = 1;
                            newCost += c;
                            if (RoutingDebug.isActive()) {
                                costExplanation = costExplanation + " Turning=" + c;
                            }
                        }
                    }
                }
                if (!SeaOfGatesEngine.this.favorArcs[nZ]) {
                    c = (int)((double)(80 * Math.abs(dz)) + 10.0 * Math.abs(dx + dy));
                    newCost += c;
                    if (RoutingDebug.isActive()) {
                        costExplanation = costExplanation + " Layer-unfavored=" + c;
                    }
                }
                if (penaltyOffGridX) {
                    c = 15;
                    newCost += c;
                    if (RoutingDebug.isActive()) {
                        costExplanation = costExplanation + " Off-X-grid=" + c;
                    }
                }
                if (penaltyOffGridY) {
                    c = 15;
                    newCost += c;
                    if (RoutingDebug.isActive()) {
                        costExplanation = costExplanation + " Off-Y-grid=" + c;
                    }
                }
                svNext.cost = newCost;
                if (alreadyThere != null) {
                    if (alreadyThere.getCost() < svNext.getCost()) {
                        if (!RoutingDebug.isActive()) continue;
                        this.completeDebugString(i, ": Already Planned at lower cost (" + alreadyThere.getCost() + ")");
                        continue;
                    }
                    this.active.remove(alreadyThere);
                }
                this.setVertex(nX, nY, nZ, svNext);
                this.active.add(svNext);
                if (RoutingDebug.isActive()) {
                    this.completeDebugString(i, ": To (" + com.sun.electric.util.TextUtils.formatDouble(svNext.getX()) + "," + com.sun.electric.util.TextUtils.formatDouble(svNext.getY()) + ",M" + (svNext.getZ() + 1) + ")" + costExplanation + "]");
                }
                if (!RoutingDebug.isActive()) continue;
                RoutingDebug.saveSVLink(svNext, i);
            }
            if (RoutingDebug.isActive()) {
                RoutingDebug.saveSVDetails(svCurrent, this.debugString);
            }
            return destinationSV;
        }

        private int getNextBucket(SearchVertex svCurrent, double nX, double nY) {
            Rectangle2D limit;
            int start;
            int bucket;
            for (bucket = start = this.orderedBase[svCurrent.globalRoutingBucket]; bucket >= 0 && bucket < this.nr.buckets.length; bucket += this.globalRoutingDelta) {
                limit = this.nr.buckets[bucket];
                if (!DBMath.isGreaterThanOrEqualTo(nX, limit.getMinX()) || !DBMath.isLessThanOrEqualTo(nX, limit.getMaxX()) || !DBMath.isGreaterThanOrEqualTo(nY, limit.getMinY()) || !DBMath.isLessThanOrEqualTo(nY, limit.getMaxY())) continue;
                return bucket;
            }
            for (bucket = start - this.globalRoutingDelta; bucket >= 0 && bucket < this.nr.buckets.length; bucket -= this.globalRoutingDelta) {
                limit = this.nr.buckets[bucket];
                if (!DBMath.isGreaterThanOrEqualTo(nX, limit.getMinX()) || !DBMath.isLessThanOrEqualTo(nX, limit.getMaxX()) || !DBMath.isGreaterThanOrEqualTo(nY, limit.getMinY()) || !DBMath.isLessThanOrEqualTo(nY, limit.getMaxY())) continue;
                return bucket;
            }
            SeaOfGatesEngine.this.error("ERROR: Could not find next bucket going from (" + com.sun.electric.util.TextUtils.formatDouble(svCurrent.xv) + "," + com.sun.electric.util.TextUtils.formatDouble(svCurrent.yv) + ") to (" + com.sun.electric.util.TextUtils.formatDouble(nX) + "," + com.sun.electric.util.TextUtils.formatDouble(nY) + ") starting at bucket " + this.orderedBase[svCurrent.globalRoutingBucket] + " (really " + svCurrent.globalRoutingBucket + ") and going " + this.globalRoutingDelta);
            return svCurrent.globalRoutingBucket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createRoute() {
            RouteNode toRN;
            int parenPos;
            String routeName = this.nr.routeName;
            if (routeName.endsWith("...")) {
                routeName = routeName.substring(0, routeName.length() - 3);
            }
            if ((parenPos = routeName.lastIndexOf(40)) > 0) {
                routeName = routeName.substring(0, parenPos);
            }
            RouteNode fromRN = new RouteNode(this.from);
            RouteNode lastRN = toRN = new RouteNode(this.to);
            Poly toPoly = this.to.getPoly();
            double minWidth = this.nr.minWidth;
            RouteResolution resolution = this.nr.batch.resolution;
            if (!DBMath.pointInRect(EPoint.fromLambda(this.toX, this.toY), this.toRect) && this.vertices.size() >= 2) {
                RouteArc ra;
                RouteNode rn;
                SearchVertex v1 = this.vertices.get(0);
                SearchVertex v2 = this.vertices.get(1);
                ArcProto type = SeaOfGatesEngine.this.metalArcs[this.toZ];
                Layer layer = SeaOfGatesEngine.this.metalLayers[this.toZ];
                double width = this.nr.getArcWidth(this.toZ);
                PrimitiveNode np = SeaOfGatesEngine.this.metalArcs[this.toZ].findPinProto();
                if (v1.getX() == v2.getX()) {
                    rn = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(v1.getX(), toPoly.getCenterY()), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                    resolution.addNode(rn);
                    ra = new RouteArc(type, routeName, SeaOfGatesEngine.this, layer, width, rn, toRN, this.nr);
                    routeName = null;
                    resolution.addArc(ra);
                    lastRN = rn;
                } else if (v1.getY() == v2.getY()) {
                    rn = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(toPoly.getCenterX(), v1.getY()), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                    resolution.addNode(rn);
                    ra = new RouteArc(type, routeName, SeaOfGatesEngine.this, layer, width, rn, toRN, this.nr);
                    routeName = null;
                    resolution.addArc(ra);
                    lastRN = rn;
                }
            }
            for (int i = 0; i < this.vertices.size(); ++i) {
                RouteNode piRN;
                SearchVertex sv = this.vertices.get(i);
                boolean madeContacts = false;
                while (i < this.vertices.size() - 1) {
                    SearchVertex svNext = this.vertices.get(i + 1);
                    if (sv.getX() != svNext.getX() || sv.getY() != svNext.getY() || sv.getZ() == svNext.getZ()) break;
                    List<MetalVia> nps = SeaOfGatesEngine.this.metalVias[Math.min(sv.getZ(), svNext.getZ())].getVias();
                    int whichContact = sv.getContactNo();
                    MetalVia mv = nps.get(whichContact);
                    PrimitiveNode np = mv.via;
                    Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                    SizeOffset so = np.getProtoSizeOffset();
                    double xOffset = so.getLowXOffset() + so.getHighXOffset();
                    double yOffset = so.getLowYOffset() + so.getHighYOffset();
                    double wid = Math.max(np.getDefWidth(SeaOfGatesEngine.this.ep) - xOffset, minWidth) + xOffset;
                    double hei = Math.max(np.getDefHeight(SeaOfGatesEngine.this.ep) - yOffset, minWidth) + yOffset;
                    Point2D size2 = sv.getSize();
                    wid = size2.getX();
                    hei = size2.getY();
                    ArcProto type = SeaOfGatesEngine.this.metalArcs[sv.getZ()];
                    Layer layer = SeaOfGatesEngine.this.metalLayers[sv.getZ()];
                    double width = this.nr.getArcWidth(sv.getZ());
                    RouteNode rn = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(sv.getX(), sv.getY()), wid, hei, orient, null, this.nr);
                    resolution.addNode(rn);
                    RouteArc ra = new RouteArc(type, routeName, SeaOfGatesEngine.this, layer, width, lastRN, rn, this.nr);
                    routeName = null;
                    resolution.addArc(ra);
                    lastRN = rn;
                    madeContacts = true;
                    sv = svNext;
                    ++i;
                }
                if (madeContacts && i != this.vertices.size() - 1) continue;
                PrimitiveNode np = SeaOfGatesEngine.this.metalArcs[sv.getZ()].findPinProto();
                if (i == this.vertices.size() - 1) {
                    piRN = fromRN;
                    if (!DBMath.pointInRect(EPoint.fromLambda(sv.getX(), sv.getY()), this.fromRect) && this.vertices.size() >= 2) {
                        PrimitiveNode pNp;
                        SearchVertex v1 = this.vertices.get(this.vertices.size() - 2);
                        SearchVertex v2 = this.vertices.get(this.vertices.size() - 1);
                        ArcProto type = SeaOfGatesEngine.this.metalArcs[this.fromZ];
                        Layer layer = SeaOfGatesEngine.this.metalLayers[this.fromZ];
                        double width = this.nr.getArcWidth(this.fromZ);
                        if (v1.getX() == v2.getX()) {
                            pNp = SeaOfGatesEngine.this.metalArcs[this.fromZ].findPinProto();
                            piRN = new RouteNode(pNp, SeaOfGatesEngine.this, EPoint.fromLambda(v1.getX(), this.fromY), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                            resolution.addNode(piRN);
                            RouteArc ra = new RouteArc(type, routeName, SeaOfGatesEngine.this, layer, width, piRN, fromRN, this.nr);
                            routeName = null;
                            resolution.addArc(ra);
                        } else if (v1.getY() == v2.getY()) {
                            pNp = SeaOfGatesEngine.this.metalArcs[this.fromZ].findPinProto();
                            piRN = new RouteNode(pNp, SeaOfGatesEngine.this, EPoint.fromLambda(this.fromX, v1.getY()), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                            resolution.addNode(piRN);
                            RouteArc ra = new RouteArc(type, routeName, SeaOfGatesEngine.this, layer, width, piRN, fromRN, this.nr);
                            routeName = null;
                            resolution.addArc(ra);
                        }
                    }
                } else {
                    PortInst pi = null;
                    if (this.nr.spineTapMap != null) {
                        pi = (PortInst)this.nr.spineTapMap.get(sv);
                    }
                    piRN = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(sv.getX(), sv.getY()), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, pi, this.nr);
                    resolution.addNode(piRN);
                }
                if (lastRN != null) {
                    ArcProto type = SeaOfGatesEngine.this.metalArcs[sv.getZ()];
                    Layer layer = SeaOfGatesEngine.this.metalLayers[sv.getZ()];
                    double width = this.nr.getArcWidth(sv.getZ());
                    if (i == 0 && !DBMath.rectsIntersect(lastRN.rect, piRN.rect)) {
                        boolean covered;
                        double hY;
                        double lY;
                        double hX;
                        double lX;
                        double tY;
                        double tX;
                        double fY;
                        double fX;
                        block38: {
                            fX = lastRN.getLoc().getX();
                            fY = lastRN.getLoc().getY();
                            tX = piRN.getLoc().getX();
                            tY = piRN.getLoc().getY();
                            lX = Math.min(fX, tX) - width / 2.0;
                            hX = Math.max(fX, tX) + width / 2.0;
                            lY = Math.min(fY, tY) - width / 2.0;
                            hY = Math.max(fY, tY) + width / 2.0;
                            Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(layer);
                            covered = false;
                            bTree.lock();
                            try {
                                if (bTree.isEmpty()) break block38;
                                Iterator sea = bTree.search(searchArea);
                                while (sea.hasNext()) {
                                    SOGBound sBound = (SOGBound)sea.next();
                                    ERectangle bound = sBound.getBounds();
                                    if (!(((RectangularShape)bound).getMinX() <= lX) || !(((RectangularShape)bound).getMaxX() >= hX) || !(((RectangularShape)bound).getMinY() <= lY) || !(((RectangularShape)bound).getMaxY() >= hY)) continue;
                                    covered = true;
                                    break;
                                }
                            }
                            finally {
                                bTree.unlock();
                            }
                        }
                        if (!covered) {
                            boolean geomOK = false;
                            if (fX == tX || fY == tY) {
                                SOGBound errSV = this.getMetalBlockageAndNotch(sv.getZ(), (hX - lX) / 2.0, (hY - lY) / 2.0, (hX + lX) / 2.0, (hY + lY) / 2.0, null);
                                if (errSV == null) {
                                    geomOK = true;
                                }
                            } else {
                                RouteArc ra;
                                double bend1X = fX;
                                double bend1Y = tY;
                                double bend2X = tX;
                                double bend2Y = fY;
                                double bend1aLX = lX;
                                double bend1aHX = lX + width;
                                double bend1aLY = lY;
                                double bend1aHY = hY;
                                double bend1bLX = lX;
                                double bend1bHX = hX;
                                double bend1bLY = hY - width;
                                double bend1bHY = hY;
                                double bend2aLX = lX;
                                double bend2aHX = hX;
                                double bend2aLY = lY;
                                double bend2aHY = lY + width;
                                double bend2bLX = hX - width;
                                double bend2bHX = hX;
                                double bend2bLY = lY;
                                double bend2bHY = hY;
                                SOGBound errSVa = this.getMetalBlockageAndNotch(sv.getZ(), (bend1aHX - bend1aLX) / 2.0, (bend1aHY - bend1aLY) / 2.0, (bend1aHX + bend1aLX) / 2.0, (bend1aHY + bend1aLY) / 2.0, null);
                                SOGBound errSVb = this.getMetalBlockageAndNotch(sv.getZ(), (bend1bHX - bend1bLX) / 2.0, (bend1bHY - bend1bLY) / 2.0, (bend1bHX + bend1bLX) / 2.0, (bend1bHY + bend1bLY) / 2.0, null);
                                if (errSVa == null && errSVb == null) {
                                    RouteNode bend1RN = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(bend1X, bend1Y), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                                    resolution.addNode(bend1RN);
                                    ra = new RouteArc(type, routeName, SeaOfGatesEngine.this, layer, width, piRN, bend1RN, this.nr);
                                    routeName = null;
                                    resolution.addArc(ra);
                                    piRN = bend1RN;
                                    geomOK = true;
                                    System.out.println("AVOIDED UNIVERSAL ARC BECAUSE BEND 1 WORKS");
                                } else {
                                    errSVa = this.getMetalBlockageAndNotch(sv.getZ(), (bend2aHX - bend2aLX) / 2.0, (bend2aHY - bend2aLY) / 2.0, (bend2aHX + bend2aLX) / 2.0, (bend2aHY + bend2aLY) / 2.0, null);
                                    errSVb = this.getMetalBlockageAndNotch(sv.getZ(), (bend2bHX - bend2bLX) / 2.0, (bend2bHY - bend2bLY) / 2.0, (bend2bHX + bend2bLX) / 2.0, (bend2bHY + bend2bLY) / 2.0, null);
                                    if (errSVa == null && errSVb == null) {
                                        RouteNode bend2RN = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(bend2X, bend2Y), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                                        resolution.addNode(bend2RN);
                                        ra = new RouteArc(type, routeName, SeaOfGatesEngine.this, layer, width, piRN, bend2RN, this.nr);
                                        routeName = null;
                                        resolution.addArc(ra);
                                        piRN = bend2RN;
                                        geomOK = true;
                                        System.out.println("AVOIDED UNIVERSAL ARC BECAUSE BEND 2 WORKS");
                                    }
                                }
                            }
                            if (!geomOK) {
                                System.out.println("WARNING: Placing Universal are on route from port " + this.from.getPortProto().getName() + " of node " + SeaOfGatesEngine.this.describe(this.from.getNodeInst()) + " AT (" + this.fromX + "," + this.fromY + ",M" + (this.fromZ + 1) + ") to port " + this.to.getPortProto().getName() + " of node " + SeaOfGatesEngine.this.describe(this.to.getNodeInst()) + " AT (" + this.toX + "," + this.toY + ",M" + (this.toZ + 1) + ")");
                                type = Generic.tech().universal_arc;
                                layer = null;
                                width = 0.0;
                            } else {
                                System.out.println("AVOIDED UNIVERSAL ARC BECAUSE EXISTING LAYER IS DRC CLEAN");
                            }
                        } else {
                            System.out.println("AVOIDED UNIVERSAL ARC BECAUSE EXISTING LAYER SURROUNDS OK");
                        }
                    }
                    RouteArc ra = new RouteArc(type, routeName, SeaOfGatesEngine.this, layer, width, lastRN, piRN, this.nr);
                    routeName = null;
                    resolution.addArc(ra);
                }
                lastRN = piRN;
            }
            if (this.nr.endBlockages != null) {
                ArrayList<Layer> allLayers = new ArrayList<Layer>();
                for (Layer lay : this.nr.endBlockages.keySet()) {
                    allLayers.add(lay);
                }
                for (Layer lay : allLayers) {
                    BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(lay);
                    bTree.lock();
                    try {
                        List endBlocks = (List)this.nr.endBlockages.get(lay);
                        for (SOGBound endBlock : endBlocks) {
                            RTNode origRoot = bTree.getRoot();
                            RTNode<SOGBound> newRoot = RTNode.unLinkGeom(null, origRoot, endBlock, false);
                            if (newRoot == origRoot) continue;
                            bTree.setRoot(newRoot);
                        }
                        this.nr.endBlockages.remove(lay);
                    }
                    finally {
                        bTree.unlock();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double getJumpSize(SearchVertex sv, double curX, double curY, int curZ, double dx, double dy, MutableBoolean foundDestination) {
            Rectangle2D originalBucket;
            Rectangle2D jumpBound = this.nr.jumpBound;
            double width = this.nr.getArcWidth(curZ);
            double[] fromSurround = this.nr.getSpacingRule(curZ, width, 50.0);
            double metalSpacingX = width / 2.0 + fromSurround[0];
            double metalSpacingY = width / 2.0 + fromSurround[1];
            double lX = curX - metalSpacingX;
            double hX = curX + metalSpacingX;
            double lY = curY - metalSpacingY;
            double hY = curY + metalSpacingY;
            if (dx > 0.0) {
                hX = jumpBound.getMaxX() + metalSpacingX;
            } else if (dx < 0.0) {
                lX = jumpBound.getMinX() - metalSpacingX;
            } else if (dy > 0.0) {
                hY = jumpBound.getMaxY() + metalSpacingY;
            } else if (dy < 0.0) {
                lY = jumpBound.getMinY() - metalSpacingY;
            }
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.metalLayers[curZ]);
            bTree.lock();
            try {
                if (!bTree.isEmpty()) {
                    boolean hitDestination = false;
                    Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                    Iterator sea = bTree.search(searchArea);
                    while (sea.hasNext()) {
                        SOGBound sBound = (SOGBound)sea.next();
                        ERectangle bound = sBound.getBounds();
                        if (sBound.isSameBasicNet(this.nr.netID)) {
                            if (foundDestination == null || !sBound.hasEndBit(this.toBit)) continue;
                            if (dx > 0.0 && ((RectangularShape)bound).getCenterX() + metalSpacingX < hX) {
                                hX = ((RectangularShape)bound).getCenterX() + metalSpacingX;
                                hitDestination = true;
                            }
                            if (dx < 0.0 && ((RectangularShape)bound).getCenterX() - metalSpacingX > lX) {
                                lX = ((RectangularShape)bound).getCenterX() - metalSpacingX;
                                hitDestination = true;
                            }
                            if (dy > 0.0 && ((RectangularShape)bound).getCenterY() + metalSpacingY < hY) {
                                hY = ((RectangularShape)bound).getCenterY() + metalSpacingY;
                                hitDestination = true;
                            }
                            if (!(dy < 0.0) || !(((RectangularShape)bound).getCenterY() - metalSpacingY > lY)) continue;
                            lY = ((RectangularShape)bound).getCenterY() - metalSpacingY;
                            hitDestination = true;
                            continue;
                        }
                        if (((RectangularShape)bound).getMinX() >= hX || ((RectangularShape)bound).getMaxX() <= lX || ((RectangularShape)bound).getMinY() >= hY || ((RectangularShape)bound).getMaxY() <= lY) continue;
                        if (dx > 0.0 && ((RectangularShape)bound).getMinX() < hX) {
                            hX = ((RectangularShape)bound).getMinX();
                            hitDestination = false;
                        }
                        if (dx < 0.0 && ((RectangularShape)bound).getMaxX() > lX) {
                            lX = ((RectangularShape)bound).getMaxX();
                            hitDestination = false;
                        }
                        if (dy > 0.0 && ((RectangularShape)bound).getMinY() < hY) {
                            hY = ((RectangularShape)bound).getMinY();
                            hitDestination = false;
                        }
                        if (!(dy < 0.0) || !(((RectangularShape)bound).getMaxY() > lY)) continue;
                        lY = ((RectangularShape)bound).getMaxY();
                        hitDestination = false;
                    }
                    if (foundDestination != null) {
                        foundDestination.setValue(hitDestination);
                    }
                }
            }
            finally {
                bTree.unlock();
            }
            if (dx > 0.0) {
                dx = this.nr.downToGrain(hX - metalSpacingX) - curX;
                if (curX + dx > this.toX && curY >= this.toRect.getMinY() && curY <= this.toRect.getMaxY() && curZ == this.toZ) {
                    dx = this.toX - curX;
                } else {
                    Rectangle2D limit;
                    if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX + dx, curY)) {
                        dx = this.nr.getLowerXGrid(curZ, curX + dx) - curX;
                    }
                    if (this.globalRoutingDelta != 0 && curX + dx > (limit = this.orderedBuckets[sv.globalRoutingBucket]).getMaxX()) {
                        originalBucket = this.nr.buckets[sv.globalRoutingBucket];
                        dx = limit.getMaxX() - curX;
                        if (curX >= originalBucket.getMinX() && curX >= originalBucket.getMaxX() && curX + dx > originalBucket.getMaxX()) {
                            dx -= originalBucket.getWidth() / 2.0;
                        }
                        dx = this.nr.getClosestXGrid(curZ, curX + dx) - curX;
                    }
                    if (curX + dx > this.toRect.getMaxX() || curX + dx < this.toRect.getMinX()) {
                        dx = this.nr.downToGrainAlways(curX + dx) - curX;
                    }
                }
                return dx;
            }
            if (dx < 0.0) {
                dx = this.nr.upToGrain(lX + metalSpacingX) - curX;
                if (curX + dx < this.toX && curY >= this.toRect.getMinY() && curY <= this.toRect.getMaxY() && curZ == this.toZ) {
                    dx = this.toX - curX;
                } else {
                    Rectangle2D limit;
                    if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX + dx, curY)) {
                        dx = this.nr.getUpperXGrid(curZ, curX + dx) - curX;
                    }
                    if (this.globalRoutingDelta != 0 && curX + dx < (limit = this.orderedBuckets[sv.globalRoutingBucket]).getMinX()) {
                        originalBucket = this.nr.buckets[sv.globalRoutingBucket];
                        dx = limit.getMinX() - curX;
                        if (curX >= originalBucket.getMinX() && curX >= originalBucket.getMaxX() && curX + dx < originalBucket.getMinX()) {
                            dx += originalBucket.getWidth() / 2.0;
                        }
                        dx = this.nr.getClosestXGrid(curZ, curX + dx) - curX;
                    }
                    if (curX + dx > this.toRect.getMaxX() || curX + dx < this.toRect.getMinX()) {
                        dx = this.nr.upToGrainAlways(curX + dx) - curX;
                    }
                }
                return dx;
            }
            if (dy > 0.0) {
                dy = this.nr.downToGrain(hY - metalSpacingY) - curY;
                if (curX >= this.toRect.getMinX() && curX <= this.toRect.getMaxX() && curY + dy > this.toY && curZ == this.toZ) {
                    dy = this.toY - curY;
                } else {
                    Rectangle2D limit;
                    if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, curY + dy)) {
                        dy = this.nr.getLowerYGrid(curZ, curY + dy) - curY;
                    }
                    if (this.globalRoutingDelta != 0 && curY + dy > (limit = this.orderedBuckets[sv.globalRoutingBucket]).getMaxY()) {
                        originalBucket = this.nr.buckets[sv.globalRoutingBucket];
                        dy = limit.getMaxY() - curY;
                        if (curY >= originalBucket.getMinY() && curY >= originalBucket.getMaxY() && curY + dy > originalBucket.getMaxY()) {
                            dy -= originalBucket.getHeight() / 2.0;
                        }
                        dy = this.nr.getClosestYGrid(curZ, curY + dy) - curY;
                    }
                    if (curY + dy > this.toRect.getMaxY() || curY + dy < this.toRect.getMinY()) {
                        dy = this.nr.downToGrainAlways(curY + dy) - curY;
                    }
                }
                return dy;
            }
            if (dy < 0.0) {
                dy = this.nr.upToGrain(lY + metalSpacingY) - curY;
                if (curX >= this.toRect.getMinX() && curX <= this.toRect.getMaxX() && curY + dy < this.toY && curZ == this.toZ) {
                    dy = this.toY - curY;
                } else {
                    Rectangle2D limit;
                    if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, curY + dy)) {
                        dy = this.nr.getUpperYGrid(curZ, curY + dy) - curY;
                    }
                    if (this.globalRoutingDelta != 0 && curY + dy < (limit = this.orderedBuckets[sv.globalRoutingBucket]).getMinY()) {
                        originalBucket = this.nr.buckets[sv.globalRoutingBucket];
                        dy = limit.getMinY() - curY;
                        if (curY >= originalBucket.getMinY() && curY >= originalBucket.getMaxY() && curY + dy < originalBucket.getMinY()) {
                            dy += originalBucket.getHeight() / 2.0;
                        }
                        dy = this.nr.getClosestYGrid(curZ, curY + dy) - curY;
                    }
                    if (curY + dy > this.toRect.getMaxY() || curY + dy < this.toRect.getMinY()) {
                        dy = this.nr.upToGrainAlways(curY + dy) - curY;
                    }
                }
                return dy;
            }
            return 0.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SOGBound getMetalBlockageAndNotch(int metNo, double halfWidth, double halfHeight, double x2, double y, SearchVertex svCurrent) {
            Layer layer = SeaOfGatesEngine.this.metalLayers[metNo];
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(layer);
            bTree.lock();
            try {
                if (bTree.isEmpty()) {
                    SOGBound sOGBound = null;
                    return sOGBound;
                }
                double minWidth = this.nr.minWidth;
                double metLX = x2 - halfWidth;
                double metHX = x2 + halfWidth;
                double metLY = y - halfHeight;
                double metHY = y + halfHeight;
                Rectangle2D.Double metBound = new Rectangle2D.Double(metLX, metLY, metHX - metLX, metHY - metLY);
                double metWid = Math.min(halfWidth, halfHeight) * 2.0;
                double metLen = Math.max(halfWidth, halfHeight) * 2.0;
                double surround = SeaOfGatesEngine.this.worstMetalSurround[metNo];
                double lX = metLX - surround;
                double hX = metHX + surround;
                double lY = metLY - surround;
                double hY = metHY + surround;
                Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                ArrayList<Rectangle2D> recsOnPath = new ArrayList<Rectangle2D>();
                if (svCurrent != null) {
                    SeaOfGatesEngine.this.getOptimizedList(svCurrent, this.optimizedList);
                    for (int ind = 1; ind < this.optimizedList.size(); ++ind) {
                        Poly poly;
                        FixpRectangle bound;
                        SearchVertex sv = this.optimizedList.get(ind);
                        SearchVertex lastSv = this.optimizedList.get(ind - 1);
                        if (sv.getZ() != metNo && lastSv.getZ() != metNo) continue;
                        if (sv.getZ() != lastSv.getZ()) {
                            List<MetalVia> nps = SeaOfGatesEngine.this.metalVias[Math.min(sv.getZ(), lastSv.getZ())].getVias();
                            int whichContact = lastSv.getContactNo();
                            MetalVia mv = nps.get(whichContact);
                            PrimitiveNode np = mv.via;
                            Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                            SizeOffset so = np.getProtoSizeOffset();
                            double xOffset = so.getLowXOffset() + so.getHighXOffset();
                            double yOffset = so.getLowYOffset() + so.getHighYOffset();
                            double wid = Math.max(np.getDefWidth(SeaOfGatesEngine.this.ep) - xOffset, minWidth) + xOffset;
                            double hei = Math.max(np.getDefHeight(SeaOfGatesEngine.this.ep) - yOffset, minWidth) + yOffset;
                            NodeInst ni = NodeInst.makeDummyInstance(np, SeaOfGatesEngine.this.ep, EPoint.fromLambda(sv.getX(), sv.getY()), wid, hei, orient);
                            FixpTransform trans = null;
                            if (orient != Orientation.IDENT) {
                                trans = ni.rotateOut();
                            }
                            Poly[] polys = np.getTechnology().getShapeOfNode(ni);
                            for (int i = 0; i < polys.length; ++i) {
                                FixpRectangle bound2;
                                Poly poly2 = polys[i];
                                if (poly2.getLayer() != layer) continue;
                                if (trans != null) {
                                    poly2.transform(trans);
                                }
                                if (((RectangularShape)(bound2 = poly2.getBounds2D())).getMaxX() <= lX || ((RectangularShape)bound2).getMinX() >= hX || ((RectangularShape)bound2).getMaxY() <= lY || ((RectangularShape)bound2).getMinY() >= hY) continue;
                                recsOnPath.add(bound2);
                            }
                            continue;
                        }
                        double width = this.nr.getArcWidth(metNo);
                        Point2D.Double head2 = new Point2D.Double(sv.getX(), sv.getY());
                        Point2D.Double tail = new Point2D.Double(lastSv.getX(), lastSv.getY());
                        int ang = 0;
                        if (((Point2D)head2).getX() != ((Point2D)tail).getX() || ((Point2D)head2).getY() != ((Point2D)tail).getY()) {
                            ang = GenMath.figureAngle(tail, head2);
                        }
                        if (((RectangularShape)(bound = (poly = Poly.makeEndPointPoly(head2.distance(tail), width, ang, head2, width / 2.0, tail, width / 2.0, Poly.Type.FILLED)).getBounds2D())).getMaxX() <= lX || ((RectangularShape)bound).getMinX() >= hX || ((RectangularShape)bound).getMaxY() <= lY || ((RectangularShape)bound).getMinY() >= hY) continue;
                        recsOnPath.add(bound);
                    }
                }
                Iterator sea = bTree.search(searchArea);
                while (sea.hasNext()) {
                    Rectangle2D.Double drcArea;
                    PolyBase poly;
                    SOGBound sBound = (SOGBound)sea.next();
                    Rectangle2D bound = sBound.getBounds();
                    if (bound.getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
                    double drWid = 0.0;
                    double drLen = 0.0;
                    drWid = Math.max(Math.min(bound.getWidth(), bound.getHeight()), Math.min(metWid, metLen));
                    drLen = Math.max(Math.max(bound.getWidth(), bound.getHeight()), Math.max(metWid, metLen));
                    double[] spacing = this.nr.getSpacingRule(metNo, drWid, drLen);
                    double lXAllow = metLX - spacing[0];
                    double hXAllow = metHX + spacing[0];
                    double lYAllow = metLY - spacing[1];
                    double hYAllow = metHY + spacing[1];
                    if (DBMath.isLessThanOrEqualTo(bound.getMaxX(), lXAllow) || DBMath.isGreaterThanOrEqualTo(bound.getMinX(), hXAllow) || DBMath.isLessThanOrEqualTo(bound.getMaxY(), lYAllow) || DBMath.isGreaterThanOrEqualTo(bound.getMinY(), hYAllow)) continue;
                    if (sBound.isSameBasicNet(this.nr.netID)) {
                        boolean notBlockage = false;
                        if (!sBound.isPseudoBlockage()) {
                            notBlockage = true;
                        }
                        if (!notBlockage) continue;
                        boolean notch = this.foundANotch(bTree, metBound, bound, this.nr.netID, recsOnPath, spacing);
                        if (!notch) continue;
                        SOGBound sOGBound = sBound;
                        return sOGBound;
                    }
                    if (sBound instanceof SOGPoly && !(poly = ((SOGPoly)sBound).getPoly()).contains(drcArea = new Rectangle2D.Double(lXAllow, lYAllow, hXAllow - lXAllow, hYAllow - lYAllow))) continue;
                    SOGBound sOGBound = sBound;
                    return sOGBound;
                }
                double[] spacing = this.nr.getSpacingRule(metNo, Math.min(metWid, metLen), Math.max(metWid, metLen));
                for (Rectangle2D bound : recsOnPath) {
                    if (!this.foundANotch(bTree, metBound, bound, this.nr.netID, recsOnPath, spacing)) continue;
                    SOGBound sOGBound = new SOGBound(ERectangle.fromLambda(bound), this.nr.netID);
                    return sOGBound;
                }
                SOGBound sOGBound = null;
                return sOGBound;
            }
            finally {
                bTree.unlock();
            }
        }

        private boolean foundANotch(BlockageTree bTree, Rectangle2D metBound, Rectangle2D bound, MutableInteger netID, List<Rectangle2D> recsOnPath, double[] dist) {
            boolean vOverlap;
            boolean hOverlap = metBound.getMinX() <= bound.getMaxX() && metBound.getMaxX() >= bound.getMinX();
            boolean bl = vOverlap = metBound.getMinY() <= bound.getMaxY() && metBound.getMaxY() >= bound.getMinY();
            if (hOverlap && vOverlap) {
                return false;
            }
            if (hOverlap) {
                double ptY;
                if (metBound.getCenterY() > bound.getCenterY()) {
                    if (metBound.getMinY() - bound.getMaxY() > dist[1]) {
                        return false;
                    }
                    ptY = (metBound.getMinY() + bound.getMaxY()) / 2.0;
                } else {
                    if (bound.getMinY() - metBound.getMaxY() > dist[1]) {
                        return false;
                    }
                    ptY = (metBound.getMaxY() + bound.getMinY()) / 2.0;
                }
                double pt1X = Math.max(metBound.getMinX(), bound.getMinX());
                double pt2X = Math.min(metBound.getMaxX(), bound.getMaxX());
                double pt3X = (pt1X + pt2X) / 2.0;
                if (!this.pointInRTree(bTree, pt1X, ptY, netID, recsOnPath)) {
                    return true;
                }
                if (!this.pointInRTree(bTree, pt2X, ptY, netID, recsOnPath)) {
                    return true;
                }
                return !this.pointInRTree(bTree, pt3X, ptY, netID, recsOnPath);
            }
            if (vOverlap) {
                double ptX;
                if (metBound.getCenterX() > bound.getCenterX()) {
                    if (metBound.getMinX() - bound.getMaxX() > dist[0]) {
                        return false;
                    }
                    ptX = (metBound.getMinX() + bound.getMaxX()) / 2.0;
                } else {
                    if (bound.getMinX() - metBound.getMaxX() > dist[0]) {
                        return false;
                    }
                    ptX = (metBound.getMaxX() + bound.getMinX()) / 2.0;
                }
                double pt1Y = Math.max(metBound.getMinY(), bound.getMinY());
                double pt2Y = Math.min(metBound.getMaxY(), bound.getMaxY());
                double pt3Y = (pt1Y + pt2Y) / 2.0;
                if (!this.pointInRTree(bTree, ptX, pt1Y, netID, recsOnPath)) {
                    return true;
                }
                if (!this.pointInRTree(bTree, ptX, pt2Y, netID, recsOnPath)) {
                    return true;
                }
                return !this.pointInRTree(bTree, ptX, pt3Y, netID, recsOnPath);
            }
            if (metBound.getMinX() > bound.getMaxX() && metBound.getMinY() > bound.getMaxY()) {
                double pt2Y;
                double pt1X = metBound.getMinX();
                double pt1Y = bound.getMaxY();
                double pt2X = bound.getMaxX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMinY())) * (pt1Y - pt2Y)) > Math.max(dist[0], dist[1])) {
                    return false;
                }
                if (this.pointInRTree(bTree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(bTree, pt2X, pt2Y, netID, recsOnPath);
            }
            if (metBound.getMaxX() < bound.getMinX() && metBound.getMinY() > bound.getMaxY()) {
                double pt2Y;
                double pt1X = metBound.getMaxX();
                double pt1Y = bound.getMaxY();
                double pt2X = bound.getMinX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMinY())) * (pt1Y - pt2Y)) > Math.max(dist[0], dist[1])) {
                    return false;
                }
                if (this.pointInRTree(bTree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(bTree, pt2X, pt2Y, netID, recsOnPath);
            }
            if (metBound.getMaxX() < bound.getMinX() && metBound.getMaxY() < bound.getMinY()) {
                double pt2Y;
                double pt1X = metBound.getMaxX();
                double pt1Y = bound.getMinY();
                double pt2X = bound.getMinX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMaxY())) * (pt1Y - pt2Y)) > Math.max(dist[0], dist[1])) {
                    return false;
                }
                if (this.pointInRTree(bTree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(bTree, pt2X, pt2Y, netID, recsOnPath);
            }
            if (metBound.getMinX() > bound.getMaxX() && metBound.getMaxY() < bound.getMinY()) {
                double pt2Y;
                double pt1X = metBound.getMinX();
                double pt1Y = bound.getMinY();
                double pt2X = bound.getMaxX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMaxY())) * (pt1Y - pt2Y)) > Math.max(dist[0], dist[1])) {
                    return false;
                }
                if (this.pointInRTree(bTree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(bTree, pt2X, pt2Y, netID, recsOnPath);
            }
            return false;
        }

        private boolean pointInRTree(BlockageTree bTree, double x2, double y, MutableInteger netID, List<Rectangle2D> recsOnPath) {
            Rectangle2D.Double searchArea = new Rectangle2D.Double(x2 - 0.5, y - 0.5, 1.0, 1.0);
            Iterator sea = bTree.search(searchArea);
            while (sea.hasNext()) {
                SOGBound sBound = (SOGBound)sea.next();
                if (!sBound.isSameBasicNet(netID) || DBMath.isGreaterThan(sBound.getBounds().getMinX(), x2) || DBMath.isLessThan(sBound.getBounds().getMaxX(), x2) || DBMath.isGreaterThan(sBound.getBounds().getMinY(), y) || DBMath.isLessThan(sBound.getBounds().getMaxY(), y)) continue;
                return true;
            }
            for (Rectangle2D bound : recsOnPath) {
                if (DBMath.isGreaterThan(bound.getMinX(), x2) || DBMath.isLessThan(bound.getMaxX(), x2) || DBMath.isGreaterThan(bound.getMinY(), y) || DBMath.isLessThan(bound.getMaxY(), y)) continue;
                return true;
            }
            return false;
        }
    }

    public class RouteArc
    implements Serializable {
        private ArcProto type;
        private double wid;
        private RouteNode from;
        private RouteNode to;
        private String netName;

        public RouteArc(ArcProto type, String netName, SeaOfGatesEngine soge, Layer layer, double wid, RouteNode from2, RouteNode to2, NeededRoute nr) {
            this.type = type;
            this.netName = netName;
            this.wid = wid;
            this.from = from2;
            this.to = to2;
            EPoint fromLoc = from2.loc;
            EPoint toLoc = to2.loc;
            SeaOfGatesEngine.this.totalWireLength += fromLoc.distance(toLoc);
            Poly poly = null;
            if (fromLoc.getX() == toLoc.getX()) {
                poly = new Poly(fromLoc.getX(), (fromLoc.getY() + toLoc.getY()) / 2.0, wid, Math.abs(fromLoc.getY() - toLoc.getY()) + wid);
            } else if (fromLoc.getY() == toLoc.getY()) {
                poly = new Poly((fromLoc.getX() + toLoc.getX()) / 2.0, fromLoc.getY(), Math.abs(fromLoc.getX() - toLoc.getX()) + wid, wid);
            } else if (from2.rect.getMaxX() >= to2.rect.getMinX() && from2.rect.getMinX() <= to2.rect.getMaxX()) {
                double x2 = (Math.max(from2.rect.getMinX(), to2.rect.getMinX()) + Math.min(from2.rect.getMaxX(), to2.rect.getMaxX())) / 2.0;
                if (fromLoc.getX() != x2) {
                    from2.loc = EPoint.fromLambda(x2, from2.loc.getY());
                }
                if (toLoc.getX() != x2) {
                    to2.loc = EPoint.fromLambda(x2, to2.loc.getY());
                }
                poly = new Poly(x2, (fromLoc.getY() + toLoc.getY()) / 2.0, wid, Math.abs(fromLoc.getY() - toLoc.getY()) + wid);
            } else if (from2.rect.getMaxY() >= to2.rect.getMinY() && from2.rect.getMinY() <= to2.rect.getMaxY()) {
                double y = (Math.max(from2.rect.getMinY(), to2.rect.getMinY()) + Math.min(from2.rect.getMaxY(), to2.rect.getMaxY())) / 2.0;
                if (fromLoc.getY() != y) {
                    from2.loc = EPoint.fromLambda(from2.loc.getX(), y);
                }
                if (toLoc.getY() != y) {
                    to2.loc = EPoint.fromLambda(to2.loc.getX(), y);
                }
                poly = new Poly((fromLoc.getX() + toLoc.getX()) / 2.0, y, Math.abs(fromLoc.getX() - toLoc.getX()) + wid, wid);
            } else {
                String layerName = "";
                if (layer != null) {
                    layerName = " " + layer.getName();
                }
                System.out.println("WARNING: angled" + layerName + " wire from (" + fromLoc.getX() + "," + fromLoc.getY() + ") to (" + toLoc.getX() + "," + toLoc.getY() + ")");
            }
            if (poly != null && layer != null) {
                poly.setLayer(layer);
                poly.setStyle(Poly.Type.FILLED);
                soge.addLayer(poly, GenMath.MATID, nr.getNetID(), true, null, false);
            }
        }

        ArcProtoId getProtoId() {
            return this.type.getId();
        }

        RouteNode getTail() {
            return this.to;
        }

        RouteNode getHead() {
            return this.from;
        }

        String getName() {
            return this.netName;
        }

        long getGridExtendOverMin() {
            return DBMath.lambdaToGrid(0.5 * this.wid) - this.type.getBaseExtend().getGrid();
        }

        int getFlags(EditingPreferences ep) {
            return this.type.getDefaultInst((EditingPreferences)ep).flags;
        }
    }

    public static class RouteNode
    implements Serializable {
        private boolean exists;
        private NodeProto np;
        private EPoint loc;
        private FixpRectangle rect;
        private double wid;
        private double hei;
        private Orientation orient;
        private int terminalNodeID;
        private PortProtoId terminalNodePort;
        private PortInst tapConnection;
        private NeededRoute nr;

        public RouteNode(NodeProto np, SeaOfGatesEngine soge, EPoint loc, double wid, double hei, Orientation orient, PortInst tapConnection, NeededRoute nr) {
            this.exists = false;
            this.np = np;
            this.loc = loc;
            long x2 = FixpCoord.lambdaToFixp(loc.getX());
            long y = FixpCoord.lambdaToFixp(loc.getY());
            this.rect = FixpRectangle.fromFixpDiagonal(x2, y, x2, y);
            this.wid = wid;
            this.hei = hei;
            this.orient = orient;
            this.tapConnection = tapConnection;
            this.nr = nr;
            NodeInst ni = NodeInst.makeDummyInstance(np, soge.ep, loc, wid, hei, orient);
            FixpTransform trans = ni.rotateOut();
            Poly[] nodeInstPolyList = np.getTechnology().getShapeOfNode(ni, true, false, null);
            for (int i = 0; i < nodeInstPolyList.length; ++i) {
                Poly poly = nodeInstPolyList[i];
                if (poly.getPort() == null) continue;
                ((PolyBase)poly).transform(trans);
                poly.setStyle(Poly.Type.FILLED);
                soge.addLayer(poly, GenMath.MATID, nr.getNetID(), true, null, false);
            }
        }

        public RouteNode(PortInst pi) {
            this.exists = true;
            this.terminalNodeID = pi.getNodeInst().getNodeId();
            this.terminalNodePort = pi.getPortProto().getId();
            this.loc = pi.getCenter();
            this.rect = pi.getPoly().getBounds2D();
        }

        boolean exists() {
            return this.exists;
        }

        NodeProtoId getProtoId() {
            return this.np.getId();
        }

        PortInst getTapConnection() {
            return this.tapConnection;
        }

        void setTapConnection(ImmutableNodeInst ini) {
            if (this.tapConnection != null) {
                this.nr.spineTapNIMap.put(this.tapConnection, ini);
            }
        }

        Name getBaseName() {
            assert (!this.exists);
            PrimitiveNode pn = (PrimitiveNode)this.np;
            return pn.getPrimitiveFunction(this.getTechBits()).getBasename();
        }

        Orientation getOrient() {
            return this.orient;
        }

        EPoint getLoc() {
            return this.loc;
        }

        EPoint getSize() {
            if (this.np instanceof Cell) {
                return EPoint.ORIGIN;
            }
            PrimitiveNode pn = (PrimitiveNode)this.np;
            ERectangle fullRectangle = pn.getFullRectangle();
            long sizeX = DBMath.lambdaToSizeGrid(this.wid) - fullRectangle.getGridWidth();
            long sizeY = DBMath.lambdaToSizeGrid(this.hei) - fullRectangle.getGridHeight();
            return EPoint.fromGrid(sizeX, sizeY);
        }

        int getTechBits() {
            return 0;
        }

        int getNodeId() {
            assert (this.exists);
            return this.terminalNodeID;
        }

        PortProtoId getPortProtoId() {
            if (this.exists) {
                return this.terminalNodePort;
            }
            PrimitiveNode pn = (PrimitiveNode)this.np;
            assert (pn.getNumPorts() == 1);
            return pn.getPort(0).getId();
        }
    }

    public static class RouteAddUnrouted
    implements Serializable {
        private int nodeIDA;
        private int nodeIDB;
        private PortProtoId portIdA;
        private PortProtoId portIdB;
        private EPoint locA;
        private EPoint locB;

        public RouteAddUnrouted(PortInst piA, PortInst piB) {
            this.nodeIDA = piA.getNodeInst().getNodeId();
            this.portIdA = piA.getPortProto().getId();
            this.locA = piA.getCenter();
            this.nodeIDB = piB.getNodeInst().getNodeId();
            this.portIdB = piB.getPortProto().getId();
            this.locB = piB.getCenter();
        }

        int getTailId() {
            return this.nodeIDA;
        }

        PortProtoId getTailPortProtoId() {
            return this.portIdA;
        }

        EPoint getTailLocation() {
            return this.locA;
        }

        int getHeadId() {
            return this.nodeIDB;
        }

        PortProtoId getHeadPortProtoId() {
            return this.portIdB;
        }

        EPoint getHeadLocation() {
            return this.locB;
        }
    }

    public static class RouteResolution
    implements Serializable {
        final CellId cellId;
        final List<RouteNode> nodesToRoute = new ArrayList<RouteNode>();
        final List<RouteArc> arcsToRoute = new ArrayList<RouteArc>();
        final List<Integer> nodesIDsToKill = new ArrayList<Integer>();
        final List<Integer> arcsIDsToKill = new ArrayList<Integer>();
        final List<RouteAddUnrouted> unroutedToAdd = new ArrayList<RouteAddUnrouted>();

        public RouteResolution(CellId cellId) {
            this.cellId = cellId;
        }

        public void addNode(RouteNode rn) {
            this.nodesToRoute.add(rn);
        }

        public void addArc(RouteArc ra) {
            this.arcsToRoute.add(ra);
        }

        public void killNode(NodeInst ni) {
            this.nodesIDsToKill.add(ni.getNodeId());
        }

        public void killArc(ArcInst ai) {
            this.arcsIDsToKill.add(ai.getArcId());
        }

        public void addUnrouted(PortInst piA, PortInst piB) {
            this.unroutedToAdd.add(new RouteAddUnrouted(piA, piB));
        }

        public void clearRoutes() {
            this.nodesToRoute.clear();
            this.arcsToRoute.clear();
            this.nodesIDsToKill.clear();
            this.arcsIDsToKill.clear();
            this.unroutedToAdd.clear();
        }
    }

    public class NeededRoute {
        private String routeName;
        private RouteBatch batch;
        private int routeInBatch;
        private final Rectangle2D routeBounds;
        private MutableInteger netID;
        private final double minWidth;
        private final Rectangle2D jumpBound;
        private int complexityLimit;
        private double aX;
        private double aY;
        private double bX;
        private double bY;
        private FixpRectangle aRect;
        private FixpRectangle bRect;
        private FixpRectangle aRectGridded;
        private FixpRectangle bRectGridded;
        private final int aZ;
        private final int bZ;
        private final PortInst aPi;
        private final PortInst bPi;
        private final List<PortInst> spineTaps;
        private final Map<SearchVertex, PortInst> spineTapMap;
        private final Map<PortInst, ImmutableNodeInst> spineTapNIMap;
        private final Poly aPoly;
        private final Poly bPoly;
        private Rectangle2D[] buckets;
        private Map<Layer, List<SOGBound>> endBlockages;
        private volatile boolean routedSuccess;
        private String errorMessage;
        private boolean reroute;
        private double[][] gridLocationsX;
        private double[][] gridLocationsY;
        private Map<SOGBound, Integer> extractList;
        private boolean[] overridePreventArcs;
        private double[] overrideMetalWidth;
        private double[] overrideMetalSpacingX;
        private double[] overrideMetalSpacingY;

        public NeededRoute(String routeName, PortInst aPi, PortInst bPi, ArcProto aArc, ArcProto bArc, List<PortInst> spineTaps, double minWidth) {
            double maxStrayFromRouteBoundsX;
            this.routeName = routeName;
            this.minWidth = minWidth;
            this.spineTaps = spineTaps;
            this.complexityLimit = ((SeaOfGatesEngine)SeaOfGatesEngine.this).prefs.complexityLimit;
            if (spineTaps == null) {
                this.spineTapMap = null;
                this.spineTapNIMap = null;
            } else {
                this.spineTapMap = new HashMap<SearchVertex, PortInst>();
                this.spineTapNIMap = new HashMap<PortInst, ImmutableNodeInst>();
            }
            this.overrideMetalWidth = null;
            this.overrideMetalSpacingY = null;
            this.overrideMetalSpacingX = null;
            for (int z = 0; z < numMetalLayers; ++z) {
                Double overrideWidth = SeaOfGatesEngine.this.sogp.getDefaultWidthOverride(SeaOfGatesEngine.this.metalArcs[z]);
                SeaOfGates.SeaOfGatesArcProperties sogap = SeaOfGatesEngine.this.sogp.getOverridesForArcsOnNet(routeName, SeaOfGatesEngine.this.metalArcs[z]);
                if (sogap != null && sogap.getWidthOverride() != null) {
                    overrideWidth = sogap.getWidthOverride();
                }
                if (overrideWidth != null) {
                    if (this.overrideMetalWidth == null) {
                        this.overrideMetalWidth = new double[numMetalLayers];
                        for (int i = 0; i < numMetalLayers; ++i) {
                            this.overrideMetalWidth[i] = Math.max(SeaOfGatesEngine.this.metalArcs[i].getDefaultLambdaBaseWidth(SeaOfGatesEngine.this.ep), minWidth);
                        }
                    }
                    this.overrideMetalWidth[z] = overrideWidth;
                }
                Double overrideSpacing = SeaOfGatesEngine.this.sogp.getDefaultSpacingOverride(SeaOfGatesEngine.this.metalArcs[z]);
                if (sogap != null && sogap.getSpacingOverride() != null) {
                    overrideSpacing = sogap.getSpacingOverride();
                }
                if (overrideSpacing == null) continue;
                if (this.overrideMetalSpacingX == null) {
                    this.overrideMetalSpacingX = new double[numMetalLayers];
                    this.overrideMetalSpacingY = new double[numMetalLayers];
                    for (int i = 0; i < numMetalLayers; ++i) {
                        this.overrideMetalSpacingY[i] = 0.0;
                        this.overrideMetalSpacingX[i] = 0.0;
                        DRCTemplate rule = DRC.getSpacingRule(SeaOfGatesEngine.this.metalLayers[i], null, SeaOfGatesEngine.this.metalLayers[i], null, false, -1, SeaOfGatesEngine.this.metalArcs[i].getDefaultLambdaBaseWidth(SeaOfGatesEngine.this.ep), 50.0);
                        if (rule == null) continue;
                        this.overrideMetalSpacingX[i] = rule.getValue(0);
                        this.overrideMetalSpacingY[i] = rule.getNumValues() <= 1 ? this.overrideMetalSpacingX[i] : rule.getValue(1);
                    }
                }
                this.overrideMetalSpacingX[z] = this.overrideMetalSpacingY[z] = overrideSpacing.doubleValue();
            }
            this.aPi = aPi;
            this.bPi = bPi;
            this.aPoly = aPi.getPoly();
            this.bPoly = bPi.getPoly();
            this.aRect = this.aPoly.getBounds2D();
            this.bRect = this.bPoly.getBounds2D();
            if (this.bRect.getMaxX() < this.aRect.getMinX()) {
                this.bX = this.upToGrain(this.bRect.getCenterX());
                this.aX = this.downToGrain(this.aRect.getCenterX());
            } else if (this.bRect.getMinX() > this.aRect.getMaxX()) {
                this.bX = this.downToGrain(this.bRect.getCenterX());
                this.aX = this.upToGrain(this.aRect.getCenterX());
            } else {
                double xVal = (Math.max(this.bRect.getMinX(), this.aRect.getMinX()) + Math.min(this.bRect.getMaxX(), this.aRect.getMaxX())) / 2.0;
                this.bX = this.aX = this.upToGrain(xVal);
            }
            if (this.bRect.getMaxY() < this.aRect.getMinY()) {
                this.bY = this.upToGrain(this.bRect.getCenterY());
                this.aY = this.downToGrain(this.aRect.getCenterY());
            } else if (this.bRect.getMinY() > this.aRect.getMaxY()) {
                this.bY = this.downToGrain(this.bRect.getCenterY());
                this.aY = this.upToGrain(this.aRect.getCenterY());
            } else {
                double yVal = (Math.max(this.bRect.getMinY(), this.aRect.getMinY()) + Math.min(this.bRect.getMaxY(), this.aRect.getMaxY())) / 2.0;
                this.bY = this.aY = this.upToGrain(yVal);
            }
            this.aZ = aArc.getFunction().getLevel() - 1;
            this.bZ = bArc.getFunction().getLevel() - 1;
            double lowX = Math.min(this.aRect.getMinX(), this.bRect.getMinX());
            double highX = Math.max(this.aRect.getMaxX(), this.bRect.getMaxX());
            double lowY = Math.min(this.aRect.getMinY(), this.bRect.getMinY());
            double highY = Math.max(this.aRect.getMaxY(), this.bRect.getMaxY());
            double gap = DRC.getWorstSpacingDistance(SeaOfGatesEngine.this.tech, -1) * 100.0;
            Rectangle2D.Double testBounds = new Rectangle2D.Double(lowX - gap, lowY - gap, highX - lowX + gap * 2.0, highY - lowY + gap * 2.0);
            this.buildGrids(testBounds);
            double aLX = this.getLowerXGrid(this.aZ, this.aRect.getMinX());
            double aHX = this.getUpperXGrid(this.aZ, this.aRect.getMaxX());
            double aLY = this.getLowerYGrid(this.aZ, this.aRect.getMinY());
            double aHY = this.getUpperYGrid(this.aZ, this.aRect.getMaxY());
            this.aRectGridded = FixpRectangle.from(new Rectangle2D.Double(aLX, aLY, aHX - aLX, aHY - aLY));
            double bLX = this.getLowerXGrid(this.bZ, this.bRect.getMinX());
            double bHX = this.getUpperXGrid(this.bZ, this.bRect.getMaxX());
            double bLY = this.getLowerYGrid(this.bZ, this.bRect.getMinY());
            double bHY = this.getUpperYGrid(this.bZ, this.bRect.getMaxY());
            this.bRectGridded = FixpRectangle.from(new Rectangle2D.Double(bLX, bLY, bHX - bLX, bHY - bLY));
            double maxStrayFromRouteBoundsY = maxStrayFromRouteBoundsX = DRC.getWorstSpacingDistance(SeaOfGatesEngine.this.tech, -1) * 2.0;
            double griddedLowX = Math.min(this.getLowerXGrid(this.aZ, lowX - maxStrayFromRouteBoundsX), this.getLowerXGrid(this.bZ, lowX - maxStrayFromRouteBoundsX));
            double griddedHighX = Math.max(this.getUpperXGrid(this.aZ, highX + maxStrayFromRouteBoundsX), this.getUpperXGrid(this.bZ, highX + maxStrayFromRouteBoundsX));
            double griddedLowY = Math.min(this.getLowerYGrid(this.aZ, lowY - maxStrayFromRouteBoundsY), this.getLowerYGrid(this.bZ, lowY - maxStrayFromRouteBoundsY));
            double griddedHighY = Math.max(this.getUpperYGrid(this.aZ, highY + maxStrayFromRouteBoundsY), this.getUpperYGrid(this.bZ, highY + maxStrayFromRouteBoundsY));
            this.routeBounds = new Rectangle2D.Double(griddedLowX, griddedLowY, griddedHighX - griddedLowX, griddedHighY - griddedLowY);
            this.jumpBound = new Rectangle2D.Double(Math.min(this.aX, this.bX), Math.min(this.aY, this.bY), Math.abs(this.aX - this.bX), Math.abs(this.aY - this.bY));
            this.overridePreventArcs = null;
            List<ArcProto> arcs = SeaOfGatesEngine.this.sogp.getArcsOnNet(routeName);
            if (arcs != null && arcs.size() > 0) {
                this.overridePreventArcs = new boolean[numMetalLayers];
                for (int i = 0; i < numMetalLayers; ++i) {
                    this.overridePreventArcs[i] = true;
                }
                for (ArcProto ap : arcs) {
                    int metNum = ap.getFunction().getLevel() - 1;
                    this.overridePreventArcs[metNum] = false;
                }
            }
        }

        public double[][] getXRoutingGrid() {
            return this.gridLocationsX;
        }

        public double[][] getYRoutingGrid() {
            return this.gridLocationsY;
        }

        public void buildGrids(Rectangle2D bounds) {
            int metIndex;
            int metNum;
            this.gridLocationsX = new double[numMetalLayers][];
            this.gridLocationsY = new double[numMetalLayers][];
            for (metNum = 1; metNum <= numMetalLayers; ++metNum) {
                double high;
                double low;
                double offset;
                double range2;
                metIndex = metNum - 1;
                double[] thisGrid = SeaOfGatesEngine.this.metalGrid[metIndex];
                if (thisGrid == null || !SeaOfGatesEngine.this.sogp.isForceHorVer() && !SeaOfGatesEngine.this.sogp.isFavorHorVer()) continue;
                boolean hor = true;
                if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                    if (metNum % 2 != 0) {
                        hor = false;
                    }
                } else if (metNum % 2 == 0) {
                    hor = false;
                }
                if (!((range2 = thisGrid[thisGrid.length - 1] - (offset = thisGrid[0])) > 0.0)) continue;
                ArrayList<Double> values2 = new ArrayList<Double>();
                if (hor) {
                    low = bounds.getMinY();
                    high = bounds.getMaxY();
                } else {
                    low = bounds.getMinX();
                    high = bounds.getMaxX();
                }
                double lowGroup = Math.floor((low - offset) / range2) * range2;
                double highGroup = Math.ceil((high - offset) / range2) * range2;
                for (double v = lowGroup; v <= highGroup; v += range2) {
                    for (int i = 0; i < thisGrid.length; ++i) {
                        double val = v + thisGrid[i];
                        if (!(val >= low) || !(val <= high)) continue;
                        values2.add(new Double(val));
                    }
                }
                if (values2.size() < 2) continue;
                if (hor) {
                    this.gridLocationsY[metIndex] = new double[values2.size()];
                    for (int i = 0; i < values2.size(); ++i) {
                        this.gridLocationsY[metIndex][i] = (Double)values2.get(i);
                    }
                    continue;
                }
                this.gridLocationsX[metIndex] = new double[values2.size()];
                for (int i = 0; i < values2.size(); ++i) {
                    this.gridLocationsX[metIndex][i] = (Double)values2.get(i);
                }
            }
            for (metNum = 1; metNum <= numMetalLayers; ++metNum) {
                int i;
                metIndex = metNum - 1;
                boolean hor = true;
                if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                    if (metNum % 2 != 0) {
                        hor = false;
                    }
                } else if (metNum % 2 == 0) {
                    hor = false;
                }
                TreeSet<Double> values3 = new TreeSet<Double>();
                if (hor) {
                    if (metIndex > 0 && this.gridLocationsX[metIndex - 1] != null) {
                        for (i = 0; i < this.gridLocationsX[metIndex - 1].length; ++i) {
                            values3.add(new Double(this.gridLocationsX[metIndex - 1][i]));
                        }
                    }
                    if (metIndex < numMetalLayers - 1 && this.gridLocationsX[metIndex + 1] != null) {
                        for (i = 0; i < this.gridLocationsX[metIndex + 1].length; ++i) {
                            values3.add(new Double(this.gridLocationsX[metIndex + 1][i]));
                        }
                    }
                    if (values3.size() < 2) continue;
                    this.gridLocationsX[metIndex] = new double[values3.size()];
                    i = 0;
                    for (Double v : values3) {
                        this.gridLocationsX[metIndex][i++] = v;
                    }
                    continue;
                }
                if (metIndex > 0 && this.gridLocationsY[metIndex - 1] != null) {
                    for (i = 0; i < this.gridLocationsY[metIndex - 1].length; ++i) {
                        values3.add(new Double(this.gridLocationsY[metIndex - 1][i]));
                    }
                }
                if (metIndex < numMetalLayers - 1 && this.gridLocationsY[metIndex + 1] != null) {
                    for (i = 0; i < this.gridLocationsY[metIndex + 1].length; ++i) {
                        values3.add(new Double(this.gridLocationsY[metIndex + 1][i]));
                    }
                }
                if (values3.size() < 2) continue;
                this.gridLocationsY[metIndex] = new double[values3.size()];
                i = 0;
                for (Double v : values3) {
                    this.gridLocationsY[metIndex][i++] = v;
                }
            }
        }

        public double getLowerXGrid(int metNum, double value2) {
            return this.findLowerValue(this.gridLocationsX[metNum], value2);
        }

        public double getUpperXGrid(int metNum, double value2) {
            return this.findUpperValue(this.gridLocationsX[metNum], value2);
        }

        public double getClosestXGrid(int metNum, double value2) {
            return this.findClosestValue(this.gridLocationsX[metNum], value2);
        }

        public double getLowerYGrid(int metNum, double value2) {
            return this.findLowerValue(this.gridLocationsY[metNum], value2);
        }

        public double getUpperYGrid(int metNum, double value2) {
            return this.findUpperValue(this.gridLocationsY[metNum], value2);
        }

        public double getClosestYGrid(int metNum, double value2) {
            return this.findClosestValue(this.gridLocationsY[metNum], value2);
        }

        public boolean isOnXGrid(int metNum, double value2) {
            return this.isOnGrid(this.gridLocationsX[metNum], value2);
        }

        public boolean isOnYGrid(int metNum, double value2) {
            return this.isOnGrid(this.gridLocationsY[metNum], value2);
        }

        private double findLowerValue(double[] thisGrid, double value2) {
            if (thisGrid == null) {
                return value2;
            }
            int lo = 0;
            int hi = thisGrid.length - 1;
            if (value2 <= thisGrid[lo]) {
                return value2;
            }
            if (value2 >= thisGrid[hi]) {
                return value2;
            }
            for (int i = 0; i < 1000; ++i) {
                int med = (hi + lo) / 2;
                if (value2 >= thisGrid[med] && value2 < thisGrid[med + 1]) {
                    return thisGrid[med];
                }
                if (value2 < thisGrid[med]) {
                    hi = med;
                    continue;
                }
                lo = med;
            }
            return value2;
        }

        private double findUpperValue(double[] thisGrid, double value2) {
            if (thisGrid == null) {
                return value2;
            }
            int lo = 0;
            int hi = thisGrid.length - 1;
            if (value2 <= thisGrid[lo]) {
                return value2;
            }
            if (value2 >= thisGrid[hi]) {
                return value2;
            }
            for (int i = 0; i < 1000; ++i) {
                int med = (hi + lo) / 2;
                if (value2 > thisGrid[med] && value2 <= thisGrid[med + 1]) {
                    return thisGrid[med + 1];
                }
                if (value2 <= thisGrid[med]) {
                    hi = med;
                    continue;
                }
                lo = med;
            }
            return value2;
        }

        private double findClosestValue(double[] thisGrid, double value2) {
            if (thisGrid == null) {
                return value2;
            }
            int lo = 0;
            int hi = thisGrid.length - 1;
            if (value2 <= thisGrid[lo]) {
                return value2;
            }
            if (value2 >= thisGrid[hi]) {
                return value2;
            }
            for (int i = 0; i < 1000; ++i) {
                int med = (hi + lo) / 2;
                if (value2 >= thisGrid[med] && value2 <= thisGrid[med + 1]) {
                    if (value2 - thisGrid[med] < thisGrid[med + 1] - value2) {
                        return thisGrid[med];
                    }
                    return thisGrid[med + 1];
                }
                if (value2 <= thisGrid[med]) {
                    hi = med;
                    continue;
                }
                lo = med;
            }
            return value2;
        }

        private boolean isOnGrid(double[] thisGrid, double value2) {
            if (thisGrid != null) {
                int lo = 0;
                int hi = thisGrid.length - 1;
                if (value2 < thisGrid[lo]) {
                    return false;
                }
                if (value2 > thisGrid[hi]) {
                    return false;
                }
                for (int i = 0; i < 1000; ++i) {
                    int med = (hi + lo) / 2;
                    if (value2 >= thisGrid[med] && value2 <= thisGrid[med + 1]) {
                        return value2 == thisGrid[med] || thisGrid[med + 1] == value2;
                    }
                    if (value2 <= thisGrid[med]) {
                        hi = med;
                        continue;
                    }
                    lo = med;
                }
                return false;
            }
            return true;
        }

        private double upToGrain(double v) {
            return v;
        }

        private double upToGrainAlways(double v) {
            return Math.ceil(v);
        }

        private double downToGrain(double v) {
            return v;
        }

        private double downToGrainAlways(double v) {
            return Math.floor(v);
        }

        public Wavefront[] makeWavefronts() {
            Wavefront dirAtoB = new Wavefront(this, this.aPi, this.aRect, this.aX, this.aY, this.aZ, 2, this.bPi, this.bRect, this.bRectGridded, this.bX, this.bY, this.bZ, 4, 1, "a->b");
            Wavefront dirBtoA = new Wavefront(this, this.bPi, this.bRect, this.bX, this.bY, this.bZ, 4, this.aPi, this.aRect, this.aRectGridded, this.aX, this.aY, this.aZ, 2, -1, "b->a");
            return new Wavefront[]{dirAtoB, dirBtoA};
        }

        public void setBatchInfo(RouteBatch batch, int routeInBatch) {
            this.batch = batch;
            this.routeInBatch = routeInBatch;
        }

        public int getNumInBatch() {
            return this.batch.routesInBatch.size();
        }

        public int getRouteInBatch() {
            return this.routeInBatch;
        }

        public MutableInteger getNetID() {
            return this.netID;
        }

        public void setNetID(MutableInteger id) {
            this.netID = id;
        }

        private void setNetID(Network net) {
            Integer netIDI = (Integer)SeaOfGatesEngine.this.netIDs.get(net);
            assert (netIDI != null);
            this.netID = new MutableInteger(netIDI);
            List<MutableInteger> theseNetIDs = SeaOfGatesEngine.this.netIDsByValue.get(netIDI);
            if (theseNetIDs == null) {
                theseNetIDs = new ArrayList<MutableInteger>();
                SeaOfGatesEngine.this.netIDsByValue.put(netIDI, theseNetIDs);
            }
            theseNetIDs.add(this.netID);
        }

        public double getArcWidth(int metNum) {
            if (this.overrideMetalWidth != null) {
                return this.overrideMetalWidth[metNum];
            }
            double width = Math.max(SeaOfGatesEngine.this.metalArcs[metNum].getDefaultLambdaBaseWidth(SeaOfGatesEngine.this.ep), this.minWidth);
            return width;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double[] getSpacingRule(int layer, double width, double length) {
            Double len;
            double[] value2;
            if (this.overrideMetalSpacingX != null) {
                return new double[]{this.overrideMetalSpacingX[layer], this.overrideMetalSpacingY[layer]};
            }
            if (width < 0.0) {
                width = SeaOfGatesEngine.this.metalArcs[layer].getDefaultLambdaBaseWidth(SeaOfGatesEngine.this.ep);
            }
            if (length < 0.0) {
                length = 50.0;
            }
            Double wid = width;
            HashMap<Double, double[]> widMap = (HashMap<Double, double[]>)SeaOfGatesEngine.this.layerSurround[layer].get(wid);
            if (widMap == null) {
                Map[] mapArray = SeaOfGatesEngine.this.layerSurround;
                synchronized (mapArray) {
                    widMap = (Map)SeaOfGatesEngine.this.layerSurround[layer].get(wid);
                    if (widMap == null) {
                        widMap = new HashMap<Double, double[]>();
                        SeaOfGatesEngine.this.layerSurround[layer].put(wid, widMap);
                    }
                }
            }
            if ((value2 = (double[])widMap.get(len = Double.valueOf(length))) == null) {
                Layer lay = SeaOfGatesEngine.this.metalLayers[layer];
                DRCTemplate rule = DRC.getSpacingRule(lay, null, lay, null, false, -1, width, length);
                double x2 = 0.0;
                double y = 0.0;
                if (rule != null) {
                    x2 = rule.getValue(0);
                    y = rule.getNumValues() <= 1 ? x2 : rule.getValue(1);
                }
                value2 = new double[]{x2, y};
                widMap.put(len, value2);
            }
            return value2;
        }

        public boolean preventArc(int metNum) {
            if (this.overridePreventArcs != null) {
                return this.overridePreventArcs[metNum];
            }
            return SeaOfGatesEngine.this.preventArcs[metNum];
        }

        public String getName() {
            return this.routeName;
        }

        public Rectangle2D getBounds() {
            return this.routeBounds;
        }

        public PortInst getAPort() {
            return this.aPi;
        }

        public PortInst getBPort() {
            return this.bPi;
        }

        public double getAX() {
            return this.aX;
        }

        public double getAY() {
            return this.aY;
        }

        public double getBX() {
            return this.bX;
        }

        public double getBY() {
            return this.bY;
        }

        public RTNode<SOGBound> getViaTree(Layer lay) {
            return SeaOfGatesEngine.this.rTrees.getViaTree(lay).getRoot();
        }

        public Iterator<SOGBound> searchViaTree(Layer lay, Rectangle2D bound) {
            return SeaOfGatesEngine.this.rTrees.getViaTree(lay).search(bound);
        }

        public Rectangle2D[] getGRBuckets() {
            return this.buckets;
        }

        public boolean checkEndSurround() {
            double[] toSurround;
            double toMetalSpacing;
            double[] fromSurround;
            double fromMetalSpacing = this.getArcWidth(this.aZ) / 2.0;
            SOGBound block = this.getMetalBlockage(this.netID, this.aZ, fromMetalSpacing, fromMetalSpacing, fromSurround = this.getSpacingRule(this.aZ, SeaOfGatesEngine.this.metalArcs[this.aZ].getDefaultLambdaBaseWidth(SeaOfGatesEngine.this.ep), -1.0), this.aX, this.aY);
            if (block != null && (block = this.getMetalBlockage(this.netID, this.aZ, fromMetalSpacing, fromMetalSpacing, fromSurround, this.aX, this.aY)) != null) {
                FixpRectangle fromRect = this.aPoly.getBounds2D();
                double stepSize = fromMetalSpacing + Math.max(fromSurround[0], fromSurround[1]);
                if (stepSize > 0.0 && (((RectangularShape)fromRect).getWidth() > 0.0 || ((RectangularShape)fromRect).getHeight() > 0.0)) {
                    for (double x2 = ((RectangularShape)fromRect).getMinX(); x2 <= ((RectangularShape)fromRect).getMaxX(); x2 += stepSize) {
                        for (double y = ((RectangularShape)fromRect).getMinY(); y <= ((RectangularShape)fromRect).getMaxY(); y += stepSize) {
                            SOGBound stepBlock = this.getMetalBlockage(this.netID, this.aZ, fromMetalSpacing, fromMetalSpacing, fromSurround, x2, y);
                            if (stepBlock != null) continue;
                            this.aX = x2;
                            this.aY = y;
                            block = null;
                            break;
                        }
                        if (block == null) break;
                    }
                }
                if (block != null) {
                    String errorMsg = "Cannot route from port " + this.aPi.getPortProto().getName() + " of node " + SeaOfGatesEngine.this.describe(this.aPi.getNodeInst()) + " at (" + SeaOfGatesEngine.this.formatDistance(this.aX) + "," + SeaOfGatesEngine.this.formatDistance(this.aY) + ") because it is blocked on layer " + SeaOfGatesEngine.this.metalLayers[this.aZ].getName() + " [needs " + SeaOfGatesEngine.this.formatDistance(fromMetalSpacing + Math.max(fromSurround[0], fromSurround[1])) + " all around, blockage is " + SeaOfGatesEngine.this.formatDistance(block.getBounds().getMinX()) + "<=X<=" + SeaOfGatesEngine.this.formatDistance(block.getBounds().getMaxX()) + " and " + SeaOfGatesEngine.this.formatDistance(block.getBounds().getMinY()) + "<=Y<=" + SeaOfGatesEngine.this.formatDistance(block.getBounds().getMaxY()) + "]";
                    if (this.reroute) {
                        errorMsg = "(Retry) " + errorMsg;
                    }
                    SeaOfGatesEngine.this.error(errorMsg);
                    ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
                    polyList.add(new PolyBase(this.aX, this.aY, (fromMetalSpacing + fromSurround[0]) * 2.0, (fromMetalSpacing + fromSurround[1]) * 2.0));
                    polyList.add(new PolyBase(block.getBounds()));
                    ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                    lineList.add(EPoint.fromLambda(block.getBounds().getMinX(), block.getBounds().getMinY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMaxX(), block.getBounds().getMaxY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMinX(), block.getBounds().getMaxY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMaxX(), block.getBounds().getMinY()));
                    SeaOfGatesEngine.this.errorLogger.logMessageWithLines(errorMsg, polyList, lineList, SeaOfGatesEngine.this.cell, 0, true);
                    return true;
                }
            }
            if ((block = this.getMetalBlockage(this.netID, this.bZ, toMetalSpacing = this.getArcWidth(this.bZ) / 2.0, toMetalSpacing, toSurround = this.getSpacingRule(this.bZ, SeaOfGatesEngine.this.metalArcs[this.bZ].getDefaultLambdaBaseWidth(SeaOfGatesEngine.this.ep), -1.0), this.bX, this.bY)) != null && (block = this.getMetalBlockage(this.netID, this.bZ, toMetalSpacing, toMetalSpacing, toSurround, this.bX, this.bY)) != null) {
                FixpRectangle toRect = this.bPoly.getBounds2D();
                double stepSize = toMetalSpacing + Math.max(toSurround[0], toSurround[1]);
                if (stepSize > 0.0 && (((RectangularShape)toRect).getWidth() > 0.0 || ((RectangularShape)toRect).getHeight() > 0.0)) {
                    for (double x3 = ((RectangularShape)toRect).getMinX(); x3 <= ((RectangularShape)toRect).getMaxX(); x3 += stepSize) {
                        for (double y = ((RectangularShape)toRect).getMinY(); y <= ((RectangularShape)toRect).getMaxY(); y += stepSize) {
                            SOGBound stepBlock = this.getMetalBlockage(this.netID, this.bZ, toMetalSpacing, toMetalSpacing, toSurround, x3, y);
                            if (stepBlock != null) continue;
                            this.bX = x3;
                            this.bY = y;
                            block = null;
                            break;
                        }
                        if (block == null) break;
                    }
                }
                if (block != null) {
                    String errorMsg = "Cannot route to port " + this.bPi.getPortProto().getName() + " of node " + SeaOfGatesEngine.this.describe(this.bPi.getNodeInst()) + " at (" + SeaOfGatesEngine.this.formatDistance(this.bX) + "," + SeaOfGatesEngine.this.formatDistance(this.bY) + ") because it is blocked on layer " + SeaOfGatesEngine.this.metalLayers[this.bZ].getName() + " [needs " + SeaOfGatesEngine.this.formatDistance(toMetalSpacing + Math.max(toSurround[0], toSurround[1])) + " all around, blockage is " + SeaOfGatesEngine.this.formatDistance(block.getBounds().getMinX()) + "<=X<=" + SeaOfGatesEngine.this.formatDistance(block.getBounds().getMaxX()) + " and " + SeaOfGatesEngine.this.formatDistance(block.getBounds().getMinY()) + "<=Y<=" + SeaOfGatesEngine.this.formatDistance(block.getBounds().getMaxY()) + "]";
                    if (this.reroute) {
                        errorMsg = "(Retry) " + errorMsg;
                    }
                    SeaOfGatesEngine.this.error(errorMsg);
                    ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
                    polyList.add(new PolyBase(this.bX, this.bY, (toMetalSpacing + toSurround[0]) * 2.0, (toMetalSpacing + toSurround[1]) * 2.0));
                    polyList.add(new PolyBase(block.getBounds()));
                    ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                    lineList.add(EPoint.fromLambda(block.getBounds().getMinX(), block.getBounds().getMinY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMaxX(), block.getBounds().getMaxY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMinX(), block.getBounds().getMaxY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMaxX(), block.getBounds().getMinY()));
                    SeaOfGatesEngine.this.errorLogger.logMessageWithLines(errorMsg, polyList, lineList, SeaOfGatesEngine.this.cell, 0, true);
                    return true;
                }
            }
            return false;
        }

        private void growNetwork() {
            Iterator<SOGBound> it;
            this.extractList = new HashMap<SOGBound, Integer>();
            this.growPoint(this.aX, this.aY, this.aZ, this.netID);
            this.growPoint(this.bX, this.bY, this.bZ, this.netID);
            if (this.spineTaps != null) {
                for (PortInst pi : this.spineTaps) {
                    ArcProto ap = SeaOfGatesEngine.this.getMetalArcOnPort(pi);
                    if (ap == null) continue;
                    int z = ap.getFunction().getLevel() - 1;
                    EPoint pt = pi.getCenter();
                    this.growPoint(pt.getX(), pt.getY(), z, this.netID);
                }
            }
            while ((it = this.extractList.keySet().iterator()).hasNext()) {
                SOGBound sBound = it.next();
                Integer layerNumInt = this.extractList.get(sBound);
                this.extractList.remove(sBound);
                this.growArea(sBound.bound, layerNumInt, sBound.getNetID());
            }
            this.extractList = null;
        }

        private void growPoint(double x2, double y, int layerNum, MutableInteger idNumber) {
            Rectangle2D.Double search = new Rectangle2D.Double(x2, y, 0.0, 0.0);
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.metalLayers[layerNum]);
            if (bTree.isEmpty()) {
                return;
            }
            Iterator sea = bTree.search(search);
            while (sea.hasNext()) {
                SOGBound sBound = (SOGBound)sea.next();
                if (sBound.getNetID() == null) {
                    sBound.setNetID(idNumber);
                    if (this.extractList.get(sBound) != null) continue;
                    this.extractList.put(sBound, layerNum);
                    SeaOfGatesEngine.this.blockagesFound++;
                    if (SeaOfGatesEngine.this.blockagesFound % 100 != 0) continue;
                    SeaOfGatesEngine.this.setProgressValue(SeaOfGatesEngine.this.blockagesFound, SeaOfGatesEngine.this.totalBlockages);
                    continue;
                }
                sBound.updateNetID(idNumber, SeaOfGatesEngine.this.netIDsByValue);
            }
        }

        private void growArea(Rectangle2D bound, int layerNum, MutableInteger idNumber) {
            SOGVia sBound;
            Iterator sea;
            BlockageTree viaTree;
            BlockageTree metalTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.metalLayers[layerNum]);
            Iterator sea2 = metalTree.search(bound);
            while (sea2.hasNext()) {
                SOGBound sBound2 = (SOGBound)sea2.next();
                if (sBound2.getNetID() == null) {
                    sBound2.setNetID(idNumber);
                    if (this.extractList.get(sBound2) != null) continue;
                    this.extractList.put(sBound2, layerNum);
                    SeaOfGatesEngine.this.blockagesFound++;
                    if (SeaOfGatesEngine.this.blockagesFound % 100 != 0) continue;
                    SeaOfGatesEngine.this.setProgressValue(SeaOfGatesEngine.this.blockagesFound, SeaOfGatesEngine.this.totalBlockages);
                    continue;
                }
                sBound2.updateNetID(idNumber, SeaOfGatesEngine.this.netIDsByValue);
            }
            if (layerNum > 0 && !(viaTree = SeaOfGatesEngine.this.rTrees.getViaTree(SeaOfGatesEngine.this.viaLayers[layerNum - 1])).isEmpty()) {
                sea = viaTree.search(bound);
                while (sea.hasNext()) {
                    sBound = (SOGVia)sea.next();
                    if (sBound.getNetID() == null) {
                        sBound.setNetID(idNumber);
                        this.growPoint(sBound.loc.getX(), sBound.loc.getY(), layerNum - 1, idNumber);
                        continue;
                    }
                    sBound.updateNetID(idNumber, SeaOfGatesEngine.this.netIDsByValue);
                }
            }
            if (layerNum < numMetalLayers - 1) {
                BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getViaTree(SeaOfGatesEngine.this.viaLayers[layerNum]);
                sea = bTree.search(bound);
                while (sea.hasNext()) {
                    sBound = (SOGVia)sea.next();
                    if (sBound.getNetID() == null) {
                        sBound.setNetID(idNumber);
                        this.growPoint(sBound.loc.getX(), sBound.loc.getY(), layerNum + 1, idNumber);
                        continue;
                    }
                    sBound.updateNetID(idNumber, SeaOfGatesEngine.this.netIDsByValue);
                }
            }
        }

        private void addBlockagesAtPorts(PortInst pi) {
            MutableInteger netIDUse = new MutableInteger(this.netID.intValue() + 1);
            Poly poly = pi.getPoly();
            FixpRectangle portBounds = poly.getBounds2D();
            ArcProto[] poss = SeaOfGatesEngine.this.getPossibleConnections(pi.getPortProto());
            int lowMetal = -1;
            int highMetal = -1;
            for (int i = 0; i < poss.length; ++i) {
                if (poss[i].getTechnology() != SeaOfGatesEngine.this.tech || !poss[i].getFunction().isMetal()) continue;
                int level = poss[i].getFunction().getLevel();
                if (lowMetal < 0) {
                    lowMetal = highMetal = level;
                    continue;
                }
                lowMetal = Math.min(lowMetal, level);
                highMetal = Math.max(highMetal, level);
            }
            if (lowMetal < 0) {
                return;
            }
            HashMap<Layer, ArrayList<Rectangle2D.Double>> blockageRects = new HashMap<Layer, ArrayList<Rectangle2D.Double>>();
            for (int via = lowMetal - 2; via < highMetal; ++via) {
                if (via < 0 || via >= numMetalLayers - 1) continue;
                List<MetalVia> mvs = SeaOfGatesEngine.this.metalVias[via].getVias();
                int upper = mvs.size();
                for (int j = 0; j < upper; ++j) {
                    MetalVia mv = mvs.get(j);
                    PrimitiveNode np = mv.via;
                    SizeOffset so = np.getProtoSizeOffset();
                    double xOffset = so.getLowXOffset() + so.getHighXOffset();
                    double yOffset = so.getLowYOffset() + so.getHighYOffset();
                    double wid = Math.max(np.getDefWidth(SeaOfGatesEngine.this.ep) - xOffset, this.minWidth) + xOffset;
                    double hei = Math.max(np.getDefHeight(SeaOfGatesEngine.this.ep) - yOffset, this.minWidth) + yOffset;
                    NodeInst dummy = NodeInst.makeDummyInstance(np, SeaOfGatesEngine.this.ep, EPoint.ORIGIN, wid, hei, Orientation.IDENT);
                    Poly[] polys = SeaOfGatesEngine.this.tech.getShapeOfNode(dummy);
                    for (int i = 0; i < polys.length; ++i) {
                        Poly metalPoly = polys[i];
                        Layer layer = metalPoly.getLayer();
                        if (!layer.getFunction().isMetal()) continue;
                        FixpRectangle metalBounds = metalPoly.getBounds2D();
                        Rectangle2D.Double bounds = new Rectangle2D.Double(((RectangularShape)metalBounds).getMinX() + ((RectangularShape)portBounds).getCenterX(), ((RectangularShape)metalBounds).getMinY() + ((RectangularShape)portBounds).getCenterY(), ((RectangularShape)metalBounds).getWidth(), ((RectangularShape)metalBounds).getHeight());
                        boolean free = true;
                        BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(layer);
                        if (!bTree.isEmpty()) {
                            Iterator sea = bTree.search(bounds);
                            while (sea.hasNext()) {
                                SOGBound sBound = (SOGBound)sea.next();
                                int netValue = 0;
                                if (sBound.getNetID() != null) {
                                    netValue = sBound.getNetID().intValue();
                                }
                                if (netValue != this.netID.intValue() || sBound.getBounds().getMinX() > bounds.getMinX() || sBound.getBounds().getMaxX() < bounds.getMaxX() || sBound.getBounds().getMinY() > bounds.getMinY() || sBound.getBounds().getMaxY() < bounds.getMaxY()) continue;
                                free = false;
                                break;
                            }
                        }
                        if (!free) continue;
                        ArrayList<Rectangle2D.Double> rects = (ArrayList<Rectangle2D.Double>)blockageRects.get(layer);
                        if (rects == null) {
                            rects = new ArrayList<Rectangle2D.Double>();
                            blockageRects.put(layer, rects);
                        }
                        rects.add(bounds);
                    }
                }
            }
            for (Layer layer : blockageRects.keySet()) {
                List rects = (List)blockageRects.get(layer);
                for (int i = 0; i < rects.size(); ++i) {
                    Rectangle2D bound1 = (Rectangle2D)rects.get(i);
                    for (int j = 0; j < rects.size(); ++j) {
                        if (j == i) continue;
                        Rectangle2D bound2 = (Rectangle2D)rects.get(j);
                        if (!(bound1.getMinX() <= bound2.getMinX()) || !(bound1.getMaxX() >= bound2.getMaxX()) || !(bound1.getMinY() <= bound2.getMinY()) || !(bound1.getMaxY() >= bound2.getMaxY())) continue;
                        rects.remove(j);
                        if (i > j) {
                            --i;
                        }
                        --j;
                    }
                }
                for (Rectangle2D bounds : rects) {
                    List<SOGBound> blocksOnLayer;
                    SOGBound rtn = SeaOfGatesEngine.this.addRectangle(bounds, layer, netIDUse, false, false);
                    if (this.endBlockages == null) {
                        this.endBlockages = new HashMap<Layer, List<SOGBound>>();
                    }
                    if ((blocksOnLayer = this.endBlockages.get(layer)) == null) {
                        blocksOnLayer = new ArrayList<SOGBound>();
                        this.endBlockages.put(layer, blocksOnLayer);
                    }
                    blocksOnLayer.add(rtn);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SOGBound getMetalBlockage(MutableInteger netID, int metNo, double halfWidth, double halfHeight, double[] surround, double x2, double y) {
            Layer layer = SeaOfGatesEngine.this.metalLayers[metNo];
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(layer);
            bTree.lock();
            try {
                double lX = x2 - halfWidth - surround[0];
                double hX = x2 + halfWidth + surround[0];
                double lY = y - halfHeight - surround[1];
                double hY = y + halfHeight + surround[1];
                Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                Iterator sea = bTree.search(searchArea);
                while (sea.hasNext()) {
                    PolyBase poly;
                    SOGBound sBound = (SOGBound)sea.next();
                    ERectangle bound = sBound.getBounds();
                    if (DBMath.isLessThanOrEqualTo(bound.getMaxX(), lX) || DBMath.isGreaterThanOrEqualTo(bound.getMinX(), hX) || DBMath.isLessThanOrEqualTo(bound.getMaxY(), lY) || DBMath.isGreaterThanOrEqualTo(bound.getMinY(), hY) || sBound.isSameBasicNet(netID) || sBound instanceof SOGPoly && !(poly = ((SOGPoly)sBound).getPoly()).contains(searchArea)) continue;
                    SOGBound sOGBound = sBound;
                    return sOGBound;
                }
                SOGBound sOGBound = null;
                return sOGBound;
            }
            finally {
                bTree.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SOGVia getViaBlockage(MutableInteger netID, Layer layer, double halfWidth, double halfHeight, double x2, double y) {
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getViaTree(layer);
            bTree.lock();
            try {
                if (bTree.isEmpty()) {
                    SOGVia sOGVia = null;
                    return sOGVia;
                }
                Rectangle2D.Double searchArea = new Rectangle2D.Double(x2 - halfWidth, y - halfHeight, halfWidth * 2.0, halfHeight * 2.0);
                Iterator sea = bTree.search(searchArea);
                while (sea.hasNext()) {
                    SOGVia sLoc = (SOGVia)sea.next();
                    if (sLoc.isSameBasicNet(netID) && DBMath.areEquals(sLoc.loc.getX(), x2) && DBMath.areEquals(sLoc.loc.getY(), y)) continue;
                    SOGVia sOGVia = sLoc;
                    return sOGVia;
                }
                SOGVia sOGVia = null;
                return sOGVia;
            }
            finally {
                bTree.unlock();
            }
        }

        public void completeRoute(SearchVertex result2) {
            if (result2.wf != null) {
                ((SearchVertex)result2).wf.vertices = new ArrayList<SearchVertex>();
                SeaOfGatesEngine.this.getOptimizedList(result2, ((SearchVertex)result2).wf.vertices);
                assert (!((SearchVertex)result2).wf.vertices.isEmpty());
                if (this.spineTaps != null) {
                    for (PortInst pi : this.spineTaps) {
                        EPoint pt = pi.getCenter();
                        SearchVertex lastSV = ((SearchVertex)result2).wf.vertices.get(0);
                        double bestDist = Double.MAX_VALUE;
                        Point2D bestLoc = null;
                        int bestInsertPos = 0;
                        for (int i = 1; i < ((SearchVertex)result2).wf.vertices.size(); ++i) {
                            Point2D loc;
                            double dist;
                            SearchVertex sv = ((SearchVertex)result2).wf.vertices.get(i);
                            if (lastSV.getZ() == sv.getZ() && (dist = Math.abs((loc = GenMath.closestPointToSegment(new Point2D.Double(lastSV.getX(), lastSV.getY()), new Point2D.Double(sv.getX(), sv.getY()), (Point2D)pt)).getX() - pt.getX()) + Math.abs(loc.getY() - pt.getY())) < bestDist) {
                                bestDist = dist;
                                bestLoc = loc;
                                bestInsertPos = i;
                            }
                            lastSV = sv;
                        }
                        if (bestLoc == null) continue;
                        SearchVertex svTap = new SearchVertex(bestLoc.getX(), bestLoc.getY(), ((SearchVertex)result2).wf.vertices.get(bestInsertPos).getZ(), 0, null, null, 0, null);
                        ((SearchVertex)result2).wf.vertices.add(bestInsertPos, svTap);
                        this.spineTapMap.put(svTap, pi);
                    }
                }
                this.routedSuccess = true;
            } else if (result2 != svAbandoned) {
                if (result2 == svLimited) {
                    this.errorMessage = "Search for '" + this.routeName + "' too complex (took more than " + this.complexityLimit + " steps)";
                } else if (result2 == svExhausted) {
                    this.errorMessage = "Search for '" + this.routeName + "' examined all possibilities without success";
                } else {
                    assert (result2 == svAborted);
                    this.errorMessage = "Search for '" + this.routeName + "' aborted by user";
                }
                if (this.reroute) {
                    this.errorMessage = "(Retry) " + this.errorMessage;
                }
                SeaOfGatesEngine.this.error(this.errorMessage);
                if (result2 == svLimited || result2 == svExhausted) {
                    ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                    lineList.add(EPoint.fromLambda(this.aX, this.aY));
                    lineList.add(EPoint.fromLambda(this.bX, this.bY));
                    SeaOfGatesEngine.this.errorLogger.logMessageWithLines(this.errorMessage, null, lineList, SeaOfGatesEngine.this.cell, 0, true);
                }
            }
            this.batch.completedRoute(this, result2.wf);
        }

        static /* synthetic */ Rectangle2D[] access$002(NeededRoute x0, Rectangle2D[] x1) {
            x0.buckets = x1;
            return x1;
        }
    }

    private class RouteBatch
    implements Comparable<RouteBatch> {
        Set<ArcInst> unroutedArcs;
        Set<NodeInst> unroutedNodes;
        List<NeededRoute> routesInBatch;
        boolean isPwrGnd;
        double length;
        private RouteResolution resolution;
        private final ReentrantLock completedRouteLock = new ReentrantLock();

        public RouteBatch() {
            this.unroutedArcs = new HashSet<ArcInst>();
            this.unroutedNodes = new HashSet<NodeInst>();
            this.routesInBatch = new ArrayList<NeededRoute>();
            CellId destCellId = SeaOfGatesEngine.this.cell.getId();
            this.resolution = new RouteResolution(destCellId);
            this.isPwrGnd = false;
            this.length = 0.0;
        }

        public void addRoute(NeededRoute nr) {
            this.routesInBatch.add(nr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completedRoute(NeededRoute nr, Wavefront winningWF) {
            this.completedRouteLock.lock();
            try {
                if (winningWF != null && winningWF.vertices != null) {
                    winningWF.createRoute();
                }
                if (this.unroutedArcs.size() > 0 || this.unroutedNodes.size() > 0) {
                    for (ArcInst aiKill : this.unroutedArcs) {
                        this.resolution.killArc(aiKill);
                    }
                    for (NodeInst niKill : this.unroutedNodes) {
                        this.resolution.killNode(niKill);
                    }
                    this.unroutedArcs.clear();
                    this.unroutedNodes.clear();
                }
                SeaOfGatesEngine.this.handler.instantiate(this.resolution);
                if (nr.spineTaps != null) {
                    SeaOfGatesEngine.this.handler.flush(true);
                    int tapNumber = 1;
                    for (SearchVertex sv : nr.spineTapMap.keySet()) {
                        NeededRoute nrTap;
                        NodeInst ni;
                        PortInst aPi = (PortInst)nr.spineTapMap.get(sv);
                        ArcProto aArc = SeaOfGatesEngine.this.getMetalArcOnPort(aPi);
                        ImmutableNodeInst ini = (ImmutableNodeInst)nr.spineTapNIMap.get(aPi);
                        if (ini == null || (ni = SeaOfGatesEngine.this.cell.getNodeById(ini.nodeId)) == null) continue;
                        PortInst bPi = ni.getOnlyPortInst();
                        ArcProto bArc = SeaOfGatesEngine.this.getMetalArcOnPort(bPi);
                        if (aArc == null || bArc == null) continue;
                        String routeName = nr.routeName;
                        if (routeName.endsWith("(spine)")) {
                            routeName = routeName.substring(0, routeName.length() - 1) + " tap " + tapNumber + ")";
                        }
                        if (SeaOfGatesEngine.this.inValidPort(aPi, nrTap = new NeededRoute(routeName, aPi, bPi, aArc, bArc, null, nr.minWidth)) || SeaOfGatesEngine.this.inValidPort(bPi, nrTap)) continue;
                        nrTap.setNetID(nr.netID);
                        nrTap.growNetwork();
                        SeaOfGatesEngine.this.tapRoutes.add(nrTap);
                        nrTap.setBatchInfo(nr.batch, tapNumber++);
                    }
                }
            }
            finally {
                this.completedRouteLock.unlock();
            }
        }

        @Override
        public int compareTo(RouteBatch other) {
            if (this.isPwrGnd != other.isPwrGnd) {
                if (this.isPwrGnd) {
                    return -1;
                }
                return 1;
            }
            if (this.length < other.length) {
                return -1;
            }
            if (this.length > other.length) {
                return 1;
            }
            return 0;
        }
    }

    public static interface Handler {
        public EditingPreferences getEditingPreferences();

        public boolean checkAbort();

        public void trace(String var1);

        public void debug(String var1);

        public void info(String var1);

        public void warn(String var1);

        public void error(String var1);

        public void termLogging(ErrorLogger var1);

        public void startProgressDialog(String var1);

        public void stopProgressDialog();

        public void setProgressNote(String var1);

        public void setProgressValue(long var1, long var3);

        public void instantiate(RouteResolution var1);

        public void flush(boolean var1);
    }
}

