/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.flag.FlagAnnotations;
import com.sun.electric.tool.generator.flag.SchematicPosition;
import com.sun.electric.tool.generator.flag.Utils;
import com.sun.electric.tool.generator.flag.router.ToConnect;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SchematicVisitor
extends HierarchyEnumerator.Visitor {
    private static final Variable.Key LAYOUT_SPACE_KEY = Variable.newKey("ATTR_LAYOUT_SPACE");
    private final Cell layCell;
    private final EditingPreferences ep;
    private SchematicPosition schPos = new SchematicPosition();
    private List<NodeInst> layInsts = new ArrayList<NodeInst>();
    private Map<NodeInst, SchematicPosition> layInstToSchPos = new HashMap<NodeInst, SchematicPosition>();
    private Map<NodeInst, Double> layInstToSpacing = new HashMap<NodeInst, Double>();
    private Map<Integer, ToConnect> netIdToToConn = new HashMap<Integer, ToConnect>();

    private static final void prln(String msg) {
        Utils.prln(msg);
    }

    private void getLayConnectionsFromIcon(Cell icon, Nodable iconInst, NodeInst layInst, HierarchyEnumerator.CellInfo info) {
        Netlist nl = info.getNetlist();
        Iterator<Export> eIt = icon.getExports();
        while (eIt.hasNext()) {
            Export e = eIt.next();
            Name eNmKey = e.getNameKey();
            int busWid = eNmKey.busWidth();
            for (int i = 0; i < busWid; ++i) {
                String subNm = eNmKey.subname(i).toString();
                PortInst layPortInst = layInst.findPortInst(subNm);
                if (layPortInst == null) {
                    SchematicVisitor.prln("layout Cell: " + layInst.getProto().getName() + " missing port: " + subNm);
                    continue;
                }
                Network net = nl.getNetwork(iconInst, e, i);
                int netID = info.getNetID(net);
                ToConnect conn = this.netIdToToConn.get(netID);
                if (conn == null) {
                    conn = new ToConnect();
                    this.netIdToToConn.put(netID, conn);
                }
                conn.addPortInst(layPortInst);
            }
        }
    }

    private String removeInnerArrayRefs(String instNm) {
        int LEN = instNm.length();
        char[] chars = new char[LEN];
        boolean findMatchOpen = false;
        for (int i = LEN - 1; i >= 0; --i) {
            chars[i] = instNm.charAt(i);
            if (i == LEN - 1 && chars[i] == ']') {
                findMatchOpen = true;
                continue;
            }
            if (findMatchOpen && chars[i] == '[') {
                findMatchOpen = false;
                continue;
            }
            if (chars[i] != ']' && chars[i] != '[') continue;
            chars[i] = 95;
        }
        if (findMatchOpen) {
            chars[LEN - 1] = 95;
        }
        return new String(chars);
    }

    private double getLayoutSpacing(Nodable no) {
        NodeInst iconInst = no.getNodeInst();
        Variable v = iconInst.getVar(LAYOUT_SPACE_KEY);
        if (v == null) {
            return 0.0;
        }
        Object o = v.getObject();
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Float) {
            return ((Float)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        return 0.0;
    }

    private boolean useCellLayout(Cell iconSch) {
        FlagAnnotations ann = new FlagAnnotations(iconSch);
        return ann.isAtomic() || ann.isAutoGen();
    }

    @Override
    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
        if (!no.isCellInstance()) {
            return false;
        }
        Cell schematic = no.getParent();
        Cell icon = (Cell)no.getProto();
        Cell iconSch = icon.getEquivalent();
        if (iconSch == schematic) {
            return false;
        }
        if (!this.useCellLayout(iconSch)) {
            return true;
        }
        Cell lay = icon.otherView(View.LAYOUT);
        Job.error(lay == null, "Can't find layout for icon: " + icon.getName());
        NodeInst layInst = LayoutLib.newNodeInst(lay, this.ep, 0.0, 0.0, 0.0, 0.0, 0.0, this.layCell);
        String instNm = info.getUniqueNodableName(no, "__");
        layInst.setName(this.removeInnerArrayRefs(instNm));
        this.layInsts.add(layInst);
        SchematicPosition copy = this.schPos.copy();
        copy.push(no.getNodeInst().getBounds().getMinX());
        this.layInstToSchPos.put(layInst, copy);
        this.layInstToSpacing.put(layInst, this.getLayoutSpacing(no));
        this.getLayConnectionsFromIcon(icon, no, layInst, info);
        return false;
    }

    @Override
    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        if (info.isRootCell()) {
            Netlist nl = info.getNetlist();
            Iterator<Network> netIt = nl.getNetworks();
            while (netIt.hasNext()) {
                Network net = netIt.next();
                Iterator<String> expIt = net.getExportedNames();
                if (!expIt.hasNext()) continue;
                ArrayList<String> expNms = new ArrayList<String>();
                while (expIt.hasNext()) {
                    expNms.add(expIt.next());
                }
                this.netIdToToConn.put(info.getNetID(net), new ToConnect(expNms));
            }
        } else {
            Nodable parentInst = info.getParentInst();
            this.schPos.push(parentInst.getNodeInst().getBounds().getMinX());
        }
        return true;
    }

    @Override
    public void exitCell(HierarchyEnumerator.CellInfo info) {
        if (!info.isRootCell()) {
            this.schPos.pop();
        }
    }

    public SchematicVisitor(Cell layCell, EditingPreferences ep) {
        this.layCell = layCell;
        this.ep = ep;
    }

    public List<ToConnect> getLayoutToConnects() {
        ArrayList<ToConnect> toConnects = new ArrayList<ToConnect>();
        for (Integer i : this.netIdToToConn.keySet()) {
            toConnects.add(this.netIdToToConn.get(i));
        }
        return toConnects;
    }

    public List<NodeInst> getLayInsts() {
        return this.layInsts;
    }

    public Map<NodeInst, SchematicPosition> getLayInstSchematicPositions() {
        return this.layInstToSchPos;
    }

    public Map<NodeInst, Double> getLayInstSpacing() {
        return this.layInstToSpacing;
    }
}

