/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Charset;
import fan.sys.Endian;
import fan.sys.FanInt;
import fan.sys.FanObj;
import fan.sys.Func;
import fan.sys.IOErr;
import fan.sys.InStream;
import fan.sys.IndexErr;
import fan.sys.List;
import fan.sys.Map;
import fan.sys.MemBuf;
import fan.sys.OutStream;
import fan.sys.Range;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.UnsupportedErr;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public abstract class Buf
extends FanObj {
    static char[] hexChars;
    static int[] hexInv;
    static char[] base64chars;
    static final int[] base64inv;
    OutStream out;
    InStream in;

    public static Buf make() {
        return new MemBuf(1024);
    }

    public static Buf make(long l) {
        return new MemBuf((int)l);
    }

    public static Buf random(long l) {
        int n = (int)l;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = FanInt.random.nextInt();
            byArray[n2++] = (byte)(n3 >> 24);
            if (n2 >= n) continue;
            byArray[n2++] = (byte)(n3 >> 16);
            if (n2 >= n) continue;
            byArray[n2++] = (byte)(n3 >> 8);
            if (n2 >= n) continue;
            byArray[n2++] = (byte)n3;
        }
        return new MemBuf(byArray);
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public String toStr() {
        return this.typeof().name() + "(pos=" + this.pos() + " size=" + this.size() + ")";
    }

    public Type typeof() {
        return Sys.BufType;
    }

    public abstract int getByte(long var1);

    public abstract void getBytes(long var1, byte[] var3, int var4, int var5);

    public abstract void setByte(long var1, int var3);

    public abstract void pipeTo(byte[] var1, int var2, int var3);

    public abstract void pipeTo(OutputStream var1, long var2) throws IOException;

    public abstract void pipeTo(RandomAccessFile var1, long var2) throws IOException;

    public abstract void pipeTo(ByteBuffer var1, int var2);

    public abstract void pipeFrom(byte[] var1, int var2, int var3);

    public abstract long pipeFrom(InputStream var1, long var2) throws IOException;

    public abstract long pipeFrom(RandomAccessFile var1, long var2) throws IOException;

    public abstract int pipeFrom(ByteBuffer var1, int var2);

    public final boolean isEmpty() {
        return this.size() == 0L;
    }

    public long capacity() {
        return Long.MAX_VALUE;
    }

    public void capacity(long l) {
    }

    public abstract long size();

    public abstract void size(long var1);

    public abstract long pos();

    abstract void pos(long var1);

    public final long remaining() {
        return this.size() - this.pos();
    }

    public final boolean more() {
        return this.size() - this.pos() > 0L;
    }

    public final Buf seek(long l) {
        long l2 = this.size();
        if (l < 0L) {
            l = l2 + l;
        }
        if (l < 0L || l > l2) {
            throw IndexErr.make(l);
        }
        this.pos(l);
        return this;
    }

    public final Buf flip() {
        this.size(this.pos());
        this.pos(0L);
        return this;
    }

    public final long get(long l) {
        long l2 = this.size();
        if (l < 0L) {
            l = l2 + l;
        }
        if (l < 0L || l >= l2) {
            throw IndexErr.make(l);
        }
        return this.getByte(l);
    }

    public final Buf getRange(Range range) {
        long l = this.size();
        long l2 = range.start(l);
        long l3 = range.end(l);
        int n = (int)(l3 - l2 + 1L);
        if (n < 0) {
            throw IndexErr.make(range);
        }
        byte[] byArray = new byte[n];
        this.getBytes(l2, byArray, 0, n);
        MemBuf memBuf = new MemBuf(byArray, n);
        memBuf.charset(this.charset());
        return memBuf;
    }

    public final Buf dup() {
        int n = (int)this.size();
        byte[] byArray = new byte[n];
        this.getBytes(0L, byArray, 0, n);
        MemBuf memBuf = new MemBuf(byArray, n);
        memBuf.charset(this.charset());
        return memBuf;
    }

    public final Buf set(long l, long l2) {
        long l3 = this.size();
        if (l < 0L) {
            l = l3 + l;
        }
        if (l < 0L || l >= l3) {
            throw IndexErr.make(l);
        }
        this.setByte(l, (int)l2);
        return this;
    }

    public Buf trim() {
        return this;
    }

    public final Buf clear() {
        this.pos(0L);
        this.size(0L);
        return this;
    }

    public Buf flush() {
        return this;
    }

    public boolean close() {
        return true;
    }

    public final Endian endian() {
        return this.out.endian();
    }

    public final void endian(Endian endian) {
        this.out.endian(endian);
        this.in.endian(endian);
    }

    public final Charset charset() {
        return this.out.charset();
    }

    public final void charset(Charset charset) {
        this.out.charset(charset);
        this.in.charset(charset);
    }

    public final Buf fill(long l, long l2) {
        if (this.capacity() < this.size() + l2) {
            this.capacity(this.size() + l2);
        }
        int n = (int)l2;
        for (int i = 0; i < n; ++i) {
            this.out.write(l);
        }
        return this;
    }

    public final OutStream out() {
        return this.out;
    }

    public final Buf write(long l) {
        this.out.write(l);
        return this;
    }

    public final Buf writeBuf(Buf buf) {
        this.out.writeBuf(buf);
        return this;
    }

    public final Buf writeBuf(Buf buf, long l) {
        this.out.writeBuf(buf, l);
        return this;
    }

    public final Buf writeI2(long l) {
        this.out.writeI2(l);
        return this;
    }

    public final Buf writeI4(long l) {
        this.out.writeI4(l);
        return this;
    }

    public final Buf writeI8(long l) {
        this.out.writeI8(l);
        return this;
    }

    public final Buf writeF4(double d) {
        this.out.writeF4(d);
        return this;
    }

    public final Buf writeF8(double d) {
        this.out.writeF8(d);
        return this;
    }

    public final Buf writeDecimal(BigDecimal bigDecimal) {
        this.out.writeDecimal(bigDecimal);
        return this;
    }

    public final Buf writeBool(boolean bl) {
        this.out.writeBool(bl);
        return this;
    }

    public final Buf writeUtf(String string) {
        this.out.writeUtf(string);
        return this;
    }

    public final Buf writeChar(long l) {
        this.out.writeChar(l);
        return this;
    }

    public final Buf writeChars(String string) {
        this.out.writeChars(string);
        return this;
    }

    public final Buf writeChars(String string, long l) {
        this.out.writeChars(string, l);
        return this;
    }

    public final Buf writeChars(String string, long l, long l2) {
        this.out.writeChars(string, l, l2);
        return this;
    }

    public final Buf print(Object object) {
        this.out.print(object);
        return this;
    }

    public final Buf printLine() {
        this.out.printLine();
        return this;
    }

    public final Buf printLine(Object object) {
        this.out.printLine(object);
        return this;
    }

    public final Buf writeProps(Map map) {
        this.out.writeProps(map);
        return this;
    }

    public final Buf writeObj(Object object) {
        this.out.writeObj(object);
        return this;
    }

    public final Buf writeObj(Object object, Map map) {
        this.out.writeObj(object, map);
        return this;
    }

    public final Buf writeXml(String string) {
        this.out.writeXml(string, 0L);
        return this;
    }

    public final Buf writeXml(String string, long l) {
        this.out.writeXml(string, l);
        return this;
    }

    public final InStream in() {
        return this.in;
    }

    public final Long read() {
        return this.in.read();
    }

    public final Long readBuf(Buf buf, long l) {
        return this.in.readBuf(buf, l);
    }

    public final Buf unread(long l) {
        this.in.unread(l);
        return this;
    }

    public final Buf readBufFully(Buf buf, long l) {
        return this.in.readBufFully(buf, l);
    }

    public final Buf readAllBuf() {
        return this.in.readAllBuf();
    }

    public final Long peek() {
        return this.in.peek();
    }

    public final long readU1() {
        return this.in.readU1();
    }

    public final long readS1() {
        return this.in.readS1();
    }

    public final long readU2() {
        return this.in.readU2();
    }

    public final long readS2() {
        return this.in.readS2();
    }

    public final long readU4() {
        return this.in.readU4();
    }

    public final long readS4() {
        return this.in.readS4();
    }

    public final long readS8() {
        return this.in.readS8();
    }

    public final double readF4() {
        return this.in.readF4();
    }

    public final double readF8() {
        return this.in.readF8();
    }

    public final BigDecimal readDecimal() {
        return this.in.readDecimal();
    }

    public final boolean readBool() {
        return this.in.readBool();
    }

    public final String readUtf() {
        return this.in.readUtf();
    }

    public final Long readChar() {
        return this.in.readChar();
    }

    public final Buf unreadChar(long l) {
        this.in.unreadChar(l);
        return this;
    }

    public final Long peekChar() {
        return this.in.peekChar();
    }

    public final String readChars(long l) {
        return this.in.readChars(l);
    }

    public final String readLine() {
        return this.in.readLine();
    }

    public final String readLine(Long l) {
        return this.in.readLine(l);
    }

    public final String readStrToken() {
        return this.in.readStrToken();
    }

    public final String readStrToken(Long l) {
        return this.in.readStrToken(l);
    }

    public final String readStrToken(Long l, Func func) {
        return this.in.readStrToken(FanInt.Chunk, func);
    }

    public final List readAllLines() {
        return this.in.readAllLines();
    }

    public final void eachLine(Func func) {
        this.in.eachLine(func);
    }

    public final String readAllStr() {
        return this.in.readAllStr();
    }

    public final String readAllStr(boolean bl) {
        return this.in.readAllStr(bl);
    }

    public final Map readProps() {
        return this.in.readProps();
    }

    public final Object readObj() {
        return this.in.readObj();
    }

    public final Object readObj(Map map) {
        return this.in.readObj(map);
    }

    public String toHex() {
        throw UnsupportedErr.make(this.typeof() + ".toHex");
    }

    public static Buf fromHex(String string) {
        String string2 = string;
        int n = string2.length();
        byte[] byArray = new byte[n / 2];
        int[] nArray = hexInv;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            char c = string2.charAt(i);
            int n4 = n3 = c < '\u0080' ? nArray[c] : -1;
            if (n3 < 0) continue;
            int n5 = -1;
            if (++i < n) {
                char c2 = string2.charAt(i);
                int n6 = n5 = c2 < '\u0080' ? nArray[c2] : -1;
            }
            if (n5 < 0) {
                throw IOErr.make("Invalid hex str");
            }
            byArray[n2++] = (byte)(n3 << 4 | n5);
        }
        return new MemBuf(byArray, n2);
    }

    public String toBase64() {
        throw UnsupportedErr.make(this.typeof() + ".toBase64");
    }

    public static Buf fromBase64(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = n * 6 / 8;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n2 < n) {
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < 4 && n2 < n) {
                char c;
                int n8;
                if ((n8 = (c = string.charAt(n2++)) < '\u0080' ? base64inv[c] : -1) < 0) continue;
                n5 |= n8 << 18 - n7++ * 6;
                if (c == '=') continue;
                ++n6;
            }
            if (n6 > 1) {
                byArray[n4++] = (byte)(n5 >> 16);
            }
            if (n6 > 2) {
                byArray[n4++] = (byte)(n5 >> 8);
            }
            if (n6 <= 3) continue;
            byArray[n4++] = (byte)n5;
        }
        return new MemBuf(byArray, n4);
    }

    public Buf toDigest(String string) {
        throw UnsupportedErr.make(this.typeof() + ".toDigest");
    }

    public Buf hmac(String string, Buf buf) {
        throw UnsupportedErr.make(this.typeof() + ".hmac");
    }

    static {
        int n;
        hexChars = "0123456789abcdef".toCharArray();
        hexInv = new int[128];
        for (n = 0; n < hexInv.length; ++n) {
            Buf.hexInv[n] = -1;
        }
        for (n = 0; n < 10; ++n) {
            Buf.hexInv[48 + n] = n;
        }
        for (n = 10; n < 16; ++n) {
            int n2 = n;
            Buf.hexInv[65 + n - 10] = n2;
            Buf.hexInv[97 + n - 10] = n2;
        }
        base64chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        base64inv = new int[128];
        for (n = 0; n < base64inv.length; ++n) {
            Buf.base64inv[n] = -1;
        }
        for (n = 0; n < base64chars.length; ++n) {
            Buf.base64inv[Buf.base64chars[n]] = n;
        }
        Buf.base64inv[61] = 0;
    }
}

