/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ClassType;
import fan.sys.Err;
import fan.sys.Pod;
import fan.sys.Sys;
import fanx.util.Box;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.HashMap;

public class FanClassLoader
extends URLClassLoader {
    static final ExtClassLoader extClassLoader = new ExtClassLoader();
    private Pod pod;
    private PermissionCollection allPermissions;
    private CodeSource codeSource;
    private HashMap pendingClasses = new HashMap();

    public FanClassLoader(Pod pod) {
        super(new URL[0], (ClassLoader)extClassLoader);
        try {
            this.pod = pod;
            this.allPermissions = new AllPermission().newPermissionCollection();
            this.codeSource = new CodeSource(new URL("file://"), (CodeSigner[])null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadFan(String string, Box box) {
        try {
            HashMap hashMap = this.pendingClasses;
            synchronized (hashMap) {
                this.pendingClasses.put(string, box);
            }
            return this.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw Err.make("Cannot load class: " + string, classNotFoundException);
        }
    }

    public String toString() {
        return "FanClassLoader[" + this.pod.name() + "]";
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        return this.allPermissions;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        try {
            Class clazz = this.findPendingClass(string);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.findFanClass(string);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.findPrecompiledClass(string, null);
            if (clazz != null) {
                return clazz;
            }
            return super.findClass(string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string2 = noClassDefFoundError.toString();
            if (string2.contains("eclipse") && string2.contains("swt")) {
                System.out.println("ERROR: cannot load SWT library - see `http://fantom.org/doc/docTools/Setup.html#swt`");
            }
            throw noClassDefFoundError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findPendingClass(String string) {
        Box box = null;
        HashMap hashMap = this.pendingClasses;
        synchronized (hashMap) {
            box = (Box)this.pendingClasses.get(string);
            if (box != null) {
                this.pendingClasses.remove(string);
            }
        }
        if (box == null) {
            return null;
        }
        return this.defineClass(string, box.buf, 0, box.len, this.codeSource);
    }

    private Class findFanClass(String string) throws ClassNotFoundException {
        if (!string.startsWith("fan.")) {
            return null;
        }
        int n = string.indexOf(46, 4);
        String string2 = string.substring(4, n);
        String string3 = string.substring(n + 1);
        if (!this.pod.name().equals(string2)) {
            Pod pod = Pod.doFind(string2, true, null, null);
            return pod.classLoader.loadClass(string);
        }
        Class clazz = this.findPrecompiledClass(string, string3);
        if (clazz != null) {
            return clazz;
        }
        this.pod.emit();
        if (string3.equals("$Pod")) {
            return this.pod.emit();
        }
        if (string3.endsWith("$")) {
            int n2 = string3.endsWith("$") ? 1 : 4;
            ClassType classType = (ClassType)this.pod.type(string3.substring(0, string3.length() - n2), true);
            clazz = classType.emit();
            return this.loadClass(string);
        }
        ClassType classType = (ClassType)this.pod.type(string3, true);
        return classType.emit();
    }

    private Class findPrecompiledClass(String string, String string2) {
        if (this.pod.fpod.store == null) {
            return null;
        }
        try {
            String string3 = string.replace('.', '/') + ".class";
            Box box = this.pod.fpod.store.readToBox(string3);
            if (box == null) {
                return null;
            }
            Class<?> clazz = this.defineClass(string, box.buf, 0, box.len, this.codeSource);
            if (string2 != null) {
                ClassType classType = (ClassType)this.pod.type(string2, false);
                if (classType != null) {
                    classType.precompiled(clazz);
                } else if (string2.equals("$Pod")) {
                    this.pod.precompiled(clazz);
                }
            }
            return clazz;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static void dumpToFile(String string, Box box) {
        try {
            File file = new File(string.substring(string.lastIndexOf(46) + 1) + ".class");
            System.out.println("Dump: " + file);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(box.buf, 0, box.len);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static class ExtClassLoader
    extends URLClassLoader {
        public ExtClassLoader() {
            super(new URL[0], FanClassLoader.class.getClassLoader());
            try {
                String string = File.separator;
                File file = new File(Sys.homeDir, "lib" + string + "java" + string + "ext");
                File file2 = new File(file, Sys.platform);
                this.addExtJars(file);
                this.addExtJars(file2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void addExtJars(File file) throws Exception {
            File[] fileArray = file.listFiles();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                if (!fileArray[i].getName().endsWith(".jar")) continue;
                this.addURL(fileArray[i].toURL());
            }
        }
    }
}

