/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.DateTime;
import fan.sys.Duration;
import fan.sys.Err;
import fan.sys.FanObj;
import fan.sys.Func;
import fan.sys.List;
import fan.sys.LogLevel;
import fan.sys.LogRec;
import fan.sys.NotImmutableErr;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.Uri;
import java.util.HashMap;

public class Log
extends FanObj {
    static volatile Func[] handlers = new Func[1];
    private static Object lock;
    private static HashMap byName;
    private String name;
    private volatile LogLevel level = LogLevel.info;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List list() {
        Object object = lock;
        synchronized (object) {
            return new List(Sys.LogType, byName.values().toArray(new Log[byName.size()])).ro();
        }
    }

    public static Log find(String string) {
        return Log.find(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log find(String string, boolean bl) {
        Object object = lock;
        synchronized (object) {
            Log log = (Log)byName.get(string);
            if (log != null) {
                return log;
            }
            if (bl) {
                throw Err.make("Unknown log: " + string);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log get(String string) {
        Object object = lock;
        synchronized (object) {
            Log log = (Log)byName.get(string);
            if (log != null) {
                return log;
            }
            return Log.make(string, true);
        }
    }

    public static Log make(String string, boolean bl) {
        Log log = new Log();
        Log.make$(log, string, bl);
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void make$(Log log, String string, boolean bl) {
        Uri.checkName(string);
        log.name = string;
        if (bl) {
            Object object = lock;
            synchronized (object) {
                if (byName.get(string) != null) {
                    throw ArgErr.make("Duplicate log name: " + string);
                }
                byName.put(string, log);
                String string2 = (String)Sys.sysPod.props(Uri.fromStr("log.props"), Duration.oneMin).get(string);
                if (string2 != null) {
                    log.level = LogLevel.fromStr(string2);
                }
            }
        }
    }

    public Type typeof() {
        return Sys.LogType;
    }

    public final String toStr() {
        return this.name;
    }

    public final String name() {
        return this.name;
    }

    public final LogLevel level() {
        return this.level;
    }

    public final void level(LogLevel logLevel) {
        if (logLevel == null) {
            throw ArgErr.make("level cannot be null");
        }
        this.level = logLevel;
    }

    public final boolean enabled(LogLevel logLevel) {
        return this.level.ord <= logLevel.ord;
    }

    public final boolean isEnabled(LogLevel logLevel) {
        return this.enabled(logLevel);
    }

    public final boolean isErr() {
        return this.isEnabled(LogLevel.err);
    }

    public final boolean isWarn() {
        return this.isEnabled(LogLevel.warn);
    }

    public final boolean isInfo() {
        return this.isEnabled(LogLevel.info);
    }

    public final boolean isDebug() {
        return this.isEnabled(LogLevel.debug);
    }

    public final void err(String string) {
        this.err(string, (Err)null);
    }

    public final void err(String string, Throwable throwable) {
        this.err(string, Err.make(throwable));
    }

    public final void err(String string, Err err) {
        this.log(LogRec.make(DateTime.now(), LogLevel.err, this.name, string, err));
    }

    public final void warn(String string) {
        this.warn(string, (Err)null);
    }

    public final void warn(String string, Throwable throwable) {
        this.warn(string, Err.make(throwable));
    }

    public final void warn(String string, Err err) {
        this.log(LogRec.make(DateTime.now(), LogLevel.warn, this.name, string, err));
    }

    public final void info(String string) {
        this.info(string, (Err)null);
    }

    public final void info(String string, Throwable throwable) {
        this.info(string, Err.make(throwable));
    }

    public final void info(String string, Err err) {
        this.log(LogRec.make(DateTime.now(), LogLevel.info, this.name, string, err));
    }

    public final void debug(String string) {
        this.debug(string, (Err)null);
    }

    public final void debug(String string, Throwable throwable) {
        this.debug(string, Err.make(throwable));
    }

    public final void debug(String string, Err err) {
        this.log(LogRec.make(DateTime.now(), LogLevel.debug, this.name, string, err));
    }

    public void log(LogRec logRec) {
        if (!this.enabled(logRec.level)) {
            return;
        }
        Func[] funcArray = handlers;
        for (int i = 0; i < funcArray.length; ++i) {
            try {
                funcArray[i].call(logRec);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static List handlers() {
        return new List(Sys.FuncType, handlers).ro();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHandler(Func func) {
        if (!func.isImmutable()) {
            throw NotImmutableErr.make("handler must be immutable");
        }
        Object object = lock;
        synchronized (object) {
            List list = new List(Sys.FuncType, handlers).add(func);
            handlers = (Func[])list.toArray(new Func[list.sz()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHandler(Func func) {
        Object object = lock;
        synchronized (object) {
            List list = new List(Sys.FuncType, handlers);
            list.remove(func);
            handlers = (Func[])list.toArray(new Func[list.sz()]);
        }
    }

    static {
        try {
            Log.handlers[0] = Sys.LogRecType.method("print", true).func();
        }
        catch (Throwable throwable) {
            handlers = new Func[0];
            throwable.printStackTrace();
        }
        lock = new Object();
        byName = new HashMap();
    }
}

