/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Env;
import fan.sys.Err;
import fan.sys.FanInt;
import fan.sys.FanObj;
import fan.sys.FanStr;
import fan.sys.File;
import fan.sys.Func;
import fan.sys.List;
import fan.sys.Method;
import fan.sys.Sys;
import fan.sys.TestErr;
import fan.sys.Type;
import fan.sys.Uri;
import fanx.util.OpUtil;

public class Test
extends FanObj {
    public int verifyCount;
    public static boolean verbose;
    public Method curTestMethod;
    File tempDir;

    public static void make$(Test test) {
    }

    public Type typeof() {
        return Sys.TestType;
    }

    public Method curTestMethod() {
        if (this.curTestMethod == null) {
            throw Err.make("No test currently executing for " + this.typeof());
        }
        return this.curTestMethod;
    }

    public void setup() {
    }

    public void teardown() {
    }

    public void verify(boolean bl) {
        this.verify(bl, null);
    }

    public void verify(boolean bl, String string) {
        if (!bl) {
            this.fail(string);
        }
        ++this.verifyCount;
    }

    public void verifyFalse(boolean bl) {
        this.verifyFalse(bl, null);
    }

    public void verifyFalse(boolean bl, String string) {
        if (bl) {
            this.fail(string);
        }
        ++this.verifyCount;
    }

    public void verifyNull(Object object) {
        this.verifyNull(object, null);
    }

    public void verifyNull(Object object, String string) {
        if (object != null) {
            if (string == null) {
                string = Test.s(object) + " is not null";
            }
            this.fail(string);
        }
        ++this.verifyCount;
    }

    public void verifyNotNull(Object object) {
        this.verifyNotNull(object, null);
    }

    public void verifyNotNull(Object object, String string) {
        if (object == null) {
            if (string == null) {
                string = "is null";
            }
            this.fail(string);
        }
        ++this.verifyCount;
    }

    public void verifyEq(Object object, Object object2) {
        this.verifyEq(object, object2, null);
    }

    public void verifyEq(Object object, Object object2, String string) {
        if (!OpUtil.compareEQ(object, object2)) {
            if (object instanceof String && object2 instanceof String) {
                List list = FanStr.splitLines((String)object);
                List list2 = FanStr.splitLines((String)object2);
                if (list.sz() > 1 || list2.sz() > 1) {
                    if (list.sz() != list2.sz()) {
                        string = "Expected " + list.sz() + " lines, actual " + list2.sz() + " lines";
                    } else {
                        for (int i = 0; i < list.sz(); ++i) {
                            if (list.get(i).equals(list2.get(i))) continue;
                            string = "Line " + (i + 1) + ": " + FanStr.toCode((String)list.get(i)) + " != " + FanStr.toCode((String)list2.get(i));
                            break;
                        }
                    }
                }
            }
            if (string == null) {
                string = Test.s(object) + " != " + Test.s(object2);
            }
            this.fail(string);
        }
        if (object != null && object2 != null && Test.hash(object) != Test.hash(object2)) {
            this.fail("Equal but different hash codes: " + object + " (0x" + FanInt.toHex(Test.hash(object)) + ") ?= " + object2 + " (0x" + FanInt.toHex(Test.hash(object2)) + ")");
        }
        ++this.verifyCount;
    }

    public void verifyNotEq(Object object, Object object2) {
        this.verifyNotEq(object, object2, null);
    }

    public void verifyNotEq(Object object, Object object2, String string) {
        if (!OpUtil.compareNE(object, object2)) {
            if (string == null) {
                string = Test.s(object) + " == " + Test.s(object2);
            }
            this.fail(string);
        }
        ++this.verifyCount;
    }

    public void verifySame(Object object, Object object2) {
        this.verifySame(object, object2, null);
    }

    public void verifySame(Object object, Object object2, String string) {
        if (object != object2) {
            if (string == null) {
                string = Test.s(object) + " !== " + Test.s(object2);
            }
            this.fail(string);
        }
        ++this.verifyCount;
    }

    public void verifyNotSame(Object object, Object object2) {
        this.verifyNotSame(object, object2, null);
    }

    public void verifyNotSame(Object object, Object object2, String string) {
        if (object == object2) {
            if (string == null) {
                string = Test.s(object) + " === " + Test.s(object2);
            }
            this.fail(string);
        }
        ++this.verifyCount;
    }

    public void verifyType(Object object, Type type) {
        this.verifyEq(Type.of(object), type);
    }

    public void verifyErr(Type type, Func func) {
        try {
            func.call(this);
        }
        catch (Err err) {
            if (verbose) {
                System.out.println("  verifyErr: " + err);
            }
            if (err.typeof() == type) {
                ++this.verifyCount;
                return;
            }
            this.fail(err.typeof() + " thrown, expected " + type);
        }
        catch (Throwable throwable) {
            Err err;
            if (verbose) {
                System.out.println("  verifyErr: " + throwable);
            }
            if ((err = Err.make(throwable)).typeof() == type) {
                ++this.verifyCount;
                return;
            }
            this.fail(throwable.toString() + " thrown, expected " + type);
        }
        this.fail("No err thrown, expected " + type);
    }

    public void fail() {
        this.fail(null);
    }

    public void fail(String string) {
        throw this.err(string);
    }

    private RuntimeException err(String string) {
        if (string == null) {
            return TestErr.make("Test failed");
        }
        return TestErr.make("Test failed: " + string);
    }

    static String s(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return FanStr.toCode((String)object) + " [sys::Str]";
        }
        if (object instanceof List) {
            return ((List)object).of().toString() + object;
        }
        return Test.toStr(object) + " [" + FanObj.typeof(object) + "]";
    }

    public Object trap(String string, List list) {
        if (string.equals("verifyCount")) {
            return (long)this.verifyCount;
        }
        return super.trap(string, list);
    }

    public File tempDir() {
        if (this.tempDir == null) {
            this.tempDir = Env.cur().tempDir().plus(Uri.fromStr("test/"), false);
            this.tempDir.delete();
            this.tempDir.create();
        }
        return this.tempDir;
    }
}

