/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Env;
import fan.sys.Err;
import fan.sys.FanInt;
import fan.sys.FanObj;
import fan.sys.FanStr;
import fan.sys.InStream;
import fan.sys.List;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.SysInStream;
import fan.sys.Type;
import fan.sys.Uri;
import java.util.ArrayList;
import java.util.HashMap;

public final class Unit
extends FanObj {
    private static final List list = new List(Sys.UnitType);
    private static final HashMap byId = new HashMap();
    private static final HashMap dims = new HashMap();
    private static final HashMap quantities = new HashMap();
    private static final HashMap combos = new HashMap();
    private static final List quantityNames;
    private static final Dimension dimensionless;
    private final List ids;
    private final double scale;
    private final double offset;
    private final Dimension dim;

    public static Unit fromStr(String string) {
        return Unit.fromStr(string, true);
    }

    public static Unit fromStr(String string, boolean bl) {
        HashMap hashMap = byId;
        synchronized (hashMap) {
            Unit unit = (Unit)byId.get(string);
            if (unit != null || !bl) {
                return unit;
            }
            throw Err.make("Unit not found: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List list() {
        List list = Unit.list;
        synchronized (list) {
            return Unit.list.dup().ro();
        }
    }

    public static List quantities() {
        return quantityNames;
    }

    public static List quantity(String string) {
        List list = (List)quantities.get(string);
        if (list == null) {
            throw Err.make("Unknown unit database quantity: " + string);
        }
        return list;
    }

    private static List loadDatabase() {
        InStream inStream = null;
        List list = new List(Sys.StrType);
        try {
            String string;
            String string2 = "etc/sys/units.txt";
            inStream = Sys.isJarDist ? new SysInStream(Unit.class.getClassLoader().getResourceAsStream(string2)) : Env.cur().findFile(Uri.fromStr(string2)).in();
            String string3 = null;
            List list2 = null;
            while ((string = inStream.readLine()) != null) {
                if ((string = string.trim()).startsWith("//") || string.length() == 0) continue;
                if (string.startsWith("--")) {
                    if (string3 != null) {
                        quantities.put(string3, list2.toImmutable());
                    }
                    string3 = string.substring(2, string.indexOf(40)).trim();
                    list2 = new List(Sys.UnitType);
                    list.add(string3);
                    continue;
                }
                try {
                    Unit unit = Unit.define(string);
                    list2.add(unit);
                }
                catch (Exception exception) {
                    System.out.println("WARNING: Init unit in etc/sys/units.txt: " + string);
                    System.out.println("  " + exception);
                }
            }
            quantities.put(string3, list2.toImmutable());
        }
        catch (Throwable throwable) {
            try {
                inStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("WARNING: Cannot load etc/sys/units.txt");
            throwable.printStackTrace();
        }
        return (List)list.toImmutable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Unit define(String string) {
        Unit unit = null;
        try {
            unit = Unit.parseUnit(string);
        }
        catch (Throwable throwable) {
            String string2 = string;
            if (throwable instanceof ParseErr) {
                string2 = string2 + ": " + ((ParseErr)throwable).msg();
            }
            throw ParseErr.make("Unit", string2);
        }
        HashMap hashMap = byId;
        synchronized (hashMap) {
            String string3;
            int n;
            for (n = 0; n < unit.ids.sz(); ++n) {
                string3 = (String)unit.ids.get(n);
                if (byId.get(string3) == null) continue;
                throw Err.make("Unit id already defined: " + string3);
            }
            for (n = 0; n < unit.ids.sz(); ++n) {
                string3 = (String)unit.ids.get(n);
                byId.put(string3, unit);
            }
            list.add(unit);
        }
        return unit;
    }

    private static Unit parseUnit(String string) {
        String string2 = string;
        int n = string.indexOf(59);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        List list = FanStr.split(string2, 44L);
        if (n < 0) {
            return new Unit(list, dimensionless, 1.0, 0.0);
        }
        String string3 = string = string.substring(n + 1).trim();
        n = string.indexOf(59);
        if (n < 0) {
            return new Unit(list, Unit.parseDim(string3), 1.0, 0.0);
        }
        string3 = string.substring(0, n).trim();
        String string4 = string = string.substring(n + 1).trim();
        n = string.indexOf(59);
        if (n < 0) {
            return new Unit(list, Unit.parseDim(string3), Double.parseDouble(string4), 0.0);
        }
        string4 = string.substring(0, n).trim();
        String string5 = string.substring(n + 1).trim();
        return new Unit(list, Unit.parseDim(string3), Double.parseDouble(string4), Double.parseDouble(string5));
    }

    private static Dimension parseDim(String string) {
        if (string.length() == 0) {
            return dimensionless;
        }
        Dimension dimension = new Dimension();
        List list = FanStr.split(string, 42L, true);
        for (int i = 0; i < list.sz(); ++i) {
            String string2 = (String)list.get(i);
            if (string2.startsWith("kg")) {
                dimension.kg = Byte.parseByte(string2.substring(2).trim());
                continue;
            }
            if (string2.startsWith("sec")) {
                dimension.sec = Byte.parseByte(string2.substring(3).trim());
                continue;
            }
            if (string2.startsWith("mol")) {
                dimension.mol = Byte.parseByte(string2.substring(3).trim());
                continue;
            }
            if (string2.startsWith("m")) {
                dimension.m = Byte.parseByte(string2.substring(1).trim());
                continue;
            }
            if (string2.startsWith("K")) {
                dimension.K = Byte.parseByte(string2.substring(1).trim());
                continue;
            }
            if (string2.startsWith("A")) {
                dimension.A = Byte.parseByte(string2.substring(1).trim());
                continue;
            }
            if (string2.startsWith("cd")) {
                dimension.cd = Byte.parseByte(string2.substring(2).trim());
                continue;
            }
            throw ParseErr.make("Bad ratio '" + string2 + "'");
        }
        return dimension.intern();
    }

    private Unit(List list, Dimension dimension, double d, double d2) {
        this.ids = Unit.checkIds(list);
        this.dim = dimension;
        this.scale = d;
        this.offset = d2;
    }

    static List checkIds(List list) {
        if (list.sz() == 0) {
            throw ParseErr.make("No unit ids defined");
        }
        for (int i = 0; i < list.sz(); ++i) {
            Unit.checkId((String)list.get(i));
        }
        return (List)list.toImmutable();
    }

    static void checkId(String string) {
        if (string.length() == 0) {
            throw ParseErr.make("Invalid unit id length 0");
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (FanInt.isAlpha(c) || c == '_' || c == '%' || c == '/' || c == '$' || c > '\u0080') continue;
            throw ParseErr.make("Invalid unit id " + string + " (invalid char '" + (char)c + "')");
        }
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return this.toStr().hashCode();
    }

    public final long hash() {
        return FanObj.hash(this.toStr());
    }

    public final Type typeof() {
        return Sys.UnitType;
    }

    public final String toStr() {
        return (String)this.ids.last();
    }

    public final List ids() {
        return this.ids;
    }

    public final String name() {
        return (String)this.ids.first();
    }

    public final String symbol() {
        return (String)this.ids.last();
    }

    public final double scale() {
        return this.scale;
    }

    public final double offset() {
        return this.offset;
    }

    public final String definition() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.ids.sz(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.ids.get(i));
        }
        if (this.dim != dimensionless) {
            stringBuilder.append("; ").append(this.dim);
            if (this.scale != 1.0 || this.offset != 0.0) {
                stringBuilder.append("; ").append(this.scale);
                if (this.offset != 0.0) {
                    stringBuilder.append("; ").append(this.offset);
                }
            }
        }
        return stringBuilder.toString();
    }

    public final long kg() {
        return this.dim.kg;
    }

    public final long m() {
        return this.dim.m;
    }

    public final long sec() {
        return this.dim.sec;
    }

    public final long K() {
        return this.dim.K;
    }

    public final long A() {
        return this.dim.A;
    }

    public final long mol() {
        return this.dim.mol;
    }

    public final long cd() {
        return this.dim.cd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Unit mult(Unit unit) {
        HashMap hashMap = combos;
        synchronized (hashMap) {
            Combo combo = new Combo(this, "*", unit);
            Unit unit2 = (Unit)combos.get(combo);
            if (unit2 == null) {
                unit2 = Unit.findMult(this, unit);
                combos.put(combo, unit2);
            }
            return unit2;
        }
    }

    private static Unit findMult(Unit unit, Unit unit2) {
        double d;
        if (unit.dim.isDimensionless() || unit2.dim.isDimensionless()) {
            throw Err.make("Cannot compute dimensionless: " + unit + " * " + unit2);
        }
        Dimension dimension = unit.dim.add(unit2.dim).intern();
        Unit[] unitArray = Unit.match(dimension, d = unit.scale * unit2.scale);
        if (unitArray.length == 1) {
            return unitArray[0];
        }
        String string = unit.name() + "_" + unit2.name();
        for (int i = 0; i < unitArray.length; ++i) {
            if (!unitArray[i].name().equals(string)) continue;
            return unitArray[i];
        }
        throw Err.make("Cannot match to db: " + unit + " * " + unit2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Unit div(Unit unit) {
        HashMap hashMap = combos;
        synchronized (hashMap) {
            Combo combo = new Combo(this, "/", unit);
            Unit unit2 = (Unit)combos.get(combo);
            if (unit2 == null) {
                unit2 = this.findDiv(this, unit);
                combos.put(combo, unit2);
            }
            return unit2;
        }
    }

    public final Unit findDiv(Unit unit, Unit unit2) {
        double d;
        if (unit.dim.isDimensionless() || unit2.dim.isDimensionless()) {
            throw Err.make("Cannot compute dimensionless: " + unit + " / " + unit2);
        }
        Dimension dimension = unit.dim.subtract(unit2.dim).intern();
        Unit[] unitArray = Unit.match(dimension, d = unit.scale / unit2.scale);
        if (unitArray.length == 1) {
            return unitArray[0];
        }
        String string = unit.name() + "_per_" + unit2.name();
        for (int i = 0; i < unitArray.length; ++i) {
            if (!unitArray[i].name().contains(string)) continue;
            return unitArray[i];
        }
        throw Err.make("Cannot match to db: " + unit + " / " + unit2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Unit[] match(Dimension dimension, double d) {
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        List list = Unit.list;
        synchronized (list) {
            for (int i = 0; i < Unit.list.sz(); ++i) {
                Unit unit = (Unit)Unit.list.get(i);
                if (unit.dim != dimension || !Unit.approx(unit.scale, d)) continue;
                arrayList.add(unit);
            }
        }
        return arrayList.toArray(new Unit[arrayList.size()]);
    }

    private static boolean approx(double d, double d2) {
        if (d == d2) {
            return true;
        }
        double d3 = Math.min(Math.abs(d / 1000.0), Math.abs(d2 / 1000.0));
        return Math.abs(d - d2) <= d3;
    }

    public final double convertTo(double d, Unit unit) {
        if (this.dim != unit.dim) {
            throw Err.make("Incovertable units: " + this + " and " + unit);
        }
        return (d * this.scale + this.offset - unit.offset) / unit.scale;
    }

    static {
        dimensionless = new Dimension();
        dims.put(dimensionless, dimensionless);
        quantityNames = Unit.loadDatabase();
    }

    static class Combo {
        final Unit a;
        final String op;
        final Unit b;

        Combo(Unit unit, String string, Unit unit2) {
            this.a = unit;
            this.op = string;
            this.b = unit2;
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.op.hashCode() ^ this.b.hashCode() << 13;
        }

        public boolean equals(Object object) {
            Combo combo = (Combo)object;
            return this.a == combo.a && this.op == combo.op && this.b == combo.b;
        }
    }

    static class Dimension {
        String str;
        byte kg;
        byte m;
        byte sec;
        byte K;
        byte A;
        byte mol;
        byte cd;

        Dimension() {
        }

        public int hashCode() {
            return this.kg << 28 ^ this.m << 23 ^ this.sec << 18 ^ this.K << 13 ^ this.A << 8 ^ this.mol << 3 ^ this.cd;
        }

        public boolean equals(Object object) {
            Dimension dimension = (Dimension)object;
            return this.kg == dimension.kg && this.m == dimension.m && this.sec == dimension.sec && this.K == dimension.K && this.A == dimension.A && this.mol == dimension.mol && this.cd == dimension.cd;
        }

        public String toString() {
            if (this.str == null) {
                StringBuilder stringBuilder = new StringBuilder();
                this.append(stringBuilder, "kg", this.kg);
                this.append(stringBuilder, "m", this.m);
                this.append(stringBuilder, "sec", this.sec);
                this.append(stringBuilder, "K", this.K);
                this.append(stringBuilder, "A", this.A);
                this.append(stringBuilder, "mol", this.mol);
                this.append(stringBuilder, "cd", this.cd);
                this.str = stringBuilder.toString();
            }
            return this.str;
        }

        private void append(StringBuilder stringBuilder, String string, int n) {
            if (n == 0) {
                return;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append('*');
            }
            stringBuilder.append(string).append(n);
        }

        public Dimension add(Dimension dimension) {
            Dimension dimension2 = new Dimension();
            dimension2.kg = (byte)(this.kg + dimension.kg);
            dimension2.m = (byte)(this.m + dimension.m);
            dimension2.sec = (byte)(this.sec + dimension.sec);
            dimension2.K = (byte)(this.K + dimension.K);
            dimension2.A = (byte)(this.A + dimension.A);
            dimension2.mol = (byte)(this.mol + dimension.mol);
            dimension2.cd = (byte)(this.cd + dimension.cd);
            return dimension2;
        }

        public Dimension subtract(Dimension dimension) {
            Dimension dimension2 = new Dimension();
            dimension2.kg = (byte)(this.kg - dimension.kg);
            dimension2.m = (byte)(this.m - dimension.m);
            dimension2.sec = (byte)(this.sec - dimension.sec);
            dimension2.K = (byte)(this.K - dimension.K);
            dimension2.A = (byte)(this.A - dimension.A);
            dimension2.mol = (byte)(this.mol - dimension.mol);
            dimension2.cd = (byte)(this.cd - dimension.cd);
            return dimension2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension intern() {
            HashMap hashMap = dims;
            synchronized (hashMap) {
                Dimension dimension = (Dimension)dims.get(this);
                if (dimension != null) {
                    return dimension;
                }
                dims.put(this, this);
                return this;
            }
        }

        public boolean isDimensionless() {
            return this.toString().length() == 0;
        }
    }
}

