/*
 * Decompiled with CFR 0.152.
 */
package fanx.fcode;

import fan.sys.Duration;
import fan.sys.Uri;
import fanx.fcode.FConst;
import fanx.fcode.FPod;
import fanx.fcode.FTable;
import java.io.IOException;
import java.math.BigDecimal;

public final class FLiterals
implements FConst {
    public FPod fpod;
    public FTable ints;
    public FTable floats;
    public FTable decimals;
    public FTable strs;
    public FTable durations;
    public FTable uris;

    public FLiterals(FPod fPod) {
        this.fpod = fPod;
        this.ints = new FTable.Ints(fPod);
        this.floats = new FTable.Floats(fPod);
        this.decimals = new FTable.Decimals(fPod);
        this.strs = new FTable.Strs(fPod);
        this.durations = new FTable.Durations(fPod);
        this.uris = new FTable.Uris(fPod);
    }

    public FLiterals read() throws IOException {
        this.ints.read(this.fpod.store.read("fcode/ints.def"));
        this.floats.read(this.fpod.store.read("fcode/floats.def"));
        this.decimals.read(this.fpod.store.read("fcode/decimals.def"));
        this.strs.read(this.fpod.store.read("fcode/strs.def"));
        this.durations.read(this.fpod.store.read("fcode/durations.def"));
        this.uris.read(this.fpod.store.read("fcode/uris.def"));
        return this;
    }

    public final Long integer(int n) {
        return (Long)this.ints.get(n);
    }

    public final Double floats(int n) {
        return (Double)this.floats.get(n);
    }

    public final BigDecimal decimals(int n) {
        return (BigDecimal)this.decimals.get(n);
    }

    public final String str(int n) {
        return (String)this.strs.get(n);
    }

    public final Duration duration(int n) {
        return (Duration)this.durations.get(n);
    }

    public final Uri uri(int n) {
        return (Uri)this.uris.get(n);
    }
}

