/*
 * Decompiled with CFR 0.152.
 */
package fanx.fcode;

import fanx.emit.CodeEmit;
import fanx.emit.EmitConst;
import fanx.fcode.FConst;
import fanx.fcode.FPod;
import fanx.fcode.FStore;
import fanx.fcode.FTypeRef;
import java.io.IOException;
import java.util.HashMap;

public class FMethodRef
implements EmitConst,
FConst {
    static Special newSpecial = new Special(){

        public void emit(FMethodRef fMethodRef, CodeEmit codeEmit) {
            codeEmit.op2(187, codeEmit.emit().cls(fMethodRef.parent.jname()));
            codeEmit.op(89);
        }
    };
    static Special classLiteralSpecial = new Special(){

        public void emit(FMethodRef fMethodRef, CodeEmit codeEmit) {
            codeEmit.op2(19, codeEmit.emit().cls(fMethodRef.parent.jname()));
        }
    };
    static Special boolAnd = new SpecialOp(126);
    static Special boolOr = new SpecialOp(128);
    static Special boolXor = new SpecialOp(130);
    static HashMap boolSpecials = new HashMap();
    static Special intPlus;
    static Special intPlusFloat;
    static Special intMinus;
    static Special intMult;
    static Special intMultFloat;
    static Special intDiv;
    static Special intMod;
    static Special intAnd;
    static Special intOr;
    static Special intXor;
    static Special intNegate;
    static Special intShiftl;
    static Special intShiftr;
    static HashMap intSpecials;
    static Special floatPlus;
    static Special floatPlusInt;
    static Special floatMinus;
    static Special floatMinusInt;
    static Special floatMult;
    static Special floatMultInt;
    static Special floatDiv;
    static Special floatDivInt;
    static Special floatMod;
    static Special floatModInt;
    static Special floatNegate;
    static HashMap floatSpecials;
    static Special arraySize;
    static Special arrayMake;
    static Special arrayGet;
    static Special arraySet;
    static HashMap arraySpecials;
    static final FTypeRef[] noParams;
    static final int INVOKE_VIRT_AS_STATIC = 1;
    public final FTypeRef parent;
    public final String name;
    public final FTypeRef ret;
    public final FTypeRef[] params;
    private String jsig;
    private String jsigAlt;
    private int mask;
    private int iiNumArgs = -1;
    private Special special;

    private FMethodRef(FTypeRef fTypeRef, String string, FTypeRef fTypeRef2, FTypeRef[] fTypeRefArray) {
        this.parent = fTypeRef;
        this.name = string;
        this.ret = fTypeRef2;
        this.params = fTypeRefArray;
        this.special = this.toSpecial();
    }

    public String toString() {
        return this.parent + "." + this.name + "()";
    }

    public void emitCallNew(CodeEmit codeEmit) {
        if (this.special != null) {
            this.special.emit(this, codeEmit);
            return;
        }
        if (this.jsig == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.parent.jname()).append('.').append(this.name).append('(');
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i].jsig(stringBuilder);
            }
            stringBuilder.append(')');
            this.parent.jsig(stringBuilder);
            this.jsig = stringBuilder.toString();
        }
        int n = codeEmit.emit().method(this.jsig);
        codeEmit.op2(184, n);
    }

    public void emitCallCtor(CodeEmit codeEmit) {
        boolean bl = this.name.equals("<init>");
        if (this.jsigAlt == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.parent.jname()).append('.').append(this.name);
            if (bl) {
                stringBuilder.append('(');
            } else {
                stringBuilder.append("$(L").append(this.parent.jname()).append(';');
            }
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i].jsig(stringBuilder);
            }
            stringBuilder.append(')').append('V');
            this.jsigAlt = stringBuilder.toString();
        }
        int n = codeEmit.emit().method(this.jsigAlt);
        if (bl) {
            codeEmit.op2(183, n);
        } else {
            codeEmit.op2(184, n);
        }
    }

    public void emitCallStatic(CodeEmit codeEmit) {
        if (this.special != null) {
            this.special.emit(this, codeEmit);
            return;
        }
        if (this.jsig == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.parent.jimpl()).append('.').append(this.name).append('(');
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i].jsig(stringBuilder);
            }
            stringBuilder.append(')');
            this.ret.jsig(stringBuilder);
            this.jsig = stringBuilder.toString();
        }
        int n = codeEmit.emit().method(this.jsig);
        codeEmit.op2(184, n);
    }

    public void emitCallVirtual(CodeEmit codeEmit) {
        if (this.special != null) {
            this.special.emit(this, codeEmit);
            return;
        }
        if (this.jsig == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.parent.jname();
            String string2 = this.parent.jimpl();
            stringBuilder.append(string2).append('.').append(this.name).append('(');
            if (string != string2) {
                this.mask |= 1;
                this.parent.jsig(stringBuilder);
            }
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i].jsig(stringBuilder);
            }
            stringBuilder.append(')');
            this.ret.jsig(stringBuilder);
            this.jsig = stringBuilder.toString();
        }
        int n = codeEmit.emit().method(this.jsig);
        if ((this.mask & 1) != 0) {
            codeEmit.op2(184, n);
        } else {
            codeEmit.op2(182, n);
        }
    }

    public void emitCallNonVirtual(CodeEmit codeEmit) {
        if (this.jsigAlt == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.parent.jname();
            String string2 = this.parent.jimpl();
            stringBuilder.append(string2).append('.').append(this.name).append('(');
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i].jsig(stringBuilder);
            }
            stringBuilder.append(')');
            this.ret.jsig(stringBuilder);
            this.jsigAlt = stringBuilder.toString();
        }
        int n = codeEmit.emit().method(this.jsigAlt);
        codeEmit.op2(183, n);
    }

    public void emitCallMixinStatic(CodeEmit codeEmit) {
        if (this.special != null) {
            this.special.emit(this, codeEmit);
            return;
        }
        if (this.jsig == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.parent.jimpl()).append("$.").append(this.name).append('(');
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i].jsig(stringBuilder);
            }
            stringBuilder.append(')');
            this.ret.jsig(stringBuilder);
            this.jsig = stringBuilder.toString();
        }
        int n = codeEmit.emit().method(this.jsig);
        codeEmit.op2(184, n);
    }

    public void emitCallMixinVirtual(CodeEmit codeEmit) {
        if (this.jsig == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.parent.jname()).append('.').append(this.name).append('(');
            int n = 1;
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i].jsig(stringBuilder);
                n += this.params[i].isWide() ? 2 : 1;
            }
            stringBuilder.append(')');
            this.ret.jsig(stringBuilder);
            this.jsig = stringBuilder.toString();
            this.iiNumArgs = n;
        }
        int n = codeEmit.emit().interfaceRef(this.jsig);
        codeEmit.op2(185, n);
        codeEmit.info.u1(this.iiNumArgs);
        codeEmit.info.u1(0);
    }

    public void emitCallMixinNonVirtual(CodeEmit codeEmit) {
        if (this.jsigAlt == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.parent.jname()).append("$.").append(this.name).append('(');
            this.parent.jsig(stringBuilder);
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i].jsig(stringBuilder);
            }
            stringBuilder.append(')');
            this.ret.jsig(stringBuilder);
            this.jsigAlt = stringBuilder.toString();
        }
        int n = codeEmit.emit().method(this.jsigAlt);
        codeEmit.op2(184, n);
    }

    private Special toSpecial() {
        if (this.name.equals("<new>")) {
            return newSpecial;
        }
        if (this.name.equals("<class>")) {
            return classLiteralSpecial;
        }
        if (this.parent.isBool()) {
            return (Special)boolSpecials.get(this.name);
        }
        if (this.parent.isInt()) {
            return (Special)intSpecials.get(this.name);
        }
        if (this.parent.isFloat()) {
            return (Special)floatSpecials.get(this.name);
        }
        if (this.parent.isPrimitiveArray()) {
            return (Special)arraySpecials.get(this.name);
        }
        return null;
    }

    public static FMethodRef read(FStore.Input input) throws IOException {
        FPod fPod = input.fpod;
        FTypeRef fTypeRef = fPod.typeRef(input.u2());
        String string = fPod.name(input.u2());
        FTypeRef fTypeRef2 = fPod.typeRef(input.u2());
        int n = input.u1();
        FTypeRef[] fTypeRefArray = noParams;
        if (n > 0) {
            fTypeRefArray = new FTypeRef[n];
            for (int i = 0; i < n; ++i) {
                fTypeRefArray[i] = fPod.typeRef(input.u2());
            }
        }
        return new FMethodRef(fTypeRef, string, fTypeRef2, fTypeRefArray);
    }

    static {
        boolSpecials.put("and", boolAnd);
        boolSpecials.put("or", boolOr);
        boolSpecials.put("xor", boolXor);
        intPlus = new SpecialOp(97);
        intPlusFloat = new SpecialOp4(94, 88, 138, 99);
        intMinus = new SpecialOp(101);
        intMult = new SpecialOp(105);
        intMultFloat = new SpecialOp4(94, 88, 138, 107);
        intDiv = new SpecialOp(109);
        intMod = new SpecialOp(113);
        intAnd = new SpecialOp(127);
        intOr = new SpecialOp(129);
        intXor = new SpecialOp(131);
        intNegate = new SpecialOp(117);
        intShiftl = new SpecialOp2(136, 121);
        intShiftr = new SpecialOp2(136, 125);
        intSpecials = new HashMap();
        intSpecials.put("negate", intNegate);
        intSpecials.put("plus", intPlus);
        intSpecials.put("plusFloat", intPlusFloat);
        intSpecials.put("minus", intMinus);
        intSpecials.put("mult", intMult);
        intSpecials.put("multFloat", intMultFloat);
        intSpecials.put("div", intDiv);
        intSpecials.put("mod", intMod);
        intSpecials.put("and", intAnd);
        intSpecials.put("or", intOr);
        intSpecials.put("xor", intXor);
        intSpecials.put("shiftl", intShiftl);
        intSpecials.put("shiftr", intShiftr);
        floatPlus = new SpecialOp(99);
        floatPlusInt = new SpecialOp2(138, 99);
        floatMinus = new SpecialOp(103);
        floatMinusInt = new SpecialOp2(138, 103);
        floatMult = new SpecialOp(107);
        floatMultInt = new SpecialOp2(138, 107);
        floatDiv = new SpecialOp(111);
        floatDivInt = new SpecialOp2(138, 111);
        floatMod = new SpecialOp(115);
        floatModInt = new SpecialOp2(138, 115);
        floatNegate = new SpecialOp(119);
        floatSpecials = new HashMap();
        floatSpecials.put("plus", floatPlus);
        floatSpecials.put("plusInt", floatPlusInt);
        floatSpecials.put("minus", floatMinus);
        floatSpecials.put("minusInt", floatMinusInt);
        floatSpecials.put("mult", floatMult);
        floatSpecials.put("multInt", floatMultInt);
        floatSpecials.put("div", floatDiv);
        floatSpecials.put("divInt", floatDivInt);
        floatSpecials.put("mod", floatMod);
        floatSpecials.put("modInt", floatModInt);
        floatSpecials.put("negate", floatNegate);
        arraySize = new SpecialOp(190);
        arrayMake = new Special(){

            public void emit(FMethodRef fMethodRef, CodeEmit codeEmit) {
                switch (fMethodRef.parent.arrayOfStackType()) {
                    case 90: {
                        codeEmit.op1(188, 4);
                        break;
                    }
                    case 67: {
                        codeEmit.op1(188, 5);
                        break;
                    }
                    case 70: {
                        codeEmit.op1(188, 6);
                        break;
                    }
                    case 68: {
                        codeEmit.op1(188, 7);
                        break;
                    }
                    case 66: {
                        codeEmit.op1(188, 8);
                        break;
                    }
                    case 83: {
                        codeEmit.op1(188, 9);
                        break;
                    }
                    case 73: {
                        codeEmit.op1(188, 10);
                        break;
                    }
                    case 74: {
                        codeEmit.op1(188, 11);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("" + fMethodRef.parent);
                    }
                }
            }
        };
        arrayGet = new Special(){

            public void emit(FMethodRef fMethodRef, CodeEmit codeEmit) {
                switch (fMethodRef.parent.arrayOfStackType()) {
                    case 90: {
                        codeEmit.op(51);
                        break;
                    }
                    case 66: {
                        codeEmit.op(51);
                        break;
                    }
                    case 83: {
                        codeEmit.op(53);
                        break;
                    }
                    case 67: {
                        codeEmit.op(52);
                        break;
                    }
                    case 73: {
                        codeEmit.op(46);
                        break;
                    }
                    case 74: {
                        codeEmit.op(47);
                        break;
                    }
                    case 70: {
                        codeEmit.op(48);
                        break;
                    }
                    case 68: {
                        codeEmit.op(49);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("" + fMethodRef.parent);
                    }
                }
            }
        };
        arraySet = new Special(){

            public void emit(FMethodRef fMethodRef, CodeEmit codeEmit) {
                switch (fMethodRef.parent.arrayOfStackType()) {
                    case 90: {
                        codeEmit.op(84);
                        break;
                    }
                    case 66: {
                        codeEmit.op(84);
                        break;
                    }
                    case 83: {
                        codeEmit.op(86);
                        break;
                    }
                    case 67: {
                        codeEmit.op(85);
                        break;
                    }
                    case 73: {
                        codeEmit.op(79);
                        break;
                    }
                    case 74: {
                        codeEmit.op(80);
                        break;
                    }
                    case 70: {
                        codeEmit.op(81);
                        break;
                    }
                    case 68: {
                        codeEmit.op(82);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("" + fMethodRef.parent);
                    }
                }
            }
        };
        arraySpecials = new HashMap();
        arraySpecials.put("size", arraySize);
        arraySpecials.put("make", arrayMake);
        arraySpecials.put("get", arrayGet);
        arraySpecials.put("set", arraySet);
        noParams = new FTypeRef[0];
    }

    static class SpecialOp4
    implements Special {
        int op1;
        int op2;
        int op3;
        int op4;

        SpecialOp4(int n, int n2, int n3, int n4) {
            this.op1 = n;
            this.op2 = n2;
            this.op3 = n3;
            this.op4 = n4;
        }

        public void emit(FMethodRef fMethodRef, CodeEmit codeEmit) {
            codeEmit.op(this.op1);
            codeEmit.op(this.op2);
            codeEmit.op(this.op3);
            codeEmit.op(this.op4);
        }
    }

    static class SpecialOp2
    implements Special {
        int op1;
        int op2;

        SpecialOp2(int n, int n2) {
            this.op1 = n;
            this.op2 = n2;
        }

        public void emit(FMethodRef fMethodRef, CodeEmit codeEmit) {
            codeEmit.op(this.op1);
            codeEmit.op(this.op2);
        }
    }

    static class SpecialOp
    implements Special {
        int op;

        SpecialOp(int n) {
            this.op = n;
        }

        public void emit(FMethodRef fMethodRef, CodeEmit codeEmit) {
            codeEmit.op(this.op);
        }
    }

    static interface Special {
        public void emit(FMethodRef var1, CodeEmit var2);
    }
}

