/*
 * Decompiled with CFR 0.152.
 */
package fanx.serial;

import fan.sys.Duration;
import fan.sys.InStream;
import fan.sys.Uri;
import fanx.serial.ObjDecoder;
import fanx.serial.Token;
import java.math.BigDecimal;

public class Tokenizer {
    private static final byte[] charMap;
    private static final int SPACE = 1;
    private static final int ALPHA = 2;
    private static final int DIGIT = 3;
    public InStream in;
    public int type;
    public Object val;
    public int line = 1;
    Undo undo;
    int cur;
    int curt;
    int peek;
    int peekt;

    public Tokenizer(InStream inStream) {
        this.in = inStream;
        this.consume();
        this.consume();
    }

    public int next() {
        if (this.undo != null) {
            this.undo.reset(this);
            this.undo = null;
            return this.type;
        }
        this.val = null;
        this.type = this.doNext();
        return this.type;
    }

    private int doNext() {
        block24: while (true) {
            if (this.curt == 1) {
                this.consume();
                continue;
            }
            if (this.cur < 0) {
                return -1;
            }
            if (this.curt == 2) {
                return this.id();
            }
            if (this.curt == 3) {
                return this.number(false);
            }
            switch (this.cur) {
                case 43: {
                    this.consume();
                    return this.number(false);
                }
                case 45: {
                    this.consume();
                    return this.number(true);
                }
                case 34: {
                    return this.str();
                }
                case 39: {
                    return this.ch();
                }
                case 96: {
                    return this.uri();
                }
                case 40: {
                    this.consume();
                    return 16;
                }
                case 41: {
                    this.consume();
                    return 17;
                }
                case 44: {
                    this.consume();
                    return 11;
                }
                case 59: {
                    this.consume();
                    return 10;
                }
                case 61: {
                    this.consume();
                    return 21;
                }
                case 123: {
                    this.consume();
                    return 14;
                }
                case 125: {
                    this.consume();
                    return 15;
                }
                case 35: {
                    this.consume();
                    return 22;
                }
                case 63: {
                    this.consume();
                    return 23;
                }
                case 64: {
                    this.consume();
                    return 24;
                }
                case 36: {
                    this.consume();
                    return 25;
                }
                case 46: {
                    if (this.peekt == 3) {
                        return this.number(false);
                    }
                    this.consume();
                    return 9;
                }
                case 91: {
                    this.consume();
                    if (this.cur == 93) {
                        this.consume();
                        return 20;
                    }
                    return 18;
                }
                case 93: {
                    this.consume();
                    return 19;
                }
                case 58: {
                    this.consume();
                    if (this.cur == 58) {
                        this.consume();
                        return 13;
                    }
                    return 12;
                }
                case 42: {
                    if (this.peek != 42) break block24;
                    this.skipCommentSL();
                    continue block24;
                }
                case 47: {
                    if (this.peek == 47) {
                        this.skipCommentSL();
                        continue block24;
                    }
                    if (this.peek != 42) break block24;
                    this.skipCommentML();
                    continue block24;
                }
            }
            break;
        }
        throw this.err("Unexpected symbol: " + (char)this.cur + " (0x" + Integer.toHexString(this.cur) + ")");
    }

    private int id() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.cur;
        while ((this.curt == 2 || this.curt == 3) && this.cur > 0) {
            stringBuilder.append((char)this.cur);
            this.consume();
        }
        String string = stringBuilder.toString();
        switch (n) {
            case 97: {
                if (!string.equals("as")) break;
                return 26;
            }
            case 102: {
                if (!string.equals("false")) break;
                this.val = false;
                return 1;
            }
            case 110: {
                if (!string.equals("null")) break;
                this.val = null;
                return 8;
            }
            case 116: {
                if (!string.equals("true")) break;
                this.val = true;
                return 1;
            }
            case 117: {
                if (!string.equals("using")) break;
                return 27;
            }
        }
        this.val = string;
        return 0;
    }

    private int number(boolean bl) {
        if (this.cur == 48 && this.peek == 120) {
            return this.hex();
        }
        StringBuilder stringBuilder = null;
        long l = 0L;
        int n = 0;
        while (this.curt == 3) {
            if (stringBuilder != null) {
                stringBuilder.append((char)this.cur);
            } else {
                l = l * 10L + (long)(this.cur - 48);
                if (++n >= 18) {
                    stringBuilder = new StringBuilder(32);
                    if (bl) {
                        stringBuilder.append('-');
                    }
                    stringBuilder.append(l);
                }
            }
            this.consume();
            if (this.cur != 95) continue;
            this.consume();
        }
        boolean bl2 = false;
        if (this.cur == 46 && this.peekt == 3) {
            bl2 = true;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(32);
                if (bl) {
                    stringBuilder.append('-');
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('.');
            this.consume();
            while (this.curt == 3) {
                stringBuilder.append((char)this.cur);
                this.consume();
                if (this.cur != 95) continue;
                this.consume();
            }
        }
        if (this.cur == 101 || this.cur == 69) {
            bl2 = true;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(32);
                if (bl) {
                    stringBuilder.append('-');
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('e');
            this.consume();
            if (this.cur == 45 || this.cur == 43) {
                stringBuilder.append((char)this.cur);
                this.consume();
            }
            if (this.curt != 3) {
                throw this.err("Expected exponent digits");
            }
            while (this.curt == 3) {
                stringBuilder.append((char)this.cur);
                this.consume();
                if (this.cur != 95) continue;
                this.consume();
            }
        }
        boolean bl3 = false;
        boolean bl4 = false;
        long l2 = -1L;
        if (100 <= this.cur && this.cur <= 115) {
            if (this.cur == 110 && this.peek == 115) {
                this.consume();
                this.consume();
                l2 = 1L;
            }
            if (this.cur == 109 && this.peek == 115) {
                this.consume();
                this.consume();
                l2 = 1000000L;
            }
            if (this.cur == 115 && this.peek == 101) {
                this.consume();
                this.consume();
                if (this.cur != 99) {
                    throw this.err("Expected 'sec' in Duration literal");
                }
                this.consume();
                l2 = 1000000000L;
            }
            if (this.cur == 109 && this.peek == 105) {
                this.consume();
                this.consume();
                if (this.cur != 110) {
                    throw this.err("Expected 'min' in Duration literal");
                }
                this.consume();
                l2 = 60000000000L;
            }
            if (this.cur == 104 && this.peek == 114) {
                this.consume();
                this.consume();
                l2 = 3600000000000L;
            }
            if (this.cur == 100 && this.peek == 97) {
                this.consume();
                this.consume();
                if (this.cur != 121) {
                    throw this.err("Expected 'day' in Duration literal");
                }
                this.consume();
                l2 = 86400000000000L;
            }
        }
        if (this.cur == 102 || this.cur == 70) {
            this.consume();
            bl3 = true;
        } else if (this.cur == 100 || this.cur == 68) {
            this.consume();
            bl4 = true;
        }
        if (bl) {
            l = -l;
        }
        try {
            long l3;
            if (bl3) {
                this.val = stringBuilder == null ? Double.valueOf(l) : Double.valueOf(Double.parseDouble(stringBuilder.toString()));
                return 4;
            }
            if (bl4 || bl2) {
                BigDecimal bigDecimal;
                BigDecimal bigDecimal2 = bigDecimal = stringBuilder == null ? new BigDecimal(l) : new BigDecimal(stringBuilder.toString());
                if (l2 > 0L) {
                    this.val = Duration.make(bigDecimal.multiply(new BigDecimal(l2)).longValue());
                    return 6;
                }
                this.val = bigDecimal;
                return 5;
            }
            long l4 = l3 = stringBuilder == null ? l : new BigDecimal(stringBuilder.toString()).longValueExact();
            if (l2 > 0L) {
                this.val = Duration.make(l3 * l2);
                return 6;
            }
            this.val = l3;
            return 3;
        }
        catch (Exception exception) {
            throw this.err("Invalid numeric literal: " + stringBuilder);
        }
    }

    int hex() {
        this.consume();
        this.consume();
        int n = 3;
        long l = Tokenizer.hex(this.cur);
        if (l < 0L) {
            throw this.err("Expecting hex number");
        }
        this.consume();
        int n2 = 1;
        while (true) {
            int n3;
            if ((n3 = Tokenizer.hex(this.cur)) < 0) {
                if (this.cur != 95) break;
                this.consume();
                continue;
            }
            if (++n2 > 16) {
                throw this.err("Hex literal too big");
            }
            l = (l << 4) + (long)n3;
            this.consume();
        }
        this.val = l;
        return n;
    }

    static int hex(int n) {
        if (48 <= n && n <= 57) {
            return n - 48;
        }
        if (97 <= n && n <= 102) {
            return n - 97 + 10;
        }
        if (65 <= n && n <= 70) {
            return n - 65 + 10;
        }
        return -1;
    }

    private int str() {
        this.consume();
        StringBuilder stringBuilder = new StringBuilder();
        block7: while (true) {
            switch (this.cur) {
                case 34: {
                    this.consume();
                    break block7;
                }
                case -1: {
                    throw this.err("Unexpected end of string");
                }
                case 36: {
                    throw this.err("Interpolated strings unsupported");
                }
                case 92: {
                    stringBuilder.append(this.escape());
                    continue block7;
                }
                case 13: {
                    stringBuilder.append('\n');
                    this.consume();
                    continue block7;
                }
                default: {
                    stringBuilder.append((char)this.cur);
                    this.consume();
                    continue block7;
                }
            }
            break;
        }
        this.val = stringBuilder.toString();
        return 2;
    }

    private int ch() {
        char c;
        this.consume();
        if (this.cur == 92) {
            c = this.escape();
        } else {
            c = (char)this.cur;
            this.consume();
        }
        if (this.cur != 39) {
            throw this.err("Expecting ' close of char literal");
        }
        this.consume();
        this.val = (long)c;
        return 3;
    }

    char escape() {
        if (this.cur != 92) {
            throw this.err("Internal error");
        }
        this.consume();
        switch (this.cur) {
            case 98: {
                this.consume();
                return '\b';
            }
            case 102: {
                this.consume();
                return '\f';
            }
            case 110: {
                this.consume();
                return '\n';
            }
            case 114: {
                this.consume();
                return '\r';
            }
            case 116: {
                this.consume();
                return '\t';
            }
            case 36: {
                this.consume();
                return '$';
            }
            case 34: {
                this.consume();
                return '\"';
            }
            case 39: {
                this.consume();
                return '\'';
            }
            case 96: {
                this.consume();
                return '`';
            }
            case 92: {
                this.consume();
                return '\\';
            }
        }
        if (this.cur == 117) {
            this.consume();
            int n = Tokenizer.hex(this.cur);
            this.consume();
            int n2 = Tokenizer.hex(this.cur);
            this.consume();
            int n3 = Tokenizer.hex(this.cur);
            this.consume();
            int n4 = Tokenizer.hex(this.cur);
            this.consume();
            if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
                throw this.err("Invalid hex value for \\uxxxx");
            }
            return (char)(n << 12 | n2 << 8 | n3 << 4 | n4);
        }
        throw this.err("Invalid escape sequence");
    }

    private int uri() {
        this.consume();
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            if (this.cur < 0) {
                throw this.err("Unexpected end of uri");
            }
            if (this.cur == 92) {
                stringBuilder.append(this.escape());
                continue;
            }
            if (this.cur == 96) break;
            stringBuilder.append((char)this.cur);
            this.consume();
        }
        this.consume();
        this.val = Uri.fromStr(stringBuilder.toString());
        return 7;
    }

    private Token skipCommentSL() {
        this.consume();
        this.consume();
        while (true) {
            if (this.cur == 10 || this.cur == 13) {
                this.consume();
                break;
            }
            if (this.cur < 0) break;
            this.consume();
        }
        return null;
    }

    private Token skipCommentML() {
        this.consume();
        this.consume();
        int n = 1;
        while (true) {
            if (this.cur == 42 && this.peek == 47) {
                this.consume();
                this.consume();
                if (--n <= 0) break;
            }
            if (this.cur == 47 && this.peek == 42) {
                this.consume();
                this.consume();
                ++n;
                continue;
            }
            if (this.cur < 0) break;
            this.consume();
        }
        return null;
    }

    public RuntimeException err(String string) {
        return ObjDecoder.err(string, this.line);
    }

    private void consume() {
        int n;
        if (this.cur == 10 || this.cur == 13) {
            ++this.line;
        }
        if ((n = this.in.rChar()) == 10 && this.peek == 13) {
            n = this.in.rChar();
        }
        this.cur = this.peek;
        this.curt = this.peekt;
        this.peek = n;
        this.peekt = 0 < n && n < 128 ? charMap[n] : 2;
    }

    public void undo(int n, Object object, int n2) {
        if (this.undo != null) {
            throw new IllegalStateException("only one pushback supported");
        }
        this.undo = new Undo(n, object, n2);
    }

    public int reset(int n, Object object, int n2) {
        this.type = n;
        this.val = object;
        this.line = n2;
        return n;
    }

    static {
        int n;
        charMap = new byte[128];
        Tokenizer.charMap[32] = 1;
        Tokenizer.charMap[10] = 1;
        Tokenizer.charMap[13] = 1;
        Tokenizer.charMap[9] = 1;
        for (n = 97; n <= 122; ++n) {
            Tokenizer.charMap[n] = 2;
        }
        for (n = 65; n <= 90; ++n) {
            Tokenizer.charMap[n] = 2;
        }
        Tokenizer.charMap[95] = 2;
        for (n = 48; n <= 57; ++n) {
            Tokenizer.charMap[n] = 3;
        }
    }

    static class Undo {
        int type;
        Object val;
        int line;

        Undo(int n, Object object, int n2) {
            this.type = n;
            this.val = object;
            this.line = n2;
        }

        void reset(Tokenizer tokenizer) {
            tokenizer.reset(this.type, this.val, this.line);
        }
    }
}

