/*
 * Decompiled with CFR 0.152.
 */
package fanx.test;

import fanx.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class Test {
    public static String[] tests = new String[]{"CharsetTest", "EmitTest", "FileUtilTest", "StrBufTest", "StrUtilTest", "TokenizerTest", "DateTimeTest"};
    public static boolean verbose;
    public static int totalVerified;
    private static File temp;
    private int verified;
    private String testName;

    public final String testName() {
        return this.testName;
    }

    public boolean skip() {
        return false;
    }

    public abstract void run() throws Exception;

    public Object newInstance(Class clazz, Object[] objectArray) throws Exception {
        return clazz.getConstructor(this.argsToParams(objectArray)).newInstance(objectArray);
    }

    public Object make(Class clazz) throws Exception {
        return this.make(clazz, new Object[0]);
    }

    public Object make(Class clazz, Object[] objectArray) throws Exception {
        return this.findMethod(clazz, "make", objectArray.length).invoke(null, objectArray);
    }

    public Object invoke(Class clazz, String string) throws Exception {
        return this.invoke(clazz, string, new Object[0]);
    }

    public Object invoke(Class clazz, String string, Object[] objectArray) throws Exception {
        try {
            int n = objectArray == null ? 0 : objectArray.length;
            return this.findMethod(clazz, string, n).invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (Exception)invocationTargetException.getCause();
        }
    }

    public Object invoke(Object object, String string) throws Exception {
        return this.invoke(object, string, new Object[0]);
    }

    public Object invoke(Object object, String string, Object[] objectArray) throws Exception {
        try {
            int n = objectArray == null ? 0 : objectArray.length;
            return this.findMethod(object.getClass(), string, n).invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (Exception)invocationTargetException.getCause();
        }
    }

    public Method findMethod(Class clazz, String string) throws Exception {
        return this.findMethod(clazz, string, -1);
    }

    public Method findMethod(Class clazz, String string, int n) throws Exception {
        Method method = this.findMethod(clazz, string, n, clazz.getMethods());
        if (method != null) {
            return method;
        }
        method = this.findMethod(clazz, string, n, clazz.getDeclaredMethods());
        if (method != null) {
            return method;
        }
        throw new IllegalStateException("No method " + string);
    }

    public Method findMethod(Class clazz, String string, int n, Method[] methodArray) throws Exception {
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string) || n != -1 && methodArray[i].getParameterTypes().length != n) continue;
            return methodArray[i];
        }
        return null;
    }

    public Object get(Class clazz, String string) throws Exception {
        return clazz.getField(string).get(null);
    }

    public Object get(Object object, String string) throws Exception {
        if (object instanceof Class) {
            return ((Class)object).getField(string).get(null);
        }
        return object.getClass().getField(string).get(object);
    }

    public void set(Class clazz, String string, Object object) throws Exception {
        clazz.getField(string).set(null, object);
    }

    public void set(Object object, String string, Object object2) throws Exception {
        if (object instanceof Class) {
            ((Class)object).getField(string).set(null, object2);
        } else {
            object.getClass().getField(string).set(object, object2);
        }
    }

    public Class[] argsToParams(Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = this.argToParam(objectArray[i]);
        }
        return classArray;
    }

    public Class argToParam(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        return clazz;
    }

    public void verify(boolean bl) {
        if (!bl) {
            throw new RuntimeException("Test failed");
        }
        ++this.verified;
        ++totalVerified;
    }

    public void verifyEq(boolean bl, boolean bl2) {
        if (bl != bl2) {
            throw new RuntimeException("Test failed " + bl + " != " + bl2);
        }
        ++this.verified;
        ++totalVerified;
    }

    public void verifyEq(long l, long l2) {
        if (l != l2) {
            throw new RuntimeException("Test failed " + l + " != " + l2);
        }
        ++this.verified;
        ++totalVerified;
    }

    public void verify(Object object, Object object2) {
        try {
            this.verify(Test.equals(object, object2));
        }
        catch (RuntimeException runtimeException) {
            if (!runtimeException.getMessage().equals("Test failed")) {
                throw runtimeException;
            }
            throw new RuntimeException("Test failed " + object + " != " + object2);
        }
    }

    public static boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public void fail() {
        this.verify(false);
    }

    public static void println(Object object) {
        System.out.println(object);
    }

    public static void verbose(Object object) {
        if (verbose) {
            System.out.println(object);
        }
    }

    public static File temp() {
        temp.mkdirs();
        return temp;
    }

    static boolean runTest(String string) {
        try {
            Class<?> clazz = Class.forName("fanx.test." + string);
            Test test = (Test)clazz.newInstance();
            test.testName = string;
            if (test.skip()) {
                Test.println("-- Skip: sys::" + string + " [skip]");
            } else {
                Test.println("-- Run:  sys::" + string + "...");
                test.run();
                Test.println("   Pass: sys::" + string + " [" + test.verified + "]");
            }
            return true;
        }
        catch (Throwable throwable) {
            Test.println("### Failed: " + string);
            throwable.printStackTrace();
            return false;
        }
    }

    public static boolean test(String string) {
        temp = new File("temp");
        if (string == null) {
            string = "";
        }
        boolean bl = true;
        int n = 0;
        for (int i = 0; i < tests.length; ++i) {
            if (!tests[i].startsWith(string)) continue;
            ++n;
            if (Test.runTest(tests[i])) continue;
            bl = false;
        }
        try {
            FileUtil.delete(temp);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }
}

