/*
 * Decompiled with CFR 0.152.
 */
package fanx.util;

import fan.sys.ArgErr;
import fan.sys.Duration;
import fan.sys.Env;
import fan.sys.File;
import fan.sys.InStream;
import fan.sys.List;
import fan.sys.Map;
import fan.sys.Pod;
import fan.sys.Sys;
import fan.sys.Uri;
import java.util.HashMap;

public class EnvProps {
    private final Env env;
    private final HashMap cache = new HashMap();

    public EnvProps(Env env) {
        this.env = env;
    }

    public synchronized Map get(Pod pod, Uri uri, Duration duration) {
        Key key = new Key(pod, uri);
        CachedProps cachedProps = (CachedProps)this.cache.get(key);
        if (cachedProps == null || Duration.nowTicks() - cachedProps.read > duration.ticks) {
            cachedProps = this.refresh(key, cachedProps);
        }
        return cachedProps.props;
    }

    private CachedProps refresh(Key key, CachedProps cachedProps) {
        List list = this.env.findAllFiles(Uri.fromStr("etc/" + key.pod + "/" + key.uri));
        if (cachedProps != null && !cachedProps.isStale(list)) {
            return cachedProps;
        }
        if (key.uri.isPathAbs()) {
            throw ArgErr.make("Env.props Uri must be relative: " + key.uri);
        }
        cachedProps = new CachedProps(key, list);
        this.cache.put(key, cachedProps);
        return cachedProps;
    }

    static Map readDef(Pod pod, Uri uri) {
        uri = Uri.fromStr(pod.uri() + "/" + uri);
        File file = pod.file(uri, false);
        Map map = Sys.emptyStrStrMap;
        try {
            if (file != null) {
                map = (Map)file.readProps().toImmutable();
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: Cannot load props " + pod + "::" + uri);
            System.out.println("  " + exception);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map read(Map map, Key key, List list) {
        if (list.isEmpty()) {
            return map;
        }
        Map map2 = map.dup();
        for (int i = list.sz() - 1; i >= 0; --i) {
            InStream inStream = ((File)list.get(i)).in();
            try {
                map2.setAll(inStream.readProps());
                continue;
            }
            finally {
                inStream.close();
            }
        }
        return (Map)map2.toImmutable();
    }

    static class CachedProps {
        long read;
        List files;
        long[] modified;
        Map defProps;
        Map props;

        CachedProps(Key key, List list) {
            this.files = list;
            this.modified = new long[list.sz()];
            for (int i = 0; i < list.sz(); ++i) {
                this.modified[i] = ((File)list.get(i)).modified().ticks();
            }
            this.defProps = EnvProps.readDef(key.pod, key.uri);
            this.props = EnvProps.read(this.defProps, key, list);
            this.read = Duration.nowTicks();
        }

        boolean isStale(List list) {
            if (this.files.sz() != list.sz()) {
                return true;
            }
            for (int i = 0; i < list.sz(); ++i) {
                if (this.modified[i] == ((File)list.get(i)).modified().ticks()) continue;
                return true;
            }
            return false;
        }
    }

    static final class Key {
        final Pod pod;
        final Uri uri;

        Key(Pod pod, Uri uri) {
            this.pod = pod;
            this.uri = uri;
        }

        public int hashCode() {
            return this.pod.hashCode() ^ this.uri.hashCode();
        }

        public boolean equals(Object object) {
            Key key = (Key)object;
            return this.pod == key.pod && this.uri.equals(key.uri);
        }
    }
}

