/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.ListenerMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;

public class ListenerSet<E> {
    public static final Executor CALLING_THREAD = ListenerMap.CALLING_THREAD;
    private final ListenerMap<E, E, E> map;
    public final E fire;

    public ListenerSet(Class<E> iface) {
        this(iface, CALLING_THREAD);
    }

    public ListenerSet(Class<E> iface, Executor executor) {
        this.map = new ListenerMap<E, E, E>(iface, executor){

            @Override
            protected Map<E, ListenerMap.ListenerEntry<? extends E>> createMap() {
                return ListenerSet.this.createMap();
            }
        };
        this.fire = this.map.fire;
    }

    public String toString() {
        return this.map.toString();
    }

    protected Map<E, ListenerMap.ListenerEntry<? extends E>> createMap() {
        return new WeakHashMap();
    }

    public <T extends E> T fire(Class<T> ext) {
        return this.map.fire(ext);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean add(E e) {
        return this.map.put(e, e) != e;
    }

    public void addAll(ListenerSet<? extends E> c) {
        this.map.putAll(c.map);
    }

    public boolean remove(E e) {
        return this.map.remove(e) == e;
    }

    public void clear() {
        this.map.clear();
    }
}

