/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.ParsingIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.SymbolParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.util.NoSuchElementException;

class MsSymbolIterator
implements ParsingIterator<AbstractMsSymbol> {
    private AbstractPdb pdb;
    private PdbByteReader reader;
    private AbstractMsSymbol currentSymbol = null;

    public MsSymbolIterator(AbstractPdb pdb, PdbByteReader reader) throws CancelledException {
        this.pdb = pdb;
        this.reader = reader;
    }

    @Override
    public boolean hasNext() throws CancelledException {
        if (this.currentSymbol == null) {
            this.find();
        }
        return this.currentSymbol != null;
    }

    @Override
    public AbstractMsSymbol next() throws CancelledException, NoSuchElementException {
        if (this.hasNext()) {
            AbstractMsSymbol returnSymbol = this.currentSymbol;
            this.currentSymbol = null;
            return returnSymbol;
        }
        throw new NoSuchElementException("next() called with no more elements");
    }

    @Override
    public AbstractMsSymbol peek() throws CancelledException, NoSuchElementException {
        if (this.hasNext()) {
            return this.currentSymbol;
        }
        throw new NoSuchElementException("peek() called with no more elements");
    }

    private void find() throws CancelledException {
        if (!this.reader.hasMore()) {
            this.currentSymbol = null;
            return;
        }
        try {
            this.currentSymbol = SymbolParser.parseLengthAndSymbol(this.pdb, this.reader);
        }
        catch (PdbException e) {
            Msg.error((Object)this, (Object)"Problem seen in find()", (Throwable)e);
            this.currentSymbol = null;
        }
    }
}

