/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;

public class SegmentMapDescription {
    private int flags;
    private int ovl;
    private int group;
    private int frame;
    private int segNameIndex;
    private int classNameIndex;
    private long segOffset;
    private long segLength;

    public int getFlags() {
        return this.flags;
    }

    public int getOvl() {
        return this.ovl;
    }

    public int getGroup() {
        return this.group;
    }

    public int getFrame() {
        return this.frame;
    }

    public int getSegNameIndex() {
        return this.segNameIndex;
    }

    public int getClassNameIndex() {
        return this.classNameIndex;
    }

    public long getOffset() {
        return this.segOffset;
    }

    public long getSegmentOffset() {
        return this.segOffset;
    }

    public long getLength() {
        return this.segLength;
    }

    void deserialize(PdbByteReader substreamReader) throws PdbException {
        this.flags = substreamReader.parseUnsignedShortVal();
        this.ovl = substreamReader.parseUnsignedShortVal();
        this.group = substreamReader.parseUnsignedShortVal();
        this.frame = substreamReader.parseUnsignedShortVal();
        this.segNameIndex = substreamReader.parseUnsignedShortVal();
        this.classNameIndex = substreamReader.parseUnsignedShortVal();
        this.segOffset = substreamReader.parseUnsignedIntVal();
        this.segLength = substreamReader.parseUnsignedIntVal();
    }

    public String toString() {
        return this.dump();
    }

    protected String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append("SegmentMapDescription---------------------------------------");
        builder.append("\nflags: ");
        builder.append(String.format("0x%04x", this.flags));
        builder.append("\novl: ");
        builder.append(this.ovl);
        builder.append("\ngroup: ");
        builder.append(this.group);
        builder.append("\nframe: ");
        builder.append(this.frame);
        builder.append("\nsegNameIndex: ");
        builder.append(this.segNameIndex);
        builder.append("; classNameIndex: ");
        builder.append(this.classNameIndex);
        builder.append("; segOffset: ");
        builder.append(this.segOffset);
        builder.append("; segLength: ");
        builder.append(this.segLength);
        builder.append("\nEnd SegmentMapDescription-----------------------------------\n");
        return builder.toString();
    }
}

