/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.Processor;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LanguageName;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCompile2MsSymbol
extends AbstractMsSymbol {
    protected long flags;
    protected LanguageName language;
    protected boolean compiledForEditAndContinue;
    protected boolean notCompiledWithDebugInfo;
    protected boolean compiledWithLinkTimeCodeGeneration;
    protected boolean compiledWithBzalignNoDataAlign;
    protected boolean managedCodeDataPresent;
    protected boolean compiledWithGsBufferSecurityChecks;
    protected boolean compiledWithHotPatch;
    protected boolean convertedWithCvtcil;
    protected boolean microsoftIntermediateLanguageNetModule;
    protected Processor processor;
    protected int frontEndMajorVersionNumber;
    protected int frontEndMinorVersionNumber;
    protected int frontEndBuildVersionNumber;
    protected int backEndMajorVersionNumber;
    protected int backEndMinorVersionNumber;
    protected int backEndBuildVersionNumber;
    protected String compilerVersionString;
    protected List<String> stringList = new ArrayList<String>();

    public AbstractCompile2MsSymbol(AbstractPdb pdb, PdbByteReader reader, StringParseType strType) throws PdbException {
        super(pdb, reader);
        String string;
        this.flags = reader.parseUnsignedIntVal();
        this.processFlags(this.flags);
        this.processor = Processor.fromValue(reader.parseUnsignedShortVal());
        this.frontEndMajorVersionNumber = reader.parseUnsignedShortVal();
        this.frontEndMinorVersionNumber = reader.parseUnsignedShortVal();
        this.frontEndBuildVersionNumber = reader.parseUnsignedShortVal();
        this.backEndMajorVersionNumber = reader.parseUnsignedShortVal();
        this.backEndMinorVersionNumber = reader.parseUnsignedShortVal();
        this.backEndBuildVersionNumber = reader.parseUnsignedShortVal();
        this.compilerVersionString = reader.parseString(pdb, strType);
        while (reader.hasMore() && !(string = reader.parseString(pdb, StringParseType.StringUtf8Nt)).isEmpty()) {
            this.stringList.add(string);
        }
        reader.align4();
        pdb.setTargetProcessor(this.processor);
    }

    public long getFlags() {
        return this.flags;
    }

    public String getLanguage() {
        return this.language.toString();
    }

    public boolean isCompiledForEditAndContinue() {
        return this.compiledForEditAndContinue;
    }

    public boolean isNotCompiledWithDebugInfo() {
        return this.notCompiledWithDebugInfo;
    }

    public boolean isCompiledWithLinkTimeCodeGeneration() {
        return this.compiledWithLinkTimeCodeGeneration;
    }

    public boolean isCompiledWithBzalignNoDataAlign() {
        return this.compiledWithBzalignNoDataAlign;
    }

    public boolean isManagedCodeDataPresent() {
        return this.managedCodeDataPresent;
    }

    public boolean isCompiledWithGsBufferSecurityChecks() {
        return this.compiledWithGsBufferSecurityChecks;
    }

    public boolean isCompiledWithHotPatch() {
        return this.compiledWithHotPatch;
    }

    public boolean isConvertedWithCvtcil() {
        return this.convertedWithCvtcil;
    }

    public boolean isMicrosoftIntermediateLanguageNetModule() {
        return this.microsoftIntermediateLanguageNetModule;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public int getFrontEndMajorVersionNumber() {
        return this.frontEndMajorVersionNumber;
    }

    public int getFrontEndMinorVersionNumber() {
        return this.frontEndMinorVersionNumber;
    }

    public int getFrontEndBuildVersionNumber() {
        return this.frontEndBuildVersionNumber;
    }

    public int getBackEndMajorVersionNumber() {
        return this.backEndMajorVersionNumber;
    }

    public int getBackEndMinorVersionNumber() {
        return this.backEndMinorVersionNumber;
    }

    public int getBackEndBuildVersionNumber() {
        return this.backEndBuildVersionNumber;
    }

    public String getCompilerVersionString() {
        return this.compilerVersionString;
    }

    public List<String> getStringList() {
        return this.stringList;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(":\n   Language: ");
        builder.append(this.language.toString());
        builder.append("\n   Target Processor: ");
        builder.append(this.processor.toString());
        builder.append("\n   Compiled for edit and continue: " + (this.compiledForEditAndContinue ? "yes" : "no"));
        builder.append("\n   Compiled without debugging info: " + (this.notCompiledWithDebugInfo ? "yes" : "no"));
        builder.append("\n   Compiled with LTCG: " + (this.compiledWithLinkTimeCodeGeneration ? "yes" : "no"));
        builder.append("\n   Compiled with /bzalign: " + (this.compiledWithBzalignNoDataAlign ? "yes" : "no"));
        builder.append("\n   Managed code present: " + (this.managedCodeDataPresent ? "yes" : "no"));
        builder.append("\n   Compiled with /GS: " + (this.compiledWithGsBufferSecurityChecks ? "yes" : "no"));
        builder.append("\n   Compiled with /hotpatch: " + (this.compiledWithHotPatch ? "yes" : "no"));
        builder.append("\n   Converted by CVTCIL: " + (this.convertedWithCvtcil ? "yes" : "no"));
        builder.append("\n   Microsoft Intermediate Language Module: " + (this.microsoftIntermediateLanguageNetModule ? "yes" : "no"));
        builder.append(String.format("\n   Frontend Version: Major = %d, Minor = %d, Build = %d", this.frontEndMajorVersionNumber, this.frontEndMinorVersionNumber, this.frontEndBuildVersionNumber));
        builder.append(String.format("\n   Backend Version: Major = %d, Minor = %d, Build = %d", this.backEndMajorVersionNumber, this.backEndMinorVersionNumber, this.backEndBuildVersionNumber));
        builder.append("\n   Version String:" + this.compilerVersionString);
        if ((this.stringList.size() & 1) == 1) {
            return;
        }
        builder.append("\nCommand block: \n");
        for (int i = 0; i < this.stringList.size(); i += 2) {
            builder.append(String.format("   %s = '%s'\n", this.stringList.get(i), this.stringList.get(i + 1)));
        }
    }

    protected void processFlags(long flagsIn) {
        this.language = LanguageName.fromValue((int)(flagsIn & 0xFFL));
        this.compiledForEditAndContinue = ((flagsIn >>= 8) & 1L) == 1L;
        this.notCompiledWithDebugInfo = ((flagsIn >>= 1) & 1L) == 1L;
        this.compiledWithLinkTimeCodeGeneration = ((flagsIn >>= 1) & 1L) == 1L;
        this.compiledWithBzalignNoDataAlign = ((flagsIn >>= 1) & 1L) == 1L;
        this.managedCodeDataPresent = ((flagsIn >>= 1) & 1L) == 1L;
        this.compiledWithGsBufferSecurityChecks = ((flagsIn >>= 1) & 1L) == 1L;
        this.compiledWithHotPatch = ((flagsIn >>= 1) & 1L) == 1L;
        this.convertedWithCvtcil = ((flagsIn >>= 1) & 1L) == 1L;
        this.microsoftIntermediateLanguageNetModule = ((flagsIn >>= 1) & 1L) == 1L;
    }
}

