/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import docking.widgets.table.GTableTextCellEditor;
import ghidra.app.plugin.core.debug.gui.model.AbstractQueryTablePanel;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.framework.plugintool.Plugin;
import ghidra.trace.model.target.TraceObject;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class ObjectsTablePanel
extends AbstractQueryTablePanel<ObjectTableModel.ValueRow, ObjectTableModel> {
    public ObjectsTablePanel(Plugin plugin) {
        super(plugin);
        this.table.setDefaultEditor(ObjectTableModel.ValueProperty.class, (TableCellEditor)((Object)new PropertyEditor()));
    }

    @Override
    protected ObjectTableModel createModel(Plugin plugin) {
        return new ObjectTableModel(plugin);
    }

    public boolean trySelectAncestor(TraceObject successor) {
        ObjectTableModel.ValueRow row = ((ObjectTableModel)this.tableModel).findTraceObjectAncestor(successor);
        if (row == null) {
            return false;
        }
        this.setSelectedItem(row);
        return true;
    }

    private static class PropertyEditor
    extends GTableTextCellEditor {
        private final JTextField textField = (JTextField)this.getComponent();

        public PropertyEditor() {
            super(new JTextField());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (value instanceof ObjectTableModel.ValueProperty) {
                ObjectTableModel.ValueProperty property = (ObjectTableModel.ValueProperty)value;
                this.textField.setText(property.getDisplay());
            } else {
                this.textField.setText(value.toString());
            }
            return this.textField;
        }

        public Object getCellEditorValue() {
            Object value = super.getCellEditorValue();
            return new ObjectTableModel.ValueFixedProperty<Object>(value);
        }
    }
}

