/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import generic.Span;
import ghidra.app.plugin.core.bookmark.BookmarkNavigator;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.stack.AbstractUnwoundFrame;
import ghidra.app.plugin.core.debug.stack.FrameStructureBuilder;
import ghidra.app.plugin.core.debug.stack.SavedRegisterMap;
import ghidra.app.plugin.core.debug.stack.StackUnwinder;
import ghidra.app.plugin.core.debug.stack.UnwindException;
import ghidra.app.plugin.core.debug.stack.UnwindInfo;
import ghidra.app.services.DebuggerControlService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.Structure;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.bookmark.TraceBookmark;
import ghidra.trace.model.bookmark.TraceBookmarkManager;
import ghidra.trace.model.bookmark.TraceBookmarkType;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.symbol.TraceReferenceManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;

public class AnalysisUnwoundFrame<T>
extends AbstractUnwoundFrame<T> {
    private final StackUnwinder unwinder;
    private final int level;
    private final Address pcVal;
    private final Address spVal;
    private final UnwindInfo info;
    private final UnwindException infoErr;
    private final SavedRegisterMap registerMap;
    private final Address base;

    AnalysisUnwoundFrame(PluginTool tool, DebuggerCoordinates coordinates, StackUnwinder unwinder, PcodeExecutorState<T> state, int level, Address pcVal, Address spVal, UnwindInfo info, UnwindException infoErr, SavedRegisterMap registerMap) {
        super(tool, coordinates, state);
        if (info == null == (infoErr == null)) {
            throw new AssertionError();
        }
        this.unwinder = unwinder;
        this.level = level;
        this.pcVal = pcVal;
        this.spVal = spVal;
        this.info = info;
        this.infoErr = infoErr;
        this.registerMap = registerMap;
        this.base = info != null ? info.computeBase(spVal) : null;
    }

    @Override
    public boolean isFake() {
        return false;
    }

    public AnalysisUnwoundFrame<T> unwindNext(TaskMonitor monitor) throws CancelledException {
        if (this.info == null || this.info.ofReturn() == null) {
            throw new NoSuchElementException();
        }
        SavedRegisterMap registerMap = this.registerMap.fork();
        this.info.mapSavedRegisters(this.base, registerMap);
        Address pcVal = this.info.computeNextPc(this.base, this.state, this.codeSpace, this.pc);
        Address spVal = this.info.computeNextSp(this.base);
        return this.unwinder.unwind(this.coordinates, this.level + 1, pcVal, spVal, this.state, registerMap, monitor);
    }

    @Override
    protected Address applyBase(long offset) {
        if (this.base == null) {
            throw new UnwindException("Cannot compute stack address for offset " + offset, this.infoErr);
        }
        return this.base.add(offset);
    }

    @Override
    protected SavedRegisterMap computeRegisterMap() {
        return this.registerMap;
    }

    @Override
    protected Address computeAddressOfReturnAddress() {
        return this.info.ofReturn(this.base);
    }

    @Override
    public Address getReturnAddress() {
        return this.info.computeNextPc(this.base, this.state, this.codeSpace, this.pc);
    }

    @Override
    public CompletableFuture<Void> setReturnAddress(DebuggerControlService.StateEditor editor, Address addr) {
        if (addr.getAddressSpace() != this.codeSpace) {
            throw new IllegalArgumentException("Return address must be in " + this.codeSpace);
        }
        BytesPcodeArithmetic bytesArithmetic = BytesPcodeArithmetic.forLanguage((Language)this.language);
        byte[] bytes = (byte[])bytesArithmetic.fromConst(addr.getOffset(), this.pc.getNumBytes());
        return editor.setVariable(this.info.ofReturn(this.base), bytes);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public String getDescription() {
        return String.format("%s %s pc=%s sp=%s base=%s", this.level, this.info.function(), this.pcVal.toString(false), this.spVal.toString(false), this.base.toString(false));
    }

    @Override
    public Address getBasePointer() {
        return this.base;
    }

    @Override
    public Address getProgramCounter() {
        return this.pcVal;
    }

    public Address getStackPointer() {
        return this.spVal;
    }

    @Override
    public Function getFunction() {
        return this.info.function();
    }

    protected Structure generateStructure(int prevParamSize) {
        FrameStructureBuilder builder = new FrameStructureBuilder(this.language, this.pcVal, this.info, prevParamSize);
        return builder.build(StackUnwinder.FRAMES_PATH, "frame_" + this.pcVal.toString(false), this.trace.getDataTypeManager());
    }

    public Structure resolveStructure(int prevParamSize) {
        Structure structure = this.generateStructure(prevParamSize);
        return structure == null ? null : (Structure)this.trace.getDataTypeManager().addType((DataType)structure, DataTypeConflictHandler.DEFAULT_HANDLER);
    }

    protected TraceBookmarkType getWarningBookmarkType() {
        TraceBookmarkType type = this.trace.getBookmarkManager().getBookmarkType("Warning");
        if (type != null) {
            return type;
        }
        BookmarkNavigator.defineBookmarkTypes((Program)this.trace.getProgramView());
        return this.trace.getBookmarkManager().getBookmarkType("Warning");
    }

    protected static void truncateOrDelete(TraceBookmark tb, Lifespan remove) {
        List newLifespan = tb.getLifespan().subtract((Span)remove);
        if (newLifespan.isEmpty()) {
            tb.delete();
        } else {
            tb.setLifespan((Lifespan)newLifespan.get(0));
        }
    }

    public TraceData applyToListing(int prevParamSize, TaskMonitor monitor) throws CancelledException {
        Address spPlusParams = this.spVal.add((long)prevParamSize);
        TraceBookmarkManager bm = this.trace.getBookmarkManager();
        TraceBookmarkType btWarn = this.getWarningBookmarkType();
        Lifespan span = Lifespan.nowOnMaybeScratch((long)this.viewSnap);
        String warnings = this.info.warnings().summarize();
        Structure structure = this.resolveStructure(prevParamSize);
        if (structure == null || structure.isZeroLength()) {
            for (TraceBookmark existing : bm.getBookmarksAt(this.viewSnap, spPlusParams)) {
                AnalysisUnwoundFrame.truncateOrDelete(existing, span);
            }
            bm.addBookmark(span, spPlusParams, btWarn, "Stack Unwind", "Frame " + this.level + " has lenght 0");
            return null;
        }
        for (TraceBookmark existing : bm.getBookmarksIntersecting(span, (AddressRange)new AddressRangeImpl(spPlusParams, spPlusParams.add((long)(structure.getLength() - 1))))) {
            AnalysisUnwoundFrame.truncateOrDelete(existing, span);
        }
        if (!warnings.isBlank()) {
            bm.addBookmark(span, spPlusParams, btWarn, "Unwind Stack", warnings);
        }
        try {
            this.trace.getCodeManager().definedUnits().clear(Lifespan.at((long)this.viewSnap), (AddressRange)new AddressRangeImpl(spPlusParams, spPlusParams.add((long)(structure.getLength() - 1))), false, monitor);
            TraceData frame = this.trace.getCodeManager().definedData().create(span, spPlusParams, (DataType)structure);
            frame.setComment(1, this.getDescription());
            TraceReferenceManager refs = this.trace.getReferenceManager();
            refs.clearReferencesFrom(span, frame.getRange());
            refs.clearReferencesTo(span, frame.getRange());
            frame.addOperandReference(0, this.base, RefType.DATA, SourceType.ANALYSIS);
            refs.addMemoryReference(span, this.pcVal, spPlusParams, RefType.DATA, SourceType.ANALYSIS, -1);
            return frame;
        }
        catch (CodeUnitInsertionException e) {
            throw new AssertionError((Object)e);
        }
    }

    public UnwindInfo getUnwindInfo() {
        return this.info;
    }

    public UnwindException getError() {
        return this.infoErr;
    }

    @Override
    public String getWarnings() {
        if (this.info == null) {
            return "";
        }
        return this.info.warnings().summarize();
    }
}

