/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.StubThemeManager;
import generic.theme.ThemeListener;
import generic.theme.ThemeManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;

public class Gui {
    private static ThemeManager themeManager = new StubThemeManager();

    private Gui() {
    }

    public static Font getFont(String id) {
        return themeManager.getFont(id);
    }

    public static Color getColor(String id) {
        return themeManager.getColor(id);
    }

    public static void addThemeListener(ThemeListener listener) {
        themeManager.addThemeListener(listener);
    }

    public static void removeThemeListener(ThemeListener listener) {
        themeManager.removeThemeListener(listener);
    }

    public static Icon getIcon(String id) {
        return themeManager.getIcon(id);
    }

    public static boolean hasColor(String id) {
        return themeManager.hasColor(id);
    }

    public static boolean hasFont(String id) {
        return themeManager.hasFont(id);
    }

    public static boolean hasIcon(String id) {
        return themeManager.hasIcon(id);
    }

    public static Color darker(Color color) {
        if (Gui.isDarkTheme()) {
            return color.brighter();
        }
        return color.darker();
    }

    public static Color brighter(Color color) {
        if (Gui.isDarkTheme()) {
            return color.darker();
        }
        return color.brighter();
    }

    public static void registerFont(Component component, String fontId) {
        themeManager.registerFont(component, fontId);
    }

    public static boolean isDarkTheme() {
        return themeManager.isDarkTheme();
    }

    public static boolean isSystemId(String id) {
        return id.startsWith("laf.") || id.startsWith("system.");
    }

    static void setThemeManager(ThemeManager manager) {
        themeManager = manager;
    }
}

