/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.evt;

import agent.gdb.manager.GdbState;
import agent.gdb.manager.evt.AbstractGdbEventWithStateChange;
import agent.gdb.manager.impl.GdbStackFrameImpl;
import agent.gdb.manager.impl.GdbThreadImpl;
import agent.gdb.manager.parsing.GdbMiParser;
import agent.gdb.manager.parsing.GdbParsingUtils;

public class GdbStoppedEvent
extends AbstractGdbEventWithStateChange {
    private final Integer tid;

    public GdbStoppedEvent(CharSequence tail) throws GdbParsingUtils.GdbParseError {
        super(tail);
        String tidStr = ((GdbMiParser.GdbMiFieldList)this.getInfo()).getString("thread-id");
        this.tid = tidStr == null ? null : Integer.valueOf(Integer.parseInt(tidStr));
    }

    public Integer getThreadId() {
        return this.tid;
    }

    public GdbStackFrameImpl getFrame(GdbThreadImpl thread) {
        GdbMiParser.GdbMiFieldList fields = ((GdbMiParser.GdbMiFieldList)this.getInfo()).getFieldList("frame");
        return fields == null ? null : GdbStackFrameImpl.fromFieldList(thread, fields);
    }

    public String assumeStoppedThreads() {
        return ((GdbMiParser.GdbMiFieldList)this.getInfo()).getString("stopped-threads");
    }

    @Override
    public GdbState newState() {
        return GdbState.STOPPED;
    }
}

