/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbInferior;
import agent.gdb.manager.GdbState;
import agent.gdb.manager.GdbThread;
import agent.gdb.manager.impl.cmd.GdbStateChangeRecord;
import agent.gdb.manager.reason.GdbBreakpointHitReason;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetBreakpointLocation;
import agent.gdb.model.impl.GdbModelTargetInferior;
import agent.gdb.model.impl.GdbModelTargetThread;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetConfigurable;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.CollectionUtils;
import ghidra.util.Msg;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="ThreadContainer", attributes={@TargetAttributeType(name="_base", type=Integer.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class GdbModelTargetThreadContainer
extends DefaultTargetObject<GdbModelTargetThread, GdbModelTargetInferior>
implements TargetConfigurable {
    public static final String NAME = "Threads";
    protected final GdbModelImpl impl;
    protected final GdbInferior inferior;

    public GdbModelTargetThreadContainer(GdbModelTargetInferior inferior) {
        super((AbstractDebuggerObjectModel)inferior.impl, (TargetObject)inferior, NAME, "ThreadContainer");
        this.impl = inferior.impl;
        this.inferior = inferior.inferior;
        this.changeAttributes(List.of(), Map.of("_base", 10), "Initialized");
    }

    public GdbModelTargetThread threadCreated(GdbThread thread) {
        GdbModelTargetThread targetThread = this.getTargetThread(thread);
        this.changeElements(List.of(), List.of(targetThread), "Created");
        return targetThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadExited(int threadId) {
        GdbModelTargetThreadContainer gdbModelTargetThreadContainer = this;
        synchronized (gdbModelTargetThreadContainer) {
            GdbModelTargetThread targetThread = (GdbModelTargetThread)this.getCachedElements().get(GdbModelTargetThread.indexThread(threadId));
            if (targetThread == null) {
                Msg.error((Object)((Object)this), (Object)("Thread " + threadId + " exited, but was not in model."));
            } else {
                this.impl.deleteModelObject(targetThread.thread);
            }
        }
        this.changeElements(List.of(GdbModelTargetThread.indexThread(threadId)), List.of(), "Exited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUsingThreads(Map<Integer, GdbThread> byTID) {
        List threads;
        GdbModelTargetThreadContainer gdbModelTargetThreadContainer = this;
        synchronized (gdbModelTargetThreadContainer) {
            threads = byTID.values().stream().map(this::getTargetThread).collect(Collectors.toList());
        }
        CollectionUtils.Delta delta = this.setElements(threads, "Refreshed");
        for (GdbModelTargetThread targetThread : delta.removed.values()) {
            this.impl.deleteModelObject(targetThread.thread);
        }
    }

    protected CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        if (!refresh.equals((Object)DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS)) {
            this.updateUsingThreads(this.inferior.getKnownThreads());
            return AsyncUtils.NIL;
        }
        return this.doRefresh();
    }

    protected CompletableFuture<Void> doRefresh() {
        return this.inferior.listThreads().thenAccept(byTID -> this.updateUsingThreads((Map<Integer, GdbThread>)byTID));
    }

    public synchronized GdbModelTargetThread getTargetThread(GdbThread thread) {
        assert (thread.getInferior() == this.inferior);
        TargetObject modelObject = this.impl.getModelObject(thread);
        if (modelObject != null) {
            return (GdbModelTargetThread)modelObject;
        }
        return new GdbModelTargetThread(this, (GdbModelTargetInferior)this.parent, thread);
    }

    public synchronized GdbModelTargetThread getTargetThreadIfPresent(GdbThread thread) {
        return (GdbModelTargetThread)this.impl.getModelObject(thread);
    }

    protected void invalidateRegisterCaches() {
        for (GdbThread thread : this.inferior.getKnownThreads().values()) {
            GdbModelTargetThread targetThread = (GdbModelTargetThread)this.impl.getModelObject(thread);
            if (targetThread == null) continue;
            targetThread.invalidateRegisterCaches();
        }
    }

    public CompletableFuture<Void> stateChanged(GdbStateChangeRecord sco) {
        if (sco.getState() != GdbState.STOPPED) {
            return this.updateThreadStates(sco);
        }
        return ((CompletableFuture)this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER).thenCompose(__ -> this.updateThreadStates(sco))).exceptionally(__ -> {
            Msg.error((Object)((Object)this), (Object)("Could not update threads " + this + " on STOPPED"));
            return null;
        });
    }

    protected CompletableFuture<Void> updateThreadStates(GdbStateChangeRecord sco) {
        AsyncFence fence = new AsyncFence();
        for (GdbThread thread : this.inferior.getKnownThreads().values()) {
            GdbModelTargetThread targetThread = (GdbModelTargetThread)this.impl.getModelObject(thread);
            if (targetThread == null) continue;
            fence.include(targetThread.stateChanged(sco));
        }
        return fence.ready();
    }

    public GdbModelTargetBreakpointLocation breakpointHit(GdbBreakpointHitReason reason) {
        GdbThread thread = this.impl.gdb.getThread(reason.getThreadId());
        return this.getTargetThread(thread).breakpointHit(reason);
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        switch (key) {
            case "_base": {
                if (value instanceof Integer) {
                    this.changeAttributes(List.of(), Map.of("_base", value), "Modified");
                    for (GdbModelTargetThread child : this.getCachedElements().values()) {
                        child.setBase(value);
                    }
                    break;
                }
                throw new DebuggerIllegalArgumentException("Base should be numeric");
            }
        }
        return AsyncUtils.NIL;
    }

    protected CompletableFuture<?> refreshInternal() {
        return this.doRefresh().exceptionally(ex -> {
            this.impl.reportError((Object)this, "Problem refreshing inferior's threads", (Throwable)ex);
            return null;
        });
    }
}

