/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.pty;

import agent.gdb.pty.Pty;
import agent.gdb.pty.linux.LinuxPtyFactory;
import agent.gdb.pty.macos.MacosPtyFactory;
import agent.gdb.pty.windows.ConPtyFactory;
import ghidra.framework.OperatingSystem;
import java.io.IOException;

public interface PtyFactory {
    public static PtyFactory local() {
        switch (OperatingSystem.CURRENT_OPERATING_SYSTEM) {
            case MAC_OS_X: {
                return new MacosPtyFactory();
            }
            case LINUX: {
                return new LinuxPtyFactory();
            }
            case WINDOWS: {
                return new ConPtyFactory();
            }
        }
        throw new UnsupportedOperationException();
    }

    public Pty openpty() throws IOException;

    public String getDescription();
}

