/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.GhidraFile;
import ghidra.framework.data.GhidraFolder;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.data.LinkedGhidraFolder;
import ghidra.framework.data.NullFolderDomainObject;
import ghidra.framework.data.URLLinkObject;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.store.FileSystem;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;

public class FolderLinkContentHandler
extends LinkHandler<NullFolderDomainObject> {
    public static FolderLinkContentHandler INSTANCE = new FolderLinkContentHandler();
    public static final String FOLDER_LINK_CONTENT_TYPE = "FolderLink";

    @Override
    public long createFile(FileSystem fs, FileSystem userfs, String path, String name, DomainObject obj, TaskMonitor monitor) throws IOException, InvalidNameException, CancelledException {
        if (!(obj instanceof URLLinkObject)) {
            throw new IOException("Unsupported domain object: " + obj.getClass().getName());
        }
        return this.createFile((URLLinkObject)obj, FOLDER_LINK_CONTENT_TYPE, fs, path, name, monitor);
    }

    @Override
    public String getContentType() {
        return FOLDER_LINK_CONTENT_TYPE;
    }

    @Override
    public String getContentTypeDisplayString() {
        return FOLDER_LINK_CONTENT_TYPE;
    }

    @Override
    public Class<NullFolderDomainObject> getDomainObjectClass() {
        return NullFolderDomainObject.class;
    }

    @Override
    public Icon getIcon() {
        return DomainFolder.CLOSED_FOLDER_ICON;
    }

    @Override
    public String getDefaultToolName() {
        return null;
    }

    public static LinkedGhidraFolder getReadOnlyLinkedFolder(DomainFile folderLinkFile) throws IOException {
        if (!FOLDER_LINK_CONTENT_TYPE.equals(folderLinkFile.getContentType())) {
            return null;
        }
        URL url = FolderLinkContentHandler.getURL(folderLinkFile);
        Project activeProject = AppInfo.getActiveProject();
        GhidraFolder parent = ((GhidraFile)folderLinkFile).getParent();
        return new LinkedGhidraFolder(activeProject, parent, folderLinkFile.getName(), url);
    }
}

