/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.list.ListPanel;
import generic.theme.GThemeDefaults;
import ghidra.framework.ToolUtils;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.SelectPanel;
import ghidra.framework.model.ToolTemplate;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

class ImportGhidraToolsDialog
extends DialogComponentProvider {
    private ListPanel<JCheckBox> listPanel;
    private JPanel mainPanel;
    private GCheckBox[] checkboxes;
    private String[] tools;
    private FrontEndTool tool;
    private boolean cancelled = false;

    ImportGhidraToolsDialog(FrontEndTool tool) {
        super("Import Ghidra Tools", true);
        this.setHelpLocation(new HelpLocation("Tool", "Import Ghidra Tools"));
        this.tool = tool;
        this.mainPanel = this.createPanel();
        this.addWorkPanel(this.mainPanel);
        this.addOKButton();
        this.addCancelButton();
    }

    void showDialog() {
        this.clearStatusText();
        this.loadListData();
        this.tool.showDialog(this);
    }

    protected void okCallback() {
        this.close();
    }

    protected void cancelCallback() {
        this.cancelled = true;
        this.close();
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel availableToolsPanel = new JPanel(new BorderLayout());
        SelectPanel myButtonPanel = new SelectPanel(e -> this.selectAll(), e -> this.deselectAll());
        this.listPanel = new ListPanel();
        this.listPanel.setCellRenderer((ListCellRenderer)new DataCellRenderer());
        this.listPanel.setMouseListener((MouseListener)new ListMouseListener());
        availableToolsPanel.add((Component)myButtonPanel, "East");
        availableToolsPanel.add((Component)this.listPanel, "Center");
        availableToolsPanel.setBorder(new TitledBorder("Available Tools"));
        panel.add((Component)availableToolsPanel, "Center");
        return panel;
    }

    private void selectAll() {
        for (GCheckBox checkboxe : this.checkboxes) {
            checkboxe.setSelected(true);
        }
        this.listPanel.repaint();
    }

    private void deselectAll() {
        for (GCheckBox checkboxe : this.checkboxes) {
            checkboxe.setSelected(false);
        }
        this.listPanel.repaint();
    }

    private void loadListData() {
        Set<ToolTemplate> defaultTools = ToolUtils.getDefaultApplicationTools();
        Set<ToolTemplate> extraTools = ToolUtils.getExtraApplicationTools();
        Stream<String> defaultToolNames = defaultTools.stream().map(ToolTemplate::getPath);
        Stream<String> extraToolNames = extraTools.stream().map(ToolTemplate::getPath);
        int elementCount = defaultTools.size() + extraTools.size();
        this.tools = new String[elementCount];
        this.checkboxes = new GCheckBox[elementCount];
        Iterator itr = defaultToolNames.iterator();
        int count = 0;
        while (itr.hasNext()) {
            this.tools[count] = (String)itr.next();
            this.checkboxes[count] = new GCheckBox(this.tools[count], false);
            this.checkboxes[count].setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
            ++count;
        }
        itr = extraToolNames.iterator();
        while (itr.hasNext()) {
            this.tools[count] = (String)itr.next();
            this.checkboxes[count] = new GCheckBox(this.tools[count], false);
            this.checkboxes[count].setBackground((Color)GThemeDefaults.Colors.Palette.LIGHT_GRAY);
            ++count;
        }
        this.listPanel.refreshList((Object[])this.checkboxes);
    }

    public List<String> getSelectedList() {
        ArrayList<String> ret = new ArrayList<String>();
        for (GCheckBox checkboxe : this.checkboxes) {
            if (!checkboxe.isSelected()) continue;
            ret.add(checkboxe.getText());
        }
        return ret;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private class DataCellRenderer
    implements ListCellRenderer<JCheckBox> {
        private Font boldFont;

        private DataCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JCheckBox> list, JCheckBox value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.boldFont == null) {
                Font font = list.getFont();
                this.boldFont = font.deriveFont(font.getStyle() | 1);
            }
            if (index == -1) {
                int selected = list.getSelectedIndex();
                if (selected == -1) {
                    return null;
                }
                index = selected;
            }
            return ImportGhidraToolsDialog.this.checkboxes[index];
        }
    }

    private class ListMouseListener
    extends MouseAdapter {
        private ListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ImportGhidraToolsDialog.this.clearStatusText();
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            boolean selected = ImportGhidraToolsDialog.this.checkboxes[index].isSelected();
            ImportGhidraToolsDialog.this.checkboxes[index].setSelected(!selected);
            ImportGhidraToolsDialog.this.listPanel.repaint();
        }
    }
}

