/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.list.ListPanel;
import generic.theme.GThemeDefaults;
import ghidra.framework.main.SelectPanel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

public class SaveDataDialog
extends DialogComponentProvider {
    private ListPanel<JCheckBox> listPanel;
    private JPanel mainPanel;
    private GCheckBox[] checkboxes;
    private List<DomainFile> files;
    private boolean[] saveable;
    private JButton yesButton;
    private JButton noButton;
    private PluginTool tool;
    private boolean operationCompleted;

    public SaveDataDialog(PluginTool tool) {
        super("Save Modified Files", true);
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "SaveDataDialog"));
        this.tool = tool;
        this.mainPanel = this.createPanel();
        this.addWorkPanel(this.mainPanel);
        this.yesButton = new JButton("Save");
        this.yesButton.setMnemonic('S');
        this.addButton(this.yesButton);
        this.yesButton.addActionListener(evt -> this.okCallback());
        this.noButton = new JButton("Don't Save");
        this.noButton.setMnemonic('n');
        this.noButton.addActionListener(evt -> {
            this.operationCompleted = true;
            this.close();
        });
        this.addButton(this.noButton);
        this.addCancelButton();
    }

    public boolean showDialog(List<DomainFile> domainFiles) {
        this.clearStatusText();
        this.operationCompleted = false;
        this.files = domainFiles;
        this.initList();
        if (!this.files.isEmpty()) {
            this.tool.showDialog(this);
        } else {
            this.operationCompleted = true;
        }
        return this.operationCompleted;
    }

    protected void okCallback() {
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        for (int i = 0; i < this.checkboxes.length; ++i) {
            if (!this.checkboxes[i].isSelected()) continue;
            list.add(this.files.get(i));
        }
        if (list.size() > 0) {
            DomainFile[] deleteFiles = new DomainFile[list.size()];
            SaveTask task = new SaveTask(list.toArray(deleteFiles));
            new TaskLauncher((Task)task, (Component)this.getComponent());
        } else {
            this.operationCompleted = true;
            this.close();
        }
    }

    protected void cancelCallback() {
        this.close();
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel parentPanel = new JPanel(new BorderLayout());
        SelectPanel myButtonPanel = new SelectPanel(e -> this.selectAll(), e -> this.deselectAll());
        this.listPanel = new ListPanel();
        this.listPanel.setCellRenderer((ListCellRenderer)new DataCellRenderer());
        this.listPanel.setMouseListener((MouseListener)new ListMouseListener());
        parentPanel.add((Component)myButtonPanel, "East");
        parentPanel.add((Component)this.listPanel, "Center");
        parentPanel.setBorder(new TitledBorder("Data"));
        panel.add((Component)parentPanel, "Center");
        return panel;
    }

    private void selectAll() {
        this.clearStatusText();
        for (int i = 0; i < this.checkboxes.length; ++i) {
            if (!this.saveable[i]) continue;
            this.checkboxes[i].setSelected(true);
        }
        this.listPanel.repaint();
    }

    private void deselectAll() {
        this.clearStatusText();
        for (GCheckBox checkboxe : this.checkboxes) {
            checkboxe.setSelected(false);
        }
        this.listPanel.repaint();
    }

    private List<DomainFile> checkForUnsavedFiles(List<DomainFile> domainFiles) {
        ArrayList<DomainFile> unsavedFiles = new ArrayList<DomainFile>();
        for (DomainFile domainFile : domainFiles) {
            if (!domainFile.isChanged()) continue;
            unsavedFiles.add(domainFile);
        }
        return unsavedFiles;
    }

    private void initList() {
        this.files = this.checkForUnsavedFiles(this.files);
        this.checkboxes = new GCheckBox[this.files.size()];
        this.saveable = new boolean[this.files.size()];
        String readOnlyString = " (Read-Only)";
        this.yesButton.setEnabled(false);
        for (int i = 0; i < this.files.size(); ++i) {
            this.checkboxes[i] = new GCheckBox(this.files.get(i).getName());
            this.checkboxes[i].setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
            this.saveable[i] = this.files.get(i).canSave();
            if (!this.saveable[i]) {
                ProjectLocator projectLocator;
                String text = this.files.get(i).getName() + readOnlyString;
                if (!this.files.get(i).isInWritableProject() && (projectLocator = this.files.get(i).getProjectLocator()) != null) {
                    text = this.files.get(i).getName() + " (Read-Only from " + this.files.get(i).getProjectLocator().getName() + ")";
                }
                this.checkboxes[i].setText(text);
                continue;
            }
            this.checkboxes[i].setSelected(true);
            this.yesButton.setEnabled(true);
        }
        this.listPanel.refreshList((Object[])this.checkboxes);
        this.setFocusComponent(this.yesButton);
    }

    private class SaveTask
    extends Task {
        private DomainFile[] domainFiles;

        SaveTask(DomainFile[] files) {
            super(files.length > 1 ? "Saving Files..." : "Saving File", true, true, true);
            this.domainFiles = files;
        }

        public void run(TaskMonitor monitor) {
            try {
                for (DomainFile domainFile : this.domainFiles) {
                    if (monitor.isCancelled()) break;
                    monitor.setProgress(0L);
                    monitor.setMessage("Saving " + domainFile.getName());
                    domainFile.save(monitor);
                }
                SaveDataDialog.this.operationCompleted = !monitor.isCancelled();
            }
            catch (CancelledException cancelledException) {
            }
            catch (Throwable t) {
                Msg.showError((Object)((Object)this), null, (String)"Error Saving Data", (Object)"Unexpected exception saving data!", (Throwable)t);
            }
            if (SaveDataDialog.this.operationCompleted) {
                Swing.runNow(() -> SaveDataDialog.this.close());
            } else if (monitor.isCancelled()) {
                Swing.runNow(() -> SaveDataDialog.this.initList());
            }
        }
    }

    private class DataCellRenderer
    implements ListCellRenderer<JCheckBox> {
        private Font boldFont;

        private DataCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JCheckBox> list, JCheckBox value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.boldFont == null) {
                Font font = list.getFont();
                this.boldFont = font.deriveFont(font.getStyle() | 1);
            }
            if (!SaveDataDialog.this.saveable[index]) {
                SaveDataDialog.this.checkboxes[index].setForeground((Color)GThemeDefaults.Colors.ERROR);
                SaveDataDialog.this.checkboxes[index].setFont(this.boldFont);
            }
            return SaveDataDialog.this.checkboxes[index];
        }
    }

    private class ListMouseListener
    extends MouseAdapter {
        private ListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SaveDataDialog.this.clearStatusText();
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            if (!SaveDataDialog.this.saveable[index]) {
                SaveDataDialog.this.setStatusText(SaveDataDialog.this.files.get(index).getPathname() + " cannot be saved to current location");
                return;
            }
            boolean selected = SaveDataDialog.this.checkboxes[index].isSelected();
            SaveDataDialog.this.checkboxes[index].setSelected(!selected);
            SaveDataDialog.this.listPanel.repaint();
        }
    }
}

