/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DialogComponentProvider;
import docking.ReusableDialogComponentProvider;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.ToolConnectionPanel;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.Workspace;
import ghidra.framework.model.WorkspaceChangeListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;
import javax.swing.JPanel;

class ToolConnectionDialog
extends ReusableDialogComponentProvider
implements WorkspaceChangeListener {
    private ToolManager toolManager;
    private ToolConnectionPanel panel;
    private FrontEndTool frontEndTool;
    private static final String CONNECTALL = "Connect All";
    private static final String DISCONNECTALL = "Disconnect All";
    private JButton connectAllButton;
    private JButton disconnectAllButton;

    ToolConnectionDialog(FrontEndTool tool, ToolManager toolManager) {
        super("Connect Tools", false, true, true, false);
        this.frontEndTool = tool;
        this.toolManager = toolManager;
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Connect_Tools"));
        this.addWorkPanel(this.buildMainPanel());
        this.connectAllButton = new JButton(CONNECTALL);
        this.connectAllButton.addActionListener(ev -> this.connectCallback());
        this.addButton(this.connectAllButton);
        this.disconnectAllButton = new JButton(DISCONNECTALL);
        this.disconnectAllButton.addActionListener(ev -> this.disconnectCallback());
        this.addButton(this.disconnectAllButton);
        this.addOKButton();
        toolManager.addWorkspaceChangeListener(this);
    }

    void setVisible(boolean v) {
        if (v) {
            this.frontEndTool.showDialog((DialogComponentProvider)this);
            this.panel.showData();
            this.setStatusText("Please select an Event Producer");
            this.setConnectAllEnabled(false);
            this.setDisconnectAllEnabled(false);
        } else {
            this.close();
            this.toolManager.removeWorkspaceChangeListener(this);
            this.panel.clear();
        }
    }

    @Override
    public void toolAdded(Workspace ws, PluginTool tool) {
        this.panel.toolAdded(tool);
    }

    @Override
    public void toolRemoved(Workspace ws, PluginTool tool) {
        this.panel.toolRemoved(tool);
    }

    protected void okCallback() {
        this.setVisible(false);
    }

    @Override
    public void workspaceAdded(Workspace ws) {
    }

    @Override
    public void workspaceRemoved(Workspace ws) {
    }

    @Override
    public void workspaceSetActive(Workspace ws) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object eventSource = event.getSource();
        if (eventSource instanceof PluginTool) {
            this.updateDisplay();
        }
    }

    void setToolManager(ToolManager tm) {
        this.toolManager.removeWorkspaceChangeListener(this);
        this.toolManager = tm;
        this.toolManager.addWorkspaceChangeListener(this);
        this.panel.setToolManager(this.toolManager);
    }

    void updateDisplay() {
        this.panel.updateDisplay();
    }

    void setConnectAllEnabled(boolean enabled) {
        this.connectAllButton.setEnabled(enabled);
    }

    void setDisconnectAllEnabled(boolean enabled) {
        this.disconnectAllButton.setEnabled(enabled);
    }

    protected JPanel buildMainPanel() {
        this.panel = new ToolConnectionPanel(this, this.toolManager);
        return this.panel;
    }

    protected void connectCallback() {
        this.panel.connectAll(true);
    }

    protected void disconnectCallback() {
        this.panel.connectAll(false);
    }
}

