/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.bookmark;

import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Bookmark;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.bookmark.DBTraceBookmarkManager;
import ghidra.trace.database.bookmark.DBTraceBookmarkSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.bookmark.TraceBookmark;
import ghidra.trace.model.bookmark.TraceBookmarkType;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceBookmark
extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<DBTraceBookmark>
implements TraceBookmark {
    protected static final String TABLE_NAME = "Bookmarks";
    static final String TYPE_COLUMN_NAME = "Type";
    static final String CATEGORY_COLUMN_NAME = "Category";
    static final String COMMENT_COLUMN_NAME = "Comment";
    @DBAnnotatedColumn(value="Type")
    static DBObjectColumn TYPE_COLUMN;
    @DBAnnotatedColumn(value="Category")
    static DBObjectColumn CATEGORY_COLUMN;
    @DBAnnotatedColumn(value="Comment")
    static DBObjectColumn COMMENT_COLUMN;
    @DBAnnotatedField(column="Type", indexed=true)
    private String typeName;
    @DBAnnotatedField(column="Category")
    private String category;
    @DBAnnotatedField(column="Comment")
    private String comment;
    protected final DBTraceBookmarkSpace space;

    static String tableName(AddressSpace space, long threadKey, int frameLevel) {
        return DBTraceUtils.tableName(TABLE_NAME, space, threadKey, frameLevel);
    }

    public DBTraceBookmark(DBTraceBookmarkSpace space, DBTraceAddressSnapRangePropertyMapTree<DBTraceBookmark, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
        super(tree, store, record);
        this.space = space;
    }

    protected void setRecordValue(DBTraceBookmark value) {
    }

    protected DBTraceBookmark getRecordValue() {
        return this;
    }

    void set(String typeName, String category, String comment) {
        this.typeName = typeName;
        this.category = category;
        this.comment = comment;
        this.update(TYPE_COLUMN, CATEGORY_COLUMN, COMMENT_COLUMN);
    }

    @Override
    public void setLifespan(Lifespan lifespan) {
        this.doSetLifespan(lifespan);
    }

    @Override
    public DBTrace getTrace() {
        return this.space.trace;
    }

    @Override
    public TraceThread getThread() {
        return this.space.getThread();
    }

    public long getId() {
        return DBTraceBookmarkManager.packId(this.key, this.space);
    }

    public Address getAddress() {
        return this.range.getMinAddress();
    }

    @Override
    public TraceBookmarkType getType() {
        return this.space.manager.getOrDefineBookmarkType(this.typeName);
    }

    public String getTypeString() {
        return this.typeName;
    }

    public String getCategory() {
        return this.category;
    }

    public String getComment() {
        return this.comment;
    }

    public void set(String category, String comment) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.category = category;
            this.comment = comment;
            this.update(CATEGORY_COLUMN, COMMENT_COLUMN);
        }
        this.space.trace.setChanged(new TraceChangeRecord<DBTraceBookmark, Void>(Trace.TraceBookmarkChangeType.CHANGED, this.space, this));
    }

    @Override
    public void delete() {
        this.space.bookmarkMapSpace.deleteData(this);
        this.space.trace.setChanged(new TraceChangeRecord<DBTraceBookmark, Void>(Trace.TraceBookmarkChangeType.DELETED, this.space, this));
    }

    public int compareTo(Bookmark o) {
        if (!(o instanceof TraceBookmark)) {
            throw new IllegalArgumentException("Can compare only to another " + TraceBookmark.class.getSimpleName());
        }
        TraceBookmark that = (TraceBookmark)o;
        int result = this.getLifespan().compareTo(that.getLifespan());
        if (result != 0) {
            return result;
        }
        result = this.getAddress().compareTo((Object)that.getAddress());
        if (result != 0) {
            return result;
        }
        result = this.getTypeString().compareTo(that.getTypeString());
        if (result != 0) {
            return result;
        }
        result = this.getComment().compareTo(that.getComment());
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        return "<TraceBookmark: " + this.typeName + "(" + this.category + "): " + this.comment + ">";
    }
}

