/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.breakpoint;

import db.DBHandle;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.breakpoint.DBTraceBreakpoint;
import ghidra.trace.database.breakpoint.DBTraceBreakpointManager;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceSpaceBased;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceBreakpointSpace
implements DBTraceSpaceBased {
    protected final DBTraceBreakpointManager manager;
    protected final DBHandle dbh;
    protected final AddressSpace space;
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBTraceAddressSnapRangePropertyMapSpace<DBTraceBreakpoint, DBTraceBreakpoint> breakpointMapSpace;
    protected final DBCachedObjectIndex<String, DBTraceBreakpoint> breakpointsByPath;
    protected final Collection<TraceBreakpoint> breakpointView;

    public DBTraceBreakpointSpace(DBTraceBreakpointManager manager, DBHandle dbh, AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        this.manager = manager;
        this.dbh = dbh;
        this.space = space;
        this.lock = manager.getLock();
        this.trace = manager.getTrace();
        DBCachedObjectStoreFactory factory = this.trace.getStoreFactory();
        long threadKey = ent.getThreadKey();
        assert (threadKey == -1L);
        this.breakpointMapSpace = new DBTraceAddressSnapRangePropertyMapSpace(DBTraceBreakpoint.tableName(space, threadKey), factory, this.lock, space, null, 0, DBTraceBreakpoint.class, (t, s, r) -> new DBTraceBreakpoint(this, t, s, r));
        this.breakpointsByPath = this.breakpointMapSpace.getUserIndex(String.class, DBTraceBreakpoint.PATH_COLUMN);
        this.breakpointView = Collections.unmodifiableCollection(this.breakpointMapSpace.values());
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.space;
    }

    @Override
    public DBTraceThread getThread() {
        return null;
    }

    @Override
    public int getFrameLevel() {
        return 0;
    }

    protected DBTraceBreakpoint addBreakpoint(String path, Lifespan lifespan, AddressRange range, Collection<TraceThread> threads, Collection<TraceBreakpointKind> kinds, boolean enabled, String comment) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceThreadManager threadManager = this.trace.getThreadManager();
            for (TraceThread t : threads) {
                threadManager.assertIsMine(t);
            }
            DBTraceBreakpoint breakpoint = this.breakpointMapSpace.put(new ImmutableTraceAddressSnapRange(range, lifespan), null);
            breakpoint.set(path, path, threads, kinds, enabled, true, comment);
            this.trace.setChanged(new TraceChangeRecord(Trace.TraceBreakpointChangeType.ADDED, this, breakpoint));
            DBTraceBreakpoint dBTraceBreakpoint = breakpoint;
            return dBTraceBreakpoint;
        }
    }

    public Collection<? extends DBTraceBreakpoint> getAllBreakpoints() {
        return this.breakpointMapSpace.values();
    }

    public Collection<? extends DBTraceBreakpoint> getBreakpointsByPath(String name) {
        return Collections.unmodifiableCollection(this.breakpointsByPath.get((Object)name));
    }

    public Collection<? extends DBTraceBreakpoint> getBreakpointsAt(long snap, Address address) {
        return Collections.unmodifiableCollection(this.breakpointMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).values());
    }

    public Collection<? extends DBTraceBreakpoint> getBreakpointsIntersecting(Lifespan span, AddressRange range) {
        return Collections.unmodifiableCollection(this.breakpointMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).orderedValues());
    }

    public void deleteBreakpoint(DBTraceBreakpoint breakpoint) {
        this.breakpointMapSpace.deleteData(breakpoint);
        this.trace.setChanged(new TraceChangeRecord(Trace.TraceBreakpointChangeType.DELETED, this, breakpoint));
    }

    @Override
    public void invalidateCache() {
        this.breakpointMapSpace.invalidateCache();
    }
}

