/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target.visitors;

import ghidra.trace.database.target.visitors.TreeTraversal;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import java.util.stream.Stream;

public enum AllPathsVisitor implements TreeTraversal.SpanIntersectingVisitor
{
    INSTANCE;


    @Override
    public TraceObjectValPath composePath(TraceObjectValPath pre, TraceObjectValue value) {
        return pre.prepend(value);
    }

    @Override
    public TreeTraversal.VisitResult visitValue(TraceObjectValue value, TraceObjectValPath path) {
        if (value.getParent() == null) {
            return TreeTraversal.VisitResult.EXCLUDE_PRUNE;
        }
        if (value.getParent().isRoot()) {
            return TreeTraversal.VisitResult.INCLUDE_DESCEND;
        }
        return TreeTraversal.VisitResult.EXCLUDE_DESCEND;
    }

    @Override
    public TraceObject continueObject(TraceObjectValue value) {
        return value.getParent();
    }

    @Override
    public Stream<? extends TraceObjectValue> continueValues(TraceObject object, Lifespan span, TraceObjectValPath path) {
        return object.getParents().stream().filter(v -> !path.contains((TraceObjectValue)v));
    }
}

