/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target.visitors;

import ghidra.trace.model.Lifespan;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import java.util.stream.Stream;

public enum TreeTraversal {
    INSTANCE;


    public Stream<? extends TraceObjectValPath> walkValue(Visitor visitor, TraceObjectValue value, Lifespan span, TraceObjectValPath path) {
        Lifespan compSpan = visitor.composeSpan(span, value);
        if (compSpan == null) {
            return Stream.empty();
        }
        TraceObjectValPath compPath = visitor.composePath(path, value);
        if (compPath == null) {
            return Stream.empty();
        }
        switch (visitor.visitValue(value, compPath)) {
            case INCLUDE_PRUNE: {
                return Stream.of(compPath);
            }
            case EXCLUDE_PRUNE: {
                return Stream.empty();
            }
            case INCLUDE_DESCEND: {
                TraceObject object = visitor.continueObject(value);
                return Stream.concat(Stream.of(compPath), this.walkObject(visitor, object, compSpan, compPath));
            }
            case EXCLUDE_DESCEND: {
                TraceObject object = visitor.continueObject(value);
                return this.walkObject(visitor, object, compSpan, compPath);
            }
        }
        throw new AssertionError();
    }

    public Stream<? extends TraceObjectValPath> walkObject(Visitor visitor, TraceObject object, Lifespan span, TraceObjectValPath path) {
        return visitor.continueValues(object, span, path).flatMap(v -> this.walkValue(visitor, (TraceObjectValue)v, span, path));
    }

    public static interface Visitor {
        public Lifespan composeSpan(Lifespan var1, TraceObjectValue var2);

        public TraceObjectValPath composePath(TraceObjectValPath var1, TraceObjectValue var2);

        public VisitResult visitValue(TraceObjectValue var1, TraceObjectValPath var2);

        public TraceObject continueObject(TraceObjectValue var1);

        public Stream<? extends TraceObjectValue> continueValues(TraceObject var1, Lifespan var2, TraceObjectValPath var3);
    }

    public static enum VisitResult {
        INCLUDE_DESCEND,
        INCLUDE_PRUNE,
        EXCLUDE_DESCEND,
        EXCLUDE_PRUNE;


        public static VisitResult result(boolean include, boolean cont) {
            if (include) {
                if (cont) {
                    return INCLUDE_DESCEND;
                }
                return INCLUDE_PRUNE;
            }
            if (cont) {
                return EXCLUDE_DESCEND;
            }
            return EXCLUDE_PRUNE;
        }
    }

    public static interface SpanIntersectingVisitor
    extends Visitor {
        @Override
        default public Lifespan composeSpan(Lifespan pre, TraceObjectValue value) {
            Lifespan span = (Lifespan)pre.intersect(value.getLifespan());
            return span.isEmpty() ? null : span;
        }
    }
}

