/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugProcessInfo;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.dbgeng.DebugThreadInfo;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgProcessCreatedEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import ghidra.comm.util.BitmaskSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DbgLaunchProcessCommand
extends AbstractDbgCommand<DbgThread> {
    private DbgProcessCreatedEvent created = null;
    private boolean completed = false;
    private List<String> args;
    private String initialDirectory;
    private String environment;
    private BitmaskSet<DebugClient.DebugCreateFlags> createFlags;
    private BitmaskSet<DebugClient.DebugEngCreateFlags> engCreateFlags;
    private BitmaskSet<DebugClient.DebugVerifierFlags> verifierFlags;

    public DbgLaunchProcessCommand(DbgManagerImpl manager, List<String> args, String initialDirectory, String environment, BitmaskSet<DebugClient.DebugCreateFlags> createFlags, BitmaskSet<DebugClient.DebugEngCreateFlags> engCreateFlags, BitmaskSet<DebugClient.DebugVerifierFlags> verifierFlags) {
        super(manager);
        this.args = args;
        this.initialDirectory = initialDirectory;
        this.environment = environment;
        this.createFlags = createFlags;
        this.engCreateFlags = engCreateFlags;
        this.verifierFlags = verifierFlags;
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            this.completed = true;
        } else if (evt instanceof DbgProcessCreatedEvent) {
            this.created = (DbgProcessCreatedEvent)evt;
        }
        return this.completed && this.created != null;
    }

    @Override
    public DbgThread complete(DbgPendingCommand<?> pending) {
        DebugProcessInfo info = (DebugProcessInfo)this.created.getInfo();
        DebugThreadInfo tinfo = info.initialThreadInfo;
        DebugSystemObjects so = this.manager.getSystemObjects();
        DebugThreadId tid = so.getThreadIdByHandle(tinfo.handle);
        return this.manager.getThread(tid);
    }

    @Override
    public void invoke() {
        DebugClient dbgeng = this.manager.getClient();
        ArrayList<String> newArgs = new ArrayList<String>();
        for (String arg : this.args) {
            newArgs.add(this.fixPath(arg));
        }
        this.initialDirectory = this.fixPath(this.initialDirectory);
        this.environment = this.fixPath(this.environment);
        dbgeng.createProcess(dbgeng.getLocalServer(), StringUtils.join(newArgs, (String)" "), this.initialDirectory, this.environment, this.createFlags, this.engCreateFlags, this.verifierFlags);
        this.manager.waitForEventEx();
    }

    private String fixPath(String input) {
        if (input == null || input.equals("")) {
            return null;
        }
        String output = input;
        if (input.startsWith("/")) {
            output = output.substring(1);
        }
        output = output.replace("/", "\\");
        output = output.replace("\\0", "\u0000");
        return output;
    }
}

