/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgConsoleOutputEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import java.math.BigInteger;

public class DbgSetActiveProcessCommand
extends AbstractDbgCommand<Void> {
    private DbgProcessImpl process;
    private Long offset;

    public DbgSetActiveProcessCommand(DbgManagerImpl manager, DbgProcess process) {
        super(manager);
        this.process = (DbgProcessImpl)process;
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            return true;
        }
        if (evt instanceof DbgConsoleOutputEvent) {
            pending.steal(evt);
        }
        return false;
    }

    @Override
    public Void complete(DbgPendingCommand<?> pending) {
        StringBuilder builder = new StringBuilder();
        for (DbgConsoleOutputEvent out : pending.findAllOf(DbgConsoleOutputEvent.class)) {
            builder.append(out.getOutput());
        }
        this.parse(builder.toString());
        if (this.offset != null) {
            this.manager.getSystemObjects().setImplicitThreadDataOffset(this.offset);
        }
        return null;
    }

    private void parse(String result) {
        String[] lines = result.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!line.contains("PROCESS")) continue;
            String[] fields = line.trim().split("\\s+");
            if (fields.length <= 1 || !fields[0].equals("PROCESS")) break;
            BigInteger val = new BigInteger(fields[1], 16);
            this.offset = val.longValue();
            this.process.setOffset(this.offset);
            break;
        }
    }

    @Override
    public void invoke() {
        DebugProcessId id;
        if (this.process != null && (id = this.process.getId()) != null) {
            DebugSystemObjects so = this.manager.getSystemObjects();
            if (this.manager.isKernelMode()) {
                this.offset = this.process.getOffset();
                if (this.offset == null || this.offset == 0L) {
                    DebugControl control = this.manager.getControl();
                    control.execute("!process " + Long.toHexString(this.process.getPid()) + " 0");
                }
            } else {
                so.setCurrentProcessId(id);
                DebugProcessId currentProcessId = so.getCurrentProcessId();
                if (!id.id().equals(currentProcessId.id())) {
                    so.setCurrentProcessId(id);
                }
            }
        }
    }
}

