/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel;

import docking.DockingUtils;
import docking.util.GraphicsUtils;
import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.HoverHandler;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.internal.AnchoredLayoutHandler;
import docking.widgets.fieldpanel.internal.CursorBlinker;
import docking.widgets.fieldpanel.internal.DefaultBackgroundColorModel;
import docking.widgets.fieldpanel.internal.LayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.LayoutColorMapFactory;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.listener.FieldInputListener;
import docking.widgets.fieldpanel.listener.FieldLocationListener;
import docking.widgets.fieldpanel.listener.FieldMouseListener;
import docking.widgets.fieldpanel.listener.FieldSelectionListener;
import docking.widgets.fieldpanel.listener.IndexMapper;
import docking.widgets.fieldpanel.listener.LayoutListener;
import docking.widgets.fieldpanel.listener.LayoutModelListener;
import docking.widgets.fieldpanel.listener.ViewListener;
import docking.widgets.fieldpanel.support.AnchoredLayout;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.fieldpanel.support.HoverProvider;
import docking.widgets.fieldpanel.support.ViewerPosition;
import docking.widgets.indexedscrollpane.IndexScrollListener;
import docking.widgets.indexedscrollpane.IndexedScrollable;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.util.ColorUtils;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FieldPanel
extends JPanel
implements IndexedScrollable,
LayoutModelListener,
ChangeListener {
    public static final int MOUSEWHEEL_LINES_TO_SCROLL = 3;
    private LayoutModel model;
    private boolean repaintPosted;
    private boolean inFocus;
    protected BackgroundColorModel backgroundColorModel = new DefaultBackgroundColorModel((Color)new GColor("color.bg.fieldpanel"));
    protected PaintContext paintContext = new PaintContext();
    private AnchoredLayoutHandler layoutHandler;
    private CursorHandler cursorHandler = new CursorHandler();
    private MouseHandler mouseHandler = new MouseHandler();
    private KeyHandler keyHandler = new KeyHandler();
    private HoverHandler hoverHandler;
    private SelectionHandler selectionHandler = new SelectionHandler();
    private boolean horizontalScrollingEnabled = true;
    private FieldLocation cursorPosition = new FieldLocation();
    private FieldSelection selection = new FieldSelection();
    private FieldSelection highlight = new FieldSelection();
    private List<IndexScrollListener> listeners = new ArrayList<IndexScrollListener>();
    private List<FieldMouseListener> fieldMouseListeners = new ArrayList<FieldMouseListener>();
    private List<FieldInputListener> inputListeners = new ArrayList<FieldInputListener>();
    private List<FieldLocationListener> cursorListeners = new ArrayList<FieldLocationListener>();
    private List<LayoutListener> layoutListeners = new ArrayList<LayoutListener>();
    private List<ViewListener> viewListeners = new ArrayList<ViewListener>();
    private List<FieldSelectionListener> selectionListeners = new ArrayList<FieldSelectionListener>();
    private List<FieldSelectionListener> highlightListeners = new ArrayList<FieldSelectionListener>();
    private List<FieldSelectionListener> liveSelectionListeners = new ArrayList<FieldSelectionListener>();
    private List<AnchoredLayout> layouts = new ArrayList<AnchoredLayout>();
    private int currentViewXpos;
    private JViewport viewport;

    public FieldPanel(LayoutModel model) {
        this.model = model;
        model.addLayoutModelListener(this);
        this.layoutHandler = new AnchoredLayoutHandler(model, this.getHeight());
        this.layouts = this.layoutHandler.positionLayoutsAroundAnchor(BigInteger.ZERO, 0);
        this.addKeyListener(new FieldPanelKeyAdapter());
        this.addMouseListener(new FieldPanelMouseAdapter());
        this.addMouseMotionListener(new FieldPanelMouseMotionAdapter());
        this.addMouseWheelListener(new BigFieldPanelMouseWheelListener());
        this.addFocusListener(new FieldPanelFocusListener());
        this.setDoubleBuffered(false);
        this.setFocusable(true);
        this.hoverHandler = new HoverHandler(this);
    }

    @Override
    public void showIndex(BigInteger layoutIndex, int verticalOffset) {
        AnchoredLayout layout;
        if (this.model.getNumIndexes().equals(BigInteger.ZERO)) {
            return;
        }
        if (!this.layouts.isEmpty() && (layout = this.layouts.get(0)).getIndex().equals(layoutIndex) && layout.getYPos() == verticalOffset) {
            return;
        }
        this.layouts = this.layoutHandler.positionLayoutsAroundAnchor(layoutIndex, verticalOffset);
        this.notifyScrollListenerViewChangedAndRepaint();
    }

    public void scrollView(int viewAmount) {
        this.layouts = this.layoutHandler.shiftView(viewAmount);
        this.notifyScrollListenerViewChangedAndRepaint();
    }

    public void scrollTo(FieldLocation fieldLocation) {
        this.doScrollTo(fieldLocation);
    }

    public void center(FieldLocation location) {
        int offset = this.getOffset(location);
        this.scrollView(offset - this.getHeight() / 2);
        this.repaint();
    }

    private void doScrollTo(FieldLocation location) {
        if (this.layouts.isEmpty()) {
            return;
        }
        BigInteger locationIndex = location.getIndex();
        if (this.layouts.get(0).getIndex().compareTo(locationIndex) > 0) {
            this.showIndex(locationIndex, 0);
        } else if (this.layouts.get(this.layouts.size() - 1).getIndex().compareTo(locationIndex) < 0) {
            this.showIndex(locationIndex, this.getHeight() - 1);
        }
        AnchoredLayout layout = this.findLayoutOnScreen(locationIndex);
        if (layout == null) {
            layout = this.findClosestLayoutOnScreen(locationIndex);
            if (layout == null) {
                return;
            }
            locationIndex = layout.getIndex();
            location.setIndex(locationIndex);
        }
        Rectangle locationRect = layout.getCursorRect(location.fieldNum, location.row, location.col);
        JViewport vp = this.getViewport();
        if (vp != null) {
            Rectangle r = SwingUtilities.convertRectangle(this, locationRect, this.getParent());
            locationRect.x = r.x;
            locationRect.x = Math.max(0, locationRect.x - 15);
            locationRect.width += 30;
            Rectangle viewRect = vp.getViewRect();
            if (viewRect.width > 0 && viewRect.height > 0) {
                if (locationRect.x < viewRect.x) {
                    vp.setViewPosition(new Point(locationRect.x, viewRect.y));
                } else if (locationRect.x + locationRect.width > viewRect.x + viewRect.width) {
                    vp.setViewPosition(new Point(locationRect.x + locationRect.width - viewRect.width, viewRect.y));
                }
            }
        }
        if (locationRect.y < 0) {
            this.scrollView(locationRect.y);
        } else if (locationRect.y + locationRect.height > this.getHeight()) {
            this.scrollView(locationRect.y + locationRect.height - this.getHeight());
        }
    }

    @Override
    public void scrollLineDown() {
        this.layouts = this.layoutHandler.shiftViewDownOneRow();
        this.notifyScrollListenerViewChangedAndRepaint();
    }

    @Override
    public void scrollLineUp() {
        this.layouts = this.layoutHandler.shiftViewUpOneRow();
        this.notifyScrollListenerViewChangedAndRepaint();
    }

    @Override
    public void scrollPageDown() {
        this.layouts = this.layoutHandler.shiftViewDownOnePage();
        this.notifyScrollListenerViewChangedAndRepaint();
    }

    @Override
    public void scrollPageUp() {
        this.layouts = this.layoutHandler.shiftViewUpOnePage();
        this.notifyScrollListenerViewChangedAndRepaint();
    }

    public void pageUp() {
        this.doPageUp(EventTrigger.API_CALL);
    }

    public void pageDown() {
        this.doPageDown(EventTrigger.API_CALL);
    }

    @Override
    public int getHeight(BigInteger index) {
        Layout layout = this.model.getLayout(index);
        return layout == null ? 0 : layout.getHeight();
    }

    @Override
    public BigInteger getIndexAfter(BigInteger index) {
        return this.model.getIndexAfter(index);
    }

    @Override
    public BigInteger getIndexBefore(BigInteger index) {
        return this.model.getIndexBefore(index);
    }

    @Override
    public BigInteger getIndexCount() {
        return this.model.getNumIndexes();
    }

    @Override
    public boolean isUniformIndex() {
        return this.model.isUniform();
    }

    public void cursorUp() {
        this.cursorHandler.doCursorUp(EventTrigger.API_CALL);
    }

    public void cursorDown() {
        this.cursorHandler.doCursorDown(EventTrigger.API_CALL);
    }

    public void cursorLeft() {
        this.cursorHandler.doCursorLeft(EventTrigger.API_CALL);
    }

    public void cursorRight() {
        this.cursorHandler.doCursorRight(EventTrigger.API_CALL);
    }

    public void cursorHome() {
        this.cursorHandler.doCursorHome(EventTrigger.API_CALL);
    }

    public void cursorTopOfFile() {
        this.doTopOfFile(EventTrigger.API_CALL);
    }

    public void cursorBottomOfFile() {
        this.doEndOfFile(EventTrigger.API_CALL);
    }

    public void cursorEnd() {
        this.cursorHandler.doCursorEnd(EventTrigger.API_CALL);
    }

    public List<AnchoredLayout> getVisibleLayouts() {
        return new ArrayList<AnchoredLayout>(this.layouts);
    }

    public boolean isLocationVisible(FieldLocation location) {
        if (location == null) {
            return false;
        }
        BigInteger locationIndex = location.getIndex();
        for (AnchoredLayout layout : this.layouts) {
            if (!layout.getIndex().equals(locationIndex)) continue;
            return true;
        }
        return false;
    }

    public AnchoredLayout getVisibleStartLayout() {
        if (this.layouts.isEmpty()) {
            return null;
        }
        return this.layouts.get(0);
    }

    public AnchoredLayout getVisibleEndLayout() {
        if (this.layouts.isEmpty()) {
            return null;
        }
        return this.layouts.get(this.layouts.size() - 1);
    }

    @Override
    public void repaint() {
        this.repaintPosted = true;
        super.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.viewport == null) {
            this.viewport = this.getViewport();
            if (this.viewport != null) {
                this.viewport.addChangeListener(this);
            }
        }
        return this.model.getPreferredViewSize();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Point viewPosition = this.viewport.getViewPosition();
        if (viewPosition.x != this.currentViewXpos) {
            this.currentViewXpos = viewPosition.x;
            this.notifyViewChanged();
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        boolean heightChanged = height != this.getHeight();
        super.setBounds(x, y, width, height);
        if (heightChanged) {
            this.layouts = this.layoutHandler.setViewHeight(height);
            this.notifyScrollListenerViewChangedAndRepaint();
        }
    }

    public void setBlinkCursor(Boolean blinkCursor) {
        this.cursorHandler.setBlinkCursor(blinkCursor);
    }

    public void enableSelection(boolean b) {
        this.selectionHandler.enableSelection(b);
    }

    public void setHorizontalScrollingEnabled(boolean enabled) {
        this.horizontalScrollingEnabled = enabled;
    }

    public Color getBackgroundColor() {
        return this.backgroundColorModel.getDefaultBackgroundColor();
    }

    @Override
    public Color getBackground() {
        if (this.backgroundColorModel != null) {
            return this.backgroundColorModel.getDefaultBackgroundColor();
        }
        return super.getBackground();
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColorModel.setDefaultBackgroundColor(c);
    }

    public Color getBackgroundColor(BigInteger index) {
        return this.backgroundColorModel.getBackgroundColor(index);
    }

    public void setBackgroundColorModel(BackgroundColorModel model) {
        Color currentDefault = this.backgroundColorModel.getDefaultBackgroundColor();
        if (model == null) {
            model = new DefaultBackgroundColorModel(currentDefault);
        }
        this.backgroundColorModel = model;
        this.backgroundColorModel.setDefaultBackgroundColor(currentDefault);
    }

    public Color getForegroundColor() {
        return this.paintContext.getForeground();
    }

    public Color getSelectionColor() {
        return this.paintContext.getSelectionColor();
    }

    public Color getHighlightColor() {
        return this.paintContext.getHighlightColor();
    }

    public Color getFocusedCursorColor() {
        return this.paintContext.getFocusedCursorColor();
    }

    public Color getNonFocusCursorColor() {
        return this.paintContext.getNotFocusedCursorColor();
    }

    public boolean isFocused() {
        return this.inFocus;
    }

    public void dispose() {
        this.mouseHandler.dispose();
        this.cursorHandler.dispose();
        this.listeners.clear();
        this.fieldMouseListeners.clear();
        this.inputListeners.clear();
        this.cursorListeners.clear();
        this.layoutListeners.clear();
        this.viewListeners.clear();
        this.selectionListeners.clear();
        this.highlightListeners.clear();
        this.layouts.clear();
    }

    public Point getCursorPoint() {
        Rectangle bounds = this.getCursorBounds();
        if (bounds == null) {
            return new Point(0, 0);
        }
        return bounds.getLocation();
    }

    public Rectangle getCursorBounds() {
        AnchoredLayout layout = this.findLayoutOnScreen(this.cursorPosition.getIndex());
        if (layout == null) {
            return null;
        }
        return layout.getCursorRect(this.cursorPosition.fieldNum, this.cursorPosition.row, this.cursorPosition.col);
    }

    public FieldLocation getCursorLocation() {
        return new FieldLocation(this.cursorPosition);
    }

    public Field getCurrentField() {
        return this.cursorHandler.getCurrentField();
    }

    @Override
    public void addIndexScrollListener(IndexScrollListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeIndexScrollListener(IndexScrollListener listener) {
        this.listeners.remove(listener);
    }

    public void addFieldSelectionListener(FieldSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeFieldSelectionListener(FieldSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void addLiveFieldSelectionListener(FieldSelectionListener listener) {
        this.liveSelectionListeners.add(listener);
    }

    public void removeLiveFieldSelectionListener(FieldSelectionListener listener) {
        this.liveSelectionListeners.remove(listener);
    }

    public void addHighlightListener(FieldSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeHighlightListener(FieldSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void addFieldMouseListener(FieldMouseListener listener) {
        this.fieldMouseListeners.add(listener);
    }

    public void removeFieldMouseListener(FieldMouseListener listener) {
        this.fieldMouseListeners.remove(listener);
    }

    public void addFieldInputListener(FieldInputListener listener) {
        this.inputListeners.add(listener);
    }

    public void removeFieldInputListener(FieldInputListener listener) {
        this.inputListeners.remove(listener);
    }

    public void addFieldLocationListener(FieldLocationListener listener) {
        this.cursorListeners.add(listener);
    }

    public void removeFieldLocationListener(FieldLocationListener listener) {
        this.cursorListeners.remove(listener);
    }

    public void addLayoutListener(LayoutListener listener) {
        this.layoutListeners.add(listener);
    }

    public void removeLayoutListener(LayoutListener listener) {
        this.layoutListeners.remove(listener);
    }

    public void addViewListener(ViewListener listener) {
        this.viewListeners.add(listener);
    }

    public void removeViewListener(ViewListener listener) {
        this.viewListeners.remove(listener);
    }

    public void setHoverProvider(HoverProvider hoverProvider) {
        this.hoverHandler.setHoverProvider(hoverProvider);
    }

    public HoverHandler getHoverHandler() {
        return this.hoverHandler;
    }

    public Field getFieldAt(int x, int y, FieldLocation loc) {
        AnchoredLayout layout = this.findLayoutAt(y);
        if (layout == null) {
            return null;
        }
        layout.setCursor(loc, x, y);
        return layout.getField(loc.fieldNum);
    }

    public void clearSelection() {
        if (this.selection.getNumRanges() > 0) {
            this.selection.clear();
            this.repaint();
            this.notifySelectionChanged(EventTrigger.API_CALL);
        }
    }

    public void clearHighlight() {
        if (this.highlight.getNumRanges() > 0) {
            this.highlight.clear();
            this.repaint();
            this.notifyHighlightChanged();
        }
    }

    public void setFocusedCursorColor(Color color) {
        this.paintContext.setFocusedCursorColor(color);
        if (this.inFocus) {
            this.paintContext.setCursorFocused(this.inFocus);
            this.repaint();
        }
    }

    public void setNonFocusCursorColor(Color color) {
        this.paintContext.setNotFocusedCursorColor(color);
        if (!this.inFocus) {
            this.paintContext.setCursorFocused(this.inFocus);
            this.repaint();
        }
    }

    public FieldSelection getSelection() {
        return new FieldSelection(this.selection);
    }

    public FieldSelection getHighlight() {
        return new FieldSelection(this.highlight);
    }

    public void setSelection(FieldSelection sel) {
        this.setSelection(sel, EventTrigger.API_CALL);
    }

    public void setSelection(FieldSelection sel, EventTrigger trigger) {
        if (!this.selectionHandler.isSelectionOn()) {
            return;
        }
        this.selection = new FieldSelection(sel);
        this.repaint();
        this.notifySelectionChanged(trigger);
    }

    public void setHighlight(FieldSelection sel) {
        this.highlight = new FieldSelection(sel);
        this.repaint();
        this.notifyHighlightChanged();
    }

    public boolean setCursorPosition(BigInteger index, int fieldNum, int row, int col) {
        return this.setCursorPosition(index, fieldNum, row, col, EventTrigger.API_CALL);
    }

    public boolean setCursorPosition(BigInteger index, int fieldNum, int row, int col, EventTrigger trigger) {
        if (this.cursorHandler.doSetCursorPosition(index, fieldNum, row, col, trigger)) {
            this.repaint();
            return true;
        }
        return false;
    }

    public void setCursorOn(boolean cursorOn) {
        this.cursorHandler.setCursorOn(cursorOn);
    }

    public boolean isCursorOn() {
        return this.cursorHandler.isCursorOn();
    }

    public void scrollToCursor() {
        this.cursorHandler.scrollToCursor();
    }

    public void goTo(BigInteger index, int fieldNum, int row, int col, boolean alwaysCenterCursor) {
        this.goTo(index, fieldNum, row, col, alwaysCenterCursor, EventTrigger.API_CALL);
    }

    protected void goTo(BigInteger index, int fieldNum, int row, int col, boolean alwaysCenterCursor, EventTrigger trigger) {
        if (!this.cursorHandler.doSetCursorPosition(index, fieldNum, row, col, trigger)) {
            return;
        }
        int beforeOffset = this.getCursorOffset();
        this.cursorHandler.scrollToCursor();
        int afterOffset = this.getCursorOffset();
        if (alwaysCenterCursor || beforeOffset != afterOffset) {
            this.scrollView(afterOffset - this.getHeight() / 2);
        }
        this.repaint();
    }

    public void takeFocus() {
        this.requestFocus();
    }

    public void positionCursor(int offset) {
        if (offset < 0) {
            offset = 0;
        }
        this.cursorHandler.scrollToCursor();
        int newOffset = this.getCursorOffset();
        int scrollAmount = newOffset - offset;
        if (this.layouts.size() == 0) {
            return;
        }
        this.scrollView(scrollAmount);
    }

    public boolean isStartDragOK() {
        return !this.selectionHandler.isInProgress();
    }

    public void setSelectionColor(Color color) {
        this.paintContext.setSelectionColor(color);
    }

    public void setHighlightColor(Color color) {
        this.paintContext.setHighlightColor(color);
    }

    public ViewerPosition getViewerPosition() {
        if (this.layouts.size() > 0) {
            return new ViewerPosition(this.layouts.get(0).getIndex(), 0, this.layouts.get(0).getYPos());
        }
        return new ViewerPosition(0, 0, 0);
    }

    public void setViewerPosition(BigInteger index, int xPos, int yPos) {
        if (index.compareTo(BigInteger.ZERO) >= 0 && index.compareTo(this.model.getNumIndexes()) < 0) {
            this.layouts = this.layoutHandler.positionLayoutsAroundAnchor(index, yPos);
            this.notifyScrollListenerViewChangedAndRepaint();
        }
        if (xPos != this.currentViewXpos && this.viewport != null) {
            Point viewPosition = this.viewport.getViewPosition();
            this.viewport.setViewPosition(new Point(xPos, viewPosition.y));
        }
    }

    public LayoutModel getLayoutModel() {
        return this.model;
    }

    public void setLayoutModel(LayoutModel model) {
        this.invalidate();
        this.model.removeLayoutModelListener(this);
        this.model = model;
        model.addLayoutModelListener(this);
        this.layoutHandler = new AnchoredLayoutHandler(model, this.getHeight());
        this.layouts = this.layoutHandler.positionLayoutsAroundAnchor(BigInteger.ZERO, 0);
        this.setCursorPosition(BigInteger.ZERO, 0, 0, 0);
        this.notifyScrollListenerModelChanged();
        this.notifyScrollListenerViewChangedAndRepaint();
    }

    @Override
    public void dataChanged(BigInteger start, BigInteger end) {
        if (this.layouts.isEmpty()) {
            this.notifyScrollListenerDataChanged(start, end);
            return;
        }
        Point cursorPoint = this.getCursorPoint();
        BigInteger firstDisplayedIndex = this.layouts.get(0).getIndex();
        BigInteger lastDisplayedIndex = this.layouts.get(this.layouts.size() - 1).getIndex();
        if (end.compareTo(firstDisplayedIndex) < 0) {
            return;
        }
        if (start.compareTo(lastDisplayedIndex) > 0) {
            return;
        }
        BigInteger anchorIndex = firstDisplayedIndex;
        int anchorOffset = this.layouts.get(0).getYPos();
        AnchoredLayout layout = this.findLayoutOnScreen(this.cursorPosition.getIndex());
        if (layout != null) {
            anchorIndex = this.cursorPosition.getIndex();
            anchorOffset = layout.getYPos();
        }
        this.notifyScrollListenerDataChanged(start, end);
        this.layouts = this.layoutHandler.positionLayoutsAroundAnchor(anchorIndex, anchorOffset);
        this.adjustCursorForDataChange();
        this.cursorHandler.updateCursor(cursorPoint);
        this.notifyScrollListenerViewChangedAndRepaint();
    }

    private void adjustCursorForDataChange() {
        BigInteger index = this.cursorPosition.getIndex();
        if (index == null) {
            return;
        }
        Layout layout = this.model.getLayout(index);
        if (layout == null && (index = this.getIndexBefore(index)) != null) {
            this.cursorPosition.setIndex(index);
        }
    }

    @Override
    public void modelSizeChanged(IndexMapper indexMapper) {
        BigInteger anchorIndex = this.layouts.isEmpty() ? BigInteger.ZERO : indexMapper.map(this.layouts.get(0).getIndex());
        int anchorOffset = this.layouts.isEmpty() ? 0 : this.layouts.get(0).getYPos();
        Point cursorPoint = this.getCursorPoint();
        BigInteger cursorIndex = indexMapper.map(this.cursorPosition.getIndex());
        AnchoredLayout layout = this.findLayoutOnScreen(cursorIndex);
        if (layout != null) {
            anchorIndex = cursorIndex;
            anchorOffset = layout.getYPos();
        }
        this.notifyScrollListenerModelChanged();
        this.layouts = this.layoutHandler.positionLayoutsAroundAnchor(anchorIndex, anchorOffset);
        this.updateHighlight(indexMapper);
        this.cursorHandler.updateCursor(cursorPoint);
        this.notifyScrollListenerViewChangedAndRepaint();
        this.invalidate();
    }

    private void updateHighlight(IndexMapper mapper) {
        if (this.highlight.isEmpty()) {
            return;
        }
        FieldSelection oldHighlight = this.highlight;
        this.highlight = new FieldSelection();
        for (FieldRange range : oldHighlight) {
            FieldLocation start = range.getStart();
            FieldLocation end = range.getEnd();
            BigInteger startIndex = mapper.map(start.getIndex());
            BigInteger endIndex = mapper.map(end.getIndex());
            if (startIndex == null || endIndex == null) continue;
            start.setIndex(startIndex);
            end.setIndex(endIndex);
            this.highlight.addRange(start, end);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.model.flushChanges();
        this.repaintPosted = false;
        Point start = new Point(0, 0);
        Rectangle paintArea = new Rectangle(start, this.getSize());
        this.clearDisplay(g, paintArea);
        for (AnchoredLayout layout : this.layouts) {
            LayoutBackgroundColorManager colorManager = this.getLayoutSelectionMap(layout.getIndex());
            this.paintLayoutBackground(g, paintArea, layout, colorManager);
            FieldLocation cursorLocation = this.cursorHandler.initializeCursorForLayout(layout, colorManager, this.paintContext);
            try {
                layout.paint(this, g, this.paintContext, paintArea, colorManager, cursorLocation);
            }
            catch (Exception e) {
                this.paintExceptionInLayout(g, paintArea, layout, e);
                break;
            }
        }
    }

    public int getOffset(FieldLocation location) {
        AnchoredLayout layout = this.findLayoutOnScreen(location.getIndex());
        if (layout == null) {
            return -1;
        }
        Rectangle rect = layout.getCursorRect(location.fieldNum, location.row, location.col);
        if (rect == null) {
            return 0;
        }
        return rect.y;
    }

    public int getCursorOffset() {
        return this.getOffset(this.cursorPosition);
    }

    private void notifyScrollListenerViewChangedAndRepaint() {
        BigInteger startIndex;
        BigInteger endIndex = startIndex = BigInteger.ZERO;
        int startY = 0;
        int endY = 0;
        if (!this.layouts.isEmpty()) {
            AnchoredLayout startLayout = this.layouts.get(0);
            AnchoredLayout anchoredLayout = this.layouts.get(this.layouts.size() - 1);
            startIndex = startLayout.getIndex();
            endIndex = anchoredLayout.getIndex();
            startY = startLayout.getYPos();
            endY = anchoredLayout.getEndY();
        }
        for (IndexScrollListener indexScrollListener : this.listeners) {
            indexScrollListener.indexRangeChanged(startIndex, endIndex, startY, endY);
        }
        for (LayoutListener layoutListener : this.layoutListeners) {
            layoutListener.layoutsChanged(this.layouts);
        }
        this.notifyViewChanged();
        this.repaint();
    }

    private void notifyScrollListenerModelChanged() {
        for (IndexScrollListener listener : this.listeners) {
            listener.indexModelChanged();
        }
    }

    private void notifyScrollListenerDataChanged(BigInteger start, BigInteger end) {
        for (IndexScrollListener listener : this.listeners) {
            listener.indexModelDataChanged(start, end);
        }
    }

    private void notifyViewChanged() {
        if (this.layouts.isEmpty()) {
            return;
        }
        AnchoredLayout layout = this.layouts.get(0);
        BigInteger index = layout.getIndex();
        int yOffset = layout.getYPos();
        for (ViewListener listener : this.viewListeners) {
            listener.viewChanged(this, index, this.currentViewXpos, yOffset);
        }
    }

    protected LayoutBackgroundColorManager getLayoutSelectionMap(BigInteger layoutIndex) {
        Color backgroundColor = this.backgroundColorModel.getBackgroundColor(layoutIndex);
        Color defaultBackColor = this.backgroundColorModel.getDefaultBackgroundColor();
        boolean isDefault = backgroundColor.equals(defaultBackColor);
        Color selectionColor = this.paintContext.getSelectionColor();
        Color highlightColor = this.paintContext.getHighlightColor();
        Color mixedColor = this.paintContext.getSelectedHighlightColor();
        if (!isDefault) {
            selectionColor = ColorUtils.addColors((Color)selectionColor, (Color)backgroundColor);
            highlightColor = ColorUtils.addColors((Color)highlightColor, (Color)backgroundColor);
            mixedColor = ColorUtils.addColors((Color)mixedColor, (Color)backgroundColor);
        }
        return LayoutColorMapFactory.getLayoutColorMap(layoutIndex, this.selection, this.highlight, backgroundColor, selectionColor, highlightColor, mixedColor);
    }

    private void paintLayoutBackground(Graphics g, Rectangle rect, AnchoredLayout layout, LayoutBackgroundColorManager layoutSelectionMap) {
        Color defaultBackgroundColor;
        Color layoutBackgroundColor = layoutSelectionMap.getBackgroundColor();
        if (layoutBackgroundColor != (defaultBackgroundColor = this.backgroundColorModel.getDefaultBackgroundColor())) {
            g.setColor(layoutBackgroundColor);
            int paintHeight = layout.getHeight() + 1;
            g.fillRect(rect.x, layout.getYPos(), rect.width, paintHeight);
        }
    }

    private void clearDisplay(Graphics g, Rectangle rect) {
        Color backgroundColor = this.backgroundColorModel.getDefaultBackgroundColor();
        g.setColor(backgroundColor);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    private void paintExceptionInLayout(Graphics g, Rectangle r, AnchoredLayout layout, Exception e) {
        Color defaultBackgroundColor = this.backgroundColorModel.getDefaultBackgroundColor();
        g.setColor(defaultBackgroundColor);
        g.fillRect(r.x, layout.getYPos() - layout.getHeight(), r.width, layout.getHeight());
        g.setColor((Color)GThemeDefaults.Colors.Messages.ERROR);
        GraphicsUtils.drawString((JComponent)this, g, "Error Painting Field", r.x, layout.getYPos());
        Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
    }

    private void doPageUp(EventTrigger trigger) {
        Rectangle rect = null;
        AnchoredLayout layout = this.findLayoutOnScreen(this.cursorPosition.getIndex());
        if (layout != null) {
            rect = layout.getCursorRect(this.cursorPosition.fieldNum, this.cursorPosition.row, this.cursorPosition.col);
        }
        this.scrollPageUp();
        int x = rect == null ? 0 : rect.x;
        int y = rect == null ? 0 : rect.y + rect.height / 2;
        this.cursorHandler.setCursorPos(x, y, trigger);
    }

    private void doPageDown(EventTrigger trigger) {
        Rectangle rect = null;
        AnchoredLayout layout = this.findLayoutOnScreen(this.cursorPosition.getIndex());
        if (layout != null) {
            rect = layout.getCursorRect(this.cursorPosition.fieldNum, this.cursorPosition.row, this.cursorPosition.col);
        }
        this.scrollPageDown();
        int x = rect == null ? 0 : rect.x;
        int y = rect == null ? 0 : rect.y + rect.height / 2;
        this.cursorHandler.setCursorPos(x, y, trigger);
    }

    private void doTopOfFile(EventTrigger trigger) {
        this.showIndex(BigInteger.ZERO, 0);
        this.cursorHandler.setCursorPos(0, 0, trigger);
    }

    private void doEndOfFile(EventTrigger trigger) {
        this.showIndex(this.model.getNumIndexes().subtract(BigInteger.ONE), 0);
        if (!this.layouts.isEmpty()) {
            AnchoredLayout l = this.layouts.get(this.layouts.size() - 1);
            this.cursorHandler.setCursorPos(0, l.getYPos() + l.getHeight() - 1, null);
        }
        this.cursorHandler.doCursorEnd(trigger);
    }

    public Point getPointForLocation(FieldLocation location) {
        AnchoredLayout layout = this.findLayoutOnScreen(location.getIndex());
        if (layout == null) {
            return null;
        }
        Rectangle r = layout.getCursorRect(location.fieldNum, location.row, location.col);
        return r.getLocation();
    }

    public FieldLocation getLocationForPoint(int x, int y) {
        FieldLocation location = new FieldLocation();
        AnchoredLayout layout = this.findLayoutAt(y);
        if (layout != null) {
            layout.setCursor(location, x, y);
        }
        return location;
    }

    private AnchoredLayout findLayoutOnScreen(BigInteger index) {
        for (AnchoredLayout layout : this.layouts) {
            if (!layout.getIndex().equals(index)) continue;
            return layout;
        }
        return null;
    }

    private AnchoredLayout findClosestLayoutOnScreen(BigInteger index) {
        for (AnchoredLayout layout : this.layouts) {
            if (layout.getIndex().compareTo(index) < 0) continue;
            return layout;
        }
        if (!this.layouts.isEmpty()) {
            return this.layouts.get(this.layouts.size() - 1);
        }
        return null;
    }

    AnchoredLayout findLayoutAt(int y) {
        for (AnchoredLayout layout : this.layouts) {
            if (!layout.contains(y)) continue;
            return layout;
        }
        return null;
    }

    private void notifyFieldMouseListeners(MouseEvent ev) {
        FieldLocation loc = new FieldLocation(this.cursorPosition);
        Field field = this.cursorHandler.getCurrentField();
        SystemUtilities.runSwingLater(() -> {
            for (FieldMouseListener l : this.fieldMouseListeners) {
                l.buttonPressed(loc, field, ev);
            }
        });
    }

    private JViewport getViewport() {
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JViewport)) continue;
            return (JViewport)c;
        }
        return null;
    }

    private void notifySelectionChanged(EventTrigger trigger) {
        FieldSelection currentSelection = new FieldSelection(this.selection);
        for (FieldSelectionListener l : this.selectionListeners) {
            l.selectionChanged(currentSelection, trigger);
        }
    }

    private void notifyLiveSelectionChanged() {
        FieldSelection currentSelection = new FieldSelection(this.selection);
        for (FieldSelectionListener l : this.liveSelectionListeners) {
            l.selectionChanged(currentSelection, EventTrigger.GUI_ACTION);
        }
    }

    private void notifyHighlightChanged() {
        FieldSelection currentSelection = new FieldSelection(this.highlight);
        for (FieldSelectionListener l : this.highlightListeners) {
            l.selectionChanged(currentSelection, EventTrigger.API_CALL);
        }
    }

    private class CursorHandler {
        private int lastX = 0;
        private boolean cursorOn = true;
        private Field currentField;
        private CursorBlinker cursorBlinker;

        CursorHandler() {
            this.cursorBlinker = new CursorBlinker(FieldPanel.this);
        }

        void setBlinkCursor(Boolean blinkCursor) {
            if (blinkCursor.booleanValue() && this.cursorBlinker == null) {
                this.cursorBlinker = new CursorBlinker(FieldPanel.this);
            } else if (!blinkCursor.booleanValue() && this.cursorBlinker != null) {
                this.cursorBlinker.dispose();
                this.cursorBlinker = null;
            }
        }

        boolean isCursorOn() {
            return this.cursorOn;
        }

        void setCursorOn(boolean cursorOn) {
            this.cursorOn = cursorOn;
        }

        void focusLost() {
            if (this.cursorBlinker != null) {
                this.cursorBlinker.stop();
            }
        }

        void focusGained() {
            if (this.cursorBlinker != null) {
                this.cursorBlinker.restart();
            }
        }

        Field getCurrentField() {
            AnchoredLayout layout;
            if (this.currentField == null && (layout = FieldPanel.this.findLayoutOnScreen(FieldPanel.this.cursorPosition.getIndex())) != null) {
                this.currentField = layout.getField(FieldPanel.this.cursorPosition.getFieldNum());
            }
            return this.currentField;
        }

        FieldLocation initializeCursorForLayout(AnchoredLayout layout, LayoutBackgroundColorManager selectionMap, PaintContext context) {
            if (!this.cursorOn || !FieldPanel.this.cursorPosition.getIndex().equals(layout.getIndex())) {
                return null;
            }
            if (FieldPanel.this.inFocus && this.cursorBlinker != null) {
                this.cursorBlinker.updatePaintArea(layout, FieldPanel.this.cursorPosition);
                context.setCursorHidden(!this.cursorBlinker.showCursor());
            }
            return FieldPanel.this.cursorPosition;
        }

        private void setCursorPos(int x, int y, EventTrigger trigger) {
            this.currentField = null;
            AnchoredLayout layout = FieldPanel.this.findLayoutAt(y);
            if (layout == null) {
                x = 0;
                y = 0;
                layout = FieldPanel.this.findLayoutAt(y);
            }
            if (layout != null) {
                FieldLocation newCursorPosition = new FieldLocation();
                this.lastX = layout.setCursor(newCursorPosition, x, y);
                this.currentField = layout.getField(newCursorPosition.fieldNum);
                if (!newCursorPosition.equals(FieldPanel.this.cursorPosition) || EventTrigger.MODEL_CHANGE.equals((Object)trigger)) {
                    FieldPanel.this.cursorPosition = newCursorPosition;
                    this.notifyCursorChanged(trigger);
                }
                this.scrollToCursor();
                FieldPanel.this.repaint();
            }
        }

        private boolean doSetCursorPosition(BigInteger index, int fieldNum, int row, int col, EventTrigger trigger) {
            this.currentField = null;
            if (!this.cursorOn) {
                return false;
            }
            if (index.compareTo(BigInteger.ZERO) < 0 || index.compareTo(FieldPanel.this.model.getNumIndexes()) >= 0) {
                return false;
            }
            Layout layout = FieldPanel.this.model.getLayout(index);
            if (layout == null) {
                return false;
            }
            if (fieldNum >= layout.getNumFields()) {
                fieldNum = 0;
            }
            this.currentField = layout.getField(fieldNum);
            if (!this.currentField.isValid(row, col)) {
                row = 0;
                col = 0;
            }
            FieldPanel.this.cursorPosition.setIndex(index);
            FieldPanel.this.cursorPosition.fieldNum = fieldNum;
            FieldPanel.this.cursorPosition.row = row;
            FieldPanel.this.cursorPosition.col = col;
            this.lastX = this.currentField.getX(row, col);
            this.notifyCursorChanged(trigger);
            return true;
        }

        private boolean doCursorUp(EventTrigger trigger) {
            if (!this.cursorOn) {
                FieldPanel.this.scrollLineUp();
                return true;
            }
            this.scrollToCursor();
            AnchoredLayout layout = FieldPanel.this.findLayoutOnScreen(FieldPanel.this.cursorPosition.getIndex());
            if (layout == null) {
                return false;
            }
            if (!layout.cursorUp(FieldPanel.this.cursorPosition, this.lastX)) {
                if (layout.getIndex().equals(BigInteger.ZERO)) {
                    return false;
                }
                int yPos = layout.getYPos() - 1;
                if ((layout = FieldPanel.this.findLayoutAt(yPos)) == null) {
                    FieldPanel.this.scrollView(yPos);
                    yPos = 0;
                    layout = FieldPanel.this.findLayoutAt(0);
                }
                if (layout == null) {
                    return false;
                }
                layout.setCursor(FieldPanel.this.cursorPosition, this.lastX, yPos);
            }
            this.scrollToCursor();
            this.currentField = layout.getField(FieldPanel.this.cursorPosition.fieldNum);
            FieldPanel.this.repaint();
            this.notifyCursorChanged(trigger);
            return true;
        }

        private boolean doCursorDown(EventTrigger trigger) {
            if (!this.cursorOn) {
                FieldPanel.this.scrollLineDown();
                return true;
            }
            this.scrollToCursor();
            AnchoredLayout layout = FieldPanel.this.findLayoutOnScreen(FieldPanel.this.cursorPosition.getIndex());
            if (layout == null) {
                return false;
            }
            if (!layout.cursorDown(FieldPanel.this.cursorPosition, this.lastX)) {
                int yPos = layout.getYPos() + layout.getHeight();
                if ((layout = FieldPanel.this.findLayoutAt(yPos)) == null) {
                    if (yPos >= FieldPanel.this.getHeight()) {
                        FieldPanel.this.scrollView(yPos - FieldPanel.this.getHeight() + 1);
                        yPos = FieldPanel.this.getHeight();
                    }
                    layout = FieldPanel.this.findLayoutAt(yPos);
                }
                if (layout == null) {
                    return false;
                }
                layout.setCursor(FieldPanel.this.cursorPosition, this.lastX, yPos);
            }
            this.currentField = layout.getField(FieldPanel.this.cursorPosition.fieldNum);
            this.scrollToCursor();
            FieldPanel.this.repaint();
            this.notifyCursorChanged(trigger);
            return true;
        }

        private void doCursorLeft(EventTrigger trigger) {
            if (!this.cursorOn) {
                return;
            }
            this.scrollToCursor();
            AnchoredLayout layout = FieldPanel.this.findLayoutOnScreen(FieldPanel.this.cursorPosition.getIndex());
            if (layout != null) {
                int result = layout.cursorLeft(FieldPanel.this.cursorPosition);
                if (result < 0) {
                    this.lastX = Integer.MAX_VALUE;
                    if (!this.doCursorUp(trigger)) {
                        this.doCursorHome(trigger);
                    }
                } else {
                    this.currentField = layout.getField(FieldPanel.this.cursorPosition.fieldNum);
                    this.lastX = result;
                }
            }
            this.scrollToCursor();
            FieldPanel.this.repaint();
            this.notifyCursorChanged(trigger);
        }

        private void doCursorRight(EventTrigger trigger) {
            if (!this.cursorOn) {
                return;
            }
            this.scrollToCursor();
            AnchoredLayout layout = FieldPanel.this.findLayoutOnScreen(FieldPanel.this.cursorPosition.getIndex());
            if (layout != null) {
                int result = layout.cursorRight(FieldPanel.this.cursorPosition);
                if (result < 0) {
                    this.lastX = 0;
                    if (!this.doCursorDown(trigger)) {
                        this.doCursorEnd(trigger);
                    }
                } else {
                    this.currentField = layout.getField(FieldPanel.this.cursorPosition.fieldNum);
                    this.lastX = result;
                }
            }
            this.scrollToCursor();
            FieldPanel.this.repaint();
            this.notifyCursorChanged(trigger);
        }

        private void doCursorHome(EventTrigger trigger) {
            if (!this.cursorOn) {
                return;
            }
            this.scrollToCursor();
            AnchoredLayout layout = FieldPanel.this.findLayoutOnScreen(FieldPanel.this.cursorPosition.getIndex());
            if (layout != null) {
                this.lastX = layout.cursorBeginning(FieldPanel.this.cursorPosition);
                this.currentField = layout.getField(FieldPanel.this.cursorPosition.fieldNum);
            }
            this.scrollToCursor();
            FieldPanel.this.repaint();
            this.notifyCursorChanged(trigger);
        }

        private void doCursorEnd(EventTrigger trigger) {
            if (!this.cursorOn) {
                return;
            }
            this.scrollToCursor();
            AnchoredLayout layout = FieldPanel.this.findLayoutOnScreen(FieldPanel.this.cursorPosition.getIndex());
            if (layout != null) {
                this.lastX = layout.cursorEnd(FieldPanel.this.cursorPosition);
                this.currentField = layout.getField(FieldPanel.this.cursorPosition.fieldNum);
            }
            this.scrollToCursor();
            FieldPanel.this.repaint();
            this.notifyCursorChanged(trigger);
        }

        private void notifyCursorChanged(EventTrigger trigger) {
            if (!this.cursorOn || trigger == null || trigger == EventTrigger.INTERNAL_ONLY) {
                return;
            }
            FieldLocation currentLocation = new FieldLocation(FieldPanel.this.cursorPosition);
            for (FieldLocationListener l : FieldPanel.this.cursorListeners) {
                l.fieldLocationChanged(currentLocation, this.currentField, trigger);
            }
        }

        void scrollToCursor() {
            FieldPanel.this.doScrollTo(FieldPanel.this.cursorPosition);
        }

        private void updateCursor(Point cursorPoint) {
            if (!this.cursorOn) {
                return;
            }
            if (!this.doSetCursorPosition(FieldPanel.this.cursorPosition.getIndex(), FieldPanel.this.cursorPosition.fieldNum, FieldPanel.this.cursorPosition.row, FieldPanel.this.cursorPosition.col, EventTrigger.MODEL_CHANGE)) {
                if (cursorPoint == null) {
                    cursorPoint = new Point(0, 0);
                }
                FieldPanel.this.cursorHandler.setCursorPos(cursorPoint.x, cursorPoint.y, EventTrigger.MODEL_CHANGE);
            }
        }

        void dispose() {
            if (this.cursorBlinker != null) {
                this.cursorBlinker.dispose();
                this.cursorBlinker = null;
            }
            this.currentField = null;
        }

        private void notifyInputListeners(KeyEvent ev) {
            if (this.cursorOn) {
                for (FieldInputListener l : FieldPanel.this.inputListeners) {
                    l.keyPressed(ev, FieldPanel.this.cursorPosition.getIndex(), FieldPanel.this.cursorPosition.fieldNum, FieldPanel.this.cursorPosition.row, FieldPanel.this.cursorPosition.col, this.currentField);
                }
            }
        }
    }

    private class MouseHandler
    implements ActionListener {
        private Timer scrollTimer = new Timer(100, this);
        private int mouseDownX;
        private int mouseDownY;
        private boolean didDrag;
        private int timerScrollAmount;
        private FieldLocation timerPoint;

        MouseHandler() {
        }

        void dispose() {
            this.scrollTimer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FieldPanel.this.scrollView(this.timerScrollAmount);
                if (this.timerScrollAmount > 0) {
                    this.timerPoint.setIndex(FieldPanel.this.layouts.get(FieldPanel.this.layouts.size() - 1).getIndex());
                } else {
                    this.timerPoint.setIndex(FieldPanel.this.layouts.get(0).getIndex());
                }
                FieldPanel.this.selectionHandler.updateSelectionSequence(this.timerPoint);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void mousePressed(MouseEvent e) {
            FieldPanel.this.requestFocus();
            this.didDrag = false;
            if (e.getButton() != 1) {
                return;
            }
            this.mouseDownX = e.getX();
            this.mouseDownY = e.getY();
            FieldLocation locationForPoint = FieldPanel.this.getLocationForPoint(this.mouseDownX, this.mouseDownY);
            if (this.isAddToContiguousSelectionActivator(e)) {
                FieldPanel.this.selectionHandler.beginSelectionSequence(FieldPanel.this.cursorPosition);
                FieldPanel.this.selectionHandler.updateSelectionSequence(locationForPoint);
            } else if (this.isAddRemoveDisjointSelectionActivator(e)) {
                AnchoredLayout layout = FieldPanel.this.findLayoutAt(this.mouseDownY);
                if (layout == null) {
                    return;
                }
                BigInteger index = layout.getIndex();
                BigInteger size = BigInteger.valueOf(layout.getIndexSize());
                FieldLocation start = new FieldLocation(index);
                FieldLocation end = new FieldLocation(index.add(size));
                FieldPanel.this.selectionHandler.beginSelectionSequence(start);
                FieldPanel.this.selectionHandler.setRemoveFromSelection(FieldPanel.this.selection.contains(start));
                FieldPanel.this.selectionHandler.updateSelectionSequence(end);
            } else if (!FieldPanel.this.selection.contains(locationForPoint)) {
                FieldPanel.this.selectionHandler.clearSelection();
                FieldPanel.this.selectionHandler.beginSelectionSequence(locationForPoint);
            }
        }

        boolean didDrag() {
            return this.didDrag;
        }

        void mouseDragged(MouseEvent e) {
            if ((e.getModifiersEx() & 0x400) == 0) {
                return;
            }
            int x = e.getX();
            int y = e.getY();
            if (Math.abs(x - this.mouseDownX) > 3 || Math.abs(y - this.mouseDownY) > 3) {
                this.didDrag = true;
                if (FieldPanel.this.selectionHandler.isInProgress()) {
                    if (y < 0 || y > FieldPanel.this.getHeight()) {
                        this.timerScrollAmount = y < 0 ? y : y - FieldPanel.this.getHeight();
                        this.timerPoint = new FieldLocation(FieldPanel.this.cursorPosition);
                        this.scrollTimer.start();
                    } else {
                        this.scrollTimer.stop();
                        FieldPanel.this.cursorHandler.setCursorPos(x, y, null);
                        FieldPanel.this.selectionHandler.updateSelectionSequence(FieldPanel.this.cursorPosition);
                        FieldPanel.this.repaint();
                    }
                }
            }
        }

        void mouseReleased(MouseEvent e) {
            this.scrollTimer.stop();
            if (e.getButton() != 1) {
                return;
            }
            FieldPanel.this.cursorHandler.setCursorPos(e.getX(), e.getY(), EventTrigger.GUI_ACTION);
            if (this.didDrag) {
                FieldPanel.this.cursorHandler.notifyCursorChanged(EventTrigger.GUI_ACTION);
            } else if (!FieldPanel.this.selectionHandler.isInProgress()) {
                FieldPanel.this.selectionHandler.clearSelection();
            }
            FieldPanel.this.selectionHandler.endSelectionSequence();
        }

        private boolean isAddToContiguousSelectionActivator(MouseEvent e) {
            return e.isShiftDown() && !DockingUtils.isControlModifier(e);
        }

        private boolean isAddRemoveDisjointSelectionActivator(MouseEvent e) {
            return DockingUtils.isControlModifier(e) && !e.isShiftDown();
        }
    }

    private class KeyHandler {
        private KeyHandler() {
        }

        void shiftKeyPressed() {
            FieldPanel.this.selectionHandler.beginSelectionSequence(FieldPanel.this.cursorPosition);
        }

        void shiftKeyReleased() {
            FieldPanel.this.selectionHandler.endSelectionSequence();
        }

        void vkUp(KeyEvent e) {
            FieldPanel.this.cursorHandler.doCursorUp(EventTrigger.GUI_ACTION);
            FieldPanel.this.selectionHandler.updateSelectionSequence(FieldPanel.this.cursorPosition);
        }

        void vkDown(KeyEvent e) {
            FieldPanel.this.cursorHandler.doCursorDown(EventTrigger.GUI_ACTION);
            FieldPanel.this.selectionHandler.updateSelectionSequence(FieldPanel.this.cursorPosition);
        }

        void vkLeft(KeyEvent e) {
            FieldPanel.this.cursorHandler.doCursorLeft(EventTrigger.GUI_ACTION);
            FieldPanel.this.selectionHandler.updateSelectionSequence(FieldPanel.this.cursorPosition);
        }

        void vkRight(KeyEvent e) {
            FieldPanel.this.cursorHandler.doCursorRight(EventTrigger.GUI_ACTION);
            FieldPanel.this.selectionHandler.updateSelectionSequence(FieldPanel.this.cursorPosition);
        }

        void vkEnd(KeyEvent e) {
            if (DockingUtils.isControlModifier(e)) {
                FieldPanel.this.doEndOfFile(EventTrigger.GUI_ACTION);
            } else {
                FieldPanel.this.cursorHandler.doCursorEnd(EventTrigger.GUI_ACTION);
            }
            FieldPanel.this.selectionHandler.updateSelectionSequence(FieldPanel.this.cursorPosition);
        }

        void vkHome(KeyEvent e) {
            if (DockingUtils.isControlModifier(e)) {
                FieldPanel.this.doTopOfFile(EventTrigger.GUI_ACTION);
            } else {
                FieldPanel.this.cursorHandler.doCursorHome(EventTrigger.GUI_ACTION);
            }
            FieldPanel.this.selectionHandler.updateSelectionSequence(FieldPanel.this.cursorPosition);
        }

        void vkPageUp(KeyEvent e) {
            FieldPanel.this.doPageUp(EventTrigger.GUI_ACTION);
            FieldPanel.this.selectionHandler.updateSelectionSequence(FieldPanel.this.cursorPosition);
        }

        void vkPageDown(KeyEvent e) {
            FieldPanel.this.doPageDown(EventTrigger.GUI_ACTION);
            FieldPanel.this.selectionHandler.updateSelectionSequence(FieldPanel.this.cursorPosition);
        }

        void vkEnter(KeyEvent e) {
            Point pt = FieldPanel.this.getCursorPoint();
            if (pt != null) {
                FieldPanel.this.notifyFieldMouseListeners(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), 0, pt.x, pt.y, 2, false, 1));
            }
        }
    }

    private class SelectionHandler {
        private boolean selectionOn = true;
        private boolean selectionChanged;
        private boolean removeFromSelection;
        private FieldLocation anchorPoint;
        private FieldLocation scrollPoint;

        private SelectionHandler() {
        }

        void beginSelectionSequence(FieldLocation point) {
            if (!this.selectionOn) {
                return;
            }
            this.removeFromSelection = false;
            this.anchorPoint = new FieldLocation(point);
        }

        void setRemoveFromSelection(boolean b) {
            this.removeFromSelection = b;
        }

        boolean isSelectionOn() {
            return this.selectionOn;
        }

        void clearSelection() {
            if (!FieldPanel.this.selection.isEmpty()) {
                FieldPanel.this.selection.clear();
                this.selectionChanged = true;
            }
        }

        boolean isInProgress() {
            return this.anchorPoint != null;
        }

        void endSelectionSequence() {
            if (!this.selectionOn) {
                return;
            }
            this.scrollPoint = null;
            this.anchorPoint = null;
            if (this.selectionChanged) {
                FieldPanel.this.notifySelectionChanged(EventTrigger.GUI_ACTION);
                this.selectionChanged = false;
            }
        }

        void updateSelectionSequence(FieldLocation point) {
            if (!this.selectionOn || this.anchorPoint == null) {
                return;
            }
            if (this.scrollPoint != null) {
                this.updateSelection(this.removeFromSelection);
            }
            this.scrollPoint = new FieldLocation(point);
            this.updateSelection(!this.removeFromSelection);
            FieldPanel.this.notifyLiveSelectionChanged();
        }

        private void updateSelection(boolean add) {
            if (add) {
                FieldPanel.this.selection.addRange(this.anchorPoint, this.scrollPoint);
            } else {
                FieldPanel.this.selection.removeRange(this.anchorPoint, this.scrollPoint);
            }
            this.selectionChanged = true;
        }

        void enableSelection(boolean b) {
            this.selectionOn = b;
            if (!this.selectionOn) {
                FieldPanel.this.selection.clear();
            }
        }
    }

    private class FieldPanelKeyAdapter
    extends KeyAdapter {
        private Map<KeyStroke, KeyAction> actionMap = new HashMap<KeyStroke, KeyAction>();

        FieldPanelKeyAdapter() {
            this.actionMap.put(KeyStroke.getKeyStroke(38, 0), new UpKeyAction());
            this.actionMap.put(KeyStroke.getKeyStroke(40, 0), new DownKeyAction());
            this.actionMap.put(KeyStroke.getKeyStroke(37, 0), new LeftKeyAction());
            this.actionMap.put(KeyStroke.getKeyStroke(39, 0), new RightKeyAction());
            this.actionMap.put(KeyStroke.getKeyStroke(36, 0), new HomeKeyAction());
            this.actionMap.put(KeyStroke.getKeyStroke(36, DockingUtils.CONTROL_KEY_MODIFIER_MASK), new HomeKeyAction());
            this.actionMap.put(KeyStroke.getKeyStroke(35, 0), new EndKeyAction());
            this.actionMap.put(KeyStroke.getKeyStroke(35, DockingUtils.CONTROL_KEY_MODIFIER_MASK), new EndKeyAction());
            this.actionMap.put(KeyStroke.getKeyStroke(33, 0), new PageUpKeyAction());
            this.actionMap.put(KeyStroke.getKeyStroke(34, 0), new PageDownKeyAction());
            this.actionMap.put(KeyStroke.getKeyStroke(10, 0), new EnterKeyAction());
        }

        @Override
        public void keyPressed(KeyEvent e) {
            FieldPanel.this.hoverHandler.stopHover();
            if (e.isAltDown()) {
                return;
            }
            int keyCode = e.getKeyCode();
            int modifiers = e.getModifiersEx() & 0xFFFFFFBF;
            KeyEvent maskedEvent = new KeyEvent(e.getComponent(), e.getID(), e.getWhen(), modifiers, keyCode, e.getKeyChar(), e.getKeyLocation());
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(maskedEvent);
            KeyAction keyAction = this.actionMap.get(keyStroke);
            if (keyAction != null) {
                e.consume();
                if (!FieldPanel.this.repaintPosted) {
                    keyAction.handleKeyEvent(e);
                }
            } else if (keyCode == 16) {
                FieldPanel.this.keyHandler.shiftKeyPressed();
            } else {
                FieldPanel.this.cursorHandler.notifyInputListeners(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 16) {
                FieldPanel.this.keyHandler.shiftKeyReleased();
            }
        }
    }

    private class FieldPanelMouseAdapter
    extends MouseAdapter {
        private FieldPanelMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            FieldPanel.this.hoverHandler.stopHover();
            FieldPanel.this.mouseHandler.mousePressed(e);
            FieldPanel.this.cursorHandler.setCursorPos(e.getX(), e.getY(), EventTrigger.GUI_ACTION);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            FieldPanel.this.mouseHandler.mouseReleased(e);
            if (!FieldPanel.this.mouseHandler.didDrag() && !this.isButton3(e)) {
                FieldPanel.this.notifyFieldMouseListeners(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            FieldPanel.this.hoverHandler.hoverExited();
        }

        private boolean isButton3(MouseEvent e) {
            return e.getButton() == 3;
        }
    }

    private class FieldPanelMouseMotionAdapter
    extends MouseMotionAdapter {
        private FieldPanelMouseMotionAdapter() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            FieldPanel.this.hoverHandler.stopHover();
            FieldPanel.this.mouseHandler.mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            FieldPanel.this.hoverHandler.startHover(e);
        }
    }

    private class BigFieldPanelMouseWheelListener
    implements MouseWheelListener {
        private BigFieldPanelMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Layout firstLayout;
            int layoutScrollHt;
            double wheelRotation = e.getPreciseWheelRotation();
            int scrollAmount = (int)(wheelRotation * (double)(layoutScrollHt = (firstLayout = FieldPanel.this.model.getLayout(BigInteger.ZERO)) != null ? firstLayout.getScrollableUnitIncrement(0, 1) : 0) * 3.0);
            if (scrollAmount == 0) {
                return;
            }
            if (FieldPanel.this.hoverHandler.isHoverShowing()) {
                FieldPanel.this.hoverHandler.scroll(scrollAmount);
            } else {
                FieldPanel.this.hoverHandler.stopHover();
                if (e.isShiftDown() && FieldPanel.this.horizontalScrollingEnabled) {
                    this.scrollViewHorizontally(scrollAmount);
                } else {
                    FieldPanel.this.scrollView(scrollAmount);
                }
            }
            e.consume();
        }

        private void scrollViewHorizontally(int scrollAmount) {
            JViewport vp = FieldPanel.this.getViewport();
            if (vp == null) {
                return;
            }
            Point pos = vp.getViewPosition();
            vp.setViewPosition(new Point(Math.max(0, pos.x + scrollAmount), pos.y));
        }
    }

    private class FieldPanelFocusListener
    implements FocusListener {
        private FieldPanelFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            FieldPanel.this.inFocus = true;
            FieldPanel.this.paintContext.setCursorFocused(true);
            FieldPanel.this.cursorHandler.focusGained();
            FieldPanel.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            FieldPanel.this.inFocus = false;
            FieldPanel.this.paintContext.setCursorFocused(false);
            FieldPanel.this.cursorHandler.focusLost();
            FieldPanel.this.selectionHandler.endSelectionSequence();
            FieldPanel.this.repaint();
        }
    }

    private class EnterKeyAction
    implements KeyAction {
        private EnterKeyAction() {
        }

        @Override
        public void handleKeyEvent(KeyEvent e) {
            FieldPanel.this.keyHandler.vkEnter(e);
        }
    }

    private class PageDownKeyAction
    implements KeyAction {
        private PageDownKeyAction() {
        }

        @Override
        public void handleKeyEvent(KeyEvent e) {
            FieldPanel.this.keyHandler.vkPageDown(e);
        }
    }

    private class PageUpKeyAction
    implements KeyAction {
        private PageUpKeyAction() {
        }

        @Override
        public void handleKeyEvent(KeyEvent e) {
            FieldPanel.this.keyHandler.vkPageUp(e);
        }
    }

    private class EndKeyAction
    implements KeyAction {
        private EndKeyAction() {
        }

        @Override
        public void handleKeyEvent(KeyEvent e) {
            FieldPanel.this.keyHandler.vkEnd(e);
        }
    }

    private class HomeKeyAction
    implements KeyAction {
        private HomeKeyAction() {
        }

        @Override
        public void handleKeyEvent(KeyEvent e) {
            FieldPanel.this.keyHandler.vkHome(e);
        }
    }

    private class RightKeyAction
    implements KeyAction {
        private RightKeyAction() {
        }

        @Override
        public void handleKeyEvent(KeyEvent e) {
            FieldPanel.this.keyHandler.vkRight(e);
        }
    }

    private class LeftKeyAction
    implements KeyAction {
        private LeftKeyAction() {
        }

        @Override
        public void handleKeyEvent(KeyEvent e) {
            FieldPanel.this.keyHandler.vkLeft(e);
        }
    }

    private class DownKeyAction
    implements KeyAction {
        private DownKeyAction() {
        }

        @Override
        public void handleKeyEvent(KeyEvent e) {
            FieldPanel.this.keyHandler.vkDown(e);
        }
    }

    private class UpKeyAction
    implements KeyAction {
        private UpKeyAction() {
        }

        @Override
        public void handleKeyEvent(KeyEvent e) {
            FieldPanel.this.keyHandler.vkUp(e);
        }
    }

    public static interface KeyAction {
        public void handleKeyEvent(KeyEvent var1);
    }
}

