/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filter;

import docking.DialogComponentProvider;
import docking.DisabledComponentLayerFactory;
import docking.widgets.InlineComponentTitledPanel;
import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GComboBox;
import docking.widgets.filter.FilterOptions;
import docking.widgets.filter.MultitermEvaluationMode;
import docking.widgets.filter.TextFilterStrategy;
import docking.widgets.label.GIconLabel;
import docking.widgets.label.GLabel;
import docking.widgets.list.GListCellRenderer;
import ghidra.util.HelpLocation;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class FilterOptionsEditorDialog
extends DialogComponentProvider {
    private FilterOptions initialFilterOptions;
    private FilterOptions resultFilterOptions;
    private FilterStrategyPanel filterStrategyPanel;
    private BooleanPanel booleanPanel;
    private InvertPanel invertPanel;
    private MultiTermPanel multiTermPanel;
    private JLayer<?> multiTermDisabledPanel;

    public FilterOptionsEditorDialog(FilterOptions filterOptions) {
        super("Text Filter Options");
        this.initialFilterOptions = filterOptions;
        this.addWorkPanel(this.createMainPanel());
        this.filterStrategyPanel.setFilterStrategy(filterOptions.getTextFilterStrategy());
        this.multiTermPanel.setEvalMode(filterOptions.getMultitermEvaluationMode());
        this.multiTermPanel.setDelimiter(filterOptions.getDelimitingCharacter());
        this.updatedEnablementForNonRegularExpressionOptions(this.filterStrategyPanel.getFilterStrategy() != TextFilterStrategy.REGULAR_EXPRESSION);
        this.multiTermPanel.setMultitermEnabled(filterOptions.isMultiterm());
        this.addOKButton();
        this.addCancelButton();
        this.setRememberSize(false);
        this.setHelpLocation(new HelpLocation("Trees", "Filter_Options"));
    }

    @Override
    protected void okCallback() {
        this.resultFilterOptions = new FilterOptions(this.filterStrategyPanel.getFilterStrategy(), this.booleanPanel.isGlobbing(), this.booleanPanel.isCaseSensitive(), this.invertPanel.isInverted(), this.multiTermPanel.isMultitermEnabled(), this.multiTermPanel.getDelimiter(), this.multiTermPanel.getEvalMode());
        this.close();
    }

    public FilterOptions getResultFilterOptions() {
        return this.resultFilterOptions;
    }

    private JComponent createMainPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(3));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.filterStrategyPanel = new FilterStrategyPanel();
        panel.add(this.filterStrategyPanel);
        this.booleanPanel = new BooleanPanel();
        panel.add(this.booleanPanel);
        this.invertPanel = new InvertPanel();
        panel.add(this.invertPanel);
        this.multiTermPanel = new MultiTermPanel();
        panel.add(this.multiTermPanel);
        this.multiTermDisabledPanel = DisabledComponentLayerFactory.getDisabledLayer(this.multiTermPanel);
        panel.add(this.multiTermDisabledPanel);
        return panel;
    }

    protected void updatedEnablementForNonRegularExpressionOptions(boolean b) {
        this.booleanPanel.setCaseSensitiveCBEnabled(b);
        this.booleanPanel.setGlobbingCBEnabled(b);
        this.multiTermDisabledPanel.setEnabled(b);
    }

    class FilterStrategyPanel
    extends JPanel {
        private TextFilterStrategy filterStrategy;

        public FilterStrategyPanel() {
            this.createPanel();
        }

        public void setFilterStrategy(TextFilterStrategy filterStrategy) {
            this.filterStrategy = filterStrategy;
        }

        public TextFilterStrategy getFilterStrategy() {
            return this.filterStrategy;
        }

        private void createPanel() {
            this.setLayout((LayoutManager)new PairLayout(2, 2));
            this.setBorder(BorderFactory.createTitledBorder("Text Filter Strategy"));
            ButtonGroup buttonGroup = new ButtonGroup();
            GRadioButton startsWithButton = new GRadioButton("Starts With");
            GRadioButton containsButton = new GRadioButton("Contains");
            GRadioButton matchesExactlyButton = new GRadioButton("Matches Exactly");
            GRadioButton regularExpressionButton = new GRadioButton("Regular Expression");
            startsWithButton.setToolTipText("The filter will match all entries that start with the entered filter text.");
            containsButton.setToolTipText("The filter will match all entries that contain the entered filter text.");
            matchesExactlyButton.setToolTipText("The filter will match all entries that exactly match the entered filter text.");
            regularExpressionButton.setToolTipText("The filter will match all entries that match a regular expression generated from the filter text.");
            buttonGroup.add(startsWithButton);
            buttonGroup.add(containsButton);
            buttonGroup.add(matchesExactlyButton);
            buttonGroup.add(regularExpressionButton);
            startsWithButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    FilterStrategyPanel.this.filterStrategy = TextFilterStrategy.STARTS_WITH;
                    FilterOptionsEditorDialog.this.updatedEnablementForNonRegularExpressionOptions(true);
                }
            });
            containsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    FilterStrategyPanel.this.filterStrategy = TextFilterStrategy.CONTAINS;
                    FilterOptionsEditorDialog.this.updatedEnablementForNonRegularExpressionOptions(true);
                }
            });
            matchesExactlyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    FilterStrategyPanel.this.filterStrategy = TextFilterStrategy.MATCHES_EXACTLY;
                    FilterOptionsEditorDialog.this.updatedEnablementForNonRegularExpressionOptions(true);
                }
            });
            regularExpressionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    FilterStrategyPanel.this.filterStrategy = TextFilterStrategy.REGULAR_EXPRESSION;
                    FilterOptionsEditorDialog.this.updatedEnablementForNonRegularExpressionOptions(false);
                }
            });
            switch (FilterOptionsEditorDialog.this.initialFilterOptions.getTextFilterStrategy()) {
                case STARTS_WITH: {
                    startsWithButton.setSelected(true);
                    break;
                }
                case MATCHES_EXACTLY: {
                    matchesExactlyButton.setSelected(true);
                    break;
                }
                case REGULAR_EXPRESSION: {
                    regularExpressionButton.setSelected(true);
                    break;
                }
                default: {
                    containsButton.setSelected(true);
                }
            }
            this.add(containsButton);
            this.add(new GIconLabel(FilterOptions.getIcon(TextFilterStrategy.CONTAINS)));
            this.add(startsWithButton);
            this.add(new GIconLabel(FilterOptions.getIcon(TextFilterStrategy.STARTS_WITH)));
            this.add(matchesExactlyButton);
            this.add(new GIconLabel(FilterOptions.getIcon(TextFilterStrategy.MATCHES_EXACTLY)));
            this.add(regularExpressionButton);
            this.add(new GIconLabel(FilterOptions.getIcon(TextFilterStrategy.REGULAR_EXPRESSION)));
        }
    }

    class MultiTermPanel
    extends InlineComponentTitledPanel {
        private JLayer<?> optionsPaneDisableLayer;
        private JCheckBox enableCheckbox;
        private List<JRadioButton> modeButtons;
        private JComboBox<String> delimiterCharacterCB;
        private MultitermEvaluationMode evalMode;

        public MultiTermPanel() {
            super(new GCheckBox("Enable Multi-Term Filtering", true), BorderFactory.createEtchedBorder());
            this.modeButtons = new ArrayList<JRadioButton>();
            this.evalMode = MultitermEvaluationMode.AND;
            this.enableCheckbox = (JCheckBox)this.getTitleComponent();
            this.enableCheckbox.addActionListener(e -> this.setOptionsEnabled(this.enableCheckbox.isSelected()));
            this.createPanel();
        }

        public MultitermEvaluationMode getEvalMode() {
            return this.evalMode;
        }

        public void setEvalMode(MultitermEvaluationMode evalMode) {
            this.evalMode = evalMode;
            for (JRadioButton rb : this.modeButtons) {
                if (!rb.getText().equals(evalMode.name())) continue;
                rb.setSelected(true);
            }
        }

        public void setMultitermEnabled(boolean enabled) {
            this.enableCheckbox.setSelected(enabled);
            this.setOptionsEnabled(enabled);
        }

        public void setOptionsEnabled(boolean enabled) {
            this.optionsPaneDisableLayer.setEnabled(enabled);
        }

        public boolean isMultitermEnabled() {
            return this.enableCheckbox.isSelected();
        }

        public char getDelimiter() {
            return this.delimiterCharacterCB.getSelectedItem().toString().charAt(0);
        }

        public void setDelimiter(char delimiter) {
            int count = this.delimiterCharacterCB.getItemCount();
            for (int i = 0; i < count; ++i) {
                if (!this.delimiterCharacterCB.getItemAt(i).equals(String.valueOf(delimiter))) continue;
                this.delimiterCharacterCB.setSelectedIndex(i);
            }
        }

        private void createPanel() {
            MultitermEvaluationMode[] modes;
            this.getContentPane().setLayout(new FlowLayout(0, 0, 0));
            JPanel outerPanel = new JPanel();
            outerPanel.setLayout(new FlowLayout(0, 0, 0));
            JPanel optionsPanel = new JPanel();
            optionsPanel.setLayout((LayoutManager)new PairLayout());
            GLabel delimiterCharacterFieldName = new GLabel("Delimiter:");
            delimiterCharacterFieldName.setToolTipText("Set the character used to separate filter terms.");
            this.delimiterCharacterCB = new GComboBox<String>(FilterOptions.VALID_MULTITERM_DELIMITERS_ARRAY);
            this.delimiterCharacterCB.setRenderer(new DelimiterListCellRenderer());
            JPanel fixedSizePanel = new JPanel();
            fixedSizePanel.setLayout(new FlowLayout(0));
            fixedSizePanel.add(this.delimiterCharacterCB);
            optionsPanel.add(delimiterCharacterFieldName);
            optionsPanel.add(fixedSizePanel);
            GLabel label = new GLabel("Evaluation Mode:");
            JPanel buttonGroupPanel = new JPanel();
            buttonGroupPanel.setLayout(new FlowLayout(0));
            ButtonGroup modeBtnGroup = new ButtonGroup();
            for (MultitermEvaluationMode mode : modes = MultitermEvaluationMode.values()) {
                GRadioButton modeRB = new GRadioButton(mode.name());
                modeRB.setToolTipText(mode.getDescription());
                modeRB.addActionListener(e -> {
                    this.evalMode = MultitermEvaluationMode.valueOf(mode.name());
                });
                this.modeButtons.add(modeRB);
                modeBtnGroup.add(modeRB);
                buttonGroupPanel.add(modeRB);
            }
            optionsPanel.add(label);
            optionsPanel.add(buttonGroupPanel);
            optionsPanel.setBorder(new EmptyBorder(0, 22, 0, 0));
            outerPanel.add(optionsPanel);
            this.add(outerPanel);
            this.optionsPaneDisableLayer = DisabledComponentLayerFactory.getDisabledLayer(outerPanel);
            this.add(this.optionsPaneDisableLayer);
        }

        private class DelimiterListCellRenderer
        extends GListCellRenderer<String> {
            public DelimiterListCellRenderer() {
                this.setHTMLRenderingEnabled(true);
            }

            @Override
            protected String getItemText(String value) {
                char char0 = value.length() > 0 ? (char)value.charAt(0) : (char)' ';
                String delimiterName = FilterOptions.DELIMITER_NAME_MAP.getOrDefault(Character.valueOf(char0), "<i>Unrecognized</i>");
                return String.format("<html><font face=monospace>%s</font> &nbsp;&nbsp; <i>%s</i>", char0 == ' ' ? "&nbsp;" : Character.valueOf(char0), delimiterName);
            }
        }
    }

    class BooleanPanel
    extends JPanel {
        private JCheckBox caseSensitiveCheckbox;
        private JCheckBox globbingCheckbox;

        public BooleanPanel() {
            this.createPanel();
        }

        public boolean isCaseSensitive() {
            return this.caseSensitiveCheckbox.isSelected();
        }

        public boolean isGlobbing() {
            return this.globbingCheckbox.isSelected();
        }

        public void setCaseSensitive(boolean val) {
            this.caseSensitiveCheckbox.setSelected(val);
        }

        public void setGlobbing(boolean val) {
            this.globbingCheckbox.setSelected(val);
        }

        public void setCaseSensitiveCBEnabled(boolean enabled) {
            this.caseSensitiveCheckbox.setEnabled(enabled);
        }

        public void setGlobbingCBEnabled(boolean enabled) {
            this.globbingCheckbox.setEnabled(enabled);
        }

        private void createPanel() {
            this.setLayout((LayoutManager)new HorizontalLayout(6));
            this.setBorder(BorderFactory.createEmptyBorder(10, 4, 0, 4));
            this.caseSensitiveCheckbox = new GCheckBox("Case Sensitive");
            this.caseSensitiveCheckbox.setToolTipText("Toggles whether the case of the filter text matters in the match.  NOTE: does not apply to regular expressons.");
            if (FilterOptionsEditorDialog.this.initialFilterOptions.isCaseSensitive()) {
                this.caseSensitiveCheckbox.setSelected(true);
            }
            this.globbingCheckbox = new GCheckBox("Allow Globbing");
            this.globbingCheckbox.setToolTipText("Toggles whether globbing chars (?*) are literal or wildcards");
            if (FilterOptionsEditorDialog.this.initialFilterOptions.isGlobbingAllowed()) {
                this.globbingCheckbox.setSelected(true);
            }
            if (FilterOptionsEditorDialog.this.initialFilterOptions.getTextFilterStrategy() == TextFilterStrategy.REGULAR_EXPRESSION) {
                this.caseSensitiveCheckbox.setEnabled(false);
                this.globbingCheckbox.setEnabled(false);
            }
            this.add(this.caseSensitiveCheckbox);
            this.add(this.globbingCheckbox);
        }
    }

    class InvertPanel
    extends JPanel {
        private JCheckBox invertCheckbox;

        public InvertPanel() {
            this.createPanel();
        }

        public boolean isInverted() {
            return this.invertCheckbox.isSelected();
        }

        private void createPanel() {
            this.setLayout((LayoutManager)new HorizontalLayout(6));
            this.setBorder(BorderFactory.createEmptyBorder(10, 4, 10, 4));
            this.invertCheckbox = new GCheckBox("Invert Filter");
            this.invertCheckbox.setToolTipText("<html>Inverts the match.  For example, <i>contains</i> becomes <i>does not contain</i>.");
            if (FilterOptionsEditorDialog.this.initialFilterOptions.isInverted()) {
                this.invertCheckbox.setSelected(true);
            }
            this.add(this.invertCheckbox);
        }
    }
}

