/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.job;

import ghidra.util.exception.AssertException;
import ghidra.util.task.BusyListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;

public abstract class AbstractAnimator {
    private Logger log = LogManager.getLogger(AbstractAnimator.class);
    protected Animator animator;
    private boolean hasFinished;
    private BusyListener busyListener;

    protected abstract Animator createAnimator();

    protected abstract void finished();

    public void setBusyListener(BusyListener listener) {
        this.busyListener = listener;
    }

    protected void followOnAnimatorScheduled() {
        this.trace("followOnAnimatorScheduled");
        this.stopMe();
    }

    public void start() {
        this.trace("start() - " + this.getClass().getSimpleName());
        this.validateNotFinished();
        this.animator = this.createAnimator();
        this.trace("\tcreated animator - " + this.animator);
        if (this.animator == null) {
            this.callFinish();
            return;
        }
        if (this.busyListener != null) {
            this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

                public void begin() {
                    AbstractAnimator.this.busyListener.setBusy(true);
                }

                public void end() {
                    AbstractAnimator.this.busyListener.setBusy(false);
                }
            });
        }
        this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

            public void end() {
                AbstractAnimator.this.callFinish();
            }
        });
        this.validateNotFinished();
        this.animator.start();
    }

    private void validateNotFinished() {
        this.trace("validateNotFinished()");
        if (this.hasFinished) {
            this.trace("\talready finished - programming error!");
            throw new AssertException("Called start() on an animator that has already finished!  Animator: " + this.getClass().getSimpleName());
        }
    }

    private void callFinish() {
        this.trace("callFinish()");
        if (this.hasFinished) {
            this.trace("\talready finished");
            return;
        }
        this.hasFinished = true;
        this.finished();
    }

    public void stop() {
        this.trace("stop()");
        this.stopMe();
    }

    protected void stopMe() {
        this.trace("stopMe()");
        if (this.animator == null) {
            this.hasFinished = true;
            return;
        }
        this.animator.stop();
    }

    public boolean isRunning() {
        this.trace("isRunning()");
        if (this.amIRunning()) {
            this.trace("\tstill running");
            return true;
        }
        return false;
    }

    public boolean hasFinished() {
        return this.hasFinished;
    }

    private boolean amIRunning() {
        this.trace("amIRunning()");
        if (this.animator == null) {
            return false;
        }
        return this.animator.isRunning();
    }

    protected void trace(String message) {
        this.log.trace(message + " " + this.getClass().getSimpleName() + " (" + System.identityHashCode(this) + ")\t");
    }
}

