/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.exceptionhandling;

import ghidra.app.cmd.data.AbstractCreateDataTypeModel;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.exceptionhandling.EHCatchHandlerModel;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.IBO32DataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;

public class EHTryBlockModel
extends AbstractCreateDataTypeModel {
    public static String DATA_TYPE_NAME = "TryBlockMapEntry";
    private static String STRUCTURE_NAME = "_s_" + DATA_TYPE_NAME;
    private static final int TRY_LOW_ORDINAL = 0;
    private static final int TRY_HIGH_ORDINAL = 1;
    private static final int CATCH_HIGH_ORDINAL = 2;
    private static final int CATCH_COUNT_ORDINAL = 3;
    private static final int HANDLER_ARRAY_ORDINAL = 4;
    private DataType dataType;

    public EHTryBlockModel(Program program, int tryBlockCount, Address tryBlockMapAddress, DataValidationOptions validationOptions) {
        super(program, tryBlockCount, tryBlockMapAddress, validationOptions);
    }

    @Override
    public String getName() {
        return DATA_TYPE_NAME;
    }

    @Override
    protected void validateModelSpecificInfo() throws InvalidDataTypeException {
        int numEntries = this.getCount();
        for (int tryBlockOrdinal = 0; tryBlockOrdinal < numEntries; ++tryBlockOrdinal) {
            if (this.isValidMap(this.getCatchHandlerCount(tryBlockOrdinal), this.getCatchHandlerMapAddress(tryBlockOrdinal))) continue;
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't have a valid catch handler map.");
        }
    }

    public static DataType getDataType(Program program) {
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        boolean isRelative = EHTryBlockModel.isRelative(program);
        CategoryPath categoryPath = new CategoryPath(CATEGORY_PATH);
        StructureDataType struct = MSDataTypeUtils.getAlignedPack4Structure((DataTypeManager)dataTypeManager, (CategoryPath)categoryPath, (String)STRUCTURE_NAME);
        DataType ehStateDt = MSDataTypeUtils.getEHStateDataType((Program)program);
        struct.add(ehStateDt, "tryLow", null);
        struct.add(ehStateDt, "tryHigh", null);
        struct.add(ehStateDt, "catchHigh", null);
        IntegerDataType compDt = new IntegerDataType((DataTypeManager)dataTypeManager);
        struct.add((DataType)compDt, "nCatches", null);
        if (isRelative) {
            compDt = new IBO32DataType((DataTypeManager)dataTypeManager);
            struct.add((DataType)compDt, "dispHandlerArray", null);
        } else {
            compDt = new PointerDataType(EHCatchHandlerModel.getDataType(program), (DataTypeManager)dataTypeManager);
            struct.add((DataType)compDt, "pHandlerArray", null);
        }
        TypedefDataType typedefDt = new TypedefDataType(categoryPath, DATA_TYPE_NAME, (DataType)struct, (DataTypeManager)dataTypeManager);
        return MSDataTypeUtils.getMatchingDataType((Program)program, (DataType)typedefDt);
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = EHTryBlockModel.getDataType(this.getProgram());
        }
        return this.dataType;
    }

    @Override
    protected int getDataTypeLength() {
        return this.getDataType().getLength();
    }

    public int getTryLow(int tryBlockOrdinal) throws InvalidDataTypeException {
        this.checkValidity(tryBlockOrdinal);
        DataType dt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(tryBlockOrdinal, dt);
        return EHDataTypeUtilities.getEHStateValue(dt, 0, specificMemBuffer);
    }

    public int getTryHigh(int tryBlockOrdinal) throws InvalidDataTypeException {
        this.checkValidity(tryBlockOrdinal);
        DataType dt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(tryBlockOrdinal, dt);
        return EHDataTypeUtilities.getEHStateValue(dt, 1, specificMemBuffer);
    }

    public int getCatchHigh(int tryBlockOrdinal) throws InvalidDataTypeException {
        this.checkValidity(tryBlockOrdinal);
        DataType dt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(tryBlockOrdinal, dt);
        return EHDataTypeUtilities.getEHStateValue(dt, 2, specificMemBuffer);
    }

    public EHCatchHandlerModel getCatchHandlerModel(int tryBlockOrdinal) throws InvalidDataTypeException {
        this.checkValidity();
        EHCatchHandlerModel catchHandlerModel = new EHCatchHandlerModel(this.getProgram(), this.getCatchHandlerCount(tryBlockOrdinal), this.getCatchHandlerMapAddress(tryBlockOrdinal), this.validationOptions);
        return catchHandlerModel;
    }

    public int getCatchHandlerCount(int tryBlockOrdinal) throws InvalidDataTypeException {
        this.checkValidity(tryBlockOrdinal);
        DataType dt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(tryBlockOrdinal, dt);
        return EHDataTypeUtilities.getCount(dt, 3, specificMemBuffer);
    }

    public Address getCatchHandlerMapAddress(int tryBlockOrdinal) throws InvalidDataTypeException {
        this.checkValidity(tryBlockOrdinal);
        DataType dt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(tryBlockOrdinal, dt);
        Address mapAddress = EHDataTypeUtilities.getAddress(dt, 4, specificMemBuffer);
        return this.getAdjustedAddress(mapAddress, this.getCatchHandlerCount(tryBlockOrdinal));
    }

    public Address getComponentAddressOfCatchHandlerMapAddress(int tryBlockOrdinal) throws InvalidDataTypeException {
        this.checkValidity(tryBlockOrdinal);
        DataType dt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(tryBlockOrdinal, dt);
        return EHDataTypeUtilities.getComponentAddress(dt, 4, specificMemBuffer);
    }
}

