/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBBreakpoint;
import SWIG.SBTarget;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LldbListBreakpointsCommand
extends AbstractLldbCommand<Map<String, Object>> {
    protected final SBTarget session;
    private Map<String, Object> updatedBreakpoints = new HashMap<String, Object>();

    public LldbListBreakpointsCommand(LldbManagerImpl manager, SBTarget session) {
        super(manager);
        this.session = session;
    }

    @Override
    public Map<String, Object> complete(LldbPendingCommand<?> pending) {
        Map<String, Object> breakpoints = this.manager.getKnownBreakpoints(this.session);
        Set<String> cur = breakpoints.keySet();
        for (String id : this.updatedBreakpoints.keySet()) {
            if (cur.contains(id)) continue;
            this.manager.addBreakpointIfAbsent(this.session, this.updatedBreakpoints.get(id));
        }
        for (String id : new ArrayList<String>(cur)) {
            if (this.updatedBreakpoints.containsKey(id)) continue;
            this.manager.removeBreakpoint(this.session, id);
        }
        return this.manager.getKnownBreakpoints(this.session);
    }

    @Override
    public void invoke() {
        SBBreakpoint bpt;
        this.updatedBreakpoints.clear();
        long n = this.session.GetNumBreakpoints();
        int i = 0;
        while ((long)i < n) {
            bpt = this.session.GetBreakpointAtIndex((long)i);
            this.updatedBreakpoints.put(DebugClient.getId(bpt), bpt);
            ++i;
        }
        n = this.session.GetNumWatchpoints();
        i = 0;
        while ((long)i < n) {
            bpt = this.session.GetWatchpointAtIndex((long)i);
            this.updatedBreakpoints.put(DebugClient.getId(bpt), bpt);
            ++i;
        }
    }
}

