/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import agent.lldb.model.iface2.LldbModelTargetConnector;
import agent.lldb.model.impl.LldbModelTargetConnectorContainerImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForRunner;
import ghidra.dbg.error.DebuggerUserException;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="ProcessLaunchWithOptionsConnector", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class LldbModelTargetProcessLaunchWithOptionsConnectorImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetConnector {
    protected final LldbModelTargetConnectorContainerImpl connectors;
    protected final TargetMethod.TargetParameterMap paramDescs;

    public LldbModelTargetProcessLaunchWithOptionsConnectorImpl(LldbModelTargetConnectorContainerImpl connectors, String name) {
        super(connectors.getModel(), (TargetObject)connectors, name, name);
        this.connectors = connectors;
        this.paramDescs = TargetMethod.TargetParameterMap.copyOf(this.computeParameters());
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay(), "_parameters", this.paramDescs), "Initialized");
    }

    @Override
    public CompletableFuture<Void> setActive() {
        this.connectors.setDefaultConnector(this);
        return CompletableFuture.completedFuture(null);
    }

    protected Map<String, TargetMethod.ParameterDescription<?>> computeParameters() {
        LinkedHashMap map = new LinkedHashMap();
        TargetMethod.ParameterDescription p0 = TargetMethod.ParameterDescription.create(String.class, (String)"File", (boolean)true, (Object)"", (String)"File", (String)"executable to be launched");
        map.put("File", p0);
        TargetMethod.ParameterDescription p1 = TargetMethod.ParameterDescription.create(String.class, (String)"Args", (boolean)false, (Object)"", (String)"Args", (String)"command-line arguments");
        map.put("Args", p1);
        TargetMethod.ParameterDescription p2 = TargetMethod.ParameterDescription.create(String.class, (String)"Env", (boolean)false, (Object)"", (String)"Env", (String)"environment arguments");
        map.put("Env", p2);
        TargetMethod.ParameterDescription p3 = TargetMethod.ParameterDescription.create(String.class, (String)"STDIN", (boolean)false, (Object)"", (String)"STDIN", (String)"path for STDIN");
        map.put("STDIN", p3);
        TargetMethod.ParameterDescription p4 = TargetMethod.ParameterDescription.create(String.class, (String)"STDOUT", (boolean)false, (Object)"", (String)"STDOUT", (String)"path for STDOUT");
        map.put("STDOUT", p4);
        TargetMethod.ParameterDescription p5 = TargetMethod.ParameterDescription.create(String.class, (String)"STDERR", (boolean)false, (Object)"", (String)"STDERR", (String)"path for STDERR");
        map.put("STDERR", p5);
        TargetMethod.ParameterDescription p6 = TargetMethod.ParameterDescription.create(String.class, (String)"Dir", (boolean)false, (Object)"", (String)"Dir", (String)"working directory");
        map.put("Dir", p6);
        TargetMethod.ParameterDescription pF0 = TargetMethod.ParameterDescription.create(Boolean.class, (String)"Exec", (boolean)false, (Object)false, (String)"Exec", (String)"exec when launching and turn the calling process into a new process");
        map.put("Exec", pF0);
        TargetMethod.ParameterDescription pF1 = TargetMethod.ParameterDescription.create(Boolean.class, (String)"BreakOnLaunch", (boolean)false, (Object)true, (String)"Break on launch", (String)"stop as soon as the process launches to allow the process to be debugged");
        map.put("BreakOnLaunch", pF1);
        TargetMethod.ParameterDescription pF2 = TargetMethod.ParameterDescription.create(Boolean.class, (String)"BreakOnEntry", (boolean)false, (Object)true, (String)"Break on entry", (String)"stop at the program entry point instead of auto-continuing");
        map.put("BreakOnEntry", pF2);
        TargetMethod.ParameterDescription pF3 = TargetMethod.ParameterDescription.create(Boolean.class, (String)"ASLR", (boolean)false, (Object)false, (String)"Disable ASLR", (String)"disable Address Space Layout Randomization (ASLR)");
        map.put("ASLR", pF3);
        TargetMethod.ParameterDescription pF4 = TargetMethod.ParameterDescription.create(Boolean.class, (String)"STDIO", (boolean)false, (Object)false, (String)"Disable STDIO", (String)"disable stdio for inferior process (e.g. for a GUI app)");
        map.put("STDIO", pF4);
        TargetMethod.ParameterDescription pF5 = TargetMethod.ParameterDescription.create(Boolean.class, (String)"NewTTY", (boolean)false, (Object)false, (String)"New TTY", (String)"launch the process in a new TTY if supported by the host");
        map.put("NewTTY", pF5);
        TargetMethod.ParameterDescription pF6 = TargetMethod.ParameterDescription.create(Boolean.class, (String)"Shell", (boolean)false, (Object)false, (String)"Launch from shell", (String)"launch the process inside a shell to get shell expansion");
        map.put("Shell", pF6);
        TargetMethod.ParameterDescription pF7 = TargetMethod.ParameterDescription.create(Boolean.class, (String)"NewGroup", (boolean)false, (Object)false, (String)"New group", (String)"launch the process in a separate process group if you are going to hand the process off (e.g. to debugserver)");
        map.put("NewGroup", pF7);
        TargetMethod.ParameterDescription pF8 = TargetMethod.ParameterDescription.create(Boolean.class, (String)"ExitRace", (boolean)false, (Object)false, (String)"Suppress race on exit", (String)"set this flag so lldb & the handee don't race to set its exit status");
        map.put("ExitRace", pF8);
        TargetMethod.ParameterDescription pF9 = TargetMethod.ParameterDescription.create(Boolean.class, (String)"Detach", (boolean)false, (Object)false, (String)"Detach on disconnect", (String)"client stub should detach rather than killing the debugee if it loses connection with lldb");
        map.put("Detach", pF9);
        TargetMethod.ParameterDescription pFA = TargetMethod.ParameterDescription.create(Boolean.class, (String)"ExpandArgs", (boolean)false, (Object)false, (String)"Shell-style expansion", (String)"perform shell-style argument expansion");
        map.put("ExpandArgs", pFA);
        TargetMethod.ParameterDescription pFB = TargetMethod.ParameterDescription.create(Boolean.class, (String)"CloseTTY", (boolean)false, (Object)false, (String)"Close TTY on exit", (String)"close the open TTY on exit");
        map.put("CloseTTY", pFB);
        TargetMethod.ParameterDescription pFC = TargetMethod.ParameterDescription.create(Boolean.class, (String)"Inherit", (boolean)false, (Object)false, (String)"Inherit TCC", (String)"inherit TCC permissions from the parent");
        map.put("Inherit", pFC);
        return map;
    }

    @Override
    public TargetMethod.TargetParameterMap getParameters() {
        return TargetMethod.getParameters((TargetObject)this);
    }

    @Override
    public CompletableFuture<Void> launch(Map<String, ?> args) {
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> this.getManager().launch(args).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).nextIgnore(arg_0, arg_1))).finish().exceptionally(exc -> {
            throw new DebuggerUserException("Launch failed for " + args);
        });
    }
}

