/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.RenameTask;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeException;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class RenameVariableTask
extends RenameTask {
    private HighSymbol highSymbol;
    private Varnode exactSpot;
    private HighFunction hfunction;
    private Function function;
    private boolean commitRequired;
    private SourceType srctype;
    private SourceType signatureSrcType;

    public RenameVariableTask(PluginTool tool, Program program, DecompilerProvider provider, ClangToken token, HighSymbol sym, SourceType st) {
        super(tool, program, provider, token, sym.getName());
        this.highSymbol = sym;
        this.exactSpot = token.getVarnode();
        this.hfunction = sym.getHighFunction();
        this.function = this.hfunction.getFunction();
        this.srctype = st;
        this.signatureSrcType = this.function.getSignatureSource();
    }

    @Override
    public void commit() throws DuplicateNameException, InvalidInputException {
        if (this.commitRequired) {
            HighFunctionDBUtil.commitParamsToDatabase((HighFunction)this.hfunction, (boolean)false, (SourceType)this.signatureSrcType);
            if (this.signatureSrcType != SourceType.DEFAULT) {
                HighFunctionDBUtil.commitReturnToDatabase((HighFunction)this.hfunction, (SourceType)this.signatureSrcType);
            }
        }
        HighFunctionDBUtil.updateDBVariable((HighSymbol)this.highSymbol, (String)this.newName, null, (SourceType)this.srctype);
    }

    @Override
    public boolean isValid(String newNm) {
        this.newName = newNm;
        if (RenameVariableTask.isSymbolInFunction(this.function, this.newName)) {
            this.errorMsg = "Duplicate name";
            return false;
        }
        this.commitRequired = AbstractDecompilerAction.checkFullCommit(this.highSymbol, this.hfunction);
        if (this.commitRequired) {
            this.exactSpot = null;
        }
        if (this.exactSpot != null && !this.highSymbol.isNameLocked()) {
            try {
                HighVariable var = this.hfunction.splitOutMergeGroup(this.exactSpot.getHigh(), this.exactSpot);
                this.highSymbol = var.getSymbol();
            }
            catch (PcodeException e) {
                this.errorMsg = "Rename Failed: " + e.getMessage();
                return false;
            }
        }
        if (this.highSymbol == null) {
            this.errorMsg = "Rename Failed: No symbol";
            return false;
        }
        return true;
    }

    @Override
    public String getTransactionName() {
        return "Rename Local Variable";
    }
}

