/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.module;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Msg;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;

public class MergeFolderCmd
implements Command {
    private String treeName;
    private String folderName;
    private String parentName;
    private String errMsg;

    public MergeFolderCmd(String treeName, String folderName, String parentName) {
        this.treeName = treeName;
        this.folderName = folderName;
        this.parentName = parentName;
    }

    public boolean applyTo(DomainObject obj) {
        Program program = (Program)obj;
        Listing listing = program.getListing();
        ProgramModule parentModule = listing.getModule(this.treeName, this.parentName);
        ProgramModule module = listing.getModule(this.treeName, this.folderName);
        if (parentModule == null || module == null) {
            return true;
        }
        Group[] groups = module.getChildren();
        for (int i = 0; i < groups.length; ++i) {
            String name = groups[i].getName();
            ProgramModule m = listing.getModule(this.treeName, name);
            ProgramFragment f = null;
            try {
                if (m != null && parentModule.contains(m)) {
                    module.removeChild(name);
                    continue;
                }
                if (m == null && parentModule.contains(f = listing.getFragment(this.treeName, name))) {
                    module.removeChild(name);
                    continue;
                }
                parentModule.reparent(name, module);
                continue;
            }
            catch (NotEmptyException e) {
                Msg.showError((Object)this, null, (String)"Error", (Object)"Error merging folder with its parent");
                continue;
            }
            catch (NotFoundException e) {
                Msg.showError((Object)this, null, (String)"Error", (Object)"Error merging folder with its parent");
            }
        }
        try {
            ProgramModule m = listing.getModule(this.treeName, this.folderName);
            ProgramModule[] parents = m.getParents();
            for (int i = 0; i < parents.length; ++i) {
                parents[i].removeChild(this.folderName);
            }
            return true;
        }
        catch (NotEmptyException e) {
            this.errMsg = e.getMessage();
            return false;
        }
    }

    public String getStatusMsg() {
        return this.errMsg;
    }

    public String getName() {
        return "Merge " + this.folderName + " with Parent";
    }
}

