/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.datatypes;

import docking.widgets.checkbox.GCheckBox;
import ghidra.app.merge.datatypes.CategoryConflictPanel;
import ghidra.app.merge.util.ConflictCountPanel;
import ghidra.framework.data.DomainObjectMergeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CategoryMergePanel
extends JPanel {
    private DomainObjectMergeManager mergeManager;
    private int totalConflicts;
    private ConflictCountPanel countPanel;
    private CategoryConflictPanel resolvePanel;
    private int selectedOption;
    private static final String USE_FOR_ALL_CHECKBOX = "UseForAllConflictCheckBox";
    private JCheckBox useForAllCB;

    CategoryMergePanel(DomainObjectMergeManager mergeManager, int totalConflicts) {
        super(new BorderLayout());
        this.mergeManager = mergeManager;
        this.totalConflicts = totalConflicts;
        this.create();
    }

    void setConflictInfo(int conflictIndex, String latestPath, String path, String origPath, boolean latestRenamed, boolean renamed, boolean latestMoved, boolean moved, boolean latestDeleted, boolean deleted) {
        this.mergeManager.setApplyEnabled(false);
        this.countPanel.updateCount(conflictIndex, this.totalConflicts);
        String s1 = "Use '" + latestPath + "' (Latest)";
        String s2 = "Use '" + path + "' (Checked Out)";
        String s3 = "Use '" + origPath + "' (Original)";
        if ((latestRenamed || renamed) && !deleted) {
            s1 = "Use name '" + latestPath + "' (Latest)";
            s2 = "Use name '" + path + "' (Checked Out)";
            s3 = "Use name '" + origPath + "' (Original)";
        } else if (latestDeleted || deleted) {
            if (latestDeleted) {
                s1 = "Delete '" + origPath + "' (Latest)";
                s2 = "Keep Category '" + path + "' (Checked Out)";
            } else {
                s1 = "Keep Category '" + latestPath + "' (Latest)";
                s2 = "Delete Category '" + origPath + "' (Checked Out)";
            }
            s3 = "Keep Category '" + origPath + "' (Original)";
        }
        this.resolvePanel.setConflictInfo(origPath, s1, s2, s3);
    }

    int getSelectedOption() {
        this.selectedOption = this.resolvePanel.getSelectedOption();
        return this.selectedOption;
    }

    private void create() {
        this.countPanel = new ConflictCountPanel();
        this.resolvePanel = new CategoryConflictPanel("Resolve Conflict", new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CategoryMergePanel.this.mergeManager.clearStatusText();
                CategoryMergePanel.this.mergeManager.setApplyEnabled(true);
            }
        });
        this.setLayout(new BorderLayout(0, 10));
        this.add((Component)this.countPanel, "North");
        this.add((Component)this.resolvePanel, "Center");
        this.add((Component)this.createUseForAllCheckBox(), "South");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        CategoryMergePanel p = new CategoryMergePanel(null, 8);
        p.setConflictInfo(3, "/Category1/Category2/Category3/My Category", "/Category1/Category2/Category3/Another Category", "/Category1/Category2/Category3/Category4", true, true, false, false, false, false);
        frame.getContentPane().add(p);
        frame.pack();
        frame.setVisible(true);
    }

    private JCheckBox createUseForAllCheckBox() {
        this.useForAllCB = new GCheckBox(this.getUseAllString("Category"));
        this.useForAllCB.setName(USE_FOR_ALL_CHECKBOX);
        return this.useForAllCB;
    }

    private String getUseAllString(String conflictType) {
        return "Use the selected option for resolving all remaining '" + conflictType + "' conflicts.";
    }

    void setUseForAll(boolean useForAll) {
        this.useForAllCB.setSelected(useForAll);
    }

    boolean getUseForAll() {
        return this.useForAllCB.isSelected();
    }
}

