/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import docking.widgets.label.GLabel;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.analysis.AnalysisBackgroundCommand;
import ghidra.app.plugin.core.analysis.AnalysisOptionsDialog;
import ghidra.app.plugin.core.analysis.AnalyzeProgramStrategy;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.ProgramManager;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Program;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.util.HTMLUtilities;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;

class AnalyzeAllOpenProgramsTask
extends Task {
    private final Program prototypeProgram;
    private final List<Program> programs;
    private final PluginTool tool;
    private AnalyzeProgramStrategy analyzeStrategy;
    private CancelledListener bottomUpCancelledListener;
    private CancelledListener topDownCancelledListener;

    AnalyzeAllOpenProgramsTask(Plugin plugin) {
        super("Analyzing All Open Programs", true, true, false);
        this.tool = plugin.getTool();
        ProgramManager pm = (ProgramManager)this.tool.getService(ProgramManager.class);
        this.prototypeProgram = pm.getCurrentProgram();
        this.programs = Arrays.asList(pm.getAllOpenPrograms());
        this.analyzeStrategy = new DefaultAnalyzeProgramStrategy();
    }

    AnalyzeAllOpenProgramsTask(PluginTool tool, Program prototypeProgram, Program[] programs, AnalyzeProgramStrategy strategy) {
        super("Analyzing All Open Programs", true, true, false);
        this.tool = tool;
        this.programs = Arrays.asList(programs);
        this.prototypeProgram = prototypeProgram;
        this.analyzeStrategy = strategy;
    }

    public void run(TaskMonitor monitor) {
        if (this.programs.isEmpty()) {
            return;
        }
        monitor.initialize((long)this.programs.size());
        List<Program> validPrograms = null;
        AnalysisOptions prototypeAnalysisOptions = null;
        ToolOptions options = this.tool.getOptions("Auto Analysis");
        boolean showDialog = options.getBoolean("Show Analysis Options", true);
        if (showDialog) {
            try {
                validPrograms = this.checkForInvalidProgramsByArchitecture();
            }
            catch (CancelledException e) {
                return;
            }
            if (!this.setOptions(this.prototypeProgram)) {
                return;
            }
            prototypeAnalysisOptions = new AnalysisOptions(this.prototypeProgram);
        } else {
            validPrograms = new ArrayList<Program>(this.programs);
        }
        this.analyzePrograms(prototypeAnalysisOptions, validPrograms, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzePrograms(AnalysisOptions prototypeAnalysisOptions, List<Program> validPrograms, TaskMonitor monitor) {
        this.bottomUpCancelledListener = new BottomUpCancelledListener(monitor);
        this.topDownCancelledListener = new TopDownCancelledListener();
        monitor.addCancelledListener(this.topDownCancelledListener);
        for (int i = 0; i < validPrograms.size() && !monitor.isCancelled(); ++i) {
            Program program = validPrograms.get(i);
            if (program.isClosed()) {
                monitor.setProgress((long)i);
                continue;
            }
            monitor.setMessage("Analyzing " + program.getName() + "...");
            int id = program.startTransaction("analysis");
            try {
                AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager(program);
                this.initializeAnalysisOptions(program, prototypeAnalysisOptions, manager);
                GhidraProgramUtilities.markProgramAnalyzed(program);
                this.analyzeStrategy.analyzeProgram(program, manager, monitor);
            }
            finally {
                program.endTransaction(id, true);
            }
            monitor.setProgress((long)i);
        }
        if (monitor.isCancelled()) {
            for (Program program : this.programs) {
                AutoAnalysisManager aam = AutoAnalysisManager.getAnalysisManager(program);
                aam.cancelQueuedTasks();
            }
        }
    }

    private boolean initializeAnalysisOptions(Program program, AnalysisOptions analysisOptions, AutoAnalysisManager mgr) {
        if (analysisOptions == null) {
            mgr.initializeOptions();
            return true;
        }
        ProgramID programID = new ProgramID(program);
        if (!programID.equals(analysisOptions.getProgramID())) {
            return false;
        }
        mgr.initializeOptions(analysisOptions.getAnalysisOptionsPropertyList());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setOptions(Program program) {
        AtomicBoolean analyze = new AtomicBoolean();
        int id = program.startTransaction("analysis");
        try {
            Swing.runNow(() -> {
                AnalysisOptionsDialog dialog = new AnalysisOptionsDialog(this.getValidProgramsByArchitecture());
                this.tool.showDialog((DialogComponentProvider)dialog);
                boolean shouldAnalyze = dialog.wasAnalyzeButtonSelected();
                analyze.set(shouldAnalyze);
            });
        }
        finally {
            program.endTransaction(id, true);
        }
        return analyze.get();
    }

    private List<Program> getValidProgramsByArchitecture() {
        ArrayList<Program> validList = new ArrayList<Program>(this.programs);
        ProgramID protoTypeProgramID = new ProgramID(this.prototypeProgram);
        for (Program program : this.programs) {
            ProgramID programID = new ProgramID(program);
            if (protoTypeProgramID.equals(programID)) continue;
            validList.remove(program);
        }
        return validList;
    }

    private List<Program> checkForInvalidProgramsByArchitecture() throws CancelledException {
        List<Program> validList = this.getValidProgramsByArchitecture();
        if (validList.size() != this.programs.size()) {
            ArrayList<Program> invalidList = new ArrayList<Program>(this.programs);
            invalidList.removeAll(validList);
            if (!this.showNonMatchingArchitecturesWarning(validList, invalidList)) {
                throw new CancelledException();
            }
        }
        return validList;
    }

    private void appendTableHeader(StringBuilder buffy) {
        buffy.append("<TR>");
        buffy.append("<TH ALIGN=\"left\">");
        buffy.append("<U>Name</U>");
        buffy.append("</TH>");
        buffy.append("<TH ALIGN=\"left\">");
        buffy.append("<U>Language ID</U>");
        buffy.append("</TH>");
        buffy.append("<TH ALIGN=\"left\">");
        buffy.append("<U>Compiler ID</U>");
        buffy.append("</TH>");
        buffy.append("</TR>");
    }

    private boolean showNonMatchingArchitecturesWarning(List<Program> validList, List<Program> invalidList) {
        StringBuilder buffy = new StringBuilder();
        buffy.append("<html><BR>");
        buffy.append("Found open programs with architectures differing from the current program.<BR><BR><BR>");
        buffy.append("These programs <B>will</B> be analyzed: <BR><BR>");
        buffy.append("<TABLE BORDER=\"0\" CELLPADDING=\"5\">");
        this.appendTableHeader(buffy);
        Object specialFontOpen = "<B><font color=\"" + GThemeDefaults.Colors.Palette.GREEN.toHexString() + "\">";
        String specialFontClose = "</font></B>";
        for (Program program : validList) {
            boolean isCurrentProgram;
            boolean bl = isCurrentProgram = program == this.prototypeProgram;
            if (!isCurrentProgram) {
                specialFontOpen = "";
                specialFontClose = "";
            }
            buffy.append("<TR>");
            buffy.append("<TD>");
            buffy.append((String)specialFontOpen);
            buffy.append(HTMLUtilities.escapeHTML((String)program.getName()));
            buffy.append(specialFontClose);
            buffy.append("</TD>");
            buffy.append("<TD>");
            buffy.append((String)specialFontOpen);
            buffy.append(program.getLanguageID());
            buffy.append(specialFontClose);
            buffy.append("</TD>");
            buffy.append("<TD>");
            buffy.append((String)specialFontOpen);
            buffy.append(program.getCompilerSpec().getCompilerSpecID());
            buffy.append(specialFontClose);
            buffy.append("</TD>");
            buffy.append("</TR>");
        }
        buffy.append("<TR>");
        buffy.append("<TD COLSPAN=\"3\">");
        buffy.append("<BR><BR>These programs will <B>not</B> be analyzed: <BR><BR>");
        buffy.append("</TD>");
        buffy.append("</TR>");
        this.appendTableHeader(buffy);
        for (Program program : invalidList) {
            buffy.append("<TR>");
            buffy.append("<TD>");
            buffy.append(HTMLUtilities.escapeHTML((String)program.getName()));
            buffy.append("</TD>");
            buffy.append("<TD>");
            buffy.append(program.getLanguageID());
            buffy.append("</TD>");
            buffy.append("<TD>");
            buffy.append(program.getCompilerSpec().getCompilerSpecID());
            buffy.append("</TD>");
            buffy.append("</TR>");
        }
        buffy.append("</TABLE>");
        return (Boolean)Swing.runNow(() -> {
            ScrollingOptionDialog dialog = new ScrollingOptionDialog(buffy.toString());
            return dialog.shouldContinue();
        });
    }

    private class DefaultAnalyzeProgramStrategy
    extends AnalyzeProgramStrategy {
        private DefaultAnalyzeProgramStrategy() {
        }

        @Override
        protected void analyzeProgram(Program program, AutoAnalysisManager manager, TaskMonitor monitor) {
            MyAnalysisBackgroundCommand cmd = new MyAnalysisBackgroundCommand(manager);
            AnalyzeAllOpenProgramsTask.this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)program);
            try {
                cmd.waitUntilFinished();
            }
            catch (InterruptedException e) {
                monitor.cancel();
            }
        }
    }

    private class AnalysisOptions {
        private Options options;
        private ProgramID programID;

        AnalysisOptions(Program program) {
            this.options = program.getOptions("Analyzers");
            this.programID = new ProgramID(program);
        }

        ProgramID getProgramID() {
            return this.programID;
        }

        Options getAnalysisOptionsPropertyList() {
            return this.options;
        }
    }

    private class BottomUpCancelledListener
    implements CancelledListener {
        private TaskMonitor outerMonitor;

        BottomUpCancelledListener(TaskMonitor outerMonitor) {
            this.outerMonitor = outerMonitor;
        }

        public void cancelled() {
            this.outerMonitor.cancel();
        }
    }

    private class TopDownCancelledListener
    implements CancelledListener {
        private TopDownCancelledListener() {
        }

        public void cancelled() {
            AnalyzeAllOpenProgramsTask.this.tool.cancelCurrentTask();
        }
    }

    private class ProgramID {
        private LanguageID languageID;
        private CompilerSpecID compilerSpecID;

        ProgramID(Program program) {
            this.languageID = program.getLanguageID();
            this.compilerSpecID = program.getCompilerSpec().getCompilerSpecID();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.compilerSpecID == null ? 0 : this.compilerSpecID.hashCode());
            result = 31 * result + (this.languageID == null ? 0 : this.languageID.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProgramID other = (ProgramID)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.compilerSpecID == null ? other.compilerSpecID != null : !this.compilerSpecID.equals((Object)other.compilerSpecID)) {
                return false;
            }
            return !(this.languageID == null ? other.languageID != null : !this.languageID.equals((Object)other.languageID));
        }

        private AnalyzeAllOpenProgramsTask getOuterType() {
            return AnalyzeAllOpenProgramsTask.this;
        }
    }

    private class ScrollingOptionDialog
    extends OptionDialog {
        public ScrollingOptionDialog(String message) {
            super("Found Differing Architectures", message, "Continue", 2, null);
        }

        boolean shouldContinue() {
            return (Boolean)Swing.runNow(() -> {
                this.show(null);
                return this.getResult() == 1;
            });
        }

        protected JPanel createTextPanel(String message) {
            if (message != null && message.toLowerCase().startsWith("<html>")) {
                JEditorPane editorPane = new JEditorPane();
                editorPane.setEditorKit(new HTMLEditorKit());
                editorPane.setName("MESSAGE-COMPONENT");
                editorPane.setText(message);
                editorPane.setBackground(new GLabel().getBackground());
                JPanel panel = new JPanel(new BorderLayout());
                panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                JScrollPane scrollPane = new JScrollPane(editorPane);
                scrollPane.setBorder(BorderFactory.createEmptyBorder());
                panel.add(scrollPane);
                return panel;
            }
            return super.createTextPanel(message);
        }
    }

    private class MyAnalysisBackgroundCommand
    extends AnalysisBackgroundCommand {
        private CountDownLatch finishedLatch;
        private AutoAnalysisManager manager;

        public MyAnalysisBackgroundCommand(AutoAnalysisManager mgr) {
            super(mgr, true);
            this.finishedLatch = new CountDownLatch(1);
            this.manager = mgr;
        }

        @Override
        public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
            monitor.addCancelledListener(AnalyzeAllOpenProgramsTask.this.bottomUpCancelledListener);
            this.manager.reAnalyzeAll(null);
            boolean result = super.applyTo(obj, monitor);
            monitor.removeCancelledListener(AnalyzeAllOpenProgramsTask.this.bottomUpCancelledListener);
            this.finishedLatch.countDown();
            return result;
        }

        void waitUntilFinished() throws InterruptedException {
            this.finishedLatch.await();
        }
    }
}

