/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.bookmark;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collections;
import java.util.List;

public class BookmarkDeleteCmd
implements Command {
    private List<Bookmark> bookmarks;
    private String type;
    private String category;
    private AddressSetView addrSet;
    private String presentationName = "Delete Bookmark(s)";

    private BookmarkDeleteCmd(List<Bookmark> bookmarks, AddressSetView set, String type, String category) {
        this.bookmarks = bookmarks;
        this.addrSet = set;
        this.type = type;
        this.category = category;
    }

    public BookmarkDeleteCmd(Bookmark bookmark) {
        this(Collections.singletonList(bookmark), null, null, null);
        if (bookmark == null) {
            throw new IllegalArgumentException();
        }
        this.presentationName = "Delete Bookmark";
    }

    public BookmarkDeleteCmd(List<Bookmark> bookmarks) {
        this(bookmarks, null, null, null);
        if (bookmarks == null) {
            throw new IllegalArgumentException();
        }
        this.presentationName = "Delete Bookmark(s)";
    }

    public BookmarkDeleteCmd(Address addr) {
        this(null, (AddressSetView)new AddressSet(addr, addr), null, null);
        this.presentationName = "Delete Bookmarks at " + addr;
    }

    public BookmarkDeleteCmd(Address addr, String type) {
        this(null, (AddressSetView)new AddressSet(addr, addr), type, null);
        this.presentationName = "Delete " + type + " Bookmarks at " + addr;
    }

    public BookmarkDeleteCmd(Address addr, String type, String category) {
        this(null, (AddressSetView)new AddressSet(addr, addr), type, category);
        this.presentationName = "Delete " + type + ", " + category + " Bookmark at " + addr;
    }

    public BookmarkDeleteCmd(AddressSetView set) {
        this(null, set, null, null);
        this.presentationName = "Delete Bookmarks over address range";
    }

    public BookmarkDeleteCmd(AddressSetView set, String type) {
        this(null, set, type, null);
        this.presentationName = "Delete " + type + " Bookmarks over address range";
    }

    public BookmarkDeleteCmd(AddressSetView set, String type, String category) {
        this(null, set, type, category);
        this.presentationName = "Delete " + type + ", " + category + " Bookmarks over address range";
    }

    public BookmarkDeleteCmd(String type) {
        this(null, null, type, null);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.presentationName = "Delete all " + type + " Bookmarks";
    }

    public BookmarkDeleteCmd(String type, String category) {
        this(null, null, type, category);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.presentationName = "Delete all Bookmarks of type " + type + " and category " + category;
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    public boolean applyTo(DomainObject obj) {
        BookmarkManager mgr = ((Program)obj).getBookmarkManager();
        if (this.bookmarks != null) {
            this.deleteBookmarks(mgr, this.bookmarks);
        } else if (this.addrSet != null) {
            if (this.type != null) {
                if (this.category != null) {
                    this.deleteBookmarks(mgr, this.addrSet, this.type, this.category);
                } else {
                    this.deleteBookmarks(mgr, this.addrSet, this.type);
                }
            } else {
                this.deleteBookmarks(mgr, this.addrSet);
            }
        } else if (this.category != null) {
            this.deleteBookmarks(mgr, this.type, this.category);
        } else {
            this.deleteBookmarks(mgr, this.type);
        }
        return true;
    }

    private void deleteBookmarks(BookmarkManager mgr, List<Bookmark> marks) {
        for (Bookmark bookmark : marks) {
            mgr.removeBookmark(bookmark);
        }
    }

    private void deleteBookmarks(BookmarkManager mgr, String theType) {
        mgr.removeBookmarks(theType);
    }

    private void deleteBookmarks(BookmarkManager mgr, String theType, String theCategory) {
        try {
            mgr.removeBookmarks(theType, theCategory, TaskMonitor.DUMMY);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private void deleteBookmarks(BookmarkManager mgr, AddressSetView set) {
        try {
            mgr.removeBookmarks(set, TaskMonitor.DUMMY);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private void deleteBookmarks(BookmarkManager mgr, AddressSetView set, String theType) {
        try {
            mgr.removeBookmarks(set, theType, TaskMonitor.DUMMY);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private void deleteBookmarks(BookmarkManager mgr, AddressSetView set, String theType, String theCategory) {
        try {
            mgr.removeBookmarks(set, theType, theCategory, TaskMonitor.DUMMY);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    public String getStatusMsg() {
        return null;
    }

    public String getName() {
        return this.presentationName;
    }
}

