/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.clipboard;

import docking.DialogComponentProvider;
import docking.widgets.list.ListPanel;
import ghidra.app.plugin.core.clipboard.ClipboardPlugin;
import ghidra.app.util.ClipboardType;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class CopyPasteSpecialDialog
extends DialogComponentProvider {
    private ListPanel listPanel;
    private JPanel mainPanel;
    private List<?> availableTypes;
    private Object selectedType;

    public CopyPasteSpecialDialog(ClipboardPlugin plugin, List<?> availableTypes, String title) {
        super(title, true);
        this.availableTypes = availableTypes;
        this.mainPanel = this.createPanel();
        this.addWorkPanel(this.mainPanel);
        this.addOKButton();
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation("ClipboardPlugin", "Copy_Special"));
    }

    private JPanel createPanel() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.listPanel = new ListPanel();
        this.listPanel.setListData(this.availableTypes.toArray());
        JList list = this.listPanel.getList();
        list.setSelectionMode(0);
        list.setVisibleRowCount(Math.max(3, Math.min(this.availableTypes.size(), 7)));
        list.setSelectedIndex(0);
        list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    evt.consume();
                    CopyPasteSpecialDialog.this.okCallback();
                }
            }
        });
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 1 && evt.getClickCount() == 2) {
                    evt.consume();
                    CopyPasteSpecialDialog.this.okCallback();
                }
            }
        });
        this.mainPanel.add((Component)this.listPanel, "Center");
        this.mainPanel.setBorder(new TitledBorder("Select Format"));
        return this.mainPanel;
    }

    protected void okCallback() {
        this.close();
        this.selectedType = this.listPanel.getSelectedValue();
    }

    protected void cancelCallback() {
        this.close();
    }

    public ClipboardType getSelectedType() {
        return (ClipboardType)this.selectedType;
    }
}

