/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.services.DataTypeManagerService;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import javax.swing.Icon;

public class ShowDataTypeInTreeAction
extends CompositeEditorTableAction {
    private static final String TOOLBAR_GROUP = "4_COMPONENT_EDITOR_ACTION";
    private static final Icon ICON = new GIcon("icon.plugin.composite.editor.show.type");

    public ShowDataTypeInTreeAction(CompositeEditorProvider provider) {
        super(provider, "Show In Data Type Manager", TOOLBAR_GROUP, null, null, ICON);
        this.setToolBarData(new ToolBarData(ICON, TOOLBAR_GROUP));
    }

    public void actionPerformed(ActionContext context) {
        DataTypeManagerService dtmService = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        DataTypeManager dtm = this.provider.getDataTypeManager();
        DataTypePath path = this.provider.getDtPath();
        DataType dt = dtm.getDataType(path);
        dtmService.setDataTypeSelected(dt);
    }

    @Override
    public void adjustEnablement() {
        DataTypePath path;
        DataTypeManager dtm = this.provider.getDataTypeManager();
        DataType dt = dtm.getDataType(path = this.provider.getDtPath());
        this.setEnabled(dt != null);
    }
}

