/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.app.services.FunctionComparisonService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import java.util.Set;
import javax.swing.Icon;

public abstract class CompareFunctionsAction
extends DockingAction {
    protected FunctionComparisonService comparisonService;
    private static final Icon COMPARISON_ICON = new GIcon("icon.plugin.functioncompare.new");
    private static final String CREATE_COMPARISON_GROUP = "A9_CreateComparison";
    static final String POPUP_MENU_NAME = "Compare Selected Functions";

    public CompareFunctionsAction(PluginTool tool, String owner) {
        super("Compare Functions", owner, KeyBindingType.SHARED);
        this.comparisonService = (FunctionComparisonService)tool.getService(FunctionComparisonService.class);
        this.setActionAttributes();
    }

    public void actionPerformed(ActionContext context) {
        Set<Function> functions = this.getSelectedFunctions(context);
        this.comparisonService.compareFunctions(functions);
    }

    public boolean isEnabledForContext(ActionContext actionContext) {
        Set<Function> functions = this.getSelectedFunctions(actionContext);
        return !functions.isEmpty();
    }

    protected Icon getToolBarIcon() {
        return COMPARISON_ICON;
    }

    protected abstract Set<Function> getSelectedFunctions(ActionContext var1);

    private void setActionAttributes() {
        this.setDescription("Create Function Comparison");
        this.setPopupMenuData(new MenuData(new String[]{POPUP_MENU_NAME}, this.getToolBarIcon(), CREATE_COMPARISON_GROUP));
        ToolBarData newToolBarData = new ToolBarData(this.getToolBarIcon(), CREATE_COMPARISON_GROUP);
        this.setToolBarData(newToolBarData);
        this.setHelpLocation(new HelpLocation("FunctionComparison", "Function_Comparison"));
        KeyBindingData data = new KeyBindingData('C', 64);
        this.setKeyBindingData(data);
    }
}

