/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import ghidra.app.plugin.core.memory.ExpandBlockModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.Program;

class ExpandBlockDownModel
extends ExpandBlockModel {
    public ExpandBlockDownModel(PluginTool tool, Program program) {
        super(tool, program);
    }

    @Override
    boolean execute() {
        this.message = "";
        this.length = this.endAddr.subtract(this.block.getEnd());
        if (this.length == 0L) {
            return true;
        }
        try {
            this.startAddr = this.endAddr.subtract(this.length - 1L);
            return this.expandBlock();
        }
        catch (Exception e) {
            this.message = e.getMessage();
            if (this.message == null) {
                this.message = e.toString();
            }
            return false;
        }
    }

    @Override
    void setLength(long length) {
        this.message = "";
        this.length = length;
        if (this.isValidLength()) {
            try {
                this.endAddr = this.block.getStart().addNoWrap(length - 1L);
            }
            catch (AddressOverflowException e) {
                this.message = "Expanded block is too large";
            }
        }
        this.listener.stateChanged(null);
    }

    @Override
    void setEndAddress(Address addr) {
        this.message = "";
        this.endAddr = addr;
        if (this.endAddr == null) {
            this.message = "Invalid Address";
        } else if (this.block.getEnd().compareTo((Object)this.endAddr) >= 0) {
            this.message = "End must be greater than " + this.block.getEnd();
        } else {
            this.length = this.endAddr.subtract(this.block.getStart()) + 1L;
        }
        this.listener.stateChanged(null);
    }

    @Override
    void setStartAddress(Address addr) {
    }
}

