/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.ComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.table.DefaultRowFilterTransformer;
import docking.widgets.table.RowFilterTransformer;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.symtable.FilterDialog;
import ghidra.app.plugin.core.symtable.SymbolEditor;
import ghidra.app.plugin.core.symtable.SymbolFilter;
import ghidra.app.plugin.core.symtable.SymbolProvider;
import ghidra.app.plugin.core.symtable.SymbolRenderer;
import ghidra.app.plugin.core.symtable.SymbolRowObject;
import ghidra.app.plugin.core.symtable.SymbolTableModel;
import ghidra.app.services.GoToService;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdom.Element;

class SymbolPanel
extends JPanel {
    private static final boolean FILTER_NAME_ONLY_DEFAULT = true;
    private static final String FILTER_SETTINGS_ELEMENT_NAME = "FILTER_SETTINGS";
    private SymbolProvider symProvider;
    private SymbolTableModel tableModel;
    private GhidraTable symTable;
    private TableModelListener listener;
    private FilterDialog filterDialog;
    private GhidraThreadedTablePanel<SymbolRowObject> threadedTablePanel;
    private GhidraTableFilterPanel<SymbolRowObject> tableFilterPanel;

    SymbolPanel(SymbolProvider provider, SymbolTableModel model, SymbolRenderer renderer, PluginTool tool, GoToService gotoService) {
        super(new BorderLayout());
        this.symProvider = provider;
        this.tableModel = model;
        this.threadedTablePanel = new GhidraThreadedTablePanel<SymbolRowObject>(model);
        this.listener = e -> this.symProvider.updateTitle();
        this.symTable = this.threadedTablePanel.getTable();
        this.symTable.setAutoLookupColumn(0);
        this.symTable.setName("SymbolTable");
        this.symTable.setRowSelectionAllowed(true);
        this.symTable.setSelectionMode(2);
        this.symTable.getModel().addTableModelListener(this.listener);
        this.symTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.handleTableSelection();
                tool.contextChanged((ComponentProvider)this.symProvider);
            }
        });
        GoToService goToService = (GoToService)tool.getService(GoToService.class);
        this.symTable.installNavigation(goToService, goToService.getDefaultNavigatable());
        for (int i = 0; i < this.symTable.getColumnCount(); ++i) {
            TableColumn column = this.symTable.getColumnModel().getColumn(i);
            column.setCellRenderer((TableCellRenderer)((Object)renderer));
            if (column.getModelIndex() != 0) continue;
            column.setCellEditor(new SymbolEditor());
        }
        this.add((Component)((Object)this.threadedTablePanel), "Center");
        this.add((Component)this.createFilterFieldPanel(), "South");
        this.filterDialog = new FilterDialog(tool);
    }

    private JPanel createFilterFieldPanel() {
        this.tableFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.symTable), this.tableModel);
        this.tableFilterPanel.setToolTipText("Filters the contents of the table on symbol names that start with the given pattern");
        this.tableFilterPanel.add(Box.createHorizontalStrut(5));
        GCheckBox nameColumnOnlyCheckbox = new GCheckBox("Name Only");
        nameColumnOnlyCheckbox.setName("NameOnly");
        nameColumnOnlyCheckbox.setToolTipText("<html><b>Selected</b> causes filter to only consider the symbol's name.");
        nameColumnOnlyCheckbox.setFocusable(false);
        nameColumnOnlyCheckbox.setSelected(true);
        this.tableFilterPanel.setFilterRowTransformer(this.updateRowDataTransformer(true));
        nameColumnOnlyCheckbox.addItemListener(arg_0 -> this.lambda$createFilterFieldPanel$2((JCheckBox)nameColumnOnlyCheckbox, arg_0));
        this.tableFilterPanel.add((Component)nameColumnOnlyCheckbox);
        return this.tableFilterPanel;
    }

    protected RowFilterTransformer<SymbolRowObject> updateRowDataTransformer(boolean nameOnly) {
        if (nameOnly) {
            return new NameOnlyRowTransformer();
        }
        return new DefaultRowFilterTransformer((RowObjectTableModel)this.tableModel, this.symTable.getColumnModel());
    }

    ProgramSelection getProgramSelection() {
        return this.symTable.getProgramSelection();
    }

    void dispose() {
        this.symTable.getModel().removeTableModelListener(this.listener);
        this.symTable.dispose();
        this.threadedTablePanel.dispose();
        this.tableFilterPanel.dispose();
        this.filterDialog.dispose();
    }

    void setFilter() {
        if (this.filterDialog == null) {
            return;
        }
        if (this.symTable.isEditing()) {
            this.symTable.editingCanceled(null);
        }
        this.symProvider.setCurrentSymbol(null);
        this.symTable.clearSelection();
        this.filterDialog.adjustFilter((ComponentProvider)this.symProvider, this.tableModel);
    }

    SymbolFilter getFilter() {
        return this.tableModel.getFilter();
    }

    void readConfigState(SaveState saveState) {
        Element filterElement = saveState.getXmlElement(FILTER_SETTINGS_ELEMENT_NAME);
        if (filterElement != null) {
            this.filterDialog.restoreFilter(filterElement);
            this.tableModel.setFilter(this.filterDialog.getFilter());
        }
    }

    void writeConfigState(SaveState saveState) {
        Element filterElement = this.filterDialog.saveFilter();
        saveState.putXmlElement(FILTER_SETTINGS_ELEMENT_NAME, filterElement);
    }

    private void handleTableSelection() {
        int selectedRowCount = this.symTable.getSelectedRowCount();
        if (selectedRowCount == 1) {
            int selectedRow = this.symTable.getSelectedRow();
            Symbol symbol = this.symProvider.getSymbolForRow(selectedRow);
            this.symProvider.setCurrentSymbol(symbol);
        } else {
            this.symProvider.setCurrentSymbol(null);
        }
    }

    int getActualSymbolCount() {
        return this.symTable.getRowCount();
    }

    List<Symbol> getSelectedSymbols() {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        int[] rows = this.symTable.getSelectedRows();
        for (SymbolRowObject rowObject : this.tableModel.getRowObjects(rows)) {
            Symbol s = rowObject.getSymbol();
            if (s == null) continue;
            list.add(s);
        }
        return list;
    }

    GhidraTable getTable() {
        return this.symTable;
    }

    private /* synthetic */ void lambda$createFilterFieldPanel$2(JCheckBox nameColumnOnlyCheckbox, ItemEvent e) {
        boolean nameOnly = nameColumnOnlyCheckbox.isSelected();
        this.tableFilterPanel.setFilterRowTransformer(this.updateRowDataTransformer(nameOnly));
    }

    private static class NameOnlyRowTransformer
    implements RowFilterTransformer<SymbolRowObject> {
        private List<String> list = new ArrayList<String>();

        private NameOnlyRowTransformer() {
        }

        public List<String> transform(SymbolRowObject rowObject) {
            this.list.clear();
            if (rowObject != null) {
                this.list.add(rowObject.toString());
            }
            return this.list;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }
    }
}

